// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1/model.proto

package automl

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Deployment state of the model.
type Model_DeploymentState int32

const (
	// Should not be used, an un-set enum has this value by default.
	Model_DEPLOYMENT_STATE_UNSPECIFIED Model_DeploymentState = 0
	// Model is deployed.
	Model_DEPLOYED Model_DeploymentState = 1
	// Model is not deployed.
	Model_UNDEPLOYED Model_DeploymentState = 2
)

var Model_DeploymentState_name = map[int32]string{
	0: "DEPLOYMENT_STATE_UNSPECIFIED",
	1: "DEPLOYED",
	2: "UNDEPLOYED",
}

var Model_DeploymentState_value = map[string]int32{
	"DEPLOYMENT_STATE_UNSPECIFIED": 0,
	"DEPLOYED":                     1,
	"UNDEPLOYED":                   2,
}

func (x Model_DeploymentState) String() string {
	return proto.EnumName(Model_DeploymentState_name, int32(x))
}

func (Model_DeploymentState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_452845e4ed6fce9d, []int{0, 0}
}

// API proto representing a trained machine learning model.
type Model struct {
	// Required.
	// The model metadata that is specific to the problem type.
	// Must match the metadata type of the dataset used to train the model.
	//
	// Types that are valid to be assigned to ModelMetadata:
	//	*Model_TranslationModelMetadata
	//	*Model_ImageClassificationModelMetadata
	//	*Model_TextClassificationModelMetadata
	//	*Model_ImageObjectDetectionModelMetadata
	//	*Model_TextExtractionModelMetadata
	//	*Model_TextSentimentModelMetadata
	ModelMetadata isModel_ModelMetadata `protobuf_oneof:"model_metadata"`
	// Output only. Resource name of the model.
	// Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the model to show in the interface. The name can be
	// up to 32 characters long and can consist only of ASCII Latin letters A-Z
	// and a-z, underscores
	// (_), and ASCII digits 0-9. It must start with a letter.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The resource ID of the dataset used to create the model. The dataset must
	// come from the same ancestor project and location.
	DatasetId string `protobuf:"bytes,3,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Output only. Timestamp when the model training finished  and can be used for prediction.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this model was last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Deployment state of the model. A model can only serve
	// prediction requests after it gets deployed.
	DeploymentState Model_DeploymentState `protobuf:"varint,8,opt,name=deployment_state,json=deploymentState,proto3,enum=google.cloud.automl.v1.Model_DeploymentState" json:"deployment_state,omitempty"`
	// Used to perform a consistent read-modify-write updates. If not set, a blind
	// "overwrite" update happens.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. The labels with user-defined metadata to organize your model.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels               map[string]string `protobuf:"bytes,34,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Model) Reset()         { *m = Model{} }
func (m *Model) String() string { return proto.CompactTextString(m) }
func (*Model) ProtoMessage()    {}
func (*Model) Descriptor() ([]byte, []int) {
	return fileDescriptor_452845e4ed6fce9d, []int{0}
}

func (m *Model) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model.Unmarshal(m, b)
}
func (m *Model) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model.Marshal(b, m, deterministic)
}
func (m *Model) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model.Merge(m, src)
}
func (m *Model) XXX_Size() int {
	return xxx_messageInfo_Model.Size(m)
}
func (m *Model) XXX_DiscardUnknown() {
	xxx_messageInfo_Model.DiscardUnknown(m)
}

var xxx_messageInfo_Model proto.InternalMessageInfo

type isModel_ModelMetadata interface {
	isModel_ModelMetadata()
}

type Model_TranslationModelMetadata struct {
	TranslationModelMetadata *TranslationModelMetadata `protobuf:"bytes,15,opt,name=translation_model_metadata,json=translationModelMetadata,proto3,oneof"`
}

type Model_ImageClassificationModelMetadata struct {
	ImageClassificationModelMetadata *ImageClassificationModelMetadata `protobuf:"bytes,13,opt,name=image_classification_model_metadata,json=imageClassificationModelMetadata,proto3,oneof"`
}

type Model_TextClassificationModelMetadata struct {
	TextClassificationModelMetadata *TextClassificationModelMetadata `protobuf:"bytes,14,opt,name=text_classification_model_metadata,json=textClassificationModelMetadata,proto3,oneof"`
}

type Model_ImageObjectDetectionModelMetadata struct {
	ImageObjectDetectionModelMetadata *ImageObjectDetectionModelMetadata `protobuf:"bytes,20,opt,name=image_object_detection_model_metadata,json=imageObjectDetectionModelMetadata,proto3,oneof"`
}

type Model_TextExtractionModelMetadata struct {
	TextExtractionModelMetadata *TextExtractionModelMetadata `protobuf:"bytes,19,opt,name=text_extraction_model_metadata,json=textExtractionModelMetadata,proto3,oneof"`
}

type Model_TextSentimentModelMetadata struct {
	TextSentimentModelMetadata *TextSentimentModelMetadata `protobuf:"bytes,22,opt,name=text_sentiment_model_metadata,json=textSentimentModelMetadata,proto3,oneof"`
}

func (*Model_TranslationModelMetadata) isModel_ModelMetadata() {}

func (*Model_ImageClassificationModelMetadata) isModel_ModelMetadata() {}

func (*Model_TextClassificationModelMetadata) isModel_ModelMetadata() {}

func (*Model_ImageObjectDetectionModelMetadata) isModel_ModelMetadata() {}

func (*Model_TextExtractionModelMetadata) isModel_ModelMetadata() {}

func (*Model_TextSentimentModelMetadata) isModel_ModelMetadata() {}

func (m *Model) GetModelMetadata() isModel_ModelMetadata {
	if m != nil {
		return m.ModelMetadata
	}
	return nil
}

func (m *Model) GetTranslationModelMetadata() *TranslationModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TranslationModelMetadata); ok {
		return x.TranslationModelMetadata
	}
	return nil
}

func (m *Model) GetImageClassificationModelMetadata() *ImageClassificationModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_ImageClassificationModelMetadata); ok {
		return x.ImageClassificationModelMetadata
	}
	return nil
}

func (m *Model) GetTextClassificationModelMetadata() *TextClassificationModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TextClassificationModelMetadata); ok {
		return x.TextClassificationModelMetadata
	}
	return nil
}

func (m *Model) GetImageObjectDetectionModelMetadata() *ImageObjectDetectionModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_ImageObjectDetectionModelMetadata); ok {
		return x.ImageObjectDetectionModelMetadata
	}
	return nil
}

func (m *Model) GetTextExtractionModelMetadata() *TextExtractionModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TextExtractionModelMetadata); ok {
		return x.TextExtractionModelMetadata
	}
	return nil
}

func (m *Model) GetTextSentimentModelMetadata() *TextSentimentModelMetadata {
	if x, ok := m.GetModelMetadata().(*Model_TextSentimentModelMetadata); ok {
		return x.TextSentimentModelMetadata
	}
	return nil
}

func (m *Model) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Model) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Model) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *Model) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Model) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Model) GetDeploymentState() Model_DeploymentState {
	if m != nil {
		return m.DeploymentState
	}
	return Model_DEPLOYMENT_STATE_UNSPECIFIED
}

func (m *Model) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Model) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Model) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Model_TranslationModelMetadata)(nil),
		(*Model_ImageClassificationModelMetadata)(nil),
		(*Model_TextClassificationModelMetadata)(nil),
		(*Model_ImageObjectDetectionModelMetadata)(nil),
		(*Model_TextExtractionModelMetadata)(nil),
		(*Model_TextSentimentModelMetadata)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.automl.v1.Model_DeploymentState", Model_DeploymentState_name, Model_DeploymentState_value)
	proto.RegisterType((*Model)(nil), "google.cloud.automl.v1.Model")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.Model.LabelsEntry")
}

func init() { proto.RegisterFile("google/cloud/automl/v1/model.proto", fileDescriptor_452845e4ed6fce9d) }

var fileDescriptor_452845e4ed6fce9d = []byte{
	// 764 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x55, 0xc1, 0x4e, 0xdb, 0x4a,
	0x14, 0xc5, 0xe1, 0xc1, 0x83, 0x09, 0x2f, 0x44, 0xf3, 0x10, 0x32, 0x01, 0x1e, 0x21, 0x4f, 0x95,
	0xd2, 0x45, 0xed, 0x26, 0x2c, 0x0a, 0xa6, 0x52, 0x15, 0x88, 0xdb, 0x46, 0x22, 0x81, 0x26, 0x01,
	0xb5, 0x15, 0xaa, 0x35, 0xb1, 0x07, 0xcb, 0xad, 0xed, 0xb1, 0x3c, 0x13, 0x4a, 0x8a, 0xd8, 0x56,
	0xea, 0xa2, 0xeb, 0xfe, 0x03, 0x9f, 0xd2, 0x4f, 0xe1, 0x2b, 0x2a, 0xcf, 0xd8, 0x01, 0xa2, 0x38,
	0xd9, 0x5d, 0xdf, 0x73, 0xce, 0xbd, 0xc7, 0xc7, 0x33, 0x09, 0x28, 0xd9, 0x84, 0xd8, 0x2e, 0x56,
	0x4d, 0x97, 0xf4, 0x2d, 0x15, 0xf5, 0x19, 0xf1, 0x5c, 0xf5, 0xb2, 0xa2, 0x7a, 0xc4, 0xc2, 0xae,
	0x12, 0x84, 0x84, 0x11, 0xb8, 0x2a, 0x38, 0x0a, 0xe7, 0x28, 0x82, 0xa3, 0x5c, 0x56, 0x0a, 0x6b,
	0xb1, 0x16, 0x05, 0x8e, 0x1a, 0x62, 0x4a, 0xfa, 0xa1, 0x89, 0x85, 0xa4, 0x90, 0x36, 0xd6, 0xf1,
	0x90, 0x9d, 0x70, 0xb6, 0x53, 0x38, 0x0c, 0x5f, 0xb1, 0x98, 0x52, 0x4e, 0xa3, 0x84, 0xc8, 0xa7,
	0x2e, 0x62, 0x0e, 0xf1, 0x63, 0xe6, 0x56, 0xcc, 0xe4, 0x4f, 0xbd, 0xfe, 0x85, 0xca, 0x1c, 0x0f,
	0x53, 0x86, 0xbc, 0x20, 0x26, 0x6c, 0x3c, 0x30, 0x8b, 0x7c, 0x9f, 0x30, 0xae, 0xa6, 0x02, 0x2d,
	0xfd, 0xca, 0x82, 0xb9, 0x66, 0xf4, 0xca, 0x30, 0x00, 0x85, 0x07, 0xd3, 0x0d, 0x9e, 0x83, 0xe1,
	0x61, 0x86, 0x2c, 0xc4, 0x90, 0xbc, 0x5c, 0x94, 0xca, 0xd9, 0xea, 0x73, 0x65, 0x7c, 0x22, 0x4a,
	0xf7, 0x5e, 0xc9, 0xa7, 0x35, 0x63, 0xdd, 0xdb, 0x99, 0xb6, 0xcc, 0x52, 0x30, 0xf8, 0x43, 0x02,
	0xff, 0xf3, 0x5c, 0x0c, 0xd3, 0x45, 0x94, 0x3a, 0x17, 0x8e, 0x39, 0x76, 0xf7, 0x3f, 0x7c, 0xf7,
	0x6e, 0xda, 0xee, 0x46, 0x34, 0xe2, 0xf0, 0xd1, 0x84, 0x51, 0x0f, 0x45, 0x67, 0x0a, 0x07, 0x7e,
	0x97, 0x40, 0x29, 0xca, 0x7f, 0x8a, 0x95, 0x1c, 0xb7, 0xf2, 0x22, 0x35, 0x06, 0x7c, 0xc5, 0x26,
	0x3b, 0xd9, 0x62, 0x93, 0x29, 0xf0, 0xa7, 0x04, 0x9e, 0x88, 0x50, 0x48, 0xef, 0x33, 0x36, 0x99,
	0x61, 0x61, 0x86, 0xcd, 0x71, 0x5e, 0x56, 0xb8, 0x97, 0xbd, 0x89, 0xb1, 0x1c, 0xf3, 0x19, 0xf5,
	0x64, 0xc4, 0xa8, 0x9b, 0x6d, 0x67, 0x1a, 0x09, 0x7e, 0x03, 0xff, 0xf1, 0x5c, 0xf0, 0x15, 0x0b,
	0xd1, 0x58, 0x1f, 0xff, 0x72, 0x1f, 0x3b, 0x93, 0x32, 0xd1, 0x87, 0xe2, 0x51, 0x07, 0xeb, 0x2c,
	0x1d, 0x86, 0x5f, 0xc1, 0x26, 0xdf, 0x4d, 0xb1, 0x1f, 0x9d, 0x6a, 0x9f, 0x8d, 0xae, 0x5e, 0xe5,
	0xab, 0xab, 0x93, 0x56, 0x77, 0x12, 0xed, 0xe8, 0xe6, 0x02, 0x4b, 0x45, 0x21, 0x04, 0x7f, 0xf9,
	0xc8, 0xc3, 0xb2, 0x54, 0x94, 0xca, 0x8b, 0x6d, 0x5e, 0xc3, 0x6d, 0xb0, 0x64, 0x39, 0x34, 0x70,
	0xd1, 0xc0, 0xe0, 0x58, 0x86, 0x63, 0xd9, 0xb8, 0xd7, 0x8a, 0x28, 0x9b, 0x00, 0x44, 0x72, 0x8a,
	0x99, 0xe1, 0x58, 0xf2, 0x2c, 0x27, 0x2c, 0xc6, 0x9d, 0x86, 0x05, 0xf7, 0x41, 0xd6, 0x0c, 0x31,
	0x62, 0xd8, 0x88, 0x76, 0xca, 0x7f, 0x73, 0xf3, 0x85, 0xc4, 0x7c, 0x72, 0x81, 0x95, 0x6e, 0x72,
	0x81, 0xdb, 0x40, 0xd0, 0xa3, 0x46, 0x24, 0xee, 0x07, 0xd6, 0x50, 0x9c, 0x9d, 0x2e, 0x16, 0x74,
	0x2e, 0x7e, 0x0f, 0xf2, 0x16, 0x0e, 0x5c, 0x32, 0xe0, 0x21, 0x52, 0x86, 0x18, 0x96, 0x17, 0x8a,
	0x52, 0x39, 0x57, 0x7d, 0x96, 0x96, 0x1d, 0x0f, 0x44, 0xa9, 0x0f, 0x55, 0x9d, 0x48, 0xd4, 0x5e,
	0xb6, 0x1e, 0x37, 0xa2, 0xa4, 0x30, 0x43, 0xb6, 0x0c, 0x44, 0x52, 0x51, 0x0d, 0x6b, 0x60, 0xde,
	0x45, 0x3d, 0xec, 0x52, 0xb9, 0x54, 0x9c, 0x2d, 0x67, 0xab, 0x4f, 0x27, 0xef, 0x38, 0xe2, 0x5c,
	0xdd, 0x67, 0xe1, 0xa0, 0x1d, 0x0b, 0x0b, 0x7b, 0x20, 0xfb, 0xa0, 0x0d, 0xf3, 0x60, 0xf6, 0x0b,
	0x1e, 0xc4, 0x9f, 0x23, 0x2a, 0xe1, 0x0a, 0x98, 0xbb, 0x44, 0x6e, 0x3f, 0xf9, 0x0c, 0xe2, 0x41,
	0xcb, 0xec, 0x4a, 0xa5, 0x77, 0x60, 0x79, 0xc4, 0x35, 0x2c, 0x82, 0x8d, 0xba, 0x7e, 0x72, 0x74,
	0xfc, 0xa1, 0xa9, 0xb7, 0xba, 0x46, 0xa7, 0x5b, 0xeb, 0xea, 0xc6, 0x69, 0xab, 0x73, 0xa2, 0x1f,
	0x36, 0x5e, 0x37, 0xf4, 0x7a, 0x7e, 0x06, 0x2e, 0x81, 0x05, 0xc1, 0xd0, 0xeb, 0x79, 0x09, 0xe6,
	0x00, 0x38, 0x6d, 0x0d, 0x9f, 0x33, 0x1a, 0xba, 0xab, 0x7d, 0x02, 0xeb, 0xb1, 0x6f, 0xf1, 0x2e,
	0x28, 0x70, 0xa8, 0x62, 0x12, 0x4f, 0x15, 0x3f, 0x9e, 0xaf, 0x82, 0x90, 0x44, 0x97, 0x88, 0xaa,
	0xd7, 0x71, 0x65, 0x38, 0xd6, 0x8d, 0xea, 0x12, 0x71, 0xc5, 0xa9, 0x7a, 0x9d, 0x94, 0xbc, 0xcf,
	0x8f, 0x31, 0x55, 0xaf, 0xc5, 0x71, 0x76, 0xac, 0x9b, 0x83, 0x3c, 0xc8, 0x3d, 0x3e, 0xdb, 0x07,
	0xb7, 0x12, 0x28, 0x98, 0xc4, 0x4b, 0xc9, 0xee, 0x44, 0xfa, 0xf8, 0x32, 0x46, 0x6c, 0xe2, 0x22,
	0xdf, 0x56, 0x48, 0x68, 0xab, 0x36, 0xf6, 0xf9, 0x49, 0x50, 0xef, 0x4d, 0x8e, 0xfe, 0x85, 0xec,
	0x8b, 0xea, 0x36, 0xb3, 0xfa, 0x46, 0xc8, 0x0f, 0xf9, 0xe0, 0x5a, 0x9f, 0x91, 0xe6, 0x91, 0x72,
	0x56, 0xf9, 0x9d, 0x00, 0xe7, 0x1c, 0x38, 0x17, 0xc0, 0xf9, 0x59, 0xe5, 0x2e, 0xb3, 0x26, 0x00,
	0x4d, 0xe3, 0x88, 0xa6, 0x09, 0x48, 0xd3, 0xce, 0x2a, 0xbd, 0x79, 0xbe, 0x76, 0xe7, 0x4f, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x9b, 0x0b, 0xbd, 0xec, 0x56, 0x07, 0x00, 0x00,
}
