# v1.8 to v2.0

## Redis Upgraded to v6.2.1

The bundled Redis version has been upgraded to v6.2.1.

The Redis itself should be able to upgrade with no downtime, as well as Argo CD does not use it as a persistent store.
However, if you are running Argo CD in production with multiple users it is recommended to upgrade during off-peak
hours to avoid user-visible failures.

## Environment variables expansion

Argo CD supports using [environment variables](../../../user-guide/build-environment/) in
config management tools parameters. The expansion logic has been improved and now expands missing environment variables
into an empty string.

## Docker image migrated to use Ubuntu as base

The official Docker image has been migrated to use `ubuntu:20.10` instead of
`debian:10-slim` as base image. While this should not affect user experience,
you might be affected if you use custom-built images and/or include third party
tools in custom-built images.

Please make sure that your custom tools are still working with the update to
v2.0 before deploying it onto production.

## Container registry switched to quay.io and sundown of Docker Hub repository

Due to Docker Hub's new rate-limiting and retention policies, the Argo project
has decided to switch to the
[quay.io](https://quay.io)
registry as a new home for all images published by its sub-projects.

As of Argo CD version 2.0, the installation manifests are configured to pull the
container images from `quay.io` and we announce the **sundown** of the existing
Docker Hub repositories. For the 2.0 release this means, we will still push to
both registries, but we will stop pushing images to Docker Hub once Argo CD 2.1
has been released.

Please make sure that your clusters can pull from the `quay.io` registry.
If you aren't able to do so timely, you can change the container image slugs in
the installation manually to Docker Hub as a workaround to install Argo CD 2.0.
This workaround will not be possible anymore with 2.1, however.

## Dex tool migrated from argocd-util to argocd-dex

The dex commands `rundex` and `gendexcfg` have been migrated from `argocd-util` to `argocd-dex`.
It means that you need to update `argocd-dex-server` deployment's commands to install `argocd-dex` 
binary instead of `argocd-util` in init container and run dex command from `argocd-dex` instead of `argocd-util`:

```bash
initContainers:
- command:
  - cp
  - -n
  - /usr/local/bin/argocd
  - /shared/argocd-dex
```

```bash
containers:
- command:
  - /shared/argocd-dex
  - rundex
```
Note that starting from v2.0 argocd binary behaviour has changed. 
It will have all argocd binaries such `argocd-dex`, `argocd-server`, `argocd-repo-server`, 
`argocd-application-controller`, `argocd-util`, `argocd` baked inside. 
The binary will change behaviour based on its name. 

## Updated retry params type from String to Duration for app sync

App Sync command exposes certain retry options, which allows the users to parameterize the sync retries. 
Two of those params, `retry-backoff-duration` and `retry-backoff-max-duration` were declared as type `string` rather than `duration`. 
This allowed users to provide the values to these flags without time unit (seconds, minutes, hours ...) or any random string as well, 
but since we have migrated from `string` to `duration`, it is now mandatory for users to provide a unit (valid duration).

```bash
EXAMPLE: 
argocd app sync <app-name> --retry-backoff-duration=10 -> invalid
argocd app sync <app-name> --retry-backoff-duration=10s -> valid
```

## Switch to Golang 1.16

The official Argo CD binaries are now being build using Go 1.16, making a jump
from the previous 1.14.x. Users should note that Go 1.15 introduced deprecation
of validating server names against the `CommonName` property of a certificate
when performing TLS connections.

If you have repository servers with an incompatible certificate, connections to
those servers might break. You will have to issue correct certificates to 
unbreak such a situation.

## Migration of CRDs from apiextensions/v1beta1 to apiextensions/v1

Our CRDs (`Application` and `AppProject`) have been moved from the
deprecated `apiextensions/v1beta1` to the `apiextensions/v1` API group.

This does **not** affect the version of the CRDs themselves.

We do not expect that changes to existing CRs for `Application` and `AppProject`
are required from users, or that this change requires otherwise actions and this
note is just included for completeness.

## Helm v3 is now the default when rendering Charts

With this release, we made Helm v3 being the default version for rendering any
Helm charts through Argo CD. We also disabled the Helm version auto-detection
depending on the `apiVersion` field of the `Chart.yaml`, so the charts will
be rendered using Helm v3 regardless of what's in the Chart's `apiVersion`
field.

This can result in minor out-of-sync conditions on your Applications that were
previously rendered using Helm v2 (e.g. a change in one of the annotations that
Helm adds). You can fix this by syncing the Application.

If you have existing Charts that require to be rendered using Helm v2, you will
need to explicitly configure your Application to use Helm v2 for rendering the
chart, as described 
[here](../../user-guide/helm.md#helm-version)

Please also note that Helm v2 is now being considered deprecated in Argo CD, as
it will not receive any updates from the upstream Helm project anymore. We will
still ship the Helm v2 binary for the next two releases, but it will be subject
to removal after that grace period.

Users are encouraged to upgrade any Charts that still require Helm v2 to be
compatible with Helm v3.

## Kustomize version updated to v3.9.4

Argo CD now ships with Kustomize v3.9.4 by default. Please make sure that your
manifests will render correctly with this Kustomize version.

If you need backwards compatibility to a previous version of Kustomize, please
consider setting up a custom Kustomize version and configure your Applications
to be rendered using that specific version.
