---
title: Welcome to Foundation 6
description: We built Foundation for Sites to be the most advanced responsive front-end framework in the world.
tags:
  - index
  - home

video-hero: true

---

## Installing Foundation

There are a number of ways to install Foundation for Sites. Our installation page will help you find the best option for you.

<a href="installation.html" class="large button">Install Foundation for Sites</a>

---

## New to Foundation for Sites?

<div class="callout training-callout">
  <p>The number one way to learn your way around Foundation and start mastering responsive web development is via the training courses offered by the ZURB team.</p>
  <a class="button" href="http://zurb.com/university/foundation-intro" target="_blank">Check out the next Foundation training →</a>
</div>

With an easy to understand syntax and consistent structure, you'll learn your way around Foundation in no time!

<ul class="accordion welcome-accordion" data-accordion data-allow-all-closed="true">
  <li class="accordion-item welcome-accordion-item" data-accordion-item>
    <a href="#" class="accordion-title">Getting Started</a>
    <div class="accordion-content" data-tab-content>

      <a href="{{root}}starter-projects.html?video=lFrpnk0Oo_8" target="_blank">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://i3.ytimg.com/vi/lFrpnk0Oo_8/maxresdefault.jpg" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>Foundation Starter Projects - CSS Download</h5>
            <p>This video will take you through downloading and getting started with the Foundation CSS project.</p>
            <span class="accordion-content-item-cta"><img src="{{root}}assets/img/icons/watch-video-icon.svg" class="" height="" width="" alt=""> Watch Video</span>
          </div>
        </div>
      </a>

      <a href="{{root}}starter-projects.html?video=3Uj74uJ3GSQ" target="_blank">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://i3.ytimg.com/vi/3Uj74uJ3GSQ/maxresdefault.jpg" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>Foundation Starter Projects - ZURB Stack</h5>
            <p>This video will take you through downloading and getting started with the Foundation ZURB stack.</p>
            <span class="accordion-content-item-cta"><img src="{{root}}assets/img/icons/watch-video-icon.svg" class="" height="" width="" alt=""> Watch Video</span>
          </div>
        </div>
      </a>

    </div>
  </li>

  <li class="accordion-item welcome-accordion-item" data-accordion-item>
    <a href="#" class="accordion-title">Why Foundation</a>

    <div class="accordion-content" data-tab-content>

      <a target="_blank" href="http://foundation.zurb.com/learn/get-your-team-on-a-solid-foundation.html">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://i.ytimg.com/vi/kLgRITKjcWw/mqdefault.jpg" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>The World’s Most Advanced Front-end Framework</h5>
            <p>Coming from another framework? It’s the perfect time to make the switch and learn Foundation. Download our free e-book that will help you convince your team that Foundation is better, easier to learn, and more flexible than anything else out there.
            </p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="http://foundation.zurb.com/learn/build-your-career-on-a-solid-foundation.html">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://i.ytimg.com/vi/dZZk9Kz5j_0/mqdefault.jpg" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>Build Your Career on a Solid Foundation</h5>
            <p>Web technologies are rapidly changing, but time and resources are finite. Find out why Learning Foundation places you at the cutting edge of the website development.
            </p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <!-- <div class="grid-x grid-margin-x accordion-content-item">
        <div class="cell medium-4 accordion-content-item-thumbnail">
          <div class="responsive-embed widescreen">
            <img src="https://placehold.it/300x300" class="" height="" width="" alt="">
          </div>
        </div>
        <div class="cell medium-8">
          <h5>Leverage the Power of Design for Your Business</h5>
          <p>With a robust ecosystem of community integrations, and the new Foundation Building Blocks, Foundation can help bridge the gap between your development team and your designers. Check out our free e-book on how you can use Foundation to leverage the power of design in your business.
          </p>
          <a target="_blank" href="#" class="accordion-content-item-cta">Learn More</a>
        </div>
      </div> -->


    </div>
  </li>

  <li class="accordion-item welcome-accordion-item" data-accordion-item>
    <a href="#" class="accordion-title">Templates and Code Snippets</a>
    <div class="accordion-content " data-tab-content>

      <a target="_blank" href="http://foundation.zurb.com/templates.html">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://foundation.zurb.com/assets/img/sites-templates/foundation6-templates-07.svg">
          </div>
          <div class="cell medium-8">
            <h5>Foundation Templates</h5>
            <p>Get eight responsive templates to kick off your projects built with the same techniques we teach in our Introduction to Foundation 6 Course to build your business upon.</p>
            <span class="accordion-content-item-cta">View Templates</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="http://zurb.com/article/1469/foundation-building-blocks-over-100-compo">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://i3.ytimg.com/vi/SmhGUT_N-jw/maxresdefault.jpg" class="" height="" width="" alt="" style="height: 142px;">
          </div>
          <div class="cell medium-8">
            <h5>Foundation Building Blocks</h5>
            <p>Building Blocks are coded UI components you can drop into any standard Foundation project. Building Blocks will help you rapidly accelerate your development time.</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="http://foundation.zurb.com/building-blocks/kits.html">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://foundation.zurb.com/building-blocks/assets/img/kits/dashboard/dashboard-kit.jpg" style="height: 142px; width: 100%;">
          </div>
          <div class="cell medium-8">
            <h5>Foundation Kits</h5>
            <p>Foundation Kits are curated bundles of Building Blocks designed for building specific types of websites and apps. Download from 7 powerful Kits to jumpstart your next project.</p>
            <span class="accordion-content-item-cta">View Kits</span>
          </div>
        </div>
      </a>

    </div>
  </li>

  <li class="accordion-item welcome-accordion-item" data-accordion-item>
    <a href="#" class="accordion-title">Additional Resources</a>
    <div class="accordion-content" data-tab-content>

      <a target="_blank" href="http://foundation.zurb.com/learn/zero-to-website-in-no-time-flat.html">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://i.ytimg.com/vi/KHMXOTbLAGE/mqdefault.jpg" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>Zero to Website Guide</h5>
            <p>Learning a framework for the first time can be overwhelming, so we’ve put together “Zero to Website,” a 60-page guide that will walk you through coding a real, live, responsive website from scratch with Foundation.</p>
            <span class="accordion-content-item-cta">Get The Guide</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="http://zurb.com/university/foundation-intro">
        <div class="grid-x grid-margin-x accordion-content-item accordion-course-callout">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="{{root}}assets/img/foundation-intro-class.jpg" style="height: 142px;">
          </div>
          <div class="cell medium-8">
            <h5>Live Webinar: Introduction to Foundation 6</h5>
            <p>Master Foundation ultra fast. The Foundation team will get you up to speed on everything you need to know to get the most out of Foundation 6.</p>
            <span href="http://zurb.com/university/foundation-intro" class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>
    </div>
  </li>

</ul>

---

## Experienced with Foundation for Sites?

With an easy to understand syntax and consistent structure, you'll learn your way around Foundation in no time!

<ul class="accordion welcome-accordion" data-accordion data-allow-all-closed="true">
  <li class="accordion-item welcome-accordion-item" data-accordion-item>
    <a href="#" class="accordion-title">Latest Foundation Updates</a>
    <div class="accordion-content" data-tab-content>

      <a target="_blank" href="http://zurb.com/blog/foundation-6-4-a-new-grid-javascript-upgrades-and-slick-new-prototyping-mode">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://i3.ytimg.com/vi/vrvt9xMFjIE/maxresdefault.jpg" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>Foundation 6.4.0 Update: A New Grid, JavaScript Upgrades, and Slick New Prototyping Mode</h5>
            <p>Foundation 6.4 has dropped and it is AWESOME. This new release is jampacked with some incredible new features that enable you to build layouts and designs with Foundation that weren’t possible before.</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="https://github.com/zurb/foundation-sites/releases/tag/6.3.1">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="{{root}}assets/img/docs-631.png" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>Foundation 6.3.1 Update: Sass mixins and bug fixes</h5>
            <p>Foundation 6.3.1 contains plenty of bug fixes underlying reworks to old features. Along with bug fixes, Foundation gets some some new Sass mixins and optimizations that make it work in more scenarios and the docs got a lot of love. Enjoy it!</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

    </div>

  </li>
  <li class="accordion-item welcome-accordion-item" data-accordion-item>
    <a href="#" class="accordion-title">Building Blocks</a>
    <div class="accordion-content" data-tab-content>

      <a target="_blank" href="http://zurb.com/article/1469/foundation-building-blocks-over-100-compo">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://i3.ytimg.com/vi/SmhGUT_N-jw/maxresdefault.jpg" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>Foundation Building Blocks Accelerate Your Development</h5>
            <p>Building Blocks are coded UI components you can drop into any standard Foundation project. Building Blocks will help you rapidly accelerate your development time.</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="http://foundation.zurb.com/building-blocks/how-to.html">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://i3.ytimg.com/vi/adLpmsU9v2g/maxresdefault.jpg" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>How to Use ZURB Foundation's Building Blocks</h5>
            <p>The Foundation team has cut your development time in half again with Foundation Building Blocks. In this tutorial we'll show you how to find the right building block and the way to install it that works best for you.</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

    </div>

  </li>
  <li class="accordion-item welcome-accordion-item" data-accordion-item>
    <a href="#" class="accordion-title">Foundation Integrations</a>
    <div class="accordion-content" data-tab-content>

      <a target="_blank" href="https://circlingthesun.github.io/angular-foundation-6/">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-3 accordion-content-item-thumbnail">
            <img src="https://circlingthesun.github.io/angular-foundation-6/assets/logo.png" class="" height="147" width="147" alt="" style="border: 0;">
          </div>
          <div class="cell medium-9">
            <h5>Angular Foundation 6</h5>
            <p>The awesome folks at Pinecone created an Angular port for Foundation. Angular.js assists with creating single-page applications, one-page web applications that only require HTML, CSS, and JavaScript on the client side.</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="https://react.foundation/">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-3 accordion-content-item-thumbnail">
            <img src="https://cdn.worldvectorlogo.com/logos/react.svg" class="" height="" width="" alt="" style="border: 0;">
          </div>
          <div class="cell medium-9">
            <h5>React + Foundation 6</h5>
            <p>React is a JavaScript library for building user interfaces. Now you can use Foundation for Sites 6 components implemented in React with CSS Modules!</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="http://jointswp.com/">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-3 accordion-content-item-thumbnail">
            <img src="https://s.w.org/about/images/logos/wordpress-logo-simplified-rgb.png" class="" height="147" width="147" alt="" style="border: 0;">
          </div>
          <div class="cell medium-9">
            <h5>JointsWP: Foundation 6 meets WordPress</h5>
            <p>JointsWP is a blank WordPress theme built with Foundation 6, giving you all the power and flexibility you need to build complex, mobile friendly websites without starting from scratch.</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="https://cell medium.com/@tommaso.marcelli/setting-up-vue-2-and-foundation-6-3f858b4ad20">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-3 accordion-content-item-thumbnail">
            <img src="{{root}}assets/img/docs-vue.jpeg" class="" height="147" width="147" alt="" style="border: 0;">
          </div>
          <div class="cell medium-9">
            <h5>Setting up Vue 2 and Foundation 6</h5>
            <p>This is a demo integration of Foundation for Sites 6.3 in a VueJS 2.1 single-page application.</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </div>
    </a>

  </li>
  <li class="accordion-item welcome-accordion-item" data-accordion-item>
    <a href="#" class="accordion-title">Foundation Showcase</a>
    <div class="accordion-content" data-tab-content>

      <a target="_blank" href="http://foundation.zurb.com/foundationturns5">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="{{root}}assets/img/foundation-turns-5.png" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>5 Years of Shaping the Web</h5>
            <p>This year Foundation turned five years old. It was the first to be responsive, the first to be semantic, the first to be mobile first, the first to be built with Sass, and the first to have accessibility built in. Learn more about the framework and where it's going next.</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="http://foundation.zurb.com/showcase/brands.html">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="{{root}}assets/img/foundation-brands.png" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>Foundation Brands</h5>
            <p>Big brands are relying more and more on the world's most advanced, responsive front-end framework. Their sites are now built so that customers can connect with them on any device.</p>
            <span class="accordion-content-item-cta">Learn More</span>
          </div>
        </div>
      </a>

      <a target="_blank" href="http://foundation.zurb.com/showcase/case-studies.html">
        <div class="grid-x grid-margin-x accordion-content-item">
          <div class="cell medium-4 accordion-content-item-thumbnail">
            <img src="https://foundation.zurb.com/assets/img/learn/case-studies/meundies-mockup1.jpg" class="" height="" width="" alt="">
          </div>
          <div class="cell medium-8">
            <h5>Foundation Case Studies</h5>
            <p>Foundation in the wild. See how people are using Foundation to build responsive, future-friendly sites. We learn what went into their designs, decisions, and how Foundation helped them get to their goals.</p>
          </div>
        </div>
      </a>
    </div>
  </li>
</ul>
