'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _Statement2 = require('../Statement');

var _Statement3 = _interopRequireDefault(_Statement2);

var _Traverse = require('../../Traverse');

var _Traverse2 = _interopRequireDefault(_Traverse);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Program = function (_Statement) {
    (0, _inherits3.default)(Program, _Statement);

    function Program(childNodes) {
        (0, _classCallCheck3.default)(this, Program);

        var _this = (0, _possibleConstructorReturn3.default)(this, (Program.__proto__ || (0, _getPrototypeOf2.default)(Program)).call(this, 'Program', childNodes));

        _this._isProgram = true;
        _this._traverse = new _Traverse2.default();
        _this._traverse.addElements(childNodes);
        _this._eventListeners = {};
        return _this;
    }

    (0, _createClass3.default)(Program, [{
        key: '_acceptPlugins',
        value: function _acceptPlugins(plugins) {
            this.plugins = plugins;
        }
    }, {
        key: '_acceptChildren',
        value: function _acceptChildren(children) {
            if (children.isToken('Hashbang')) {
                children.passToken('Hashbang');
            }

            children.skipNonCode();

            var directives = [];
            while (children.isNode('Directive')) {
                directives.push(children.passNode());
                children.skipNonCode();
            }

            var body = [];
            while (children.isStatement()) {
                body.push(children.passStatement());
                children.skipNonCode();
            }

            children.passToken('EOF');
            children.assertEnd();

            this.body = body;
            this.directives = directives;
        }

        /**
         * Returns node list with specified type from the tree.
         *
         * @param {String} type
         * @returns {Node[]}
         */

    }, {
        key: 'selectNodesByType',
        value: function selectNodesByType(type) {
            return this._traverse.selectNodesByType(type);
        }

        /**
         * Returns tokens list with specified type from the tree.
         *
         * @param {String} type
         * @returns {Token[]}
         */

    }, {
        key: 'selectTokensByType',
        value: function selectTokensByType(type) {
            return this._traverse.selectTokensByType(type);
        }
    }, {
        key: '_addElementsToProgram',
        value: function _addElementsToProgram(elements) {
            this._traverse.addElements(elements);
            this._emit('elements-add', elements);
        }
    }, {
        key: '_prependElementsToProgram',
        value: function _prependElementsToProgram(elements) {
            this._traverse.prependElements(elements);
            this._emit('elements-add', elements);
        }
    }, {
        key: '_removeElementsFromProgram',
        value: function _removeElementsFromProgram(elements) {
            this._traverse.removeElements(elements);
            this._emit('elements-remove', elements);
        }
    }, {
        key: 'on',
        value: function on(eventName, callback) {
            if (this._eventListeners[eventName]) {
                this._eventListeners[eventName].push(callback);
            } else {
                this._eventListeners[eventName] = [callback];
            }
        }
    }, {
        key: 'off',
        value: function off(eventName, callback) {
            if (this._eventListeners[eventName]) {
                this._eventListeners[eventName] = this._eventListeners[eventName].filter(function (handler) {
                    return callback !== handler;
                });
            }
        }
    }, {
        key: '_emit',
        value: function _emit(eventName, data) {
            var handlers = this._eventListeners[eventName];
            if (handlers) {
                for (var i = 0; i < handlers.length; i++) {
                    handlers[i](data);
                }
            }
        }
    }]);
    return Program;
}(_Statement3.default);

exports.default = Program;
//# sourceMappingURL=Program.js.map