'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _Element2 = require('./Element');

var _Element3 = _interopRequireDefault(_Element2);

var _lines = require('../utils/lines');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Token = function (_Element) {
    (0, _inherits3.default)(Token, _Element);
    (0, _createClass3.default)(Token, null, [{
        key: 'create',

        /**
         * Generic token constructor.
         *
         * @param {String} type
         * @param {*} value
         */
        value: function create(type, value) {
            return new Token(type, value, valueToSourceCode(type, value));
        }

        /**
         * Creates new token using babel/acorn parser token.
         *
         * @param {{type: String, value: String, sourceCode: String}} token
         */

    }, {
        key: 'createFromToken',
        value: function createFromToken(token) {
            return new Token(token.type, token.value, token.sourceCode);
        }

        /**
         * @param {String} type
         * @param {String} value
         * @param {String} _sourceCode private source code argument
         */

    }]);

    function Token(type, value, _sourceCode) {
        (0, _classCallCheck3.default)(this, Token);

        var _this = (0, _possibleConstructorReturn3.default)(this, (Token.__proto__ || (0, _getPrototypeOf2.default)(Token)).call(this, type, []));

        if (arguments.length === 2) {
            _sourceCode = valueToSourceCode(type, value);
        }

        var isComment = false;
        var isWhitespace = false;
        var isCode = true;
        switch (type) {
            case 'CommentLine':
                isComment = true;
                isCode = false;
                break;
            case 'CommentBlock':
                isComment = true;
                isCode = false;
                break;
            case 'Whitespace':
                isWhitespace = true;
                isCode = false;
                break;
            case 'AppleInstrumentationDirective':
            case 'GritDirective':
            case 'Hashbang':
                isCode = false;
                break;
        }
        _this.value = value;
        _this._sourceCode = _sourceCode;
        _this._sourceCodeLength = _sourceCode.length;
        _this._sourceCodeLines = (0, _lines.getLines)(_sourceCode);
        _this.isToken = true;
        _this.isComment = isComment;
        _this.isWhitespace = isWhitespace;
        _this.isCode = isCode;
        _this.isNonCodeToken = !isCode;
        return _this;
    }

    (0, _createClass3.default)(Token, [{
        key: 'getFirstToken',
        value: function getFirstToken() {
            return this;
        }
    }, {
        key: 'getLastToken',
        value: function getLastToken() {
            return this;
        }
    }, {
        key: 'getSourceCode',
        value: function getSourceCode() {
            return this._sourceCode;
        }
    }, {
        key: 'getSourceCodeLength',
        value: function getSourceCodeLength() {
            return this._sourceCodeLength;
        }
    }, {
        key: 'getSourceCodeLines',
        value: function getSourceCodeLines() {
            return this._sourceCodeLines;
        }
    }, {
        key: 'getNewlineCount',
        value: function getNewlineCount() {
            return this._sourceCodeLines.length - 1;
        }
    }, {
        key: 'getValueLineInfo',
        value: function getValueLineInfo() {
            return (0, _lines.getLineInfo)(this.value);
        }
    }, {
        key: '_setChildren',
        value: function _setChildren(newChildren) {
            if (newChildren.length > 0) {
                throw new Error('Token nodes cannot contain child nodes');
            }

            this.childElements = newChildren;
        }

        /**
         * Clones current Element structure.
         *
         * @returns {Element}
         */

    }, {
        key: 'cloneElement',
        value: function cloneElement() {
            return new Token(this.type, this.value, this._sourceCode);
        }
    }]);
    return Token;
}(_Element3.default);

exports.default = Token;


function valueToSourceCode(type, value) {
    switch (type) {
        case 'CommentLine':
            return '//' + value;

        case 'CommentBlock':
            return '/*' + value + '*/';

        case 'RegularExpression':
            return String(value);

        case 'Numeric':
        case 'Boolean':
        case 'Null':
            return String(value);

        default:
            return value;
    }
}
//# sourceMappingURL=Token.js.map