// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53resolver

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateResolverEndpointIpAddress = "AssociateResolverEndpointIpAddress"

// AssociateResolverEndpointIpAddressRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResolverEndpointIpAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResolverEndpointIpAddress for more information on using the AssociateResolverEndpointIpAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateResolverEndpointIpAddressRequest method.
//    req, resp := client.AssociateResolverEndpointIpAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress
func (c *Route53Resolver) AssociateResolverEndpointIpAddressRequest(input *AssociateResolverEndpointIpAddressInput) (req *request.Request, output *AssociateResolverEndpointIpAddressOutput) {
	op := &request.Operation{
		Name:       opAssociateResolverEndpointIpAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateResolverEndpointIpAddressInput{}
	}

	output = &AssociateResolverEndpointIpAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResolverEndpointIpAddress API operation for Amazon Route 53 Resolver.
//
// Adds IP addresses to an inbound or an outbound Resolver endpoint. If you
// want to add more than one IP address, submit one AssociateResolverEndpointIpAddress
// request for each IP address.
//
// To remove an IP address from an endpoint, see DisassociateResolverEndpointIpAddress
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation AssociateResolverEndpointIpAddress for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceExistsException
//   The resource that you tried to create already exists.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * LimitExceededException
//   The request caused one or more limits to be exceeded.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress
func (c *Route53Resolver) AssociateResolverEndpointIpAddress(input *AssociateResolverEndpointIpAddressInput) (*AssociateResolverEndpointIpAddressOutput, error) {
	req, out := c.AssociateResolverEndpointIpAddressRequest(input)
	return out, req.Send()
}

// AssociateResolverEndpointIpAddressWithContext is the same as AssociateResolverEndpointIpAddress with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResolverEndpointIpAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) AssociateResolverEndpointIpAddressWithContext(ctx aws.Context, input *AssociateResolverEndpointIpAddressInput, opts ...request.Option) (*AssociateResolverEndpointIpAddressOutput, error) {
	req, out := c.AssociateResolverEndpointIpAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResolverQueryLogConfig = "AssociateResolverQueryLogConfig"

// AssociateResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResolverQueryLogConfig for more information on using the AssociateResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateResolverQueryLogConfigRequest method.
//    req, resp := client.AssociateResolverQueryLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverQueryLogConfig
func (c *Route53Resolver) AssociateResolverQueryLogConfigRequest(input *AssociateResolverQueryLogConfigInput) (req *request.Request, output *AssociateResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opAssociateResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateResolverQueryLogConfigInput{}
	}

	output = &AssociateResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Associates an Amazon VPC with a specified query logging configuration. Route
// 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that
// are associated with a specified query logging configuration. To associate
// more than one VPC with a configuration, submit one AssociateResolverQueryLogConfig
// request for each VPC.
//
// The VPCs that you associate with a query logging configuration must be in
// the same Region as the configuration.
//
// To remove a VPC from a query logging configuration, see DisassociateResolverQueryLogConfig
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation AssociateResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceExistsException
//   The resource that you tried to create already exists.
//
//   * LimitExceededException
//   The request caused one or more limits to be exceeded.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverQueryLogConfig
func (c *Route53Resolver) AssociateResolverQueryLogConfig(input *AssociateResolverQueryLogConfigInput) (*AssociateResolverQueryLogConfigOutput, error) {
	req, out := c.AssociateResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// AssociateResolverQueryLogConfigWithContext is the same as AssociateResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) AssociateResolverQueryLogConfigWithContext(ctx aws.Context, input *AssociateResolverQueryLogConfigInput, opts ...request.Option) (*AssociateResolverQueryLogConfigOutput, error) {
	req, out := c.AssociateResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResolverRule = "AssociateResolverRule"

// AssociateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResolverRule for more information on using the AssociateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateResolverRuleRequest method.
//    req, resp := client.AssociateResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule
func (c *Route53Resolver) AssociateResolverRuleRequest(input *AssociateResolverRuleInput) (req *request.Request, output *AssociateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opAssociateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateResolverRuleInput{}
	}

	output = &AssociateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResolverRule API operation for Amazon Route 53 Resolver.
//
// Associates a Resolver rule with a VPC. When you associate a rule with a VPC,
// Resolver forwards all DNS queries for the domain name that is specified in
// the rule and that originate in the VPC. The queries are forwarded to the
// IP addresses for the DNS resolvers that are specified in the rule. For more
// information about rules, see CreateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation AssociateResolverRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * LimitExceededException
//   The request caused one or more limits to be exceeded.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * ResourceUnavailableException
//   The specified resource isn't available.
//
//   * ResourceExistsException
//   The resource that you tried to create already exists.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule
func (c *Route53Resolver) AssociateResolverRule(input *AssociateResolverRuleInput) (*AssociateResolverRuleOutput, error) {
	req, out := c.AssociateResolverRuleRequest(input)
	return out, req.Send()
}

// AssociateResolverRuleWithContext is the same as AssociateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) AssociateResolverRuleWithContext(ctx aws.Context, input *AssociateResolverRuleInput, opts ...request.Option) (*AssociateResolverRuleOutput, error) {
	req, out := c.AssociateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverEndpoint = "CreateResolverEndpoint"

// CreateResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResolverEndpoint for more information on using the CreateResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResolverEndpointRequest method.
//    req, resp := client.CreateResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint
func (c *Route53Resolver) CreateResolverEndpointRequest(input *CreateResolverEndpointInput) (req *request.Request, output *CreateResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverEndpointInput{}
	}

	output = &CreateResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound
// and outbound:
//
//    * An inbound Resolver endpoint forwards DNS queries to the DNS service
//    for a VPC from your network.
//
//    * An outbound Resolver endpoint forwards DNS queries from the DNS service
//    for a VPC to your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateResolverEndpoint for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceExistsException
//   The resource that you tried to create already exists.
//
//   * LimitExceededException
//   The request caused one or more limits to be exceeded.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint
func (c *Route53Resolver) CreateResolverEndpoint(input *CreateResolverEndpointInput) (*CreateResolverEndpointOutput, error) {
	req, out := c.CreateResolverEndpointRequest(input)
	return out, req.Send()
}

// CreateResolverEndpointWithContext is the same as CreateResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateResolverEndpointWithContext(ctx aws.Context, input *CreateResolverEndpointInput, opts ...request.Option) (*CreateResolverEndpointOutput, error) {
	req, out := c.CreateResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverQueryLogConfig = "CreateResolverQueryLogConfig"

// CreateResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResolverQueryLogConfig for more information on using the CreateResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResolverQueryLogConfigRequest method.
//    req, resp := client.CreateResolverQueryLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverQueryLogConfig
func (c *Route53Resolver) CreateResolverQueryLogConfigRequest(input *CreateResolverQueryLogConfigInput) (req *request.Request, output *CreateResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opCreateResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverQueryLogConfigInput{}
	}

	output = &CreateResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Creates a Resolver query logging configuration, which defines where you want
// Resolver to save DNS query logs that originate in your VPCs. Resolver can
// log queries only for VPCs that are in the same Region as the query logging
// configuration.
//
// To specify which VPCs you want to log queries for, you use AssociateResolverQueryLogConfig.
// For more information, see AssociateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html).
//
// You can optionally use AWS Resource Access Manager (AWS RAM) to share a query
// logging configuration with other AWS accounts. The other accounts can then
// associate VPCs with the configuration. The query logs that Resolver creates
// for a configuration include all DNS queries that originate in all VPCs that
// are associated with the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceExistsException
//   The resource that you tried to create already exists.
//
//   * LimitExceededException
//   The request caused one or more limits to be exceeded.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverQueryLogConfig
func (c *Route53Resolver) CreateResolverQueryLogConfig(input *CreateResolverQueryLogConfigInput) (*CreateResolverQueryLogConfigOutput, error) {
	req, out := c.CreateResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// CreateResolverQueryLogConfigWithContext is the same as CreateResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateResolverQueryLogConfigWithContext(ctx aws.Context, input *CreateResolverQueryLogConfigInput, opts ...request.Option) (*CreateResolverQueryLogConfigOutput, error) {
	req, out := c.CreateResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverRule = "CreateResolverRule"

// CreateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResolverRule for more information on using the CreateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResolverRuleRequest method.
//    req, resp := client.CreateResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule
func (c *Route53Resolver) CreateResolverRuleRequest(input *CreateResolverRuleInput) (req *request.Request, output *CreateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opCreateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverRuleInput{}
	}

	output = &CreateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResolverRule API operation for Amazon Route 53 Resolver.
//
// For DNS queries that originate in your VPCs, specifies which Resolver endpoint
// the queries pass through, one domain name that you want to forward to your
// network, and the IP addresses of the DNS resolvers in your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateResolverRule for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * LimitExceededException
//   The request caused one or more limits to be exceeded.
//
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * ResourceExistsException
//   The resource that you tried to create already exists.
//
//   * ResourceUnavailableException
//   The specified resource isn't available.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule
func (c *Route53Resolver) CreateResolverRule(input *CreateResolverRuleInput) (*CreateResolverRuleOutput, error) {
	req, out := c.CreateResolverRuleRequest(input)
	return out, req.Send()
}

// CreateResolverRuleWithContext is the same as CreateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateResolverRuleWithContext(ctx aws.Context, input *CreateResolverRuleInput, opts ...request.Option) (*CreateResolverRuleOutput, error) {
	req, out := c.CreateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResolverEndpoint = "DeleteResolverEndpoint"

// DeleteResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResolverEndpoint for more information on using the DeleteResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResolverEndpointRequest method.
//    req, resp := client.DeleteResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint
func (c *Route53Resolver) DeleteResolverEndpointRequest(input *DeleteResolverEndpointInput) (req *request.Request, output *DeleteResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResolverEndpointInput{}
	}

	output = &DeleteResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends
// on whether it's an inbound or an outbound Resolver endpoint:
//
//    * Inbound: DNS queries from your network are no longer routed to the DNS
//    service for the specified VPC.
//
//    * Outbound: DNS queries from a VPC are no longer routed to your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteResolverEndpoint for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint
func (c *Route53Resolver) DeleteResolverEndpoint(input *DeleteResolverEndpointInput) (*DeleteResolverEndpointOutput, error) {
	req, out := c.DeleteResolverEndpointRequest(input)
	return out, req.Send()
}

// DeleteResolverEndpointWithContext is the same as DeleteResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteResolverEndpointWithContext(ctx aws.Context, input *DeleteResolverEndpointInput, opts ...request.Option) (*DeleteResolverEndpointOutput, error) {
	req, out := c.DeleteResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResolverQueryLogConfig = "DeleteResolverQueryLogConfig"

// DeleteResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResolverQueryLogConfig for more information on using the DeleteResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResolverQueryLogConfigRequest method.
//    req, resp := client.DeleteResolverQueryLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverQueryLogConfig
func (c *Route53Resolver) DeleteResolverQueryLogConfigRequest(input *DeleteResolverQueryLogConfigInput) (req *request.Request, output *DeleteResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResolverQueryLogConfigInput{}
	}

	output = &DeleteResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Deletes a query logging configuration. When you delete a configuration, Resolver
// stops logging DNS queries for all of the Amazon VPCs that are associated
// with the configuration. This also applies if the query logging configuration
// is shared with other AWS accounts, and the other accounts have associated
// VPCs with the shared configuration.
//
// Before you can delete a query logging configuration, you must first disassociate
// all VPCs from the configuration. See DisassociateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
//
// If you used Resource Access Manager (RAM) to share a query logging configuration
// with other accounts, you must stop sharing the configuration before you can
// delete a configuration. The accounts that you shared the configuration with
// can first disassociate VPCs that they associated with the configuration,
// but that's not necessary. If you stop sharing the configuration, those VPCs
// are automatically disassociated from the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverQueryLogConfig
func (c *Route53Resolver) DeleteResolverQueryLogConfig(input *DeleteResolverQueryLogConfigInput) (*DeleteResolverQueryLogConfigOutput, error) {
	req, out := c.DeleteResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// DeleteResolverQueryLogConfigWithContext is the same as DeleteResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteResolverQueryLogConfigWithContext(ctx aws.Context, input *DeleteResolverQueryLogConfigInput, opts ...request.Option) (*DeleteResolverQueryLogConfigOutput, error) {
	req, out := c.DeleteResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResolverRule = "DeleteResolverRule"

// DeleteResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResolverRule for more information on using the DeleteResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResolverRuleRequest method.
//    req, resp := client.DeleteResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule
func (c *Route53Resolver) DeleteResolverRuleRequest(input *DeleteResolverRuleInput) (req *request.Request, output *DeleteResolverRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResolverRuleInput{}
	}

	output = &DeleteResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResolverRule API operation for Amazon Route 53 Resolver.
//
// Deletes a Resolver rule. Before you can delete a Resolver rule, you must
// disassociate it from all the VPCs that you associated the Resolver rule with.
// For more information, see DisassociateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteResolverRule for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * ResourceInUseException
//   The resource that you tried to update or delete is currently in use.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule
func (c *Route53Resolver) DeleteResolverRule(input *DeleteResolverRuleInput) (*DeleteResolverRuleOutput, error) {
	req, out := c.DeleteResolverRuleRequest(input)
	return out, req.Send()
}

// DeleteResolverRuleWithContext is the same as DeleteResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteResolverRuleWithContext(ctx aws.Context, input *DeleteResolverRuleInput, opts ...request.Option) (*DeleteResolverRuleOutput, error) {
	req, out := c.DeleteResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResolverEndpointIpAddress = "DisassociateResolverEndpointIpAddress"

// DisassociateResolverEndpointIpAddressRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResolverEndpointIpAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResolverEndpointIpAddress for more information on using the DisassociateResolverEndpointIpAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateResolverEndpointIpAddressRequest method.
//    req, resp := client.DisassociateResolverEndpointIpAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress
func (c *Route53Resolver) DisassociateResolverEndpointIpAddressRequest(input *DisassociateResolverEndpointIpAddressInput) (req *request.Request, output *DisassociateResolverEndpointIpAddressOutput) {
	op := &request.Operation{
		Name:       opDisassociateResolverEndpointIpAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateResolverEndpointIpAddressInput{}
	}

	output = &DisassociateResolverEndpointIpAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResolverEndpointIpAddress API operation for Amazon Route 53 Resolver.
//
// Removes IP addresses from an inbound or an outbound Resolver endpoint. If
// you want to remove more than one IP address, submit one DisassociateResolverEndpointIpAddress
// request for each IP address.
//
// To add an IP address to an endpoint, see AssociateResolverEndpointIpAddress
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DisassociateResolverEndpointIpAddress for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceExistsException
//   The resource that you tried to create already exists.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress
func (c *Route53Resolver) DisassociateResolverEndpointIpAddress(input *DisassociateResolverEndpointIpAddressInput) (*DisassociateResolverEndpointIpAddressOutput, error) {
	req, out := c.DisassociateResolverEndpointIpAddressRequest(input)
	return out, req.Send()
}

// DisassociateResolverEndpointIpAddressWithContext is the same as DisassociateResolverEndpointIpAddress with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResolverEndpointIpAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DisassociateResolverEndpointIpAddressWithContext(ctx aws.Context, input *DisassociateResolverEndpointIpAddressInput, opts ...request.Option) (*DisassociateResolverEndpointIpAddressOutput, error) {
	req, out := c.DisassociateResolverEndpointIpAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResolverQueryLogConfig = "DisassociateResolverQueryLogConfig"

// DisassociateResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResolverQueryLogConfig for more information on using the DisassociateResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateResolverQueryLogConfigRequest method.
//    req, resp := client.DisassociateResolverQueryLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverQueryLogConfig
func (c *Route53Resolver) DisassociateResolverQueryLogConfigRequest(input *DisassociateResolverQueryLogConfigInput) (req *request.Request, output *DisassociateResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opDisassociateResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateResolverQueryLogConfigInput{}
	}

	output = &DisassociateResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Disassociates a VPC from a query logging configuration.
//
// Before you can delete a query logging configuration, you must first disassociate
// all VPCs from the configuration. If you used Resource Access Manager (RAM)
// to share a query logging configuration with other accounts, VPCs can be disassociated
// from the configuration in the following ways:
//
//    * The accounts that you shared the configuration with can disassociate
//    VPCs from the configuration.
//
//    * You can stop sharing the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DisassociateResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverQueryLogConfig
func (c *Route53Resolver) DisassociateResolverQueryLogConfig(input *DisassociateResolverQueryLogConfigInput) (*DisassociateResolverQueryLogConfigOutput, error) {
	req, out := c.DisassociateResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// DisassociateResolverQueryLogConfigWithContext is the same as DisassociateResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DisassociateResolverQueryLogConfigWithContext(ctx aws.Context, input *DisassociateResolverQueryLogConfigInput, opts ...request.Option) (*DisassociateResolverQueryLogConfigOutput, error) {
	req, out := c.DisassociateResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResolverRule = "DisassociateResolverRule"

// DisassociateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResolverRule for more information on using the DisassociateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateResolverRuleRequest method.
//    req, resp := client.DisassociateResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule
func (c *Route53Resolver) DisassociateResolverRuleRequest(input *DisassociateResolverRuleInput) (req *request.Request, output *DisassociateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opDisassociateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateResolverRuleInput{}
	}

	output = &DisassociateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResolverRule API operation for Amazon Route 53 Resolver.
//
// Removes the association between a specified Resolver rule and a specified
// VPC.
//
// If you disassociate a Resolver rule from a VPC, Resolver stops forwarding
// DNS queries for the domain name that you specified in the Resolver rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DisassociateResolverRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule
func (c *Route53Resolver) DisassociateResolverRule(input *DisassociateResolverRuleInput) (*DisassociateResolverRuleOutput, error) {
	req, out := c.DisassociateResolverRuleRequest(input)
	return out, req.Send()
}

// DisassociateResolverRuleWithContext is the same as DisassociateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DisassociateResolverRuleWithContext(ctx aws.Context, input *DisassociateResolverRuleInput, opts ...request.Option) (*DisassociateResolverRuleOutput, error) {
	req, out := c.DisassociateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverEndpoint = "GetResolverEndpoint"

// GetResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverEndpoint for more information on using the GetResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverEndpointRequest method.
//    req, resp := client.GetResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint
func (c *Route53Resolver) GetResolverEndpointRequest(input *GetResolverEndpointInput) (req *request.Request, output *GetResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opGetResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverEndpointInput{}
	}

	output = &GetResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified Resolver endpoint, such as whether it's
// an inbound or an outbound Resolver endpoint, and the current status of the
// endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverEndpoint for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint
func (c *Route53Resolver) GetResolverEndpoint(input *GetResolverEndpointInput) (*GetResolverEndpointOutput, error) {
	req, out := c.GetResolverEndpointRequest(input)
	return out, req.Send()
}

// GetResolverEndpointWithContext is the same as GetResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverEndpointWithContext(ctx aws.Context, input *GetResolverEndpointInput, opts ...request.Option) (*GetResolverEndpointOutput, error) {
	req, out := c.GetResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverQueryLogConfig = "GetResolverQueryLogConfig"

// GetResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverQueryLogConfig for more information on using the GetResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverQueryLogConfigRequest method.
//    req, resp := client.GetResolverQueryLogConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfig
func (c *Route53Resolver) GetResolverQueryLogConfigRequest(input *GetResolverQueryLogConfigInput) (req *request.Request, output *GetResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opGetResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverQueryLogConfigInput{}
	}

	output = &GetResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified Resolver query logging configuration,
// such as the number of VPCs that the configuration is logging queries for
// and the location that logs are sent to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfig
func (c *Route53Resolver) GetResolverQueryLogConfig(input *GetResolverQueryLogConfigInput) (*GetResolverQueryLogConfigOutput, error) {
	req, out := c.GetResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// GetResolverQueryLogConfigWithContext is the same as GetResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverQueryLogConfigWithContext(ctx aws.Context, input *GetResolverQueryLogConfigInput, opts ...request.Option) (*GetResolverQueryLogConfigOutput, error) {
	req, out := c.GetResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverQueryLogConfigAssociation = "GetResolverQueryLogConfigAssociation"

// GetResolverQueryLogConfigAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverQueryLogConfigAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverQueryLogConfigAssociation for more information on using the GetResolverQueryLogConfigAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverQueryLogConfigAssociationRequest method.
//    req, resp := client.GetResolverQueryLogConfigAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigAssociation
func (c *Route53Resolver) GetResolverQueryLogConfigAssociationRequest(input *GetResolverQueryLogConfigAssociationInput) (req *request.Request, output *GetResolverQueryLogConfigAssociationOutput) {
	op := &request.Operation{
		Name:       opGetResolverQueryLogConfigAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverQueryLogConfigAssociationInput{}
	}

	output = &GetResolverQueryLogConfigAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverQueryLogConfigAssociation API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified association between a Resolver query logging
// configuration and an Amazon VPC. When you associate a VPC with a query logging
// configuration, Resolver logs DNS queries that originate in that VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverQueryLogConfigAssociation for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigAssociation
func (c *Route53Resolver) GetResolverQueryLogConfigAssociation(input *GetResolverQueryLogConfigAssociationInput) (*GetResolverQueryLogConfigAssociationOutput, error) {
	req, out := c.GetResolverQueryLogConfigAssociationRequest(input)
	return out, req.Send()
}

// GetResolverQueryLogConfigAssociationWithContext is the same as GetResolverQueryLogConfigAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverQueryLogConfigAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverQueryLogConfigAssociationWithContext(ctx aws.Context, input *GetResolverQueryLogConfigAssociationInput, opts ...request.Option) (*GetResolverQueryLogConfigAssociationOutput, error) {
	req, out := c.GetResolverQueryLogConfigAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverQueryLogConfigPolicy = "GetResolverQueryLogConfigPolicy"

// GetResolverQueryLogConfigPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverQueryLogConfigPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverQueryLogConfigPolicy for more information on using the GetResolverQueryLogConfigPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverQueryLogConfigPolicyRequest method.
//    req, resp := client.GetResolverQueryLogConfigPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigPolicy
func (c *Route53Resolver) GetResolverQueryLogConfigPolicyRequest(input *GetResolverQueryLogConfigPolicyInput) (req *request.Request, output *GetResolverQueryLogConfigPolicyOutput) {
	op := &request.Operation{
		Name:       opGetResolverQueryLogConfigPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverQueryLogConfigPolicyInput{}
	}

	output = &GetResolverQueryLogConfigPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverQueryLogConfigPolicy API operation for Amazon Route 53 Resolver.
//
// Gets information about a query logging policy. A query logging policy specifies
// the Resolver query logging operations and resources that you want to allow
// another AWS account to be able to use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverQueryLogConfigPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * UnknownResourceException
//   The specified resource doesn't exist.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigPolicy
func (c *Route53Resolver) GetResolverQueryLogConfigPolicy(input *GetResolverQueryLogConfigPolicyInput) (*GetResolverQueryLogConfigPolicyOutput, error) {
	req, out := c.GetResolverQueryLogConfigPolicyRequest(input)
	return out, req.Send()
}

// GetResolverQueryLogConfigPolicyWithContext is the same as GetResolverQueryLogConfigPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverQueryLogConfigPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverQueryLogConfigPolicyWithContext(ctx aws.Context, input *GetResolverQueryLogConfigPolicyInput, opts ...request.Option) (*GetResolverQueryLogConfigPolicyOutput, error) {
	req, out := c.GetResolverQueryLogConfigPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverRule = "GetResolverRule"

// GetResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverRule for more information on using the GetResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverRuleRequest method.
//    req, resp := client.GetResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule
func (c *Route53Resolver) GetResolverRuleRequest(input *GetResolverRuleInput) (req *request.Request, output *GetResolverRuleOutput) {
	op := &request.Operation{
		Name:       opGetResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRuleInput{}
	}

	output = &GetResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverRule API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified Resolver rule, such as the domain name
// that the rule forwards DNS queries for and the ID of the outbound Resolver
// endpoint that the rule is associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule
func (c *Route53Resolver) GetResolverRule(input *GetResolverRuleInput) (*GetResolverRuleOutput, error) {
	req, out := c.GetResolverRuleRequest(input)
	return out, req.Send()
}

// GetResolverRuleWithContext is the same as GetResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverRuleWithContext(ctx aws.Context, input *GetResolverRuleInput, opts ...request.Option) (*GetResolverRuleOutput, error) {
	req, out := c.GetResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverRuleAssociation = "GetResolverRuleAssociation"

// GetResolverRuleAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverRuleAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverRuleAssociation for more information on using the GetResolverRuleAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverRuleAssociationRequest method.
//    req, resp := client.GetResolverRuleAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation
func (c *Route53Resolver) GetResolverRuleAssociationRequest(input *GetResolverRuleAssociationInput) (req *request.Request, output *GetResolverRuleAssociationOutput) {
	op := &request.Operation{
		Name:       opGetResolverRuleAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRuleAssociationInput{}
	}

	output = &GetResolverRuleAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverRuleAssociation API operation for Amazon Route 53 Resolver.
//
// Gets information about an association between a specified Resolver rule and
// a VPC. You associate a Resolver rule and a VPC using AssociateResolverRule
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverRuleAssociation for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation
func (c *Route53Resolver) GetResolverRuleAssociation(input *GetResolverRuleAssociationInput) (*GetResolverRuleAssociationOutput, error) {
	req, out := c.GetResolverRuleAssociationRequest(input)
	return out, req.Send()
}

// GetResolverRuleAssociationWithContext is the same as GetResolverRuleAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverRuleAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverRuleAssociationWithContext(ctx aws.Context, input *GetResolverRuleAssociationInput, opts ...request.Option) (*GetResolverRuleAssociationOutput, error) {
	req, out := c.GetResolverRuleAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverRulePolicy = "GetResolverRulePolicy"

// GetResolverRulePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverRulePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverRulePolicy for more information on using the GetResolverRulePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverRulePolicyRequest method.
//    req, resp := client.GetResolverRulePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy
func (c *Route53Resolver) GetResolverRulePolicyRequest(input *GetResolverRulePolicyInput) (req *request.Request, output *GetResolverRulePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResolverRulePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRulePolicyInput{}
	}

	output = &GetResolverRulePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverRulePolicy API operation for Amazon Route 53 Resolver.
//
// Gets information about a Resolver rule policy. A Resolver rule policy specifies
// the Resolver operations and resources that you want to allow another AWS
// account to be able to use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverRulePolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * UnknownResourceException
//   The specified resource doesn't exist.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy
func (c *Route53Resolver) GetResolverRulePolicy(input *GetResolverRulePolicyInput) (*GetResolverRulePolicyOutput, error) {
	req, out := c.GetResolverRulePolicyRequest(input)
	return out, req.Send()
}

// GetResolverRulePolicyWithContext is the same as GetResolverRulePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverRulePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverRulePolicyWithContext(ctx aws.Context, input *GetResolverRulePolicyInput, opts ...request.Option) (*GetResolverRulePolicyOutput, error) {
	req, out := c.GetResolverRulePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResolverEndpointIpAddresses = "ListResolverEndpointIpAddresses"

// ListResolverEndpointIpAddressesRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverEndpointIpAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverEndpointIpAddresses for more information on using the ListResolverEndpointIpAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverEndpointIpAddressesRequest method.
//    req, resp := client.ListResolverEndpointIpAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses
func (c *Route53Resolver) ListResolverEndpointIpAddressesRequest(input *ListResolverEndpointIpAddressesInput) (req *request.Request, output *ListResolverEndpointIpAddressesOutput) {
	op := &request.Operation{
		Name:       opListResolverEndpointIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverEndpointIpAddressesInput{}
	}

	output = &ListResolverEndpointIpAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverEndpointIpAddresses API operation for Amazon Route 53 Resolver.
//
// Gets the IP addresses for a specified Resolver endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverEndpointIpAddresses for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * InvalidNextTokenException
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses
func (c *Route53Resolver) ListResolverEndpointIpAddresses(input *ListResolverEndpointIpAddressesInput) (*ListResolverEndpointIpAddressesOutput, error) {
	req, out := c.ListResolverEndpointIpAddressesRequest(input)
	return out, req.Send()
}

// ListResolverEndpointIpAddressesWithContext is the same as ListResolverEndpointIpAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverEndpointIpAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointIpAddressesWithContext(ctx aws.Context, input *ListResolverEndpointIpAddressesInput, opts ...request.Option) (*ListResolverEndpointIpAddressesOutput, error) {
	req, out := c.ListResolverEndpointIpAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverEndpointIpAddressesPages iterates over the pages of a ListResolverEndpointIpAddresses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverEndpointIpAddresses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverEndpointIpAddresses operation.
//    pageNum := 0
//    err := client.ListResolverEndpointIpAddressesPages(params,
//        func(page *route53resolver.ListResolverEndpointIpAddressesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverEndpointIpAddressesPages(input *ListResolverEndpointIpAddressesInput, fn func(*ListResolverEndpointIpAddressesOutput, bool) bool) error {
	return c.ListResolverEndpointIpAddressesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverEndpointIpAddressesPagesWithContext same as ListResolverEndpointIpAddressesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointIpAddressesPagesWithContext(ctx aws.Context, input *ListResolverEndpointIpAddressesInput, fn func(*ListResolverEndpointIpAddressesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverEndpointIpAddressesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverEndpointIpAddressesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverEndpointIpAddressesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverEndpoints = "ListResolverEndpoints"

// ListResolverEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverEndpoints for more information on using the ListResolverEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverEndpointsRequest method.
//    req, resp := client.ListResolverEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints
func (c *Route53Resolver) ListResolverEndpointsRequest(input *ListResolverEndpointsInput) (req *request.Request, output *ListResolverEndpointsOutput) {
	op := &request.Operation{
		Name:       opListResolverEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverEndpointsInput{}
	}

	output = &ListResolverEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverEndpoints API operation for Amazon Route 53 Resolver.
//
// Lists all the Resolver endpoints that were created using the current AWS
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverEndpoints for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints
func (c *Route53Resolver) ListResolverEndpoints(input *ListResolverEndpointsInput) (*ListResolverEndpointsOutput, error) {
	req, out := c.ListResolverEndpointsRequest(input)
	return out, req.Send()
}

// ListResolverEndpointsWithContext is the same as ListResolverEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointsWithContext(ctx aws.Context, input *ListResolverEndpointsInput, opts ...request.Option) (*ListResolverEndpointsOutput, error) {
	req, out := c.ListResolverEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverEndpointsPages iterates over the pages of a ListResolverEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverEndpoints operation.
//    pageNum := 0
//    err := client.ListResolverEndpointsPages(params,
//        func(page *route53resolver.ListResolverEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverEndpointsPages(input *ListResolverEndpointsInput, fn func(*ListResolverEndpointsOutput, bool) bool) error {
	return c.ListResolverEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverEndpointsPagesWithContext same as ListResolverEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointsPagesWithContext(ctx aws.Context, input *ListResolverEndpointsInput, fn func(*ListResolverEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverQueryLogConfigAssociations = "ListResolverQueryLogConfigAssociations"

// ListResolverQueryLogConfigAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverQueryLogConfigAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverQueryLogConfigAssociations for more information on using the ListResolverQueryLogConfigAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverQueryLogConfigAssociationsRequest method.
//    req, resp := client.ListResolverQueryLogConfigAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations
func (c *Route53Resolver) ListResolverQueryLogConfigAssociationsRequest(input *ListResolverQueryLogConfigAssociationsInput) (req *request.Request, output *ListResolverQueryLogConfigAssociationsOutput) {
	op := &request.Operation{
		Name:       opListResolverQueryLogConfigAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverQueryLogConfigAssociationsInput{}
	}

	output = &ListResolverQueryLogConfigAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverQueryLogConfigAssociations API operation for Amazon Route 53 Resolver.
//
// Lists information about associations between Amazon VPCs and query logging
// configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverQueryLogConfigAssociations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * LimitExceededException
//   The request caused one or more limits to be exceeded.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations
func (c *Route53Resolver) ListResolverQueryLogConfigAssociations(input *ListResolverQueryLogConfigAssociationsInput) (*ListResolverQueryLogConfigAssociationsOutput, error) {
	req, out := c.ListResolverQueryLogConfigAssociationsRequest(input)
	return out, req.Send()
}

// ListResolverQueryLogConfigAssociationsWithContext is the same as ListResolverQueryLogConfigAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverQueryLogConfigAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverQueryLogConfigAssociationsWithContext(ctx aws.Context, input *ListResolverQueryLogConfigAssociationsInput, opts ...request.Option) (*ListResolverQueryLogConfigAssociationsOutput, error) {
	req, out := c.ListResolverQueryLogConfigAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverQueryLogConfigAssociationsPages iterates over the pages of a ListResolverQueryLogConfigAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverQueryLogConfigAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverQueryLogConfigAssociations operation.
//    pageNum := 0
//    err := client.ListResolverQueryLogConfigAssociationsPages(params,
//        func(page *route53resolver.ListResolverQueryLogConfigAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverQueryLogConfigAssociationsPages(input *ListResolverQueryLogConfigAssociationsInput, fn func(*ListResolverQueryLogConfigAssociationsOutput, bool) bool) error {
	return c.ListResolverQueryLogConfigAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverQueryLogConfigAssociationsPagesWithContext same as ListResolverQueryLogConfigAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverQueryLogConfigAssociationsPagesWithContext(ctx aws.Context, input *ListResolverQueryLogConfigAssociationsInput, fn func(*ListResolverQueryLogConfigAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverQueryLogConfigAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverQueryLogConfigAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverQueryLogConfigAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverQueryLogConfigs = "ListResolverQueryLogConfigs"

// ListResolverQueryLogConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverQueryLogConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverQueryLogConfigs for more information on using the ListResolverQueryLogConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverQueryLogConfigsRequest method.
//    req, resp := client.ListResolverQueryLogConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs
func (c *Route53Resolver) ListResolverQueryLogConfigsRequest(input *ListResolverQueryLogConfigsInput) (req *request.Request, output *ListResolverQueryLogConfigsOutput) {
	op := &request.Operation{
		Name:       opListResolverQueryLogConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverQueryLogConfigsInput{}
	}

	output = &ListResolverQueryLogConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverQueryLogConfigs API operation for Amazon Route 53 Resolver.
//
// Lists information about the specified query logging configurations. Each
// configuration defines where you want Resolver to save DNS query logs and
// specifies the VPCs that you want to log queries for.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverQueryLogConfigs for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs
func (c *Route53Resolver) ListResolverQueryLogConfigs(input *ListResolverQueryLogConfigsInput) (*ListResolverQueryLogConfigsOutput, error) {
	req, out := c.ListResolverQueryLogConfigsRequest(input)
	return out, req.Send()
}

// ListResolverQueryLogConfigsWithContext is the same as ListResolverQueryLogConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverQueryLogConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverQueryLogConfigsWithContext(ctx aws.Context, input *ListResolverQueryLogConfigsInput, opts ...request.Option) (*ListResolverQueryLogConfigsOutput, error) {
	req, out := c.ListResolverQueryLogConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverQueryLogConfigsPages iterates over the pages of a ListResolverQueryLogConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverQueryLogConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverQueryLogConfigs operation.
//    pageNum := 0
//    err := client.ListResolverQueryLogConfigsPages(params,
//        func(page *route53resolver.ListResolverQueryLogConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverQueryLogConfigsPages(input *ListResolverQueryLogConfigsInput, fn func(*ListResolverQueryLogConfigsOutput, bool) bool) error {
	return c.ListResolverQueryLogConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverQueryLogConfigsPagesWithContext same as ListResolverQueryLogConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverQueryLogConfigsPagesWithContext(ctx aws.Context, input *ListResolverQueryLogConfigsInput, fn func(*ListResolverQueryLogConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverQueryLogConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverQueryLogConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverQueryLogConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverRuleAssociations = "ListResolverRuleAssociations"

// ListResolverRuleAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverRuleAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverRuleAssociations for more information on using the ListResolverRuleAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverRuleAssociationsRequest method.
//    req, resp := client.ListResolverRuleAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations
func (c *Route53Resolver) ListResolverRuleAssociationsRequest(input *ListResolverRuleAssociationsInput) (req *request.Request, output *ListResolverRuleAssociationsOutput) {
	op := &request.Operation{
		Name:       opListResolverRuleAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverRuleAssociationsInput{}
	}

	output = &ListResolverRuleAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverRuleAssociations API operation for Amazon Route 53 Resolver.
//
// Lists the associations that were created between Resolver rules and VPCs
// using the current AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverRuleAssociations for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations
func (c *Route53Resolver) ListResolverRuleAssociations(input *ListResolverRuleAssociationsInput) (*ListResolverRuleAssociationsOutput, error) {
	req, out := c.ListResolverRuleAssociationsRequest(input)
	return out, req.Send()
}

// ListResolverRuleAssociationsWithContext is the same as ListResolverRuleAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverRuleAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRuleAssociationsWithContext(ctx aws.Context, input *ListResolverRuleAssociationsInput, opts ...request.Option) (*ListResolverRuleAssociationsOutput, error) {
	req, out := c.ListResolverRuleAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverRuleAssociationsPages iterates over the pages of a ListResolverRuleAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverRuleAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverRuleAssociations operation.
//    pageNum := 0
//    err := client.ListResolverRuleAssociationsPages(params,
//        func(page *route53resolver.ListResolverRuleAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverRuleAssociationsPages(input *ListResolverRuleAssociationsInput, fn func(*ListResolverRuleAssociationsOutput, bool) bool) error {
	return c.ListResolverRuleAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverRuleAssociationsPagesWithContext same as ListResolverRuleAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRuleAssociationsPagesWithContext(ctx aws.Context, input *ListResolverRuleAssociationsInput, fn func(*ListResolverRuleAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverRuleAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverRuleAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverRuleAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverRules = "ListResolverRules"

// ListResolverRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverRules for more information on using the ListResolverRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverRulesRequest method.
//    req, resp := client.ListResolverRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules
func (c *Route53Resolver) ListResolverRulesRequest(input *ListResolverRulesInput) (req *request.Request, output *ListResolverRulesOutput) {
	op := &request.Operation{
		Name:       opListResolverRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverRulesInput{}
	}

	output = &ListResolverRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverRules API operation for Amazon Route 53 Resolver.
//
// Lists the Resolver rules that were created using the current AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverRules for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules
func (c *Route53Resolver) ListResolverRules(input *ListResolverRulesInput) (*ListResolverRulesOutput, error) {
	req, out := c.ListResolverRulesRequest(input)
	return out, req.Send()
}

// ListResolverRulesWithContext is the same as ListResolverRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRulesWithContext(ctx aws.Context, input *ListResolverRulesInput, opts ...request.Option) (*ListResolverRulesOutput, error) {
	req, out := c.ListResolverRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverRulesPages iterates over the pages of a ListResolverRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverRules operation.
//    pageNum := 0
//    err := client.ListResolverRulesPages(params,
//        func(page *route53resolver.ListResolverRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverRulesPages(input *ListResolverRulesInput, fn func(*ListResolverRulesOutput, bool) bool) error {
	return c.ListResolverRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverRulesPagesWithContext same as ListResolverRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRulesPagesWithContext(ctx aws.Context, input *ListResolverRulesInput, fn func(*ListResolverRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource
func (c *Route53Resolver) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Route 53 Resolver.
//
// Lists the tags that you associated with the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidNextTokenException
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource
func (c *Route53Resolver) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *route53resolver.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutResolverQueryLogConfigPolicy = "PutResolverQueryLogConfigPolicy"

// PutResolverQueryLogConfigPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResolverQueryLogConfigPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResolverQueryLogConfigPolicy for more information on using the PutResolverQueryLogConfigPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResolverQueryLogConfigPolicyRequest method.
//    req, resp := client.PutResolverQueryLogConfigPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverQueryLogConfigPolicy
func (c *Route53Resolver) PutResolverQueryLogConfigPolicyRequest(input *PutResolverQueryLogConfigPolicyInput) (req *request.Request, output *PutResolverQueryLogConfigPolicyOutput) {
	op := &request.Operation{
		Name:       opPutResolverQueryLogConfigPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResolverQueryLogConfigPolicyInput{}
	}

	output = &PutResolverQueryLogConfigPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResolverQueryLogConfigPolicy API operation for Amazon Route 53 Resolver.
//
// Specifies an AWS account that you want to share a query logging configuration
// with, the query logging configuration that you want to share, and the operations
// that you want the account to be able to perform on the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation PutResolverQueryLogConfigPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidPolicyDocument
//   The specified Resolver rule policy is invalid.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * UnknownResourceException
//   The specified resource doesn't exist.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * AccessDeniedException
//   The current account doesn't have the IAM permissions required to perform
//   the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverQueryLogConfigPolicy
func (c *Route53Resolver) PutResolverQueryLogConfigPolicy(input *PutResolverQueryLogConfigPolicyInput) (*PutResolverQueryLogConfigPolicyOutput, error) {
	req, out := c.PutResolverQueryLogConfigPolicyRequest(input)
	return out, req.Send()
}

// PutResolverQueryLogConfigPolicyWithContext is the same as PutResolverQueryLogConfigPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResolverQueryLogConfigPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) PutResolverQueryLogConfigPolicyWithContext(ctx aws.Context, input *PutResolverQueryLogConfigPolicyInput, opts ...request.Option) (*PutResolverQueryLogConfigPolicyOutput, error) {
	req, out := c.PutResolverQueryLogConfigPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResolverRulePolicy = "PutResolverRulePolicy"

// PutResolverRulePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResolverRulePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResolverRulePolicy for more information on using the PutResolverRulePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResolverRulePolicyRequest method.
//    req, resp := client.PutResolverRulePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy
func (c *Route53Resolver) PutResolverRulePolicyRequest(input *PutResolverRulePolicyInput) (req *request.Request, output *PutResolverRulePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResolverRulePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResolverRulePolicyInput{}
	}

	output = &PutResolverRulePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResolverRulePolicy API operation for Amazon Route 53 Resolver.
//
// Specifies an AWS account that you want to share rules with, the Resolver
// rules that you want to share, and the operations that you want the account
// to be able to perform on those rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation PutResolverRulePolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidPolicyDocument
//   The specified Resolver rule policy is invalid.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * UnknownResourceException
//   The specified resource doesn't exist.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy
func (c *Route53Resolver) PutResolverRulePolicy(input *PutResolverRulePolicyInput) (*PutResolverRulePolicyOutput, error) {
	req, out := c.PutResolverRulePolicyRequest(input)
	return out, req.Send()
}

// PutResolverRulePolicyWithContext is the same as PutResolverRulePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResolverRulePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) PutResolverRulePolicyWithContext(ctx aws.Context, input *PutResolverRulePolicyInput, opts ...request.Option) (*PutResolverRulePolicyOutput, error) {
	req, out := c.PutResolverRulePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource
func (c *Route53Resolver) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Route 53 Resolver.
//
// Adds one or more tags to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The request caused one or more limits to be exceeded.
//
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InvalidTagException
//   The specified tag is invalid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource
func (c *Route53Resolver) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource
func (c *Route53Resolver) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Route 53 Resolver.
//
// Removes one or more tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource
func (c *Route53Resolver) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResolverEndpoint = "UpdateResolverEndpoint"

// UpdateResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResolverEndpoint for more information on using the UpdateResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResolverEndpointRequest method.
//    req, resp := client.UpdateResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint
func (c *Route53Resolver) UpdateResolverEndpointRequest(input *UpdateResolverEndpointInput) (req *request.Request, output *UpdateResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResolverEndpointInput{}
	}

	output = &UpdateResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Updates the name of an inbound or an outbound Resolver endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateResolverEndpoint for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint
func (c *Route53Resolver) UpdateResolverEndpoint(input *UpdateResolverEndpointInput) (*UpdateResolverEndpointOutput, error) {
	req, out := c.UpdateResolverEndpointRequest(input)
	return out, req.Send()
}

// UpdateResolverEndpointWithContext is the same as UpdateResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateResolverEndpointWithContext(ctx aws.Context, input *UpdateResolverEndpointInput, opts ...request.Option) (*UpdateResolverEndpointOutput, error) {
	req, out := c.UpdateResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResolverRule = "UpdateResolverRule"

// UpdateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResolverRule for more information on using the UpdateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResolverRuleRequest method.
//    req, resp := client.UpdateResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule
func (c *Route53Resolver) UpdateResolverRuleRequest(input *UpdateResolverRuleInput) (req *request.Request, output *UpdateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResolverRuleInput{}
	}

	output = &UpdateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResolverRule API operation for Amazon Route 53 Resolver.
//
// Updates settings for a specified Resolver rule. ResolverRuleId is required,
// and all other parameters are optional. If you don't specify a parameter,
// it retains its current value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateResolverRule for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * InvalidParameterException
//   One or more parameters in this request are not valid.
//
//   * ResourceNotFoundException
//   The specified resource doesn't exist.
//
//   * ResourceUnavailableException
//   The specified resource isn't available.
//
//   * LimitExceededException
//   The request caused one or more limits to be exceeded.
//
//   * InternalServiceErrorException
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ThrottlingException
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule
func (c *Route53Resolver) UpdateResolverRule(input *UpdateResolverRuleInput) (*UpdateResolverRuleOutput, error) {
	req, out := c.UpdateResolverRuleRequest(input)
	return out, req.Send()
}

// UpdateResolverRuleWithContext is the same as UpdateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateResolverRuleWithContext(ctx aws.Context, input *UpdateResolverRuleInput, opts ...request.Option) (*UpdateResolverRuleOutput, error) {
	req, out := c.UpdateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The current account doesn't have the IAM permissions required to perform
// the specified Resolver operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateResolverEndpointIpAddressInput struct {
	_ struct{} `type:"structure"`

	// Either the IPv4 address that you want to add to a Resolver endpoint or a
	// subnet ID. If you specify a subnet ID, Resolver chooses an IP address for
	// you from the available IPs in the specified subnet.
	//
	// IpAddress is a required field
	IpAddress *IpAddressUpdate `type:"structure" required:"true"`

	// The ID of the Resolver endpoint that you want to associate IP addresses with.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateResolverEndpointIpAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverEndpointIpAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResolverEndpointIpAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResolverEndpointIpAddressInput"}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.IpAddress != nil {
		if err := s.IpAddress.Validate(); err != nil {
			invalidParams.AddNested("IpAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAddress sets the IpAddress field's value.
func (s *AssociateResolverEndpointIpAddressInput) SetIpAddress(v *IpAddressUpdate) *AssociateResolverEndpointIpAddressInput {
	s.IpAddress = v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *AssociateResolverEndpointIpAddressInput) SetResolverEndpointId(v string) *AssociateResolverEndpointIpAddressInput {
	s.ResolverEndpointId = &v
	return s
}

type AssociateResolverEndpointIpAddressOutput struct {
	_ struct{} `type:"structure"`

	// The response to an AssociateResolverEndpointIpAddress request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s AssociateResolverEndpointIpAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverEndpointIpAddressOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *AssociateResolverEndpointIpAddressOutput) SetResolverEndpoint(v *ResolverEndpoint) *AssociateResolverEndpointIpAddressOutput {
	s.ResolverEndpoint = v
	return s
}

type AssociateResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the query logging configuration that you want to associate a VPC
	// with.
	//
	// ResolverQueryLogConfigId is a required field
	ResolverQueryLogConfigId *string `min:"1" type:"string" required:"true"`

	// The ID of an Amazon VPC that you want this query logging configuration to
	// log queries for.
	//
	// The VPCs and the query logging configuration must be in the same Region.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResolverQueryLogConfigInput"}
	if s.ResolverQueryLogConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigId"))
	}
	if s.ResolverQueryLogConfigId != nil && len(*s.ResolverQueryLogConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigId", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *AssociateResolverQueryLogConfigInput) SetResolverQueryLogConfigId(v string) *AssociateResolverQueryLogConfigInput {
	s.ResolverQueryLogConfigId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssociateResolverQueryLogConfigInput) SetResourceId(v string) *AssociateResolverQueryLogConfigInput {
	s.ResourceId = &v
	return s
}

type AssociateResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for a specified association between
	// an Amazon VPC and a query logging configuration.
	ResolverQueryLogConfigAssociation *ResolverQueryLogConfigAssociation `type:"structure"`
}

// String returns the string representation
func (s AssociateResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfigAssociation sets the ResolverQueryLogConfigAssociation field's value.
func (s *AssociateResolverQueryLogConfigOutput) SetResolverQueryLogConfigAssociation(v *ResolverQueryLogConfigAssociation) *AssociateResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfigAssociation = v
	return s
}

type AssociateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// A name for the association that you're creating between a Resolver rule and
	// a VPC.
	Name *string `type:"string"`

	// The ID of the Resolver rule that you want to associate with the VPC. To list
	// the existing Resolver rules, use ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html).
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`

	// The ID of the VPC that you want to associate the Resolver rule with.
	//
	// VPCId is a required field
	VPCId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}
	if s.VPCId == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCId"))
	}
	if s.VPCId != nil && len(*s.VPCId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AssociateResolverRuleInput) SetName(v string) *AssociateResolverRuleInput {
	s.Name = &v
	return s
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *AssociateResolverRuleInput) SetResolverRuleId(v string) *AssociateResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *AssociateResolverRuleInput) SetVPCId(v string) *AssociateResolverRuleInput {
	s.VPCId = &v
	return s
}

type AssociateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the AssociateResolverRule request, including the status
	// of the request.
	ResolverRuleAssociation *ResolverRuleAssociation `type:"structure"`
}

// String returns the string representation
func (s AssociateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRuleAssociation sets the ResolverRuleAssociation field's value.
func (s *AssociateResolverRuleOutput) SetResolverRuleAssociation(v *ResolverRuleAssociation) *AssociateResolverRuleOutput {
	s.ResolverRuleAssociation = v
	return s
}

type CreateResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of executing the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	//
	// CreatorRequestId is a required field
	CreatorRequestId *string `min:"1" type:"string" required:"true"`

	// Specify the applicable value:
	//
	//    * INBOUND: Resolver forwards DNS queries to the DNS service for a VPC
	//    from your network
	//
	//    * OUTBOUND: Resolver forwards DNS queries from the DNS service for a VPC
	//    to your network
	//
	// Direction is a required field
	Direction *string `type:"string" required:"true" enum:"ResolverEndpointDirection"`

	// The subnets and IP addresses in your VPC that DNS queries originate from
	// (for outbound endpoints) or that you forward DNS queries to (for inbound
	// endpoints). The subnet ID uniquely identifies a VPC.
	//
	// IpAddresses is a required field
	IpAddresses []*IpAddressRequest `min:"1" type:"list" required:"true"`

	// A friendly name that lets you easily find a configuration in the Resolver
	// dashboard in the Route 53 console.
	Name *string `type:"string"`

	// The ID of one or more security groups that you want to use to control access
	// to this VPC. The security group that you specify must include one or more
	// inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound
	// Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access.
	// For inbound access, open port 53. For outbound access, open the port that
	// you're using for DNS queries on your network.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `type:"list" required:"true"`

	// A list of the tag keys and values that you want to associate with the endpoint.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverEndpointInput"}
	if s.CreatorRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorRequestId"))
	}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.Direction == nil {
		invalidParams.Add(request.NewErrParamRequired("Direction"))
	}
	if s.IpAddresses == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddresses"))
	}
	if s.IpAddresses != nil && len(s.IpAddresses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpAddresses", 1))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.IpAddresses != nil {
		for i, v := range s.IpAddresses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IpAddresses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateResolverEndpointInput) SetCreatorRequestId(v string) *CreateResolverEndpointInput {
	s.CreatorRequestId = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *CreateResolverEndpointInput) SetDirection(v string) *CreateResolverEndpointInput {
	s.Direction = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *CreateResolverEndpointInput) SetIpAddresses(v []*IpAddressRequest) *CreateResolverEndpointInput {
	s.IpAddresses = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverEndpointInput) SetName(v string) *CreateResolverEndpointInput {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateResolverEndpointInput) SetSecurityGroupIds(v []*string) *CreateResolverEndpointInput {
	s.SecurityGroupIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverEndpointInput) SetTags(v []*Tag) *CreateResolverEndpointInput {
	s.Tags = v
	return s
}

type CreateResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the CreateResolverEndpoint request, including the status
	// of the request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s CreateResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *CreateResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *CreateResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type CreateResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of executing the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the resource that you want Resolver to send query logs. You can
	// send query logs to an S3 bucket, a CloudWatch Logs log group, or a Kinesis
	// Data Firehose delivery stream. Examples of valid values include the following:
	//
	//    * S3 bucket: arn:aws:s3:::examplebucket You can optionally append a file
	//    prefix to the end of the ARN. arn:aws:s3:::examplebucket/development/
	//
	//    * CloudWatch Logs log group: arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*
	//
	//    * Kinesis Data Firehose delivery stream: arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name
	//
	// DestinationArn is a required field
	DestinationArn *string `min:"1" type:"string" required:"true"`

	// The name that you want to give the query logging configuration
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of the tag keys and values that you want to associate with the query
	// logging configuration.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverQueryLogConfigInput"}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.DestinationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationArn"))
	}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateResolverQueryLogConfigInput) SetCreatorRequestId(v string) *CreateResolverQueryLogConfigInput {
	s.CreatorRequestId = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *CreateResolverQueryLogConfigInput) SetDestinationArn(v string) *CreateResolverQueryLogConfigInput {
	s.DestinationArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverQueryLogConfigInput) SetName(v string) *CreateResolverQueryLogConfigInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverQueryLogConfigInput) SetTags(v []*Tag) *CreateResolverQueryLogConfigInput {
	s.Tags = v
	return s
}

type CreateResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the CreateResolverQueryLogConfig request, including the
	// status of the request.
	ResolverQueryLogConfig *ResolverQueryLogConfig `type:"structure"`
}

// String returns the string representation
func (s CreateResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfig sets the ResolverQueryLogConfig field's value.
func (s *CreateResolverQueryLogConfigOutput) SetResolverQueryLogConfig(v *ResolverQueryLogConfig) *CreateResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfig = v
	return s
}

type CreateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of executing the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	//
	// CreatorRequestId is a required field
	CreatorRequestId *string `min:"1" type:"string" required:"true"`

	// DNS queries for this domain name are forwarded to the IP addresses that you
	// specify in TargetIps. If a query matches multiple Resolver rules (example.com
	// and www.example.com), outbound DNS queries are routed using the Resolver
	// rule that contains the most specific domain name (www.example.com).
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// A friendly name that lets you easily find a rule in the Resolver dashboard
	// in the Route 53 console.
	Name *string `type:"string"`

	// The ID of the outbound Resolver endpoint that you want to use to route DNS
	// queries to the IP addresses that you specify in TargetIps.
	ResolverEndpointId *string `min:"1" type:"string"`

	// When you want to forward DNS queries for specified domain name to resolvers
	// on your network, specify FORWARD.
	//
	// When you have a forwarding rule to forward DNS queries for a domain to your
	// network and you want Resolver to process queries for a subdomain of that
	// domain, specify SYSTEM.
	//
	// For example, to forward DNS queries for example.com to resolvers on your
	// network, you create a rule and specify FORWARD for RuleType. To then have
	// Resolver process queries for apex.example.com, you create a rule and specify
	// SYSTEM for RuleType.
	//
	// Currently, only Resolver can create rules that have a value of RECURSIVE
	// for RuleType.
	//
	// RuleType is a required field
	RuleType *string `type:"string" required:"true" enum:"RuleTypeOption"`

	// A list of the tag keys and values that you want to associate with the endpoint.
	Tags []*Tag `type:"list"`

	// The IPs that you want Resolver to forward DNS queries to. You can specify
	// only IPv4 addresses. Separate IP addresses with a comma.
	//
	// TargetIps is available only when the value of Rule type is FORWARD.
	TargetIps []*TargetAddress `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverRuleInput"}
	if s.CreatorRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorRequestId"))
	}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.RuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleType"))
	}
	if s.TargetIps != nil && len(s.TargetIps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetIps", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetIps != nil {
		for i, v := range s.TargetIps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetIps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateResolverRuleInput) SetCreatorRequestId(v string) *CreateResolverRuleInput {
	s.CreatorRequestId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateResolverRuleInput) SetDomainName(v string) *CreateResolverRuleInput {
	s.DomainName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverRuleInput) SetName(v string) *CreateResolverRuleInput {
	s.Name = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *CreateResolverRuleInput) SetResolverEndpointId(v string) *CreateResolverRuleInput {
	s.ResolverEndpointId = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *CreateResolverRuleInput) SetRuleType(v string) *CreateResolverRuleInput {
	s.RuleType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverRuleInput) SetTags(v []*Tag) *CreateResolverRuleInput {
	s.Tags = v
	return s
}

// SetTargetIps sets the TargetIps field's value.
func (s *CreateResolverRuleInput) SetTargetIps(v []*TargetAddress) *CreateResolverRuleInput {
	s.TargetIps = v
	return s
}

type CreateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the CreateResolverRule request, including the status of
	// the request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation
func (s CreateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *CreateResolverRuleOutput) SetResolverRule(v *ResolverRule) *CreateResolverRuleOutput {
	s.ResolverRule = v
	return s
}

type DeleteResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver endpoint that you want to delete.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResolverEndpointInput"}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *DeleteResolverEndpointInput) SetResolverEndpointId(v string) *DeleteResolverEndpointInput {
	s.ResolverEndpointId = &v
	return s
}

type DeleteResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DeleteResolverEndpoint request, including the status
	// of the request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s DeleteResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *DeleteResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *DeleteResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type DeleteResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the query logging configuration that you want to delete.
	//
	// ResolverQueryLogConfigId is a required field
	ResolverQueryLogConfigId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResolverQueryLogConfigInput"}
	if s.ResolverQueryLogConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigId"))
	}
	if s.ResolverQueryLogConfigId != nil && len(*s.ResolverQueryLogConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *DeleteResolverQueryLogConfigInput) SetResolverQueryLogConfigId(v string) *DeleteResolverQueryLogConfigInput {
	s.ResolverQueryLogConfigId = &v
	return s
}

type DeleteResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query logging configuration that you deleted, including
	// the status of the request.
	ResolverQueryLogConfig *ResolverQueryLogConfig `type:"structure"`
}

// String returns the string representation
func (s DeleteResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfig sets the ResolverQueryLogConfig field's value.
func (s *DeleteResolverQueryLogConfigOutput) SetResolverQueryLogConfig(v *ResolverQueryLogConfig) *DeleteResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfig = v
	return s
}

type DeleteResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule that you want to delete.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *DeleteResolverRuleInput) SetResolverRuleId(v string) *DeleteResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

type DeleteResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DeleteResolverRule request, including the status of
	// the request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation
func (s DeleteResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *DeleteResolverRuleOutput) SetResolverRule(v *ResolverRule) *DeleteResolverRuleOutput {
	s.ResolverRule = v
	return s
}

type DisassociateResolverEndpointIpAddressInput struct {
	_ struct{} `type:"structure"`

	// The IPv4 address that you want to remove from a Resolver endpoint.
	//
	// IpAddress is a required field
	IpAddress *IpAddressUpdate `type:"structure" required:"true"`

	// The ID of the Resolver endpoint that you want to disassociate an IP address
	// from.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateResolverEndpointIpAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverEndpointIpAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResolverEndpointIpAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResolverEndpointIpAddressInput"}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.IpAddress != nil {
		if err := s.IpAddress.Validate(); err != nil {
			invalidParams.AddNested("IpAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAddress sets the IpAddress field's value.
func (s *DisassociateResolverEndpointIpAddressInput) SetIpAddress(v *IpAddressUpdate) *DisassociateResolverEndpointIpAddressInput {
	s.IpAddress = v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *DisassociateResolverEndpointIpAddressInput) SetResolverEndpointId(v string) *DisassociateResolverEndpointIpAddressInput {
	s.ResolverEndpointId = &v
	return s
}

type DisassociateResolverEndpointIpAddressOutput struct {
	_ struct{} `type:"structure"`

	// The response to an DisassociateResolverEndpointIpAddress request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s DisassociateResolverEndpointIpAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverEndpointIpAddressOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *DisassociateResolverEndpointIpAddressOutput) SetResolverEndpoint(v *ResolverEndpoint) *DisassociateResolverEndpointIpAddressOutput {
	s.ResolverEndpoint = v
	return s
}

type DisassociateResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the query logging configuration that you want to disassociate a
	// specified VPC from.
	//
	// ResolverQueryLogConfigId is a required field
	ResolverQueryLogConfigId *string `min:"1" type:"string" required:"true"`

	// The ID of the Amazon VPC that you want to disassociate from a specified query
	// logging configuration.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResolverQueryLogConfigInput"}
	if s.ResolverQueryLogConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigId"))
	}
	if s.ResolverQueryLogConfigId != nil && len(*s.ResolverQueryLogConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigId", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *DisassociateResolverQueryLogConfigInput) SetResolverQueryLogConfigId(v string) *DisassociateResolverQueryLogConfigInput {
	s.ResolverQueryLogConfigId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DisassociateResolverQueryLogConfigInput) SetResourceId(v string) *DisassociateResolverQueryLogConfigInput {
	s.ResourceId = &v
	return s
}

type DisassociateResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the association that you deleted
	// between an Amazon VPC and a query logging configuration.
	ResolverQueryLogConfigAssociation *ResolverQueryLogConfigAssociation `type:"structure"`
}

// String returns the string representation
func (s DisassociateResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfigAssociation sets the ResolverQueryLogConfigAssociation field's value.
func (s *DisassociateResolverQueryLogConfigOutput) SetResolverQueryLogConfigAssociation(v *ResolverQueryLogConfigAssociation) *DisassociateResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfigAssociation = v
	return s
}

type DisassociateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule that you want to disassociate from the specified
	// VPC.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`

	// The ID of the VPC that you want to disassociate the Resolver rule from.
	//
	// VPCId is a required field
	VPCId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}
	if s.VPCId == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCId"))
	}
	if s.VPCId != nil && len(*s.VPCId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *DisassociateResolverRuleInput) SetResolverRuleId(v string) *DisassociateResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *DisassociateResolverRuleInput) SetVPCId(v string) *DisassociateResolverRuleInput {
	s.VPCId = &v
	return s
}

type DisassociateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DisassociateResolverRule request, including the status
	// of the request.
	ResolverRuleAssociation *ResolverRuleAssociation `type:"structure"`
}

// String returns the string representation
func (s DisassociateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRuleAssociation sets the ResolverRuleAssociation field's value.
func (s *DisassociateResolverRuleOutput) SetResolverRuleAssociation(v *ResolverRuleAssociation) *DisassociateResolverRuleOutput {
	s.ResolverRuleAssociation = v
	return s
}

// For Resolver list operations (ListResolverEndpoints (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html),
// ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html),
// ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html),
// ListResolverQueryLogConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html),
// and ListResolverQueryLogConfigAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html)),
// an optional specification to return a subset of objects.
//
// To filter objects, such as Resolver endpoints or Resolver rules, you specify
// Name and Values. For example, to list only inbound Resolver endpoints, specify
// Direction for Name and specify INBOUND for Values.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter that you want to use to filter objects.
	//
	// The valid values for Name depend on the action that you're including the
	// filter in, ListResolverEndpoints (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html),
	// ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html),
	// ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html),
	// ListResolverQueryLogConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html),
	// or ListResolverQueryLogConfigAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html).
	//
	// In early versions of Resolver, values for Name were listed as uppercase,
	// with underscore (_) delimiters. For example, CreatorRequestId was originally
	// listed as CREATOR_REQUEST_ID. Uppercase values for Name are still supported.
	//
	// ListResolverEndpoints
	//
	// Valid values for Name include the following:
	//
	//    * CreatorRequestId: The value that you specified when you created the
	//    Resolver endpoint.
	//
	//    * Direction: Whether you want to return inbound or outbound Resolver endpoints.
	//    If you specify DIRECTION for Name, specify INBOUND or OUTBOUND for Values.
	//
	//    * HostVpcId: The ID of the VPC that inbound DNS queries pass through on
	//    the way from your network to your VPCs in a region, or the VPC that outbound
	//    queries pass through on the way from your VPCs to your network. In a CreateResolverEndpoint
	//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html)
	//    request, SubnetId indirectly identifies the VPC. In a GetResolverEndpoint
	//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html)
	//    request, the VPC ID for a Resolver endpoint is returned in the HostVPCId
	//    element.
	//
	//    * IpAddressCount: The number of IP addresses that you have associated
	//    with the Resolver endpoint.
	//
	//    * Name: The name of the Resolver endpoint.
	//
	//    * SecurityGroupIds: The IDs of the VPC security groups that you specified
	//    when you created the Resolver endpoint.
	//
	//    * Status: The status of the Resolver endpoint. If you specify Status for
	//    Name, specify one of the following status codes for Values: CREATING,
	//    OPERATIONAL, UPDATING, AUTO_RECOVERING, ACTION_NEEDED, or DELETING. For
	//    more information, see Status in ResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverEndpoint.html).
	//
	// ListResolverRules
	//
	// Valid values for Name include the following:
	//
	//    * CreatorRequestId: The value that you specified when you created the
	//    Resolver rule.
	//
	//    * DomainName: The domain name for which Resolver is forwarding DNS queries
	//    to your network. In the value that you specify for Values, include a trailing
	//    dot (.) after the domain name. For example, if the domain name is example.com,
	//    specify the following value. Note the "." after com: example.com.
	//
	//    * Name: The name of the Resolver rule.
	//
	//    * ResolverEndpointId: The ID of the Resolver endpoint that the Resolver
	//    rule is associated with. You can filter on the Resolver endpoint only
	//    for rules that have a value of FORWARD for RuleType.
	//
	//    * Status: The status of the Resolver rule. If you specify Status for Name,
	//    specify one of the following status codes for Values: COMPLETE, DELETING,
	//    UPDATING, or FAILED.
	//
	//    * Type: The type of the Resolver rule. If you specify TYPE for Name, specify
	//    FORWARD or SYSTEM for Values.
	//
	// ListResolverRuleAssociations
	//
	// Valid values for Name include the following:
	//
	//    * Name: The name of the Resolver rule association.
	//
	//    * ResolverRuleId: The ID of the Resolver rule that is associated with
	//    one or more VPCs.
	//
	//    * Status: The status of the Resolver rule association. If you specify
	//    Status for Name, specify one of the following status codes for Values:
	//    CREATING, COMPLETE, DELETING, or FAILED.
	//
	//    * VPCId: The ID of the VPC that the Resolver rule is associated with.
	//
	// ListResolverQueryLogConfigs
	//
	// Valid values for Name include the following:
	//
	//    * Arn: The ARN for the query logging configuration.
	//
	//    * AssociationCount: The number of VPCs that are associated with the query
	//    logging configuration.
	//
	//    * CreationTime: The date and time that the query logging configuration
	//    was created, in Unix time format and Coordinated Universal Time (UTC).
	//
	//    * CreatorRequestId: A unique string that identifies the request that created
	//    the query logging configuration.
	//
	//    * Destination: The AWS service that you want to forward query logs to.
	//    Valid values include the following: S3 CloudWatchLogs KinesisFirehose
	//
	//    * DestinationArn: The ARN of the location that Resolver is sending query
	//    logs to. This value can be the ARN for an S3 bucket, a CloudWatch Logs
	//    log group, or a Kinesis Data Firehose delivery stream.
	//
	//    * Id: The ID of the query logging configuration
	//
	//    * Name: The name of the query logging configuration
	//
	//    * OwnerId: The AWS account ID for the account that created the query logging
	//    configuration.
	//
	//    * ShareStatus: An indication of whether the query logging configuration
	//    is shared with other AWS accounts, or was shared with the current account
	//    by another AWS account. Valid values include: NOT_SHARED, SHARED_WITH_ME,
	//    or SHARED_BY_ME.
	//
	//    * Status: The status of the query logging configuration. If you specify
	//    Status for Name, specify the applicable status code for Values: CREATING,
	//    CREATED, DELETING, or FAILED. For more information, see Status (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfig.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfig-Status).
	//
	// ListResolverQueryLogConfigAssociations
	//
	// Valid values for Name include the following:
	//
	//    * CreationTime: The date and time that the VPC was associated with the
	//    query logging configuration, in Unix time format and Coordinated Universal
	//    Time (UTC).
	//
	//    * Error: If the value of Status is FAILED, specify the cause: DESTINATION_NOT_FOUND
	//    or ACCESS_DENIED.
	//
	//    * Id: The ID of the query logging association.
	//
	//    * ResolverQueryLogConfigId: The ID of the query logging configuration
	//    that a VPC is associated with.
	//
	//    * ResourceId: The ID of the Amazon VPC that is associated with the query
	//    logging configuration.
	//
	//    * Status: The status of the query logging association. If you specify
	//    Status for Name, specify the applicable status code for Values: CREATING,
	//    CREATED, DELETING, or FAILED. For more information, see Status (https://docs.aws.amazon.com/API_route53resolver_ResolverQueryLogConfigAssociation.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfigAssociation-Status).
	Name *string `min:"1" type:"string"`

	// When you're using a List operation and you want the operation to return a
	// subset of objects, such as Resolver endpoints or Resolver rules, the value
	// of the parameter that you want to use to filter objects. For example, to
	// list only inbound Resolver endpoints, specify Direction for Name and specify
	// INBOUND for Values.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type GetResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver endpoint that you want to get information about.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverEndpointInput"}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *GetResolverEndpointInput) SetResolverEndpointId(v string) *GetResolverEndpointInput {
	s.ResolverEndpointId = &v
	return s
}

type GetResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver endpoint that you specified in a GetResolverEndpoint
	// request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s GetResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *GetResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *GetResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type GetResolverQueryLogConfigAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver query logging configuration association that you want
	// to get information about.
	//
	// ResolverQueryLogConfigAssociationId is a required field
	ResolverQueryLogConfigAssociationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverQueryLogConfigAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverQueryLogConfigAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverQueryLogConfigAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverQueryLogConfigAssociationInput"}
	if s.ResolverQueryLogConfigAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigAssociationId"))
	}
	if s.ResolverQueryLogConfigAssociationId != nil && len(*s.ResolverQueryLogConfigAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigAssociationId sets the ResolverQueryLogConfigAssociationId field's value.
func (s *GetResolverQueryLogConfigAssociationInput) SetResolverQueryLogConfigAssociationId(v string) *GetResolverQueryLogConfigAssociationInput {
	s.ResolverQueryLogConfigAssociationId = &v
	return s
}

type GetResolverQueryLogConfigAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver query logging configuration association that
	// you specified in a GetQueryLogConfigAssociation request.
	ResolverQueryLogConfigAssociation *ResolverQueryLogConfigAssociation `type:"structure"`
}

// String returns the string representation
func (s GetResolverQueryLogConfigAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverQueryLogConfigAssociationOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfigAssociation sets the ResolverQueryLogConfigAssociation field's value.
func (s *GetResolverQueryLogConfigAssociationOutput) SetResolverQueryLogConfigAssociation(v *ResolverQueryLogConfigAssociation) *GetResolverQueryLogConfigAssociationOutput {
	s.ResolverQueryLogConfigAssociation = v
	return s
}

type GetResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver query logging configuration that you want to get information
	// about.
	//
	// ResolverQueryLogConfigId is a required field
	ResolverQueryLogConfigId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverQueryLogConfigInput"}
	if s.ResolverQueryLogConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigId"))
	}
	if s.ResolverQueryLogConfigId != nil && len(*s.ResolverQueryLogConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *GetResolverQueryLogConfigInput) SetResolverQueryLogConfigId(v string) *GetResolverQueryLogConfigInput {
	s.ResolverQueryLogConfigId = &v
	return s
}

type GetResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver query logging configuration that you specified
	// in a GetQueryLogConfig request.
	ResolverQueryLogConfig *ResolverQueryLogConfig `type:"structure"`
}

// String returns the string representation
func (s GetResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfig sets the ResolverQueryLogConfig field's value.
func (s *GetResolverQueryLogConfigOutput) SetResolverQueryLogConfig(v *ResolverQueryLogConfig) *GetResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfig = v
	return s
}

type GetResolverQueryLogConfigPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the query logging configuration that you want to get the query
	// logging policy for.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverQueryLogConfigPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverQueryLogConfigPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverQueryLogConfigPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverQueryLogConfigPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetResolverQueryLogConfigPolicyInput) SetArn(v string) *GetResolverQueryLogConfigPolicyInput {
	s.Arn = &v
	return s
}

type GetResolverQueryLogConfigPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query logging policy for the query logging configuration
	// that you specified in a GetResolverQueryLogConfigPolicy request.
	ResolverQueryLogConfigPolicy *string `type:"string"`
}

// String returns the string representation
func (s GetResolverQueryLogConfigPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverQueryLogConfigPolicyOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfigPolicy sets the ResolverQueryLogConfigPolicy field's value.
func (s *GetResolverQueryLogConfigPolicyOutput) SetResolverQueryLogConfigPolicy(v string) *GetResolverQueryLogConfigPolicyOutput {
	s.ResolverQueryLogConfigPolicy = &v
	return s
}

type GetResolverRuleAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule association that you want to get information
	// about.
	//
	// ResolverRuleAssociationId is a required field
	ResolverRuleAssociationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverRuleAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRuleAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRuleAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverRuleAssociationInput"}
	if s.ResolverRuleAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleAssociationId"))
	}
	if s.ResolverRuleAssociationId != nil && len(*s.ResolverRuleAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleAssociationId sets the ResolverRuleAssociationId field's value.
func (s *GetResolverRuleAssociationInput) SetResolverRuleAssociationId(v string) *GetResolverRuleAssociationInput {
	s.ResolverRuleAssociationId = &v
	return s
}

type GetResolverRuleAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver rule association that you specified in a GetResolverRuleAssociation
	// request.
	ResolverRuleAssociation *ResolverRuleAssociation `type:"structure"`
}

// String returns the string representation
func (s GetResolverRuleAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRuleAssociationOutput) GoString() string {
	return s.String()
}

// SetResolverRuleAssociation sets the ResolverRuleAssociation field's value.
func (s *GetResolverRuleAssociationOutput) SetResolverRuleAssociation(v *ResolverRuleAssociation) *GetResolverRuleAssociationOutput {
	s.ResolverRuleAssociation = v
	return s
}

type GetResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule that you want to get information about.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *GetResolverRuleInput) SetResolverRuleId(v string) *GetResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

type GetResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver rule that you specified in a GetResolverRule
	// request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation
func (s GetResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *GetResolverRuleOutput) SetResolverRule(v *ResolverRule) *GetResolverRuleOutput {
	s.ResolverRule = v
	return s
}

type GetResolverRulePolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule policy that you want to get information about.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverRulePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRulePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRulePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverRulePolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetResolverRulePolicyInput) SetArn(v string) *GetResolverRulePolicyInput {
	s.Arn = &v
	return s
}

type GetResolverRulePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver rule policy that you specified in a GetResolverRulePolicy
	// request.
	ResolverRulePolicy *string `type:"string"`
}

// String returns the string representation
func (s GetResolverRulePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRulePolicyOutput) GoString() string {
	return s.String()
}

// SetResolverRulePolicy sets the ResolverRulePolicy field's value.
func (s *GetResolverRulePolicyOutput) SetResolverRulePolicy(v string) *GetResolverRulePolicyOutput {
	s.ResolverRulePolicy = &v
	return s
}

// We encountered an unknown error. Try again in a few minutes.
type InternalServiceErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServiceErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServiceErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServiceErrorException(v protocol.ResponseMetadata) error {
	return &InternalServiceErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceErrorException) Code() string {
	return "InternalServiceErrorException"
}

// Message returns the exception's message.
func (s *InternalServiceErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceErrorException) OrigErr() error {
	return nil
}

func (s *InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The value that you specified for NextToken in a List request isn't valid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more parameters in this request are not valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// For an InvalidParameterException error, the name of the parameter that's
	// invalid.
	FieldName *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Resolver rule policy is invalid.
type InvalidPolicyDocument struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidPolicyDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidPolicyDocument) GoString() string {
	return s.String()
}

func newErrorInvalidPolicyDocument(v protocol.ResponseMetadata) error {
	return &InvalidPolicyDocument{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPolicyDocument) Code() string {
	return "InvalidPolicyDocument"
}

// Message returns the exception's message.
func (s *InvalidPolicyDocument) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPolicyDocument) OrigErr() error {
	return nil
}

func (s *InvalidPolicyDocument) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPolicyDocument) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPolicyDocument) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is invalid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified tag is invalid.
type InvalidTagException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidTagException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidTagException) GoString() string {
	return s.String()
}

func newErrorInvalidTagException(v protocol.ResponseMetadata) error {
	return &InvalidTagException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTagException) Code() string {
	return "InvalidTagException"
}

// Message returns the exception's message.
func (s *InvalidTagException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTagException) OrigErr() error {
	return nil
}

func (s *InvalidTagException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTagException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTagException) RequestID() string {
	return s.RespMetadata.RequestID
}

// In a CreateResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html)
// request, the IP address that DNS queries originate from (for outbound endpoints)
// or that you forward DNS queries to (for inbound endpoints). IpAddressRequest
// also includes the ID of the subnet that contains the IP address.
type IpAddressRequest struct {
	_ struct{} `type:"structure"`

	// The IP address that you want to use for DNS queries.
	Ip *string `min:"7" type:"string"`

	// The ID of the subnet that contains the IP address.
	//
	// SubnetId is a required field
	SubnetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IpAddressRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAddressRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpAddressRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpAddressRequest"}
	if s.Ip != nil && len(*s.Ip) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 7))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *IpAddressRequest) SetIp(v string) *IpAddressRequest {
	s.Ip = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *IpAddressRequest) SetSubnetId(v string) *IpAddressRequest {
	s.SubnetId = &v
	return s
}

// In the response to a GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html)
// request, information about the IP addresses that the Resolver endpoint uses
// for DNS queries.
type IpAddressResponse struct {
	_ struct{} `type:"structure"`

	// The date and time that the IP address was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// One IP address that the Resolver endpoint uses for DNS queries.
	Ip *string `min:"7" type:"string"`

	// The ID of one IP address.
	IpId *string `min:"1" type:"string"`

	// The date and time that the IP address was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// A status code that gives the current status of the request.
	Status *string `type:"string" enum:"IpAddressStatus"`

	// A message that provides additional information about the status of the request.
	StatusMessage *string `type:"string"`

	// The ID of one subnet.
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IpAddressResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAddressResponse) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *IpAddressResponse) SetCreationTime(v string) *IpAddressResponse {
	s.CreationTime = &v
	return s
}

// SetIp sets the Ip field's value.
func (s *IpAddressResponse) SetIp(v string) *IpAddressResponse {
	s.Ip = &v
	return s
}

// SetIpId sets the IpId field's value.
func (s *IpAddressResponse) SetIpId(v string) *IpAddressResponse {
	s.IpId = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *IpAddressResponse) SetModificationTime(v string) *IpAddressResponse {
	s.ModificationTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IpAddressResponse) SetStatus(v string) *IpAddressResponse {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *IpAddressResponse) SetStatusMessage(v string) *IpAddressResponse {
	s.StatusMessage = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *IpAddressResponse) SetSubnetId(v string) *IpAddressResponse {
	s.SubnetId = &v
	return s
}

// In an UpdateResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html)
// request, information about an IP address to update.
type IpAddressUpdate struct {
	_ struct{} `type:"structure"`

	// The new IP address.
	Ip *string `min:"7" type:"string"`

	// Only when removing an IP address from a Resolver endpoint: The ID of the
	// IP address that you want to remove. To get this ID, use GetResolverEndpoint
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html).
	IpId *string `min:"1" type:"string"`

	// The ID of the subnet that includes the IP address that you want to update.
	// To get this ID, use GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html).
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IpAddressUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAddressUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpAddressUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpAddressUpdate"}
	if s.Ip != nil && len(*s.Ip) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 7))
	}
	if s.IpId != nil && len(*s.IpId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpId", 1))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *IpAddressUpdate) SetIp(v string) *IpAddressUpdate {
	s.Ip = &v
	return s
}

// SetIpId sets the IpId field's value.
func (s *IpAddressUpdate) SetIpId(v string) *IpAddressUpdate {
	s.IpId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *IpAddressUpdate) SetSubnetId(v string) *IpAddressUpdate {
	s.SubnetId = &v
	return s
}

// The request caused one or more limits to be exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a LimitExceededException error, the type of resource that exceeded the
	// current limit.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListResolverEndpointIpAddressesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of IP addresses that you want to return in the response
	// to a ListResolverEndpointIpAddresses request. If you don't specify a value
	// for MaxResults, Resolver returns up to 100 IP addresses.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverEndpointIpAddresses request, omit this value.
	//
	// If the specified Resolver endpoint has more than MaxResults IP addresses,
	// you can submit another ListResolverEndpointIpAddresses request to get the
	// next group of IP addresses. In the next request, specify the value of NextToken
	// from the previous response.
	NextToken *string `type:"string"`

	// The ID of the Resolver endpoint that you want to get IP addresses for.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResolverEndpointIpAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverEndpointIpAddressesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverEndpointIpAddressesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverEndpointIpAddressesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointIpAddressesInput) SetMaxResults(v int64) *ListResolverEndpointIpAddressesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointIpAddressesInput) SetNextToken(v string) *ListResolverEndpointIpAddressesInput {
	s.NextToken = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *ListResolverEndpointIpAddressesInput) SetResolverEndpointId(v string) *ListResolverEndpointIpAddressesInput {
	s.ResolverEndpointId = &v
	return s
}

type ListResolverEndpointIpAddressesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the IP addresses in your VPC that DNS queries originate
	// from (for outbound endpoints) or that you forward DNS queries to (for inbound
	// endpoints).
	IpAddresses []*IpAddressResponse `type:"list"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the specified endpoint has more than MaxResults IP addresses, you can
	// submit another ListResolverEndpointIpAddresses request to get the next group
	// of IP addresses. In the next request, specify the value of NextToken from
	// the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResolverEndpointIpAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverEndpointIpAddressesOutput) GoString() string {
	return s.String()
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *ListResolverEndpointIpAddressesOutput) SetIpAddresses(v []*IpAddressResponse) *ListResolverEndpointIpAddressesOutput {
	s.IpAddresses = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointIpAddressesOutput) SetMaxResults(v int64) *ListResolverEndpointIpAddressesOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointIpAddressesOutput) SetNextToken(v string) *ListResolverEndpointIpAddressesOutput {
	s.NextToken = &v
	return s
}

type ListResolverEndpointsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of Resolver endpoints, such
	// as all inbound Resolver endpoints.
	//
	// If you submit a second or subsequent ListResolverEndpoints request and specify
	// the NextToken parameter, you must use the same values for Filters, if any,
	// as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of Resolver endpoints that you want to return in the response
	// to a ListResolverEndpoints request. If you don't specify a value for MaxResults,
	// Resolver returns up to 100 Resolver endpoints.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverEndpoints request, omit this value.
	//
	// If you have more than MaxResults Resolver endpoints, you can submit another
	// ListResolverEndpoints request to get the next group of Resolver endpoints.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResolverEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverEndpointsInput) SetFilters(v []*Filter) *ListResolverEndpointsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointsInput) SetMaxResults(v int64) *ListResolverEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointsInput) SetNextToken(v string) *ListResolverEndpointsInput {
	s.NextToken = &v
	return s
}

type ListResolverEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults IP addresses match the specified criteria, you can
	// submit another ListResolverEndpoint request to get the next group of results.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The Resolver endpoints that were created by using the current AWS account,
	// and that match the specified filters, if any.
	ResolverEndpoints []*ResolverEndpoint `type:"list"`
}

// String returns the string representation
func (s ListResolverEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverEndpointsOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointsOutput) SetMaxResults(v int64) *ListResolverEndpointsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointsOutput) SetNextToken(v string) *ListResolverEndpointsOutput {
	s.NextToken = &v
	return s
}

// SetResolverEndpoints sets the ResolverEndpoints field's value.
func (s *ListResolverEndpointsOutput) SetResolverEndpoints(v []*ResolverEndpoint) *ListResolverEndpointsOutput {
	s.ResolverEndpoints = v
	return s
}

type ListResolverQueryLogConfigAssociationsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of query logging associations.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigAssociations
	// request and specify the NextToken parameter, you must use the same values
	// for Filters, if any, as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of query logging associations that you want to return
	// in the response to a ListResolverQueryLogConfigAssociations request. If you
	// don't specify a value for MaxResults, Resolver returns up to 100 query logging
	// associations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverQueryLogConfigAssociations request, omit this value.
	//
	// If there are more than MaxResults query logging associations that match the
	// values that you specify for Filters, you can submit another ListResolverQueryLogConfigAssociations
	// request to get the next group of associations. In the next request, specify
	// the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The element that you want Resolver to sort query logging associations by.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigAssociations
	// request and specify the NextToken parameter, you must use the same value
	// for SortBy, if any, as in the previous request.
	//
	// Valid values include the following elements:
	//
	//    * CreationTime: The ID of the query logging association.
	//
	//    * Error: If the value of Status is FAILED, the value of Error indicates
	//    the cause: DESTINATION_NOT_FOUND: The specified destination (for example,
	//    an Amazon S3 bucket) was deleted. ACCESS_DENIED: Permissions don't allow
	//    sending logs to the destination. If Status is a value other than FAILED,
	//    ERROR is null.
	//
	//    * Id: The ID of the query logging association
	//
	//    * ResolverQueryLogConfigId: The ID of the query logging configuration
	//
	//    * ResourceId: The ID of the VPC that is associated with the query logging
	//    configuration
	//
	//    * Status: The current status of the configuration. Valid values include
	//    the following: CREATING: Resolver is creating an association between an
	//    Amazon VPC and a query logging configuration. CREATED: The association
	//    between an Amazon VPC and a query logging configuration was successfully
	//    created. Resolver is logging queries that originate in the specified VPC.
	//    DELETING: Resolver is deleting this query logging association. FAILED:
	//    Resolver either couldn't create or couldn't delete the query logging association.
	//    Here are two common causes: The specified destination (for example, an
	//    Amazon S3 bucket) was deleted. Permissions don't allow sending logs to
	//    the destination.
	SortBy *string `min:"1" type:"string"`

	// If you specified a value for SortBy, the order that you want query logging
	// associations to be listed in, ASCENDING or DESCENDING.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigAssociations
	// request and specify the NextToken parameter, you must use the same value
	// for SortOrder, if any, as in the previous request.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s ListResolverQueryLogConfigAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverQueryLogConfigAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverQueryLogConfigAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverQueryLogConfigAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SortBy != nil && len(*s.SortBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SortBy", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetFilters(v []*Filter) *ListResolverQueryLogConfigAssociationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetMaxResults(v int64) *ListResolverQueryLogConfigAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetNextToken(v string) *ListResolverQueryLogConfigAssociationsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetSortBy(v string) *ListResolverQueryLogConfigAssociationsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetSortOrder(v string) *ListResolverQueryLogConfigAssociationsInput {
	s.SortOrder = &v
	return s
}

type ListResolverQueryLogConfigAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more than MaxResults query logging associations, you can submit
	// another ListResolverQueryLogConfigAssociations request to get the next group
	// of associations. In the next request, specify the value of NextToken from
	// the previous response.
	NextToken *string `type:"string"`

	// A list that contains one ResolverQueryLogConfigAssociations element for each
	// query logging association that matches the values that you specified for
	// Filter.
	ResolverQueryLogConfigAssociations []*ResolverQueryLogConfigAssociation `type:"list"`

	// The total number of query logging associations that were created by the current
	// account in the specified Region. This count can differ from the number of
	// associations that are returned in a ListResolverQueryLogConfigAssociations
	// response, depending on the values that you specify in the request.
	TotalCount *int64 `type:"integer"`

	// The total number of query logging associations that were created by the current
	// account in the specified Region and that match the filters that were specified
	// in the ListResolverQueryLogConfigAssociations request. For the total number
	// of associations that were created by the current account in the specified
	// Region, see TotalCount.
	TotalFilteredCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ListResolverQueryLogConfigAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverQueryLogConfigAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverQueryLogConfigAssociationsOutput) SetNextToken(v string) *ListResolverQueryLogConfigAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetResolverQueryLogConfigAssociations sets the ResolverQueryLogConfigAssociations field's value.
func (s *ListResolverQueryLogConfigAssociationsOutput) SetResolverQueryLogConfigAssociations(v []*ResolverQueryLogConfigAssociation) *ListResolverQueryLogConfigAssociationsOutput {
	s.ResolverQueryLogConfigAssociations = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListResolverQueryLogConfigAssociationsOutput) SetTotalCount(v int64) *ListResolverQueryLogConfigAssociationsOutput {
	s.TotalCount = &v
	return s
}

// SetTotalFilteredCount sets the TotalFilteredCount field's value.
func (s *ListResolverQueryLogConfigAssociationsOutput) SetTotalFilteredCount(v int64) *ListResolverQueryLogConfigAssociationsOutput {
	s.TotalFilteredCount = &v
	return s
}

type ListResolverQueryLogConfigsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of query logging configurations.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigs request
	// and specify the NextToken parameter, you must use the same values for Filters,
	// if any, as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of query logging configurations that you want to return
	// in the response to a ListResolverQueryLogConfigs request. If you don't specify
	// a value for MaxResults, Resolver returns up to 100 query logging configurations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverQueryLogConfigs request, omit this value.
	//
	// If there are more than MaxResults query logging configurations that match
	// the values that you specify for Filters, you can submit another ListResolverQueryLogConfigs
	// request to get the next group of configurations. In the next request, specify
	// the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The element that you want Resolver to sort query logging configurations by.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigs request
	// and specify the NextToken parameter, you must use the same value for SortBy,
	// if any, as in the previous request.
	//
	// Valid values include the following elements:
	//
	//    * Arn: The ARN of the query logging configuration
	//
	//    * AssociationCount: The number of VPCs that are associated with the specified
	//    configuration
	//
	//    * CreationTime: The date and time that Resolver returned when the configuration
	//    was created
	//
	//    * CreatorRequestId: The value that was specified for CreatorRequestId
	//    when the configuration was created
	//
	//    * DestinationArn: The location that logs are sent to
	//
	//    * Id: The ID of the configuration
	//
	//    * Name: The name of the configuration
	//
	//    * OwnerId: The AWS account number of the account that created the configuration
	//
	//    * ShareStatus: Whether the configuration is shared with other AWS accounts
	//    or shared with the current account by another AWS account. Sharing is
	//    configured through AWS Resource Access Manager (AWS RAM).
	//
	//    * Status: The current status of the configuration. Valid values include
	//    the following: CREATING: Resolver is creating the query logging configuration.
	//    CREATED: The query logging configuration was successfully created. Resolver
	//    is logging queries that originate in the specified VPC. DELETING: Resolver
	//    is deleting this query logging configuration. FAILED: Resolver either
	//    couldn't create or couldn't delete the query logging configuration. Here
	//    are two common causes: The specified destination (for example, an Amazon
	//    S3 bucket) was deleted. Permissions don't allow sending logs to the destination.
	SortBy *string `min:"1" type:"string"`

	// If you specified a value for SortBy, the order that you want query logging
	// configurations to be listed in, ASCENDING or DESCENDING.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigs request
	// and specify the NextToken parameter, you must use the same value for SortOrder,
	// if any, as in the previous request.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s ListResolverQueryLogConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverQueryLogConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverQueryLogConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverQueryLogConfigsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SortBy != nil && len(*s.SortBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SortBy", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverQueryLogConfigsInput) SetFilters(v []*Filter) *ListResolverQueryLogConfigsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverQueryLogConfigsInput) SetMaxResults(v int64) *ListResolverQueryLogConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverQueryLogConfigsInput) SetNextToken(v string) *ListResolverQueryLogConfigsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListResolverQueryLogConfigsInput) SetSortBy(v string) *ListResolverQueryLogConfigsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListResolverQueryLogConfigsInput) SetSortOrder(v string) *ListResolverQueryLogConfigsInput {
	s.SortOrder = &v
	return s
}

type ListResolverQueryLogConfigsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more than MaxResults query logging configurations, you can submit
	// another ListResolverQueryLogConfigs request to get the next group of configurations.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// A list that contains one ResolverQueryLogConfig element for each query logging
	// configuration that matches the values that you specified for Filter.
	ResolverQueryLogConfigs []*ResolverQueryLogConfig `type:"list"`

	// The total number of query logging configurations that were created by the
	// current account in the specified Region. This count can differ from the number
	// of query logging configurations that are returned in a ListResolverQueryLogConfigs
	// response, depending on the values that you specify in the request.
	TotalCount *int64 `type:"integer"`

	// The total number of query logging configurations that were created by the
	// current account in the specified Region and that match the filters that were
	// specified in the ListResolverQueryLogConfigs request. For the total number
	// of query logging configurations that were created by the current account
	// in the specified Region, see TotalCount.
	TotalFilteredCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ListResolverQueryLogConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverQueryLogConfigsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverQueryLogConfigsOutput) SetNextToken(v string) *ListResolverQueryLogConfigsOutput {
	s.NextToken = &v
	return s
}

// SetResolverQueryLogConfigs sets the ResolverQueryLogConfigs field's value.
func (s *ListResolverQueryLogConfigsOutput) SetResolverQueryLogConfigs(v []*ResolverQueryLogConfig) *ListResolverQueryLogConfigsOutput {
	s.ResolverQueryLogConfigs = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListResolverQueryLogConfigsOutput) SetTotalCount(v int64) *ListResolverQueryLogConfigsOutput {
	s.TotalCount = &v
	return s
}

// SetTotalFilteredCount sets the TotalFilteredCount field's value.
func (s *ListResolverQueryLogConfigsOutput) SetTotalFilteredCount(v int64) *ListResolverQueryLogConfigsOutput {
	s.TotalFilteredCount = &v
	return s
}

type ListResolverRuleAssociationsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of Resolver rules, such as Resolver
	// rules that are associated with the same VPC ID.
	//
	// If you submit a second or subsequent ListResolverRuleAssociations request
	// and specify the NextToken parameter, you must use the same values for Filters,
	// if any, as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of rule associations that you want to return in the response
	// to a ListResolverRuleAssociations request. If you don't specify a value for
	// MaxResults, Resolver returns up to 100 rule associations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverRuleAssociation request, omit this value.
	//
	// If you have more than MaxResults rule associations, you can submit another
	// ListResolverRuleAssociation request to get the next group of rule associations.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResolverRuleAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverRuleAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverRuleAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverRuleAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverRuleAssociationsInput) SetFilters(v []*Filter) *ListResolverRuleAssociationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRuleAssociationsInput) SetMaxResults(v int64) *ListResolverRuleAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRuleAssociationsInput) SetNextToken(v string) *ListResolverRuleAssociationsInput {
	s.NextToken = &v
	return s
}

type ListResolverRuleAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults rule associations match the specified criteria, you
	// can submit another ListResolverRuleAssociation request to get the next group
	// of results. In the next request, specify the value of NextToken from the
	// previous response.
	NextToken *string `type:"string"`

	// The associations that were created between Resolver rules and VPCs using
	// the current AWS account, and that match the specified filters, if any.
	ResolverRuleAssociations []*ResolverRuleAssociation `type:"list"`
}

// String returns the string representation
func (s ListResolverRuleAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverRuleAssociationsOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRuleAssociationsOutput) SetMaxResults(v int64) *ListResolverRuleAssociationsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRuleAssociationsOutput) SetNextToken(v string) *ListResolverRuleAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetResolverRuleAssociations sets the ResolverRuleAssociations field's value.
func (s *ListResolverRuleAssociationsOutput) SetResolverRuleAssociations(v []*ResolverRuleAssociation) *ListResolverRuleAssociationsOutput {
	s.ResolverRuleAssociations = v
	return s
}

type ListResolverRulesInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of Resolver rules, such as all
	// Resolver rules that are associated with the same Resolver endpoint.
	//
	// If you submit a second or subsequent ListResolverRules request and specify
	// the NextToken parameter, you must use the same values for Filters, if any,
	// as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of Resolver rules that you want to return in the response
	// to a ListResolverRules request. If you don't specify a value for MaxResults,
	// Resolver returns up to 100 Resolver rules.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverRules request, omit this value.
	//
	// If you have more than MaxResults Resolver rules, you can submit another ListResolverRules
	// request to get the next group of Resolver rules. In the next request, specify
	// the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResolverRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverRulesInput) SetFilters(v []*Filter) *ListResolverRulesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRulesInput) SetMaxResults(v int64) *ListResolverRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRulesInput) SetNextToken(v string) *ListResolverRulesInput {
	s.NextToken = &v
	return s
}

type ListResolverRulesOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults Resolver rules match the specified criteria, you
	// can submit another ListResolverRules request to get the next group of results.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The Resolver rules that were created using the current AWS account and that
	// match the specified filters, if any.
	ResolverRules []*ResolverRule `type:"list"`
}

// String returns the string representation
func (s ListResolverRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverRulesOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRulesOutput) SetMaxResults(v int64) *ListResolverRulesOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRulesOutput) SetNextToken(v string) *ListResolverRulesOutput {
	s.NextToken = &v
	return s
}

// SetResolverRules sets the ResolverRules field's value.
func (s *ListResolverRulesOutput) SetResolverRules(v []*ResolverRule) *ListResolverRulesOutput {
	s.ResolverRules = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tags that you want to return in the response to a ListTagsForResource
	// request. If you don't specify a value for MaxResults, Resolver returns up
	// to 100 tags.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListTagsForResource request, omit this value.
	//
	// If you have more than MaxResults tags, you can submit another ListTagsForResource
	// request to get the next group of tags for the resource. In the next request,
	// specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) for the resource that you want to list tags
	// for.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults tags match the specified criteria, you can submit
	// another ListTagsForResource request to get the next group of results. In
	// the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The tags that are associated with the resource that you specified in the
	// ListTagsForResource request.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PutResolverQueryLogConfigPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the account that you want to share rules
	// with.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// An AWS Identity and Access Management policy statement that lists the query
	// logging configurations that you want to share with another AWS account and
	// the operations that you want the account to be able to perform. You can specify
	// the following operations in the Actions section of the statement:
	//
	//    * route53resolver:AssociateResolverQueryLogConfig
	//
	//    * route53resolver:DisassociateResolverQueryLogConfig
	//
	//    * route53resolver:ListResolverQueryLogConfigAssociations
	//
	//    * route53resolver:ListResolverQueryLogConfigs
	//
	// In the Resource section of the statement, you specify the ARNs for the query
	// logging configurations that you want to share with the account that you specified
	// in Arn.
	//
	// ResolverQueryLogConfigPolicy is a required field
	ResolverQueryLogConfigPolicy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutResolverQueryLogConfigPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResolverQueryLogConfigPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResolverQueryLogConfigPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResolverQueryLogConfigPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ResolverQueryLogConfigPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigPolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *PutResolverQueryLogConfigPolicyInput) SetArn(v string) *PutResolverQueryLogConfigPolicyInput {
	s.Arn = &v
	return s
}

// SetResolverQueryLogConfigPolicy sets the ResolverQueryLogConfigPolicy field's value.
func (s *PutResolverQueryLogConfigPolicyInput) SetResolverQueryLogConfigPolicy(v string) *PutResolverQueryLogConfigPolicyInput {
	s.ResolverQueryLogConfigPolicy = &v
	return s
}

// The response to a PutResolverQueryLogConfigPolicy request.
type PutResolverQueryLogConfigPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Whether the PutResolverQueryLogConfigPolicy request was successful.
	ReturnValue *bool `type:"boolean"`
}

// String returns the string representation
func (s PutResolverQueryLogConfigPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResolverQueryLogConfigPolicyOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *PutResolverQueryLogConfigPolicyOutput) SetReturnValue(v bool) *PutResolverQueryLogConfigPolicyOutput {
	s.ReturnValue = &v
	return s
}

type PutResolverRulePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the account that you want to share rules
	// with.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// An AWS Identity and Access Management policy statement that lists the rules
	// that you want to share with another AWS account and the operations that you
	// want the account to be able to perform. You can specify the following operations
	// in the Actions section of the statement:
	//
	//    * route53resolver:GetResolverRule
	//
	//    * route53resolver:AssociateResolverRule
	//
	//    * route53resolver:DisassociateResolverRule
	//
	//    * route53resolver:ListResolverRules
	//
	//    * route53resolver:ListResolverRuleAssociations
	//
	// In the Resource section of the statement, you specify the ARNs for the rules
	// that you want to share with the account that you specified in Arn.
	//
	// ResolverRulePolicy is a required field
	ResolverRulePolicy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutResolverRulePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResolverRulePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResolverRulePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResolverRulePolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ResolverRulePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRulePolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *PutResolverRulePolicyInput) SetArn(v string) *PutResolverRulePolicyInput {
	s.Arn = &v
	return s
}

// SetResolverRulePolicy sets the ResolverRulePolicy field's value.
func (s *PutResolverRulePolicyInput) SetResolverRulePolicy(v string) *PutResolverRulePolicyInput {
	s.ResolverRulePolicy = &v
	return s
}

// The response to a PutResolverRulePolicy request.
type PutResolverRulePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Whether the PutResolverRulePolicy request was successful.
	ReturnValue *bool `type:"boolean"`
}

// String returns the string representation
func (s PutResolverRulePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResolverRulePolicyOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *PutResolverRulePolicyOutput) SetReturnValue(v bool) *PutResolverRulePolicyOutput {
	s.ReturnValue = &v
	return s
}

// In the response to a CreateResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html),
// DeleteResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverEndpoint.html),
// GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html),
// ListResolverEndpoints (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html),
// or UpdateResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html)
// request, a complex type that contains settings for an existing inbound or
// outbound Resolver endpoint.
type ResolverEndpoint struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the Resolver endpoint.
	Arn *string `min:"1" type:"string"`

	// The date and time that the endpoint was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string that identifies the request that created the Resolver endpoint.
	// The CreatorRequestId allows failed requests to be retried without the risk
	// of executing the operation twice.
	CreatorRequestId *string `min:"1" type:"string"`

	// Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:
	//
	//    * INBOUND: allows DNS queries to your VPC from your network
	//
	//    * OUTBOUND: allows DNS queries from your VPC to your network
	Direction *string `type:"string" enum:"ResolverEndpointDirection"`

	// The ID of the VPC that you want to create the Resolver endpoint in.
	HostVPCId *string `min:"1" type:"string"`

	// The ID of the Resolver endpoint.
	Id *string `min:"1" type:"string"`

	// The number of IP addresses that the Resolver endpoint can use for DNS queries.
	IpAddressCount *int64 `type:"integer"`

	// The date and time that the endpoint was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// The name that you assigned to the Resolver endpoint when you submitted a
	// CreateResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html)
	// request.
	Name *string `type:"string"`

	// The ID of one or more security groups that control access to this VPC. The
	// security group must include one or more inbound rules (for inbound endpoints)
	// or outbound rules (for outbound endpoints). Inbound and outbound rules must
	// allow TCP and UDP access. For inbound access, open port 53. For outbound
	// access, open the port that you're using for DNS queries on your network.
	SecurityGroupIds []*string `type:"list"`

	// A code that specifies the current status of the Resolver endpoint. Valid
	// values include the following:
	//
	//    * CREATING: Resolver is creating and configuring one or more Amazon VPC
	//    network interfaces for this endpoint.
	//
	//    * OPERATIONAL: The Amazon VPC network interfaces for this endpoint are
	//    correctly configured and able to pass inbound or outbound DNS queries
	//    between your network and Resolver.
	//
	//    * UPDATING: Resolver is associating or disassociating one or more network
	//    interfaces with this endpoint.
	//
	//    * AUTO_RECOVERING: Resolver is trying to recover one or more of the network
	//    interfaces that are associated with this endpoint. During the recovery
	//    process, the endpoint functions with limited capacity because of the limit
	//    on the number of DNS queries per IP address (per network interface). For
	//    the current limit, see Limits on Route 53 Resolver (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver).
	//
	//    * ACTION_NEEDED: This endpoint is unhealthy, and Resolver can't automatically
	//    recover it. To resolve the problem, we recommend that you check each IP
	//    address that you associated with the endpoint. For each IP address that
	//    isn't available, add another IP address and then delete the IP address
	//    that isn't available. (An endpoint must always include at least two IP
	//    addresses.) A status of ACTION_NEEDED can have a variety of causes. Here
	//    are two common causes: One or more of the network interfaces that are
	//    associated with the endpoint were deleted using Amazon VPC. The network
	//    interface couldn't be created for some reason that's outside the control
	//    of Resolver.
	//
	//    * DELETING: Resolver is deleting this endpoint and the associated network
	//    interfaces.
	Status *string `type:"string" enum:"ResolverEndpointStatus"`

	// A detailed description of the status of the Resolver endpoint.
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s ResolverEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverEndpoint) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResolverEndpoint) SetArn(v string) *ResolverEndpoint {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResolverEndpoint) SetCreationTime(v string) *ResolverEndpoint {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *ResolverEndpoint) SetCreatorRequestId(v string) *ResolverEndpoint {
	s.CreatorRequestId = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *ResolverEndpoint) SetDirection(v string) *ResolverEndpoint {
	s.Direction = &v
	return s
}

// SetHostVPCId sets the HostVPCId field's value.
func (s *ResolverEndpoint) SetHostVPCId(v string) *ResolverEndpoint {
	s.HostVPCId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverEndpoint) SetId(v string) *ResolverEndpoint {
	s.Id = &v
	return s
}

// SetIpAddressCount sets the IpAddressCount field's value.
func (s *ResolverEndpoint) SetIpAddressCount(v int64) *ResolverEndpoint {
	s.IpAddressCount = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *ResolverEndpoint) SetModificationTime(v string) *ResolverEndpoint {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverEndpoint) SetName(v string) *ResolverEndpoint {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *ResolverEndpoint) SetSecurityGroupIds(v []*string) *ResolverEndpoint {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverEndpoint) SetStatus(v string) *ResolverEndpoint {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResolverEndpoint) SetStatusMessage(v string) *ResolverEndpoint {
	s.StatusMessage = &v
	return s
}

// In the response to a CreateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html),
// DeleteResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html),
// GetResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html),
// or ListResolverQueryLogConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html)
// request, a complex type that contains settings for one query logging configuration.
type ResolverQueryLogConfig struct {
	_ struct{} `type:"structure"`

	// The ARN for the query logging configuration.
	Arn *string `min:"1" type:"string"`

	// The number of VPCs that are associated with the query logging configuration.
	AssociationCount *int64 `type:"integer"`

	// The date and time that the query logging configuration was created, in Unix
	// time format and Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string that identifies the request that created the query logging
	// configuration. The CreatorRequestId allows failed requests to be retried
	// without the risk of executing the operation twice.
	CreatorRequestId *string `min:"1" type:"string"`

	// The ARN of the resource that you want Resolver to send query logs: an Amazon
	// S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery
	// stream.
	DestinationArn *string `min:"1" type:"string"`

	// The ID for the query logging configuration.
	Id *string `min:"1" type:"string"`

	// The name of the query logging configuration.
	Name *string `min:"1" type:"string"`

	// The AWS account ID for the account that created the query logging configuration.
	OwnerId *string `min:"12" type:"string"`

	// An indication of whether the query logging configuration is shared with other
	// AWS accounts, or was shared with the current account by another AWS account.
	// Sharing is configured through AWS Resource Access Manager (AWS RAM).
	ShareStatus *string `type:"string" enum:"ShareStatus"`

	// The status of the specified query logging configuration. Valid values include
	// the following:
	//
	//    * CREATING: Resolver is creating the query logging configuration.
	//
	//    * CREATED: The query logging configuration was successfully created. Resolver
	//    is logging queries that originate in the specified VPC.
	//
	//    * DELETING: Resolver is deleting this query logging configuration.
	//
	//    * FAILED: Resolver can't deliver logs to the location that is specified
	//    in the query logging configuration. Here are two common causes: The specified
	//    destination (for example, an Amazon S3 bucket) was deleted. Permissions
	//    don't allow sending logs to the destination.
	Status *string `type:"string" enum:"ResolverQueryLogConfigStatus"`
}

// String returns the string representation
func (s ResolverQueryLogConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverQueryLogConfig) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResolverQueryLogConfig) SetArn(v string) *ResolverQueryLogConfig {
	s.Arn = &v
	return s
}

// SetAssociationCount sets the AssociationCount field's value.
func (s *ResolverQueryLogConfig) SetAssociationCount(v int64) *ResolverQueryLogConfig {
	s.AssociationCount = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResolverQueryLogConfig) SetCreationTime(v string) *ResolverQueryLogConfig {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *ResolverQueryLogConfig) SetCreatorRequestId(v string) *ResolverQueryLogConfig {
	s.CreatorRequestId = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *ResolverQueryLogConfig) SetDestinationArn(v string) *ResolverQueryLogConfig {
	s.DestinationArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverQueryLogConfig) SetId(v string) *ResolverQueryLogConfig {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverQueryLogConfig) SetName(v string) *ResolverQueryLogConfig {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ResolverQueryLogConfig) SetOwnerId(v string) *ResolverQueryLogConfig {
	s.OwnerId = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *ResolverQueryLogConfig) SetShareStatus(v string) *ResolverQueryLogConfig {
	s.ShareStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverQueryLogConfig) SetStatus(v string) *ResolverQueryLogConfig {
	s.Status = &v
	return s
}

// In the response to an AssociateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html),
// DisassociateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html),
// GetResolverQueryLogConfigAssociation (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html),
// or ListResolverQueryLogConfigAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html),
// request, a complex type that contains settings for a specified association
// between an Amazon VPC and a query logging configuration.
type ResolverQueryLogConfigAssociation struct {
	_ struct{} `type:"structure"`

	// The date and time that the VPC was associated with the query logging configuration,
	// in Unix time format and Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// If the value of Status is FAILED, the value of Error indicates the cause:
	//
	//    * DESTINATION_NOT_FOUND: The specified destination (for example, an Amazon
	//    S3 bucket) was deleted.
	//
	//    * ACCESS_DENIED: Permissions don't allow sending logs to the destination.
	//
	// If the value of Status is a value other than FAILED, Error is null.
	Error *string `type:"string" enum:"ResolverQueryLogConfigAssociationError"`

	// Contains additional information about the error. If the value or Error is
	// null, the value of ErrorMessage also is null.
	ErrorMessage *string `type:"string"`

	// The ID of the query logging association.
	Id *string `min:"1" type:"string"`

	// The ID of the query logging configuration that a VPC is associated with.
	ResolverQueryLogConfigId *string `min:"1" type:"string"`

	// The ID of the Amazon VPC that is associated with the query logging configuration.
	ResourceId *string `min:"1" type:"string"`

	// The status of the specified query logging association. Valid values include
	// the following:
	//
	//    * CREATING: Resolver is creating an association between an Amazon VPC
	//    and a query logging configuration.
	//
	//    * CREATED: The association between an Amazon VPC and a query logging configuration
	//    was successfully created. Resolver is logging queries that originate in
	//    the specified VPC.
	//
	//    * DELETING: Resolver is deleting this query logging association.
	//
	//    * FAILED: Resolver either couldn't create or couldn't delete the query
	//    logging association.
	Status *string `type:"string" enum:"ResolverQueryLogConfigAssociationStatus"`
}

// String returns the string representation
func (s ResolverQueryLogConfigAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverQueryLogConfigAssociation) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResolverQueryLogConfigAssociation) SetCreationTime(v string) *ResolverQueryLogConfigAssociation {
	s.CreationTime = &v
	return s
}

// SetError sets the Error field's value.
func (s *ResolverQueryLogConfigAssociation) SetError(v string) *ResolverQueryLogConfigAssociation {
	s.Error = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ResolverQueryLogConfigAssociation) SetErrorMessage(v string) *ResolverQueryLogConfigAssociation {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverQueryLogConfigAssociation) SetId(v string) *ResolverQueryLogConfigAssociation {
	s.Id = &v
	return s
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *ResolverQueryLogConfigAssociation) SetResolverQueryLogConfigId(v string) *ResolverQueryLogConfigAssociation {
	s.ResolverQueryLogConfigId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResolverQueryLogConfigAssociation) SetResourceId(v string) *ResolverQueryLogConfigAssociation {
	s.ResourceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverQueryLogConfigAssociation) SetStatus(v string) *ResolverQueryLogConfigAssociation {
	s.Status = &v
	return s
}

// For queries that originate in your VPC, detailed information about a Resolver
// rule, which specifies how to route DNS queries out of the VPC. The ResolverRule
// parameter appears in the response to a CreateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html),
// DeleteResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverRule.html),
// GetResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html),
// ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html),
// or UpdateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html)
// request.
type ResolverRule struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the Resolver rule specified by Id.
	Arn *string `min:"1" type:"string"`

	// The date and time that the Resolver rule was created, in Unix time format
	// and Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string that you specified when you created the Resolver rule. CreatorRequestId
	// identifies the request and allows failed requests to be retried without the
	// risk of executing the operation twice.
	CreatorRequestId *string `min:"1" type:"string"`

	// DNS queries for this domain name are forwarded to the IP addresses that are
	// specified in TargetIps. If a query matches multiple Resolver rules (example.com
	// and www.example.com), the query is routed using the Resolver rule that contains
	// the most specific domain name (www.example.com).
	DomainName *string `min:"1" type:"string"`

	// The ID that Resolver assigned to the Resolver rule when you created it.
	Id *string `min:"1" type:"string"`

	// The date and time that the Resolver rule was last updated, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// The name for the Resolver rule, which you specified when you created the
	// Resolver rule.
	Name *string `type:"string"`

	// When a rule is shared with another AWS account, the account ID of the account
	// that the rule is shared with.
	OwnerId *string `min:"12" type:"string"`

	// The ID of the endpoint that the rule is associated with.
	ResolverEndpointId *string `min:"1" type:"string"`

	// When you want to forward DNS queries for specified domain name to resolvers
	// on your network, specify FORWARD.
	//
	// When you have a forwarding rule to forward DNS queries for a domain to your
	// network and you want Resolver to process queries for a subdomain of that
	// domain, specify SYSTEM.
	//
	// For example, to forward DNS queries for example.com to resolvers on your
	// network, you create a rule and specify FORWARD for RuleType. To then have
	// Resolver process queries for apex.example.com, you create a rule and specify
	// SYSTEM for RuleType.
	//
	// Currently, only Resolver can create rules that have a value of RECURSIVE
	// for RuleType.
	RuleType *string `type:"string" enum:"RuleTypeOption"`

	// Whether the rules is shared and, if so, whether the current account is sharing
	// the rule with another account, or another account is sharing the rule with
	// the current account.
	ShareStatus *string `type:"string" enum:"ShareStatus"`

	// A code that specifies the current status of the Resolver rule.
	Status *string `type:"string" enum:"ResolverRuleStatus"`

	// A detailed description of the status of a Resolver rule.
	StatusMessage *string `type:"string"`

	// An array that contains the IP addresses and ports that an outbound endpoint
	// forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers
	// on your network. Specify IPv4 addresses. IPv6 is not supported.
	TargetIps []*TargetAddress `min:"1" type:"list"`
}

// String returns the string representation
func (s ResolverRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverRule) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResolverRule) SetArn(v string) *ResolverRule {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResolverRule) SetCreationTime(v string) *ResolverRule {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *ResolverRule) SetCreatorRequestId(v string) *ResolverRule {
	s.CreatorRequestId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ResolverRule) SetDomainName(v string) *ResolverRule {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverRule) SetId(v string) *ResolverRule {
	s.Id = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *ResolverRule) SetModificationTime(v string) *ResolverRule {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverRule) SetName(v string) *ResolverRule {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ResolverRule) SetOwnerId(v string) *ResolverRule {
	s.OwnerId = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *ResolverRule) SetResolverEndpointId(v string) *ResolverRule {
	s.ResolverEndpointId = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *ResolverRule) SetRuleType(v string) *ResolverRule {
	s.RuleType = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *ResolverRule) SetShareStatus(v string) *ResolverRule {
	s.ShareStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverRule) SetStatus(v string) *ResolverRule {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResolverRule) SetStatusMessage(v string) *ResolverRule {
	s.StatusMessage = &v
	return s
}

// SetTargetIps sets the TargetIps field's value.
func (s *ResolverRule) SetTargetIps(v []*TargetAddress) *ResolverRule {
	s.TargetIps = v
	return s
}

// In the response to an AssociateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html),
// DisassociateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html),
// or ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html)
// request, provides information about an association between a Resolver rule
// and a VPC. The association determines which DNS queries that originate in
// the VPC are forwarded to your network.
type ResolverRuleAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the association between a Resolver rule and a VPC. Resolver assigns
	// this value when you submit an AssociateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html)
	// request.
	Id *string `min:"1" type:"string"`

	// The name of an association between a Resolver rule and a VPC.
	Name *string `type:"string"`

	// The ID of the Resolver rule that you associated with the VPC that is specified
	// by VPCId.
	ResolverRuleId *string `min:"1" type:"string"`

	// A code that specifies the current status of the association between a Resolver
	// rule and a VPC.
	Status *string `type:"string" enum:"ResolverRuleAssociationStatus"`

	// A detailed description of the status of the association between a Resolver
	// rule and a VPC.
	StatusMessage *string `type:"string"`

	// The ID of the VPC that you associated the Resolver rule with.
	VPCId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResolverRuleAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverRuleAssociation) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ResolverRuleAssociation) SetId(v string) *ResolverRuleAssociation {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverRuleAssociation) SetName(v string) *ResolverRuleAssociation {
	s.Name = &v
	return s
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *ResolverRuleAssociation) SetResolverRuleId(v string) *ResolverRuleAssociation {
	s.ResolverRuleId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverRuleAssociation) SetStatus(v string) *ResolverRuleAssociation {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResolverRuleAssociation) SetStatusMessage(v string) *ResolverRuleAssociation {
	s.StatusMessage = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *ResolverRuleAssociation) SetVPCId(v string) *ResolverRuleAssociation {
	s.VPCId = &v
	return s
}

// In an UpdateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html)
// request, information about the changes that you want to make.
type ResolverRuleConfig struct {
	_ struct{} `type:"structure"`

	// The new name for the Resolver rule. The name that you specify appears in
	// the Resolver dashboard in the Route 53 console.
	Name *string `type:"string"`

	// The ID of the new outbound Resolver endpoint that you want to use to route
	// DNS queries to the IP addresses that you specify in TargetIps.
	ResolverEndpointId *string `min:"1" type:"string"`

	// For DNS queries that originate in your VPC, the new IP addresses that you
	// want to route outbound DNS queries to.
	TargetIps []*TargetAddress `min:"1" type:"list"`
}

// String returns the string representation
func (s ResolverRuleConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverRuleConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolverRuleConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolverRuleConfig"}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.TargetIps != nil && len(s.TargetIps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetIps", 1))
	}
	if s.TargetIps != nil {
		for i, v := range s.TargetIps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetIps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ResolverRuleConfig) SetName(v string) *ResolverRuleConfig {
	s.Name = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *ResolverRuleConfig) SetResolverEndpointId(v string) *ResolverRuleConfig {
	s.ResolverEndpointId = &v
	return s
}

// SetTargetIps sets the TargetIps field's value.
func (s *ResolverRuleConfig) SetTargetIps(v []*TargetAddress) *ResolverRuleConfig {
	s.TargetIps = v
	return s
}

// The resource that you tried to create already exists.
type ResourceExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a ResourceExistsException error, the type of resource that the error
	// applies to.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ResourceExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceExistsException) GoString() string {
	return s.String()
}

func newErrorResourceExistsException(v protocol.ResponseMetadata) error {
	return &ResourceExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceExistsException) Code() string {
	return "ResourceExistsException"
}

// Message returns the exception's message.
func (s *ResourceExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceExistsException) OrigErr() error {
	return nil
}

func (s *ResourceExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource that you tried to update or delete is currently in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a ResourceInUseException error, the type of resource that is currently
	// in use.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a ResourceNotFoundException error, the type of resource that doesn't
	// exist.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource isn't available.
type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a ResourceUnavailableException error, the type of resource that isn't
	// available.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One tag that you want to add to the specified resource. A tag consists of
// a Key (a name for the tag) and a Value.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name for the tag. For example, if you want to associate Resolver resources
	// with the account IDs of your customers for billing purposes, the value of
	// Key might be account-id.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the tag. For example, if Key is account-id, then Value might
	// be the ID of the customer account that you're creating the resource for.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource that you want to add tags
	// to. To get the ARN for a resource, use the applicable Get or List command:
	//
	//    * GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html)
	//
	//    * GetResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html)
	//
	//    * GetResolverRuleAssociation (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html)
	//
	//    * ListResolverEndpoints (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html)
	//
	//    * ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html)
	//
	//    * ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html)
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags that you want to add to the specified resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// In a CreateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html)
// request, an array of the IPs that you want to forward DNS queries to.
type TargetAddress struct {
	_ struct{} `type:"structure"`

	// One IP address that you want to forward DNS queries to. You can specify only
	// IPv4 addresses.
	//
	// Ip is a required field
	Ip *string `min:"7" type:"string" required:"true"`

	// The port at Ip that you want to forward DNS queries to.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s TargetAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetAddress) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetAddress) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetAddress"}
	if s.Ip == nil {
		invalidParams.Add(request.NewErrParamRequired("Ip"))
	}
	if s.Ip != nil && len(*s.Ip) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *TargetAddress) SetIp(v string) *TargetAddress {
	s.Ip = &v
	return s
}

// SetPort sets the Port field's value.
func (s *TargetAddress) SetPort(v int64) *TargetAddress {
	s.Port = &v
	return s
}

// The request was throttled. Try again in a few minutes.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource doesn't exist.
type UnknownResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnknownResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnknownResourceException) GoString() string {
	return s.String()
}

func newErrorUnknownResourceException(v protocol.ResponseMetadata) error {
	return &UnknownResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnknownResourceException) Code() string {
	return "UnknownResourceException"
}

// Message returns the exception's message.
func (s *UnknownResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnknownResourceException) OrigErr() error {
	return nil
}

func (s *UnknownResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnknownResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnknownResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource that you want to remove tags
	// from. To get the ARN for a resource, use the applicable Get or List command:
	//
	//    * GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html)
	//
	//    * GetResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html)
	//
	//    * GetResolverRuleAssociation (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html)
	//
	//    * ListResolverEndpoints (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html)
	//
	//    * ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html)
	//
	//    * ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html)
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags that you want to remove to the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the Resolver endpoint that you want to update.
	Name *string `type:"string"`

	// The ID of the Resolver endpoint that you want to update.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResolverEndpointInput"}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateResolverEndpointInput) SetName(v string) *UpdateResolverEndpointInput {
	s.Name = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *UpdateResolverEndpointInput) SetResolverEndpointId(v string) *UpdateResolverEndpointInput {
	s.ResolverEndpointId = &v
	return s
}

type UpdateResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The response to an UpdateResolverEndpoint request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s UpdateResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *UpdateResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *UpdateResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type UpdateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The new settings for the Resolver rule.
	//
	// Config is a required field
	Config *ResolverRuleConfig `type:"structure" required:"true"`

	// The ID of the Resolver rule that you want to update.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResolverRuleInput"}
	if s.Config == nil {
		invalidParams.Add(request.NewErrParamRequired("Config"))
	}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}
	if s.Config != nil {
		if err := s.Config.Validate(); err != nil {
			invalidParams.AddNested("Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfig sets the Config field's value.
func (s *UpdateResolverRuleInput) SetConfig(v *ResolverRuleConfig) *UpdateResolverRuleInput {
	s.Config = v
	return s
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *UpdateResolverRuleInput) SetResolverRuleId(v string) *UpdateResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

type UpdateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// The response to an UpdateResolverRule request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation
func (s UpdateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *UpdateResolverRuleOutput) SetResolverRule(v *ResolverRule) *UpdateResolverRuleOutput {
	s.ResolverRule = v
	return s
}

const (
	// IpAddressStatusCreating is a IpAddressStatus enum value
	IpAddressStatusCreating = "CREATING"

	// IpAddressStatusFailedCreation is a IpAddressStatus enum value
	IpAddressStatusFailedCreation = "FAILED_CREATION"

	// IpAddressStatusAttaching is a IpAddressStatus enum value
	IpAddressStatusAttaching = "ATTACHING"

	// IpAddressStatusAttached is a IpAddressStatus enum value
	IpAddressStatusAttached = "ATTACHED"

	// IpAddressStatusRemapDetaching is a IpAddressStatus enum value
	IpAddressStatusRemapDetaching = "REMAP_DETACHING"

	// IpAddressStatusRemapAttaching is a IpAddressStatus enum value
	IpAddressStatusRemapAttaching = "REMAP_ATTACHING"

	// IpAddressStatusDetaching is a IpAddressStatus enum value
	IpAddressStatusDetaching = "DETACHING"

	// IpAddressStatusFailedResourceGone is a IpAddressStatus enum value
	IpAddressStatusFailedResourceGone = "FAILED_RESOURCE_GONE"

	// IpAddressStatusDeleting is a IpAddressStatus enum value
	IpAddressStatusDeleting = "DELETING"

	// IpAddressStatusDeleteFailedFasExpired is a IpAddressStatus enum value
	IpAddressStatusDeleteFailedFasExpired = "DELETE_FAILED_FAS_EXPIRED"
)

// IpAddressStatus_Values returns all elements of the IpAddressStatus enum
func IpAddressStatus_Values() []string {
	return []string{
		IpAddressStatusCreating,
		IpAddressStatusFailedCreation,
		IpAddressStatusAttaching,
		IpAddressStatusAttached,
		IpAddressStatusRemapDetaching,
		IpAddressStatusRemapAttaching,
		IpAddressStatusDetaching,
		IpAddressStatusFailedResourceGone,
		IpAddressStatusDeleting,
		IpAddressStatusDeleteFailedFasExpired,
	}
}

const (
	// ResolverEndpointDirectionInbound is a ResolverEndpointDirection enum value
	ResolverEndpointDirectionInbound = "INBOUND"

	// ResolverEndpointDirectionOutbound is a ResolverEndpointDirection enum value
	ResolverEndpointDirectionOutbound = "OUTBOUND"
)

// ResolverEndpointDirection_Values returns all elements of the ResolverEndpointDirection enum
func ResolverEndpointDirection_Values() []string {
	return []string{
		ResolverEndpointDirectionInbound,
		ResolverEndpointDirectionOutbound,
	}
}

const (
	// ResolverEndpointStatusCreating is a ResolverEndpointStatus enum value
	ResolverEndpointStatusCreating = "CREATING"

	// ResolverEndpointStatusOperational is a ResolverEndpointStatus enum value
	ResolverEndpointStatusOperational = "OPERATIONAL"

	// ResolverEndpointStatusUpdating is a ResolverEndpointStatus enum value
	ResolverEndpointStatusUpdating = "UPDATING"

	// ResolverEndpointStatusAutoRecovering is a ResolverEndpointStatus enum value
	ResolverEndpointStatusAutoRecovering = "AUTO_RECOVERING"

	// ResolverEndpointStatusActionNeeded is a ResolverEndpointStatus enum value
	ResolverEndpointStatusActionNeeded = "ACTION_NEEDED"

	// ResolverEndpointStatusDeleting is a ResolverEndpointStatus enum value
	ResolverEndpointStatusDeleting = "DELETING"
)

// ResolverEndpointStatus_Values returns all elements of the ResolverEndpointStatus enum
func ResolverEndpointStatus_Values() []string {
	return []string{
		ResolverEndpointStatusCreating,
		ResolverEndpointStatusOperational,
		ResolverEndpointStatusUpdating,
		ResolverEndpointStatusAutoRecovering,
		ResolverEndpointStatusActionNeeded,
		ResolverEndpointStatusDeleting,
	}
}

const (
	// ResolverQueryLogConfigAssociationErrorNone is a ResolverQueryLogConfigAssociationError enum value
	ResolverQueryLogConfigAssociationErrorNone = "NONE"

	// ResolverQueryLogConfigAssociationErrorDestinationNotFound is a ResolverQueryLogConfigAssociationError enum value
	ResolverQueryLogConfigAssociationErrorDestinationNotFound = "DESTINATION_NOT_FOUND"

	// ResolverQueryLogConfigAssociationErrorAccessDenied is a ResolverQueryLogConfigAssociationError enum value
	ResolverQueryLogConfigAssociationErrorAccessDenied = "ACCESS_DENIED"

	// ResolverQueryLogConfigAssociationErrorInternalServiceError is a ResolverQueryLogConfigAssociationError enum value
	ResolverQueryLogConfigAssociationErrorInternalServiceError = "INTERNAL_SERVICE_ERROR"
)

// ResolverQueryLogConfigAssociationError_Values returns all elements of the ResolverQueryLogConfigAssociationError enum
func ResolverQueryLogConfigAssociationError_Values() []string {
	return []string{
		ResolverQueryLogConfigAssociationErrorNone,
		ResolverQueryLogConfigAssociationErrorDestinationNotFound,
		ResolverQueryLogConfigAssociationErrorAccessDenied,
		ResolverQueryLogConfigAssociationErrorInternalServiceError,
	}
}

const (
	// ResolverQueryLogConfigAssociationStatusCreating is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusCreating = "CREATING"

	// ResolverQueryLogConfigAssociationStatusActive is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusActive = "ACTIVE"

	// ResolverQueryLogConfigAssociationStatusActionNeeded is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusActionNeeded = "ACTION_NEEDED"

	// ResolverQueryLogConfigAssociationStatusDeleting is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusDeleting = "DELETING"

	// ResolverQueryLogConfigAssociationStatusFailed is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusFailed = "FAILED"
)

// ResolverQueryLogConfigAssociationStatus_Values returns all elements of the ResolverQueryLogConfigAssociationStatus enum
func ResolverQueryLogConfigAssociationStatus_Values() []string {
	return []string{
		ResolverQueryLogConfigAssociationStatusCreating,
		ResolverQueryLogConfigAssociationStatusActive,
		ResolverQueryLogConfigAssociationStatusActionNeeded,
		ResolverQueryLogConfigAssociationStatusDeleting,
		ResolverQueryLogConfigAssociationStatusFailed,
	}
}

const (
	// ResolverQueryLogConfigStatusCreating is a ResolverQueryLogConfigStatus enum value
	ResolverQueryLogConfigStatusCreating = "CREATING"

	// ResolverQueryLogConfigStatusCreated is a ResolverQueryLogConfigStatus enum value
	ResolverQueryLogConfigStatusCreated = "CREATED"

	// ResolverQueryLogConfigStatusDeleting is a ResolverQueryLogConfigStatus enum value
	ResolverQueryLogConfigStatusDeleting = "DELETING"

	// ResolverQueryLogConfigStatusFailed is a ResolverQueryLogConfigStatus enum value
	ResolverQueryLogConfigStatusFailed = "FAILED"
)

// ResolverQueryLogConfigStatus_Values returns all elements of the ResolverQueryLogConfigStatus enum
func ResolverQueryLogConfigStatus_Values() []string {
	return []string{
		ResolverQueryLogConfigStatusCreating,
		ResolverQueryLogConfigStatusCreated,
		ResolverQueryLogConfigStatusDeleting,
		ResolverQueryLogConfigStatusFailed,
	}
}

const (
	// ResolverRuleAssociationStatusCreating is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusCreating = "CREATING"

	// ResolverRuleAssociationStatusComplete is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusComplete = "COMPLETE"

	// ResolverRuleAssociationStatusDeleting is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusDeleting = "DELETING"

	// ResolverRuleAssociationStatusFailed is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusFailed = "FAILED"

	// ResolverRuleAssociationStatusOverridden is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusOverridden = "OVERRIDDEN"
)

// ResolverRuleAssociationStatus_Values returns all elements of the ResolverRuleAssociationStatus enum
func ResolverRuleAssociationStatus_Values() []string {
	return []string{
		ResolverRuleAssociationStatusCreating,
		ResolverRuleAssociationStatusComplete,
		ResolverRuleAssociationStatusDeleting,
		ResolverRuleAssociationStatusFailed,
		ResolverRuleAssociationStatusOverridden,
	}
}

const (
	// ResolverRuleStatusComplete is a ResolverRuleStatus enum value
	ResolverRuleStatusComplete = "COMPLETE"

	// ResolverRuleStatusDeleting is a ResolverRuleStatus enum value
	ResolverRuleStatusDeleting = "DELETING"

	// ResolverRuleStatusUpdating is a ResolverRuleStatus enum value
	ResolverRuleStatusUpdating = "UPDATING"

	// ResolverRuleStatusFailed is a ResolverRuleStatus enum value
	ResolverRuleStatusFailed = "FAILED"
)

// ResolverRuleStatus_Values returns all elements of the ResolverRuleStatus enum
func ResolverRuleStatus_Values() []string {
	return []string{
		ResolverRuleStatusComplete,
		ResolverRuleStatusDeleting,
		ResolverRuleStatusUpdating,
		ResolverRuleStatusFailed,
	}
}

const (
	// RuleTypeOptionForward is a RuleTypeOption enum value
	RuleTypeOptionForward = "FORWARD"

	// RuleTypeOptionSystem is a RuleTypeOption enum value
	RuleTypeOptionSystem = "SYSTEM"

	// RuleTypeOptionRecursive is a RuleTypeOption enum value
	RuleTypeOptionRecursive = "RECURSIVE"
)

// RuleTypeOption_Values returns all elements of the RuleTypeOption enum
func RuleTypeOption_Values() []string {
	return []string{
		RuleTypeOptionForward,
		RuleTypeOptionSystem,
		RuleTypeOptionRecursive,
	}
}

const (
	// ShareStatusNotShared is a ShareStatus enum value
	ShareStatusNotShared = "NOT_SHARED"

	// ShareStatusSharedWithMe is a ShareStatus enum value
	ShareStatusSharedWithMe = "SHARED_WITH_ME"

	// ShareStatusSharedByMe is a ShareStatus enum value
	ShareStatusSharedByMe = "SHARED_BY_ME"
)

// ShareStatus_Values returns all elements of the ShareStatus enum
func ShareStatus_Values() []string {
	return []string{
		ShareStatusNotShared,
		ShareStatusSharedWithMe,
		ShareStatusSharedByMe,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}
