// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApi = "CreateApi"

// CreateApiRequest generates a "aws/request.Request" representing the
// client's request for the CreateApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApi for more information on using the CreateApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApiRequest method.
//    req, resp := client.CreateApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateApi
func (c *ApiGatewayV2) CreateApiRequest(input *CreateApiInput) (req *request.Request, output *CreateApiOutput) {
	op := &request.Operation{
		Name:       opCreateApi,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis",
	}

	if input == nil {
		input = &CreateApiInput{}
	}

	output = &CreateApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApi API operation for AmazonApiGatewayV2.
//
// Creates an Api resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateApi for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateApi
func (c *ApiGatewayV2) CreateApi(input *CreateApiInput) (*CreateApiOutput, error) {
	req, out := c.CreateApiRequest(input)
	return out, req.Send()
}

// CreateApiWithContext is the same as CreateApi with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateApiWithContext(ctx aws.Context, input *CreateApiInput, opts ...request.Option) (*CreateApiOutput, error) {
	req, out := c.CreateApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApiMapping = "CreateApiMapping"

// CreateApiMappingRequest generates a "aws/request.Request" representing the
// client's request for the CreateApiMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApiMapping for more information on using the CreateApiMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApiMappingRequest method.
//    req, resp := client.CreateApiMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateApiMapping
func (c *ApiGatewayV2) CreateApiMappingRequest(input *CreateApiMappingInput) (req *request.Request, output *CreateApiMappingOutput) {
	op := &request.Operation{
		Name:       opCreateApiMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domainnames/{domainName}/apimappings",
	}

	if input == nil {
		input = &CreateApiMappingInput{}
	}

	output = &CreateApiMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApiMapping API operation for AmazonApiGatewayV2.
//
// Creates an API mapping.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateApiMapping for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateApiMapping
func (c *ApiGatewayV2) CreateApiMapping(input *CreateApiMappingInput) (*CreateApiMappingOutput, error) {
	req, out := c.CreateApiMappingRequest(input)
	return out, req.Send()
}

// CreateApiMappingWithContext is the same as CreateApiMapping with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApiMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateApiMappingWithContext(ctx aws.Context, input *CreateApiMappingInput, opts ...request.Option) (*CreateApiMappingOutput, error) {
	req, out := c.CreateApiMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAuthorizer = "CreateAuthorizer"

// CreateAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the CreateAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAuthorizer for more information on using the CreateAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAuthorizerRequest method.
//    req, resp := client.CreateAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateAuthorizer
func (c *ApiGatewayV2) CreateAuthorizerRequest(input *CreateAuthorizerInput) (req *request.Request, output *CreateAuthorizerOutput) {
	op := &request.Operation{
		Name:       opCreateAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/authorizers",
	}

	if input == nil {
		input = &CreateAuthorizerInput{}
	}

	output = &CreateAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAuthorizer API operation for AmazonApiGatewayV2.
//
// Creates an Authorizer for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateAuthorizer for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateAuthorizer
func (c *ApiGatewayV2) CreateAuthorizer(input *CreateAuthorizerInput) (*CreateAuthorizerOutput, error) {
	req, out := c.CreateAuthorizerRequest(input)
	return out, req.Send()
}

// CreateAuthorizerWithContext is the same as CreateAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateAuthorizerWithContext(ctx aws.Context, input *CreateAuthorizerInput, opts ...request.Option) (*CreateAuthorizerOutput, error) {
	req, out := c.CreateAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentRequest method.
//    req, resp := client.CreateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateDeployment
func (c *ApiGatewayV2) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/deployments",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &CreateDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeployment API operation for AmazonApiGatewayV2.
//
// Creates a Deployment for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateDeployment
func (c *ApiGatewayV2) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateDeploymentWithContext(ctx aws.Context, input *CreateDeploymentInput, opts ...request.Option) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomainName = "CreateDomainName"

// CreateDomainNameRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomainName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomainName for more information on using the CreateDomainName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainNameRequest method.
//    req, resp := client.CreateDomainNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateDomainName
func (c *ApiGatewayV2) CreateDomainNameRequest(input *CreateDomainNameInput) (req *request.Request, output *CreateDomainNameOutput) {
	op := &request.Operation{
		Name:       opCreateDomainName,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domainnames",
	}

	if input == nil {
		input = &CreateDomainNameInput{}
	}

	output = &CreateDomainNameOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomainName API operation for AmazonApiGatewayV2.
//
// Creates a domain name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateDomainName for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateDomainName
func (c *ApiGatewayV2) CreateDomainName(input *CreateDomainNameInput) (*CreateDomainNameOutput, error) {
	req, out := c.CreateDomainNameRequest(input)
	return out, req.Send()
}

// CreateDomainNameWithContext is the same as CreateDomainName with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateDomainNameWithContext(ctx aws.Context, input *CreateDomainNameInput, opts ...request.Option) (*CreateDomainNameOutput, error) {
	req, out := c.CreateDomainNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIntegration = "CreateIntegration"

// CreateIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the CreateIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIntegration for more information on using the CreateIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIntegrationRequest method.
//    req, resp := client.CreateIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateIntegration
func (c *ApiGatewayV2) CreateIntegrationRequest(input *CreateIntegrationInput) (req *request.Request, output *CreateIntegrationOutput) {
	op := &request.Operation{
		Name:       opCreateIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/integrations",
	}

	if input == nil {
		input = &CreateIntegrationInput{}
	}

	output = &CreateIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIntegration API operation for AmazonApiGatewayV2.
//
// Creates an Integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateIntegration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateIntegration
func (c *ApiGatewayV2) CreateIntegration(input *CreateIntegrationInput) (*CreateIntegrationOutput, error) {
	req, out := c.CreateIntegrationRequest(input)
	return out, req.Send()
}

// CreateIntegrationWithContext is the same as CreateIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateIntegrationWithContext(ctx aws.Context, input *CreateIntegrationInput, opts ...request.Option) (*CreateIntegrationOutput, error) {
	req, out := c.CreateIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIntegrationResponse = "CreateIntegrationResponse"

// CreateIntegrationResponseRequest generates a "aws/request.Request" representing the
// client's request for the CreateIntegrationResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIntegrationResponse for more information on using the CreateIntegrationResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIntegrationResponseRequest method.
//    req, resp := client.CreateIntegrationResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateIntegrationResponse
func (c *ApiGatewayV2) CreateIntegrationResponseRequest(input *CreateIntegrationResponseInput) (req *request.Request, output *CreateIntegrationResponseOutput) {
	op := &request.Operation{
		Name:       opCreateIntegrationResponse,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses",
	}

	if input == nil {
		input = &CreateIntegrationResponseInput{}
	}

	output = &CreateIntegrationResponseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIntegrationResponse API operation for AmazonApiGatewayV2.
//
// Creates an IntegrationResponses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateIntegrationResponse for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateIntegrationResponse
func (c *ApiGatewayV2) CreateIntegrationResponse(input *CreateIntegrationResponseInput) (*CreateIntegrationResponseOutput, error) {
	req, out := c.CreateIntegrationResponseRequest(input)
	return out, req.Send()
}

// CreateIntegrationResponseWithContext is the same as CreateIntegrationResponse with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIntegrationResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateIntegrationResponseWithContext(ctx aws.Context, input *CreateIntegrationResponseInput, opts ...request.Option) (*CreateIntegrationResponseOutput, error) {
	req, out := c.CreateIntegrationResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModel for more information on using the CreateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelRequest method.
//    req, resp := client.CreateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateModel
func (c *ApiGatewayV2) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *CreateModelOutput) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/models",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	output = &CreateModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModel API operation for AmazonApiGatewayV2.
//
// Creates a Model for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateModel for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateModel
func (c *ApiGatewayV2) CreateModel(input *CreateModelInput) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	return out, req.Send()
}

// CreateModelWithContext is the same as CreateModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateModelWithContext(ctx aws.Context, input *CreateModelInput, opts ...request.Option) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoute for more information on using the CreateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRouteRequest method.
//    req, resp := client.CreateRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateRoute
func (c *ApiGatewayV2) CreateRouteRequest(input *CreateRouteInput) (req *request.Request, output *CreateRouteOutput) {
	op := &request.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/routes",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	output = &CreateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoute API operation for AmazonApiGatewayV2.
//
// Creates a Route for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateRoute for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateRoute
func (c *ApiGatewayV2) CreateRoute(input *CreateRouteInput) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	return out, req.Send()
}

// CreateRouteWithContext is the same as CreateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateRouteWithContext(ctx aws.Context, input *CreateRouteInput, opts ...request.Option) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRouteResponse = "CreateRouteResponse"

// CreateRouteResponseRequest generates a "aws/request.Request" representing the
// client's request for the CreateRouteResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRouteResponse for more information on using the CreateRouteResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRouteResponseRequest method.
//    req, resp := client.CreateRouteResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateRouteResponse
func (c *ApiGatewayV2) CreateRouteResponseRequest(input *CreateRouteResponseInput) (req *request.Request, output *CreateRouteResponseOutput) {
	op := &request.Operation{
		Name:       opCreateRouteResponse,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}/routeresponses",
	}

	if input == nil {
		input = &CreateRouteResponseInput{}
	}

	output = &CreateRouteResponseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRouteResponse API operation for AmazonApiGatewayV2.
//
// Creates a RouteResponse for a Route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateRouteResponse for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateRouteResponse
func (c *ApiGatewayV2) CreateRouteResponse(input *CreateRouteResponseInput) (*CreateRouteResponseOutput, error) {
	req, out := c.CreateRouteResponseRequest(input)
	return out, req.Send()
}

// CreateRouteResponseWithContext is the same as CreateRouteResponse with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRouteResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateRouteResponseWithContext(ctx aws.Context, input *CreateRouteResponseInput, opts ...request.Option) (*CreateRouteResponseOutput, error) {
	req, out := c.CreateRouteResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStage = "CreateStage"

// CreateStageRequest generates a "aws/request.Request" representing the
// client's request for the CreateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStage for more information on using the CreateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStageRequest method.
//    req, resp := client.CreateStageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateStage
func (c *ApiGatewayV2) CreateStageRequest(input *CreateStageInput) (req *request.Request, output *CreateStageOutput) {
	op := &request.Operation{
		Name:       opCreateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/apis/{apiId}/stages",
	}

	if input == nil {
		input = &CreateStageInput{}
	}

	output = &CreateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStage API operation for AmazonApiGatewayV2.
//
// Creates a Stage for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateStage for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateStage
func (c *ApiGatewayV2) CreateStage(input *CreateStageInput) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	return out, req.Send()
}

// CreateStageWithContext is the same as CreateStage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateStageWithContext(ctx aws.Context, input *CreateStageInput, opts ...request.Option) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcLink = "CreateVpcLink"

// CreateVpcLinkRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcLink for more information on using the CreateVpcLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpcLinkRequest method.
//    req, resp := client.CreateVpcLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateVpcLink
func (c *ApiGatewayV2) CreateVpcLinkRequest(input *CreateVpcLinkInput) (req *request.Request, output *CreateVpcLinkOutput) {
	op := &request.Operation{
		Name:       opCreateVpcLink,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/vpclinks",
	}

	if input == nil {
		input = &CreateVpcLinkInput{}
	}

	output = &CreateVpcLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcLink API operation for AmazonApiGatewayV2.
//
// Creates a VPC link.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation CreateVpcLink for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateVpcLink
func (c *ApiGatewayV2) CreateVpcLink(input *CreateVpcLinkInput) (*CreateVpcLinkOutput, error) {
	req, out := c.CreateVpcLinkRequest(input)
	return out, req.Send()
}

// CreateVpcLinkWithContext is the same as CreateVpcLink with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) CreateVpcLinkWithContext(ctx aws.Context, input *CreateVpcLinkInput, opts ...request.Option) (*CreateVpcLinkOutput, error) {
	req, out := c.CreateVpcLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessLogSettings = "DeleteAccessLogSettings"

// DeleteAccessLogSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessLogSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessLogSettings for more information on using the DeleteAccessLogSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccessLogSettingsRequest method.
//    req, resp := client.DeleteAccessLogSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteAccessLogSettings
func (c *ApiGatewayV2) DeleteAccessLogSettingsRequest(input *DeleteAccessLogSettingsInput) (req *request.Request, output *DeleteAccessLogSettingsOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessLogSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/stages/{stageName}/accesslogsettings",
	}

	if input == nil {
		input = &DeleteAccessLogSettingsInput{}
	}

	output = &DeleteAccessLogSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccessLogSettings API operation for AmazonApiGatewayV2.
//
// Deletes the AccessLogSettings for a Stage. To disable access logging for
// a Stage, delete its AccessLogSettings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteAccessLogSettings for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteAccessLogSettings
func (c *ApiGatewayV2) DeleteAccessLogSettings(input *DeleteAccessLogSettingsInput) (*DeleteAccessLogSettingsOutput, error) {
	req, out := c.DeleteAccessLogSettingsRequest(input)
	return out, req.Send()
}

// DeleteAccessLogSettingsWithContext is the same as DeleteAccessLogSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessLogSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteAccessLogSettingsWithContext(ctx aws.Context, input *DeleteAccessLogSettingsInput, opts ...request.Option) (*DeleteAccessLogSettingsOutput, error) {
	req, out := c.DeleteAccessLogSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApi = "DeleteApi"

// DeleteApiRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApi for more information on using the DeleteApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApiRequest method.
//    req, resp := client.DeleteApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteApi
func (c *ApiGatewayV2) DeleteApiRequest(input *DeleteApiInput) (req *request.Request, output *DeleteApiOutput) {
	op := &request.Operation{
		Name:       opDeleteApi,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}",
	}

	if input == nil {
		input = &DeleteApiInput{}
	}

	output = &DeleteApiOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApi API operation for AmazonApiGatewayV2.
//
// Deletes an Api resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteApi for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteApi
func (c *ApiGatewayV2) DeleteApi(input *DeleteApiInput) (*DeleteApiOutput, error) {
	req, out := c.DeleteApiRequest(input)
	return out, req.Send()
}

// DeleteApiWithContext is the same as DeleteApi with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteApiWithContext(ctx aws.Context, input *DeleteApiInput, opts ...request.Option) (*DeleteApiOutput, error) {
	req, out := c.DeleteApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApiMapping = "DeleteApiMapping"

// DeleteApiMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApiMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApiMapping for more information on using the DeleteApiMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApiMappingRequest method.
//    req, resp := client.DeleteApiMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteApiMapping
func (c *ApiGatewayV2) DeleteApiMappingRequest(input *DeleteApiMappingInput) (req *request.Request, output *DeleteApiMappingOutput) {
	op := &request.Operation{
		Name:       opDeleteApiMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
	}

	if input == nil {
		input = &DeleteApiMappingInput{}
	}

	output = &DeleteApiMappingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApiMapping API operation for AmazonApiGatewayV2.
//
// Deletes an API mapping.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteApiMapping for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteApiMapping
func (c *ApiGatewayV2) DeleteApiMapping(input *DeleteApiMappingInput) (*DeleteApiMappingOutput, error) {
	req, out := c.DeleteApiMappingRequest(input)
	return out, req.Send()
}

// DeleteApiMappingWithContext is the same as DeleteApiMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApiMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteApiMappingWithContext(ctx aws.Context, input *DeleteApiMappingInput, opts ...request.Option) (*DeleteApiMappingOutput, error) {
	req, out := c.DeleteApiMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAuthorizer = "DeleteAuthorizer"

// DeleteAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAuthorizer for more information on using the DeleteAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAuthorizerRequest method.
//    req, resp := client.DeleteAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteAuthorizer
func (c *ApiGatewayV2) DeleteAuthorizerRequest(input *DeleteAuthorizerInput) (req *request.Request, output *DeleteAuthorizerOutput) {
	op := &request.Operation{
		Name:       opDeleteAuthorizer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/authorizers/{authorizerId}",
	}

	if input == nil {
		input = &DeleteAuthorizerInput{}
	}

	output = &DeleteAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAuthorizer API operation for AmazonApiGatewayV2.
//
// Deletes an Authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteAuthorizer for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteAuthorizer
func (c *ApiGatewayV2) DeleteAuthorizer(input *DeleteAuthorizerInput) (*DeleteAuthorizerOutput, error) {
	req, out := c.DeleteAuthorizerRequest(input)
	return out, req.Send()
}

// DeleteAuthorizerWithContext is the same as DeleteAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteAuthorizerWithContext(ctx aws.Context, input *DeleteAuthorizerInput, opts ...request.Option) (*DeleteAuthorizerOutput, error) {
	req, out := c.DeleteAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCorsConfiguration = "DeleteCorsConfiguration"

// DeleteCorsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCorsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCorsConfiguration for more information on using the DeleteCorsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCorsConfigurationRequest method.
//    req, resp := client.DeleteCorsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteCorsConfiguration
func (c *ApiGatewayV2) DeleteCorsConfigurationRequest(input *DeleteCorsConfigurationInput) (req *request.Request, output *DeleteCorsConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteCorsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/cors",
	}

	if input == nil {
		input = &DeleteCorsConfigurationInput{}
	}

	output = &DeleteCorsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCorsConfiguration API operation for AmazonApiGatewayV2.
//
// Deletes a CORS configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteCorsConfiguration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteCorsConfiguration
func (c *ApiGatewayV2) DeleteCorsConfiguration(input *DeleteCorsConfigurationInput) (*DeleteCorsConfigurationOutput, error) {
	req, out := c.DeleteCorsConfigurationRequest(input)
	return out, req.Send()
}

// DeleteCorsConfigurationWithContext is the same as DeleteCorsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCorsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteCorsConfigurationWithContext(ctx aws.Context, input *DeleteCorsConfigurationInput, opts ...request.Option) (*DeleteCorsConfigurationOutput, error) {
	req, out := c.DeleteCorsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeployment = "DeleteDeployment"

// DeleteDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeployment for more information on using the DeleteDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeploymentRequest method.
//    req, resp := client.DeleteDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteDeployment
func (c *ApiGatewayV2) DeleteDeploymentRequest(input *DeleteDeploymentInput) (req *request.Request, output *DeleteDeploymentOutput) {
	op := &request.Operation{
		Name:       opDeleteDeployment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/deployments/{deploymentId}",
	}

	if input == nil {
		input = &DeleteDeploymentInput{}
	}

	output = &DeleteDeploymentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeployment API operation for AmazonApiGatewayV2.
//
// Deletes a Deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteDeployment for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteDeployment
func (c *ApiGatewayV2) DeleteDeployment(input *DeleteDeploymentInput) (*DeleteDeploymentOutput, error) {
	req, out := c.DeleteDeploymentRequest(input)
	return out, req.Send()
}

// DeleteDeploymentWithContext is the same as DeleteDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteDeploymentWithContext(ctx aws.Context, input *DeleteDeploymentInput, opts ...request.Option) (*DeleteDeploymentOutput, error) {
	req, out := c.DeleteDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomainName = "DeleteDomainName"

// DeleteDomainNameRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomainName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomainName for more information on using the DeleteDomainName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainNameRequest method.
//    req, resp := client.DeleteDomainNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteDomainName
func (c *ApiGatewayV2) DeleteDomainNameRequest(input *DeleteDomainNameInput) (req *request.Request, output *DeleteDomainNameOutput) {
	op := &request.Operation{
		Name:       opDeleteDomainName,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domainnames/{domainName}",
	}

	if input == nil {
		input = &DeleteDomainNameInput{}
	}

	output = &DeleteDomainNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDomainName API operation for AmazonApiGatewayV2.
//
// Deletes a domain name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteDomainName for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteDomainName
func (c *ApiGatewayV2) DeleteDomainName(input *DeleteDomainNameInput) (*DeleteDomainNameOutput, error) {
	req, out := c.DeleteDomainNameRequest(input)
	return out, req.Send()
}

// DeleteDomainNameWithContext is the same as DeleteDomainName with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomainName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteDomainNameWithContext(ctx aws.Context, input *DeleteDomainNameInput, opts ...request.Option) (*DeleteDomainNameOutput, error) {
	req, out := c.DeleteDomainNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntegration = "DeleteIntegration"

// DeleteIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntegration for more information on using the DeleteIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIntegrationRequest method.
//    req, resp := client.DeleteIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteIntegration
func (c *ApiGatewayV2) DeleteIntegrationRequest(input *DeleteIntegrationInput) (req *request.Request, output *DeleteIntegrationOutput) {
	op := &request.Operation{
		Name:       opDeleteIntegration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}",
	}

	if input == nil {
		input = &DeleteIntegrationInput{}
	}

	output = &DeleteIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIntegration API operation for AmazonApiGatewayV2.
//
// Deletes an Integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteIntegration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteIntegration
func (c *ApiGatewayV2) DeleteIntegration(input *DeleteIntegrationInput) (*DeleteIntegrationOutput, error) {
	req, out := c.DeleteIntegrationRequest(input)
	return out, req.Send()
}

// DeleteIntegrationWithContext is the same as DeleteIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteIntegrationWithContext(ctx aws.Context, input *DeleteIntegrationInput, opts ...request.Option) (*DeleteIntegrationOutput, error) {
	req, out := c.DeleteIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntegrationResponse = "DeleteIntegrationResponse"

// DeleteIntegrationResponseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntegrationResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntegrationResponse for more information on using the DeleteIntegrationResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIntegrationResponseRequest method.
//    req, resp := client.DeleteIntegrationResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteIntegrationResponse
func (c *ApiGatewayV2) DeleteIntegrationResponseRequest(input *DeleteIntegrationResponseInput) (req *request.Request, output *DeleteIntegrationResponseOutput) {
	op := &request.Operation{
		Name:       opDeleteIntegrationResponse,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
	}

	if input == nil {
		input = &DeleteIntegrationResponseInput{}
	}

	output = &DeleteIntegrationResponseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIntegrationResponse API operation for AmazonApiGatewayV2.
//
// Deletes an IntegrationResponses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteIntegrationResponse for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteIntegrationResponse
func (c *ApiGatewayV2) DeleteIntegrationResponse(input *DeleteIntegrationResponseInput) (*DeleteIntegrationResponseOutput, error) {
	req, out := c.DeleteIntegrationResponseRequest(input)
	return out, req.Send()
}

// DeleteIntegrationResponseWithContext is the same as DeleteIntegrationResponse with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntegrationResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteIntegrationResponseWithContext(ctx aws.Context, input *DeleteIntegrationResponseInput, opts ...request.Option) (*DeleteIntegrationResponseOutput, error) {
	req, out := c.DeleteIntegrationResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModel = "DeleteModel"

// DeleteModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModel for more information on using the DeleteModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelRequest method.
//    req, resp := client.DeleteModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteModel
func (c *ApiGatewayV2) DeleteModelRequest(input *DeleteModelInput) (req *request.Request, output *DeleteModelOutput) {
	op := &request.Operation{
		Name:       opDeleteModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/models/{modelId}",
	}

	if input == nil {
		input = &DeleteModelInput{}
	}

	output = &DeleteModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModel API operation for AmazonApiGatewayV2.
//
// Deletes a Model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteModel for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteModel
func (c *ApiGatewayV2) DeleteModel(input *DeleteModelInput) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	return out, req.Send()
}

// DeleteModelWithContext is the same as DeleteModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteModelWithContext(ctx aws.Context, input *DeleteModelInput, opts ...request.Option) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoute = "DeleteRoute"

// DeleteRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoute for more information on using the DeleteRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRouteRequest method.
//    req, resp := client.DeleteRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteRoute
func (c *ApiGatewayV2) DeleteRouteRequest(input *DeleteRouteInput) (req *request.Request, output *DeleteRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteRoute,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}",
	}

	if input == nil {
		input = &DeleteRouteInput{}
	}

	output = &DeleteRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoute API operation for AmazonApiGatewayV2.
//
// Deletes a Route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteRoute for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteRoute
func (c *ApiGatewayV2) DeleteRoute(input *DeleteRouteInput) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	return out, req.Send()
}

// DeleteRouteWithContext is the same as DeleteRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteRouteWithContext(ctx aws.Context, input *DeleteRouteInput, opts ...request.Option) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRouteRequestParameter = "DeleteRouteRequestParameter"

// DeleteRouteRequestParameterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRouteRequestParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRouteRequestParameter for more information on using the DeleteRouteRequestParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRouteRequestParameterRequest method.
//    req, resp := client.DeleteRouteRequestParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteRouteRequestParameter
func (c *ApiGatewayV2) DeleteRouteRequestParameterRequest(input *DeleteRouteRequestParameterInput) (req *request.Request, output *DeleteRouteRequestParameterOutput) {
	op := &request.Operation{
		Name:       opDeleteRouteRequestParameter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}/requestparameters/{requestParameterKey}",
	}

	if input == nil {
		input = &DeleteRouteRequestParameterInput{}
	}

	output = &DeleteRouteRequestParameterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRouteRequestParameter API operation for AmazonApiGatewayV2.
//
// Deletes a route request parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteRouteRequestParameter for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteRouteRequestParameter
func (c *ApiGatewayV2) DeleteRouteRequestParameter(input *DeleteRouteRequestParameterInput) (*DeleteRouteRequestParameterOutput, error) {
	req, out := c.DeleteRouteRequestParameterRequest(input)
	return out, req.Send()
}

// DeleteRouteRequestParameterWithContext is the same as DeleteRouteRequestParameter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRouteRequestParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteRouteRequestParameterWithContext(ctx aws.Context, input *DeleteRouteRequestParameterInput, opts ...request.Option) (*DeleteRouteRequestParameterOutput, error) {
	req, out := c.DeleteRouteRequestParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRouteResponse = "DeleteRouteResponse"

// DeleteRouteResponseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRouteResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRouteResponse for more information on using the DeleteRouteResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRouteResponseRequest method.
//    req, resp := client.DeleteRouteResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteRouteResponse
func (c *ApiGatewayV2) DeleteRouteResponseRequest(input *DeleteRouteResponseInput) (req *request.Request, output *DeleteRouteResponseOutput) {
	op := &request.Operation{
		Name:       opDeleteRouteResponse,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}/routeresponses/{routeResponseId}",
	}

	if input == nil {
		input = &DeleteRouteResponseInput{}
	}

	output = &DeleteRouteResponseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRouteResponse API operation for AmazonApiGatewayV2.
//
// Deletes a RouteResponse.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteRouteResponse for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteRouteResponse
func (c *ApiGatewayV2) DeleteRouteResponse(input *DeleteRouteResponseInput) (*DeleteRouteResponseOutput, error) {
	req, out := c.DeleteRouteResponseRequest(input)
	return out, req.Send()
}

// DeleteRouteResponseWithContext is the same as DeleteRouteResponse with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRouteResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteRouteResponseWithContext(ctx aws.Context, input *DeleteRouteResponseInput, opts ...request.Option) (*DeleteRouteResponseOutput, error) {
	req, out := c.DeleteRouteResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRouteSettings = "DeleteRouteSettings"

// DeleteRouteSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRouteSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRouteSettings for more information on using the DeleteRouteSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRouteSettingsRequest method.
//    req, resp := client.DeleteRouteSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteRouteSettings
func (c *ApiGatewayV2) DeleteRouteSettingsRequest(input *DeleteRouteSettingsInput) (req *request.Request, output *DeleteRouteSettingsOutput) {
	op := &request.Operation{
		Name:       opDeleteRouteSettings,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/stages/{stageName}/routesettings/{routeKey}",
	}

	if input == nil {
		input = &DeleteRouteSettingsInput{}
	}

	output = &DeleteRouteSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRouteSettings API operation for AmazonApiGatewayV2.
//
// Deletes the RouteSettings for a stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteRouteSettings for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteRouteSettings
func (c *ApiGatewayV2) DeleteRouteSettings(input *DeleteRouteSettingsInput) (*DeleteRouteSettingsOutput, error) {
	req, out := c.DeleteRouteSettingsRequest(input)
	return out, req.Send()
}

// DeleteRouteSettingsWithContext is the same as DeleteRouteSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRouteSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteRouteSettingsWithContext(ctx aws.Context, input *DeleteRouteSettingsInput, opts ...request.Option) (*DeleteRouteSettingsOutput, error) {
	req, out := c.DeleteRouteSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStage = "DeleteStage"

// DeleteStageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStage for more information on using the DeleteStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStageRequest method.
//    req, resp := client.DeleteStageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteStage
func (c *ApiGatewayV2) DeleteStageRequest(input *DeleteStageInput) (req *request.Request, output *DeleteStageOutput) {
	op := &request.Operation{
		Name:       opDeleteStage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/stages/{stageName}",
	}

	if input == nil {
		input = &DeleteStageInput{}
	}

	output = &DeleteStageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStage API operation for AmazonApiGatewayV2.
//
// Deletes a Stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteStage for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteStage
func (c *ApiGatewayV2) DeleteStage(input *DeleteStageInput) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	return out, req.Send()
}

// DeleteStageWithContext is the same as DeleteStage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteStageWithContext(ctx aws.Context, input *DeleteStageInput, opts ...request.Option) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcLink = "DeleteVpcLink"

// DeleteVpcLinkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcLink for more information on using the DeleteVpcLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpcLinkRequest method.
//    req, resp := client.DeleteVpcLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteVpcLink
func (c *ApiGatewayV2) DeleteVpcLinkRequest(input *DeleteVpcLinkInput) (req *request.Request, output *DeleteVpcLinkOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcLink,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/vpclinks/{vpcLinkId}",
	}

	if input == nil {
		input = &DeleteVpcLinkInput{}
	}

	output = &DeleteVpcLinkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpcLink API operation for AmazonApiGatewayV2.
//
// Deletes a VPC link.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation DeleteVpcLink for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteVpcLink
func (c *ApiGatewayV2) DeleteVpcLink(input *DeleteVpcLinkInput) (*DeleteVpcLinkOutput, error) {
	req, out := c.DeleteVpcLinkRequest(input)
	return out, req.Send()
}

// DeleteVpcLinkWithContext is the same as DeleteVpcLink with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) DeleteVpcLinkWithContext(ctx aws.Context, input *DeleteVpcLinkInput, opts ...request.Option) (*DeleteVpcLinkOutput, error) {
	req, out := c.DeleteVpcLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportApi = "ExportApi"

// ExportApiRequest generates a "aws/request.Request" representing the
// client's request for the ExportApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportApi for more information on using the ExportApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportApiRequest method.
//    req, resp := client.ExportApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ExportApi
func (c *ApiGatewayV2) ExportApiRequest(input *ExportApiInput) (req *request.Request, output *ExportApiOutput) {
	op := &request.Operation{
		Name:       opExportApi,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/exports/{specification}",
	}

	if input == nil {
		input = &ExportApiInput{}
	}

	output = &ExportApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportApi API operation for AmazonApiGatewayV2.
//
// Exports a definition of an API in a particular output format and specification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation ExportApi for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ExportApi
func (c *ApiGatewayV2) ExportApi(input *ExportApiInput) (*ExportApiOutput, error) {
	req, out := c.ExportApiRequest(input)
	return out, req.Send()
}

// ExportApiWithContext is the same as ExportApi with the addition of
// the ability to pass a context and additional request options.
//
// See ExportApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) ExportApiWithContext(ctx aws.Context, input *ExportApiInput, opts ...request.Option) (*ExportApiOutput, error) {
	req, out := c.ExportApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApi = "GetApi"

// GetApiRequest generates a "aws/request.Request" representing the
// client's request for the GetApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApi for more information on using the GetApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApiRequest method.
//    req, resp := client.GetApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetApi
func (c *ApiGatewayV2) GetApiRequest(input *GetApiInput) (req *request.Request, output *GetApiOutput) {
	op := &request.Operation{
		Name:       opGetApi,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}",
	}

	if input == nil {
		input = &GetApiInput{}
	}

	output = &GetApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApi API operation for AmazonApiGatewayV2.
//
// Gets an Api resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetApi for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetApi
func (c *ApiGatewayV2) GetApi(input *GetApiInput) (*GetApiOutput, error) {
	req, out := c.GetApiRequest(input)
	return out, req.Send()
}

// GetApiWithContext is the same as GetApi with the addition of
// the ability to pass a context and additional request options.
//
// See GetApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetApiWithContext(ctx aws.Context, input *GetApiInput, opts ...request.Option) (*GetApiOutput, error) {
	req, out := c.GetApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApiMapping = "GetApiMapping"

// GetApiMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetApiMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApiMapping for more information on using the GetApiMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApiMappingRequest method.
//    req, resp := client.GetApiMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetApiMapping
func (c *ApiGatewayV2) GetApiMappingRequest(input *GetApiMappingInput) (req *request.Request, output *GetApiMappingOutput) {
	op := &request.Operation{
		Name:       opGetApiMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
	}

	if input == nil {
		input = &GetApiMappingInput{}
	}

	output = &GetApiMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApiMapping API operation for AmazonApiGatewayV2.
//
// Gets an API mapping.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetApiMapping for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetApiMapping
func (c *ApiGatewayV2) GetApiMapping(input *GetApiMappingInput) (*GetApiMappingOutput, error) {
	req, out := c.GetApiMappingRequest(input)
	return out, req.Send()
}

// GetApiMappingWithContext is the same as GetApiMapping with the addition of
// the ability to pass a context and additional request options.
//
// See GetApiMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetApiMappingWithContext(ctx aws.Context, input *GetApiMappingInput, opts ...request.Option) (*GetApiMappingOutput, error) {
	req, out := c.GetApiMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApiMappings = "GetApiMappings"

// GetApiMappingsRequest generates a "aws/request.Request" representing the
// client's request for the GetApiMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApiMappings for more information on using the GetApiMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApiMappingsRequest method.
//    req, resp := client.GetApiMappingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetApiMappings
func (c *ApiGatewayV2) GetApiMappingsRequest(input *GetApiMappingsInput) (req *request.Request, output *GetApiMappingsOutput) {
	op := &request.Operation{
		Name:       opGetApiMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domainnames/{domainName}/apimappings",
	}

	if input == nil {
		input = &GetApiMappingsInput{}
	}

	output = &GetApiMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApiMappings API operation for AmazonApiGatewayV2.
//
// Gets API mappings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetApiMappings for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetApiMappings
func (c *ApiGatewayV2) GetApiMappings(input *GetApiMappingsInput) (*GetApiMappingsOutput, error) {
	req, out := c.GetApiMappingsRequest(input)
	return out, req.Send()
}

// GetApiMappingsWithContext is the same as GetApiMappings with the addition of
// the ability to pass a context and additional request options.
//
// See GetApiMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetApiMappingsWithContext(ctx aws.Context, input *GetApiMappingsInput, opts ...request.Option) (*GetApiMappingsOutput, error) {
	req, out := c.GetApiMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApis = "GetApis"

// GetApisRequest generates a "aws/request.Request" representing the
// client's request for the GetApis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApis for more information on using the GetApis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApisRequest method.
//    req, resp := client.GetApisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetApis
func (c *ApiGatewayV2) GetApisRequest(input *GetApisInput) (req *request.Request, output *GetApisOutput) {
	op := &request.Operation{
		Name:       opGetApis,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis",
	}

	if input == nil {
		input = &GetApisInput{}
	}

	output = &GetApisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApis API operation for AmazonApiGatewayV2.
//
// Gets a collection of Api resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetApis for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetApis
func (c *ApiGatewayV2) GetApis(input *GetApisInput) (*GetApisOutput, error) {
	req, out := c.GetApisRequest(input)
	return out, req.Send()
}

// GetApisWithContext is the same as GetApis with the addition of
// the ability to pass a context and additional request options.
//
// See GetApis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetApisWithContext(ctx aws.Context, input *GetApisInput, opts ...request.Option) (*GetApisOutput, error) {
	req, out := c.GetApisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAuthorizer = "GetAuthorizer"

// GetAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the GetAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAuthorizer for more information on using the GetAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAuthorizerRequest method.
//    req, resp := client.GetAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetAuthorizer
func (c *ApiGatewayV2) GetAuthorizerRequest(input *GetAuthorizerInput) (req *request.Request, output *GetAuthorizerOutput) {
	op := &request.Operation{
		Name:       opGetAuthorizer,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/authorizers/{authorizerId}",
	}

	if input == nil {
		input = &GetAuthorizerInput{}
	}

	output = &GetAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAuthorizer API operation for AmazonApiGatewayV2.
//
// Gets an Authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetAuthorizer for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetAuthorizer
func (c *ApiGatewayV2) GetAuthorizer(input *GetAuthorizerInput) (*GetAuthorizerOutput, error) {
	req, out := c.GetAuthorizerRequest(input)
	return out, req.Send()
}

// GetAuthorizerWithContext is the same as GetAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See GetAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetAuthorizerWithContext(ctx aws.Context, input *GetAuthorizerInput, opts ...request.Option) (*GetAuthorizerOutput, error) {
	req, out := c.GetAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAuthorizers = "GetAuthorizers"

// GetAuthorizersRequest generates a "aws/request.Request" representing the
// client's request for the GetAuthorizers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAuthorizers for more information on using the GetAuthorizers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAuthorizersRequest method.
//    req, resp := client.GetAuthorizersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetAuthorizers
func (c *ApiGatewayV2) GetAuthorizersRequest(input *GetAuthorizersInput) (req *request.Request, output *GetAuthorizersOutput) {
	op := &request.Operation{
		Name:       opGetAuthorizers,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/authorizers",
	}

	if input == nil {
		input = &GetAuthorizersInput{}
	}

	output = &GetAuthorizersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAuthorizers API operation for AmazonApiGatewayV2.
//
// Gets the Authorizers for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetAuthorizers for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetAuthorizers
func (c *ApiGatewayV2) GetAuthorizers(input *GetAuthorizersInput) (*GetAuthorizersOutput, error) {
	req, out := c.GetAuthorizersRequest(input)
	return out, req.Send()
}

// GetAuthorizersWithContext is the same as GetAuthorizers with the addition of
// the ability to pass a context and additional request options.
//
// See GetAuthorizers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetAuthorizersWithContext(ctx aws.Context, input *GetAuthorizersInput, opts ...request.Option) (*GetAuthorizersOutput, error) {
	req, out := c.GetAuthorizersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployment for more information on using the GetDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentRequest method.
//    req, resp := client.GetDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetDeployment
func (c *ApiGatewayV2) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/deployments/{deploymentId}",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	output = &GetDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployment API operation for AmazonApiGatewayV2.
//
// Gets a Deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetDeployment for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetDeployment
func (c *ApiGatewayV2) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	return out, req.Send()
}

// GetDeploymentWithContext is the same as GetDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetDeploymentWithContext(ctx aws.Context, input *GetDeploymentInput, opts ...request.Option) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployments = "GetDeployments"

// GetDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployments for more information on using the GetDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentsRequest method.
//    req, resp := client.GetDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetDeployments
func (c *ApiGatewayV2) GetDeploymentsRequest(input *GetDeploymentsInput) (req *request.Request, output *GetDeploymentsOutput) {
	op := &request.Operation{
		Name:       opGetDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/deployments",
	}

	if input == nil {
		input = &GetDeploymentsInput{}
	}

	output = &GetDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployments API operation for AmazonApiGatewayV2.
//
// Gets the Deployments for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetDeployments for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetDeployments
func (c *ApiGatewayV2) GetDeployments(input *GetDeploymentsInput) (*GetDeploymentsOutput, error) {
	req, out := c.GetDeploymentsRequest(input)
	return out, req.Send()
}

// GetDeploymentsWithContext is the same as GetDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetDeploymentsWithContext(ctx aws.Context, input *GetDeploymentsInput, opts ...request.Option) (*GetDeploymentsOutput, error) {
	req, out := c.GetDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainName = "GetDomainName"

// GetDomainNameRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainName for more information on using the GetDomainName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainNameRequest method.
//    req, resp := client.GetDomainNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetDomainName
func (c *ApiGatewayV2) GetDomainNameRequest(input *GetDomainNameInput) (req *request.Request, output *GetDomainNameOutput) {
	op := &request.Operation{
		Name:       opGetDomainName,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domainnames/{domainName}",
	}

	if input == nil {
		input = &GetDomainNameInput{}
	}

	output = &GetDomainNameOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainName API operation for AmazonApiGatewayV2.
//
// Gets a domain name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetDomainName for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetDomainName
func (c *ApiGatewayV2) GetDomainName(input *GetDomainNameInput) (*GetDomainNameOutput, error) {
	req, out := c.GetDomainNameRequest(input)
	return out, req.Send()
}

// GetDomainNameWithContext is the same as GetDomainName with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetDomainNameWithContext(ctx aws.Context, input *GetDomainNameInput, opts ...request.Option) (*GetDomainNameOutput, error) {
	req, out := c.GetDomainNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainNames = "GetDomainNames"

// GetDomainNamesRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainNames for more information on using the GetDomainNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainNamesRequest method.
//    req, resp := client.GetDomainNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetDomainNames
func (c *ApiGatewayV2) GetDomainNamesRequest(input *GetDomainNamesInput) (req *request.Request, output *GetDomainNamesOutput) {
	op := &request.Operation{
		Name:       opGetDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domainnames",
	}

	if input == nil {
		input = &GetDomainNamesInput{}
	}

	output = &GetDomainNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainNames API operation for AmazonApiGatewayV2.
//
// Gets the domain names for an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetDomainNames for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetDomainNames
func (c *ApiGatewayV2) GetDomainNames(input *GetDomainNamesInput) (*GetDomainNamesOutput, error) {
	req, out := c.GetDomainNamesRequest(input)
	return out, req.Send()
}

// GetDomainNamesWithContext is the same as GetDomainNames with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetDomainNamesWithContext(ctx aws.Context, input *GetDomainNamesInput, opts ...request.Option) (*GetDomainNamesOutput, error) {
	req, out := c.GetDomainNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntegration = "GetIntegration"

// GetIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the GetIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntegration for more information on using the GetIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntegrationRequest method.
//    req, resp := client.GetIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegration
func (c *ApiGatewayV2) GetIntegrationRequest(input *GetIntegrationInput) (req *request.Request, output *GetIntegrationOutput) {
	op := &request.Operation{
		Name:       opGetIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}",
	}

	if input == nil {
		input = &GetIntegrationInput{}
	}

	output = &GetIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntegration API operation for AmazonApiGatewayV2.
//
// Gets an Integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetIntegration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegration
func (c *ApiGatewayV2) GetIntegration(input *GetIntegrationInput) (*GetIntegrationOutput, error) {
	req, out := c.GetIntegrationRequest(input)
	return out, req.Send()
}

// GetIntegrationWithContext is the same as GetIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetIntegrationWithContext(ctx aws.Context, input *GetIntegrationInput, opts ...request.Option) (*GetIntegrationOutput, error) {
	req, out := c.GetIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntegrationResponse = "GetIntegrationResponse"

// GetIntegrationResponseRequest generates a "aws/request.Request" representing the
// client's request for the GetIntegrationResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntegrationResponse for more information on using the GetIntegrationResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntegrationResponseRequest method.
//    req, resp := client.GetIntegrationResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegrationResponse
func (c *ApiGatewayV2) GetIntegrationResponseRequest(input *GetIntegrationResponseInput) (req *request.Request, output *GetIntegrationResponseOutput) {
	op := &request.Operation{
		Name:       opGetIntegrationResponse,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
	}

	if input == nil {
		input = &GetIntegrationResponseInput{}
	}

	output = &GetIntegrationResponseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntegrationResponse API operation for AmazonApiGatewayV2.
//
// Gets an IntegrationResponses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetIntegrationResponse for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegrationResponse
func (c *ApiGatewayV2) GetIntegrationResponse(input *GetIntegrationResponseInput) (*GetIntegrationResponseOutput, error) {
	req, out := c.GetIntegrationResponseRequest(input)
	return out, req.Send()
}

// GetIntegrationResponseWithContext is the same as GetIntegrationResponse with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntegrationResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetIntegrationResponseWithContext(ctx aws.Context, input *GetIntegrationResponseInput, opts ...request.Option) (*GetIntegrationResponseOutput, error) {
	req, out := c.GetIntegrationResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntegrationResponses = "GetIntegrationResponses"

// GetIntegrationResponsesRequest generates a "aws/request.Request" representing the
// client's request for the GetIntegrationResponses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntegrationResponses for more information on using the GetIntegrationResponses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntegrationResponsesRequest method.
//    req, resp := client.GetIntegrationResponsesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegrationResponses
func (c *ApiGatewayV2) GetIntegrationResponsesRequest(input *GetIntegrationResponsesInput) (req *request.Request, output *GetIntegrationResponsesOutput) {
	op := &request.Operation{
		Name:       opGetIntegrationResponses,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses",
	}

	if input == nil {
		input = &GetIntegrationResponsesInput{}
	}

	output = &GetIntegrationResponsesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntegrationResponses API operation for AmazonApiGatewayV2.
//
// Gets the IntegrationResponses for an Integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetIntegrationResponses for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegrationResponses
func (c *ApiGatewayV2) GetIntegrationResponses(input *GetIntegrationResponsesInput) (*GetIntegrationResponsesOutput, error) {
	req, out := c.GetIntegrationResponsesRequest(input)
	return out, req.Send()
}

// GetIntegrationResponsesWithContext is the same as GetIntegrationResponses with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntegrationResponses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetIntegrationResponsesWithContext(ctx aws.Context, input *GetIntegrationResponsesInput, opts ...request.Option) (*GetIntegrationResponsesOutput, error) {
	req, out := c.GetIntegrationResponsesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntegrations = "GetIntegrations"

// GetIntegrationsRequest generates a "aws/request.Request" representing the
// client's request for the GetIntegrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntegrations for more information on using the GetIntegrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntegrationsRequest method.
//    req, resp := client.GetIntegrationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegrations
func (c *ApiGatewayV2) GetIntegrationsRequest(input *GetIntegrationsInput) (req *request.Request, output *GetIntegrationsOutput) {
	op := &request.Operation{
		Name:       opGetIntegrations,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/integrations",
	}

	if input == nil {
		input = &GetIntegrationsInput{}
	}

	output = &GetIntegrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntegrations API operation for AmazonApiGatewayV2.
//
// Gets the Integrations for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetIntegrations for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegrations
func (c *ApiGatewayV2) GetIntegrations(input *GetIntegrationsInput) (*GetIntegrationsOutput, error) {
	req, out := c.GetIntegrationsRequest(input)
	return out, req.Send()
}

// GetIntegrationsWithContext is the same as GetIntegrations with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntegrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetIntegrationsWithContext(ctx aws.Context, input *GetIntegrationsInput, opts ...request.Option) (*GetIntegrationsOutput, error) {
	req, out := c.GetIntegrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModel = "GetModel"

// GetModelRequest generates a "aws/request.Request" representing the
// client's request for the GetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModel for more information on using the GetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelRequest method.
//    req, resp := client.GetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModel
func (c *ApiGatewayV2) GetModelRequest(input *GetModelInput) (req *request.Request, output *GetModelOutput) {
	op := &request.Operation{
		Name:       opGetModel,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/models/{modelId}",
	}

	if input == nil {
		input = &GetModelInput{}
	}

	output = &GetModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModel API operation for AmazonApiGatewayV2.
//
// Gets a Model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetModel for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModel
func (c *ApiGatewayV2) GetModel(input *GetModelInput) (*GetModelOutput, error) {
	req, out := c.GetModelRequest(input)
	return out, req.Send()
}

// GetModelWithContext is the same as GetModel with the addition of
// the ability to pass a context and additional request options.
//
// See GetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetModelWithContext(ctx aws.Context, input *GetModelInput, opts ...request.Option) (*GetModelOutput, error) {
	req, out := c.GetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModelTemplate = "GetModelTemplate"

// GetModelTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetModelTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelTemplate for more information on using the GetModelTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelTemplateRequest method.
//    req, resp := client.GetModelTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModelTemplate
func (c *ApiGatewayV2) GetModelTemplateRequest(input *GetModelTemplateInput) (req *request.Request, output *GetModelTemplateOutput) {
	op := &request.Operation{
		Name:       opGetModelTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/models/{modelId}/template",
	}

	if input == nil {
		input = &GetModelTemplateInput{}
	}

	output = &GetModelTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelTemplate API operation for AmazonApiGatewayV2.
//
// Gets a model template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetModelTemplate for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModelTemplate
func (c *ApiGatewayV2) GetModelTemplate(input *GetModelTemplateInput) (*GetModelTemplateOutput, error) {
	req, out := c.GetModelTemplateRequest(input)
	return out, req.Send()
}

// GetModelTemplateWithContext is the same as GetModelTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetModelTemplateWithContext(ctx aws.Context, input *GetModelTemplateInput, opts ...request.Option) (*GetModelTemplateOutput, error) {
	req, out := c.GetModelTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModels = "GetModels"

// GetModelsRequest generates a "aws/request.Request" representing the
// client's request for the GetModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModels for more information on using the GetModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelsRequest method.
//    req, resp := client.GetModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModels
func (c *ApiGatewayV2) GetModelsRequest(input *GetModelsInput) (req *request.Request, output *GetModelsOutput) {
	op := &request.Operation{
		Name:       opGetModels,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/models",
	}

	if input == nil {
		input = &GetModelsInput{}
	}

	output = &GetModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModels API operation for AmazonApiGatewayV2.
//
// Gets the Models for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetModels for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModels
func (c *ApiGatewayV2) GetModels(input *GetModelsInput) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	return out, req.Send()
}

// GetModelsWithContext is the same as GetModels with the addition of
// the ability to pass a context and additional request options.
//
// See GetModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetModelsWithContext(ctx aws.Context, input *GetModelsInput, opts ...request.Option) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoute = "GetRoute"

// GetRouteRequest generates a "aws/request.Request" representing the
// client's request for the GetRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoute for more information on using the GetRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRouteRequest method.
//    req, resp := client.GetRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetRoute
func (c *ApiGatewayV2) GetRouteRequest(input *GetRouteInput) (req *request.Request, output *GetRouteOutput) {
	op := &request.Operation{
		Name:       opGetRoute,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}",
	}

	if input == nil {
		input = &GetRouteInput{}
	}

	output = &GetRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoute API operation for AmazonApiGatewayV2.
//
// Gets a Route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetRoute for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetRoute
func (c *ApiGatewayV2) GetRoute(input *GetRouteInput) (*GetRouteOutput, error) {
	req, out := c.GetRouteRequest(input)
	return out, req.Send()
}

// GetRouteWithContext is the same as GetRoute with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetRouteWithContext(ctx aws.Context, input *GetRouteInput, opts ...request.Option) (*GetRouteOutput, error) {
	req, out := c.GetRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRouteResponse = "GetRouteResponse"

// GetRouteResponseRequest generates a "aws/request.Request" representing the
// client's request for the GetRouteResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRouteResponse for more information on using the GetRouteResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRouteResponseRequest method.
//    req, resp := client.GetRouteResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetRouteResponse
func (c *ApiGatewayV2) GetRouteResponseRequest(input *GetRouteResponseInput) (req *request.Request, output *GetRouteResponseOutput) {
	op := &request.Operation{
		Name:       opGetRouteResponse,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}/routeresponses/{routeResponseId}",
	}

	if input == nil {
		input = &GetRouteResponseInput{}
	}

	output = &GetRouteResponseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRouteResponse API operation for AmazonApiGatewayV2.
//
// Gets a RouteResponse.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetRouteResponse for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetRouteResponse
func (c *ApiGatewayV2) GetRouteResponse(input *GetRouteResponseInput) (*GetRouteResponseOutput, error) {
	req, out := c.GetRouteResponseRequest(input)
	return out, req.Send()
}

// GetRouteResponseWithContext is the same as GetRouteResponse with the addition of
// the ability to pass a context and additional request options.
//
// See GetRouteResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetRouteResponseWithContext(ctx aws.Context, input *GetRouteResponseInput, opts ...request.Option) (*GetRouteResponseOutput, error) {
	req, out := c.GetRouteResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRouteResponses = "GetRouteResponses"

// GetRouteResponsesRequest generates a "aws/request.Request" representing the
// client's request for the GetRouteResponses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRouteResponses for more information on using the GetRouteResponses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRouteResponsesRequest method.
//    req, resp := client.GetRouteResponsesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetRouteResponses
func (c *ApiGatewayV2) GetRouteResponsesRequest(input *GetRouteResponsesInput) (req *request.Request, output *GetRouteResponsesOutput) {
	op := &request.Operation{
		Name:       opGetRouteResponses,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}/routeresponses",
	}

	if input == nil {
		input = &GetRouteResponsesInput{}
	}

	output = &GetRouteResponsesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRouteResponses API operation for AmazonApiGatewayV2.
//
// Gets the RouteResponses for a Route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetRouteResponses for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetRouteResponses
func (c *ApiGatewayV2) GetRouteResponses(input *GetRouteResponsesInput) (*GetRouteResponsesOutput, error) {
	req, out := c.GetRouteResponsesRequest(input)
	return out, req.Send()
}

// GetRouteResponsesWithContext is the same as GetRouteResponses with the addition of
// the ability to pass a context and additional request options.
//
// See GetRouteResponses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetRouteResponsesWithContext(ctx aws.Context, input *GetRouteResponsesInput, opts ...request.Option) (*GetRouteResponsesOutput, error) {
	req, out := c.GetRouteResponsesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoutes = "GetRoutes"

// GetRoutesRequest generates a "aws/request.Request" representing the
// client's request for the GetRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoutes for more information on using the GetRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRoutesRequest method.
//    req, resp := client.GetRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetRoutes
func (c *ApiGatewayV2) GetRoutesRequest(input *GetRoutesInput) (req *request.Request, output *GetRoutesOutput) {
	op := &request.Operation{
		Name:       opGetRoutes,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/routes",
	}

	if input == nil {
		input = &GetRoutesInput{}
	}

	output = &GetRoutesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoutes API operation for AmazonApiGatewayV2.
//
// Gets the Routes for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetRoutes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetRoutes
func (c *ApiGatewayV2) GetRoutes(input *GetRoutesInput) (*GetRoutesOutput, error) {
	req, out := c.GetRoutesRequest(input)
	return out, req.Send()
}

// GetRoutesWithContext is the same as GetRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetRoutesWithContext(ctx aws.Context, input *GetRoutesInput, opts ...request.Option) (*GetRoutesOutput, error) {
	req, out := c.GetRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStage = "GetStage"

// GetStageRequest generates a "aws/request.Request" representing the
// client's request for the GetStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStage for more information on using the GetStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStageRequest method.
//    req, resp := client.GetStageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetStage
func (c *ApiGatewayV2) GetStageRequest(input *GetStageInput) (req *request.Request, output *GetStageOutput) {
	op := &request.Operation{
		Name:       opGetStage,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/stages/{stageName}",
	}

	if input == nil {
		input = &GetStageInput{}
	}

	output = &GetStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStage API operation for AmazonApiGatewayV2.
//
// Gets a Stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetStage for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetStage
func (c *ApiGatewayV2) GetStage(input *GetStageInput) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	return out, req.Send()
}

// GetStageWithContext is the same as GetStage with the addition of
// the ability to pass a context and additional request options.
//
// See GetStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetStageWithContext(ctx aws.Context, input *GetStageInput, opts ...request.Option) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStages = "GetStages"

// GetStagesRequest generates a "aws/request.Request" representing the
// client's request for the GetStages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStages for more information on using the GetStages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStagesRequest method.
//    req, resp := client.GetStagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetStages
func (c *ApiGatewayV2) GetStagesRequest(input *GetStagesInput) (req *request.Request, output *GetStagesOutput) {
	op := &request.Operation{
		Name:       opGetStages,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/stages",
	}

	if input == nil {
		input = &GetStagesInput{}
	}

	output = &GetStagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStages API operation for AmazonApiGatewayV2.
//
// Gets the Stages for an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetStages for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetStages
func (c *ApiGatewayV2) GetStages(input *GetStagesInput) (*GetStagesOutput, error) {
	req, out := c.GetStagesRequest(input)
	return out, req.Send()
}

// GetStagesWithContext is the same as GetStages with the addition of
// the ability to pass a context and additional request options.
//
// See GetStages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetStagesWithContext(ctx aws.Context, input *GetStagesInput, opts ...request.Option) (*GetStagesOutput, error) {
	req, out := c.GetStagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTags = "GetTags"

// GetTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTags for more information on using the GetTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagsRequest method.
//    req, resp := client.GetTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetTags
func (c *ApiGatewayV2) GetTagsRequest(input *GetTagsInput) (req *request.Request, output *GetTagsOutput) {
	op := &request.Operation{
		Name:       opGetTags,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/tags/{resource-arn}",
	}

	if input == nil {
		input = &GetTagsInput{}
	}

	output = &GetTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTags API operation for AmazonApiGatewayV2.
//
// Gets a collection of Tag resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetTags for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetTags
func (c *ApiGatewayV2) GetTags(input *GetTagsInput) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	return out, req.Send()
}

// GetTagsWithContext is the same as GetTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetTagsWithContext(ctx aws.Context, input *GetTagsInput, opts ...request.Option) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVpcLink = "GetVpcLink"

// GetVpcLinkRequest generates a "aws/request.Request" representing the
// client's request for the GetVpcLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVpcLink for more information on using the GetVpcLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVpcLinkRequest method.
//    req, resp := client.GetVpcLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetVpcLink
func (c *ApiGatewayV2) GetVpcLinkRequest(input *GetVpcLinkInput) (req *request.Request, output *GetVpcLinkOutput) {
	op := &request.Operation{
		Name:       opGetVpcLink,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/vpclinks/{vpcLinkId}",
	}

	if input == nil {
		input = &GetVpcLinkInput{}
	}

	output = &GetVpcLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVpcLink API operation for AmazonApiGatewayV2.
//
// Gets a VPC link.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetVpcLink for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetVpcLink
func (c *ApiGatewayV2) GetVpcLink(input *GetVpcLinkInput) (*GetVpcLinkOutput, error) {
	req, out := c.GetVpcLinkRequest(input)
	return out, req.Send()
}

// GetVpcLinkWithContext is the same as GetVpcLink with the addition of
// the ability to pass a context and additional request options.
//
// See GetVpcLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetVpcLinkWithContext(ctx aws.Context, input *GetVpcLinkInput, opts ...request.Option) (*GetVpcLinkOutput, error) {
	req, out := c.GetVpcLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVpcLinks = "GetVpcLinks"

// GetVpcLinksRequest generates a "aws/request.Request" representing the
// client's request for the GetVpcLinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVpcLinks for more information on using the GetVpcLinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVpcLinksRequest method.
//    req, resp := client.GetVpcLinksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetVpcLinks
func (c *ApiGatewayV2) GetVpcLinksRequest(input *GetVpcLinksInput) (req *request.Request, output *GetVpcLinksOutput) {
	op := &request.Operation{
		Name:       opGetVpcLinks,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/vpclinks",
	}

	if input == nil {
		input = &GetVpcLinksInput{}
	}

	output = &GetVpcLinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVpcLinks API operation for AmazonApiGatewayV2.
//
// Gets a collection of VPC links.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation GetVpcLinks for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetVpcLinks
func (c *ApiGatewayV2) GetVpcLinks(input *GetVpcLinksInput) (*GetVpcLinksOutput, error) {
	req, out := c.GetVpcLinksRequest(input)
	return out, req.Send()
}

// GetVpcLinksWithContext is the same as GetVpcLinks with the addition of
// the ability to pass a context and additional request options.
//
// See GetVpcLinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) GetVpcLinksWithContext(ctx aws.Context, input *GetVpcLinksInput, opts ...request.Option) (*GetVpcLinksOutput, error) {
	req, out := c.GetVpcLinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportApi = "ImportApi"

// ImportApiRequest generates a "aws/request.Request" representing the
// client's request for the ImportApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportApi for more information on using the ImportApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportApiRequest method.
//    req, resp := client.ImportApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ImportApi
func (c *ApiGatewayV2) ImportApiRequest(input *ImportApiInput) (req *request.Request, output *ImportApiOutput) {
	op := &request.Operation{
		Name:       opImportApi,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/apis",
	}

	if input == nil {
		input = &ImportApiInput{}
	}

	output = &ImportApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportApi API operation for AmazonApiGatewayV2.
//
// Imports an API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation ImportApi for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ImportApi
func (c *ApiGatewayV2) ImportApi(input *ImportApiInput) (*ImportApiOutput, error) {
	req, out := c.ImportApiRequest(input)
	return out, req.Send()
}

// ImportApiWithContext is the same as ImportApi with the addition of
// the ability to pass a context and additional request options.
//
// See ImportApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) ImportApiWithContext(ctx aws.Context, input *ImportApiInput, opts ...request.Option) (*ImportApiOutput, error) {
	req, out := c.ImportApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReimportApi = "ReimportApi"

// ReimportApiRequest generates a "aws/request.Request" representing the
// client's request for the ReimportApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReimportApi for more information on using the ReimportApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReimportApiRequest method.
//    req, resp := client.ReimportApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ReimportApi
func (c *ApiGatewayV2) ReimportApiRequest(input *ReimportApiInput) (req *request.Request, output *ReimportApiOutput) {
	op := &request.Operation{
		Name:       opReimportApi,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/apis/{apiId}",
	}

	if input == nil {
		input = &ReimportApiInput{}
	}

	output = &ReimportApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReimportApi API operation for AmazonApiGatewayV2.
//
// Puts an Api resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation ReimportApi for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ReimportApi
func (c *ApiGatewayV2) ReimportApi(input *ReimportApiInput) (*ReimportApiOutput, error) {
	req, out := c.ReimportApiRequest(input)
	return out, req.Send()
}

// ReimportApiWithContext is the same as ReimportApi with the addition of
// the ability to pass a context and additional request options.
//
// See ReimportApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) ReimportApiWithContext(ctx aws.Context, input *ReimportApiInput, opts ...request.Option) (*ReimportApiOutput, error) {
	req, out := c.ReimportApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/TagResource
func (c *ApiGatewayV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AmazonApiGatewayV2.
//
// Creates a new Tag resource to represent a tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/TagResource
func (c *ApiGatewayV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UntagResource
func (c *ApiGatewayV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AmazonApiGatewayV2.
//
// Deletes a Tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UntagResource
func (c *ApiGatewayV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApi = "UpdateApi"

// UpdateApiRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApi for more information on using the UpdateApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApiRequest method.
//    req, resp := client.UpdateApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateApi
func (c *ApiGatewayV2) UpdateApiRequest(input *UpdateApiInput) (req *request.Request, output *UpdateApiOutput) {
	op := &request.Operation{
		Name:       opUpdateApi,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}",
	}

	if input == nil {
		input = &UpdateApiInput{}
	}

	output = &UpdateApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApi API operation for AmazonApiGatewayV2.
//
// Updates an Api resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateApi for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateApi
func (c *ApiGatewayV2) UpdateApi(input *UpdateApiInput) (*UpdateApiOutput, error) {
	req, out := c.UpdateApiRequest(input)
	return out, req.Send()
}

// UpdateApiWithContext is the same as UpdateApi with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateApiWithContext(ctx aws.Context, input *UpdateApiInput, opts ...request.Option) (*UpdateApiOutput, error) {
	req, out := c.UpdateApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApiMapping = "UpdateApiMapping"

// UpdateApiMappingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApiMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApiMapping for more information on using the UpdateApiMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApiMappingRequest method.
//    req, resp := client.UpdateApiMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateApiMapping
func (c *ApiGatewayV2) UpdateApiMappingRequest(input *UpdateApiMappingInput) (req *request.Request, output *UpdateApiMappingOutput) {
	op := &request.Operation{
		Name:       opUpdateApiMapping,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
	}

	if input == nil {
		input = &UpdateApiMappingInput{}
	}

	output = &UpdateApiMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApiMapping API operation for AmazonApiGatewayV2.
//
// The API mapping.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateApiMapping for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateApiMapping
func (c *ApiGatewayV2) UpdateApiMapping(input *UpdateApiMappingInput) (*UpdateApiMappingOutput, error) {
	req, out := c.UpdateApiMappingRequest(input)
	return out, req.Send()
}

// UpdateApiMappingWithContext is the same as UpdateApiMapping with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApiMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateApiMappingWithContext(ctx aws.Context, input *UpdateApiMappingInput, opts ...request.Option) (*UpdateApiMappingOutput, error) {
	req, out := c.UpdateApiMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAuthorizer = "UpdateAuthorizer"

// UpdateAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAuthorizer for more information on using the UpdateAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAuthorizerRequest method.
//    req, resp := client.UpdateAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateAuthorizer
func (c *ApiGatewayV2) UpdateAuthorizerRequest(input *UpdateAuthorizerInput) (req *request.Request, output *UpdateAuthorizerOutput) {
	op := &request.Operation{
		Name:       opUpdateAuthorizer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}/authorizers/{authorizerId}",
	}

	if input == nil {
		input = &UpdateAuthorizerInput{}
	}

	output = &UpdateAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAuthorizer API operation for AmazonApiGatewayV2.
//
// Updates an Authorizer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateAuthorizer for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateAuthorizer
func (c *ApiGatewayV2) UpdateAuthorizer(input *UpdateAuthorizerInput) (*UpdateAuthorizerOutput, error) {
	req, out := c.UpdateAuthorizerRequest(input)
	return out, req.Send()
}

// UpdateAuthorizerWithContext is the same as UpdateAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateAuthorizerWithContext(ctx aws.Context, input *UpdateAuthorizerInput, opts ...request.Option) (*UpdateAuthorizerOutput, error) {
	req, out := c.UpdateAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeployment = "UpdateDeployment"

// UpdateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeployment for more information on using the UpdateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeploymentRequest method.
//    req, resp := client.UpdateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateDeployment
func (c *ApiGatewayV2) UpdateDeploymentRequest(input *UpdateDeploymentInput) (req *request.Request, output *UpdateDeploymentOutput) {
	op := &request.Operation{
		Name:       opUpdateDeployment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}/deployments/{deploymentId}",
	}

	if input == nil {
		input = &UpdateDeploymentInput{}
	}

	output = &UpdateDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDeployment API operation for AmazonApiGatewayV2.
//
// Updates a Deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateDeployment for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateDeployment
func (c *ApiGatewayV2) UpdateDeployment(input *UpdateDeploymentInput) (*UpdateDeploymentOutput, error) {
	req, out := c.UpdateDeploymentRequest(input)
	return out, req.Send()
}

// UpdateDeploymentWithContext is the same as UpdateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateDeploymentWithContext(ctx aws.Context, input *UpdateDeploymentInput, opts ...request.Option) (*UpdateDeploymentOutput, error) {
	req, out := c.UpdateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainName = "UpdateDomainName"

// UpdateDomainNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainName for more information on using the UpdateDomainName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainNameRequest method.
//    req, resp := client.UpdateDomainNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateDomainName
func (c *ApiGatewayV2) UpdateDomainNameRequest(input *UpdateDomainNameInput) (req *request.Request, output *UpdateDomainNameOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainName,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domainnames/{domainName}",
	}

	if input == nil {
		input = &UpdateDomainNameInput{}
	}

	output = &UpdateDomainNameOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomainName API operation for AmazonApiGatewayV2.
//
// Updates a domain name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateDomainName for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateDomainName
func (c *ApiGatewayV2) UpdateDomainName(input *UpdateDomainNameInput) (*UpdateDomainNameOutput, error) {
	req, out := c.UpdateDomainNameRequest(input)
	return out, req.Send()
}

// UpdateDomainNameWithContext is the same as UpdateDomainName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateDomainNameWithContext(ctx aws.Context, input *UpdateDomainNameInput, opts ...request.Option) (*UpdateDomainNameOutput, error) {
	req, out := c.UpdateDomainNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIntegration = "UpdateIntegration"

// UpdateIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIntegration for more information on using the UpdateIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIntegrationRequest method.
//    req, resp := client.UpdateIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateIntegration
func (c *ApiGatewayV2) UpdateIntegrationRequest(input *UpdateIntegrationInput) (req *request.Request, output *UpdateIntegrationOutput) {
	op := &request.Operation{
		Name:       opUpdateIntegration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}",
	}

	if input == nil {
		input = &UpdateIntegrationInput{}
	}

	output = &UpdateIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIntegration API operation for AmazonApiGatewayV2.
//
// Updates an Integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateIntegration for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateIntegration
func (c *ApiGatewayV2) UpdateIntegration(input *UpdateIntegrationInput) (*UpdateIntegrationOutput, error) {
	req, out := c.UpdateIntegrationRequest(input)
	return out, req.Send()
}

// UpdateIntegrationWithContext is the same as UpdateIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateIntegrationWithContext(ctx aws.Context, input *UpdateIntegrationInput, opts ...request.Option) (*UpdateIntegrationOutput, error) {
	req, out := c.UpdateIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIntegrationResponse = "UpdateIntegrationResponse"

// UpdateIntegrationResponseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIntegrationResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIntegrationResponse for more information on using the UpdateIntegrationResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIntegrationResponseRequest method.
//    req, resp := client.UpdateIntegrationResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateIntegrationResponse
func (c *ApiGatewayV2) UpdateIntegrationResponseRequest(input *UpdateIntegrationResponseInput) (req *request.Request, output *UpdateIntegrationResponseOutput) {
	op := &request.Operation{
		Name:       opUpdateIntegrationResponse,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
	}

	if input == nil {
		input = &UpdateIntegrationResponseInput{}
	}

	output = &UpdateIntegrationResponseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIntegrationResponse API operation for AmazonApiGatewayV2.
//
// Updates an IntegrationResponses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateIntegrationResponse for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateIntegrationResponse
func (c *ApiGatewayV2) UpdateIntegrationResponse(input *UpdateIntegrationResponseInput) (*UpdateIntegrationResponseOutput, error) {
	req, out := c.UpdateIntegrationResponseRequest(input)
	return out, req.Send()
}

// UpdateIntegrationResponseWithContext is the same as UpdateIntegrationResponse with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIntegrationResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateIntegrationResponseWithContext(ctx aws.Context, input *UpdateIntegrationResponseInput, opts ...request.Option) (*UpdateIntegrationResponseOutput, error) {
	req, out := c.UpdateIntegrationResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModel = "UpdateModel"

// UpdateModelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModel for more information on using the UpdateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateModelRequest method.
//    req, resp := client.UpdateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateModel
func (c *ApiGatewayV2) UpdateModelRequest(input *UpdateModelInput) (req *request.Request, output *UpdateModelOutput) {
	op := &request.Operation{
		Name:       opUpdateModel,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}/models/{modelId}",
	}

	if input == nil {
		input = &UpdateModelInput{}
	}

	output = &UpdateModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateModel API operation for AmazonApiGatewayV2.
//
// Updates a Model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateModel for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateModel
func (c *ApiGatewayV2) UpdateModel(input *UpdateModelInput) (*UpdateModelOutput, error) {
	req, out := c.UpdateModelRequest(input)
	return out, req.Send()
}

// UpdateModelWithContext is the same as UpdateModel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateModelWithContext(ctx aws.Context, input *UpdateModelInput, opts ...request.Option) (*UpdateModelOutput, error) {
	req, out := c.UpdateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoute = "UpdateRoute"

// UpdateRouteRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoute for more information on using the UpdateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRouteRequest method.
//    req, resp := client.UpdateRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateRoute
func (c *ApiGatewayV2) UpdateRouteRequest(input *UpdateRouteInput) (req *request.Request, output *UpdateRouteOutput) {
	op := &request.Operation{
		Name:       opUpdateRoute,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}",
	}

	if input == nil {
		input = &UpdateRouteInput{}
	}

	output = &UpdateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoute API operation for AmazonApiGatewayV2.
//
// Updates a Route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateRoute for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateRoute
func (c *ApiGatewayV2) UpdateRoute(input *UpdateRouteInput) (*UpdateRouteOutput, error) {
	req, out := c.UpdateRouteRequest(input)
	return out, req.Send()
}

// UpdateRouteWithContext is the same as UpdateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateRouteWithContext(ctx aws.Context, input *UpdateRouteInput, opts ...request.Option) (*UpdateRouteOutput, error) {
	req, out := c.UpdateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRouteResponse = "UpdateRouteResponse"

// UpdateRouteResponseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRouteResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRouteResponse for more information on using the UpdateRouteResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRouteResponseRequest method.
//    req, resp := client.UpdateRouteResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateRouteResponse
func (c *ApiGatewayV2) UpdateRouteResponseRequest(input *UpdateRouteResponseInput) (req *request.Request, output *UpdateRouteResponseOutput) {
	op := &request.Operation{
		Name:       opUpdateRouteResponse,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}/routeresponses/{routeResponseId}",
	}

	if input == nil {
		input = &UpdateRouteResponseInput{}
	}

	output = &UpdateRouteResponseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRouteResponse API operation for AmazonApiGatewayV2.
//
// Updates a RouteResponse.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateRouteResponse for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateRouteResponse
func (c *ApiGatewayV2) UpdateRouteResponse(input *UpdateRouteResponseInput) (*UpdateRouteResponseOutput, error) {
	req, out := c.UpdateRouteResponseRequest(input)
	return out, req.Send()
}

// UpdateRouteResponseWithContext is the same as UpdateRouteResponse with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRouteResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateRouteResponseWithContext(ctx aws.Context, input *UpdateRouteResponseInput, opts ...request.Option) (*UpdateRouteResponseOutput, error) {
	req, out := c.UpdateRouteResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStage = "UpdateStage"

// UpdateStageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStage for more information on using the UpdateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStageRequest method.
//    req, resp := client.UpdateStageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateStage
func (c *ApiGatewayV2) UpdateStageRequest(input *UpdateStageInput) (req *request.Request, output *UpdateStageOutput) {
	op := &request.Operation{
		Name:       opUpdateStage,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/apis/{apiId}/stages/{stageName}",
	}

	if input == nil {
		input = &UpdateStageInput{}
	}

	output = &UpdateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStage API operation for AmazonApiGatewayV2.
//
// Updates a Stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateStage for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
//   * ConflictException
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request. See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateStage
func (c *ApiGatewayV2) UpdateStage(input *UpdateStageInput) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	return out, req.Send()
}

// UpdateStageWithContext is the same as UpdateStage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateStageWithContext(ctx aws.Context, input *UpdateStageInput, opts ...request.Option) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVpcLink = "UpdateVpcLink"

// UpdateVpcLinkRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVpcLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVpcLink for more information on using the UpdateVpcLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVpcLinkRequest method.
//    req, resp := client.UpdateVpcLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateVpcLink
func (c *ApiGatewayV2) UpdateVpcLinkRequest(input *UpdateVpcLinkInput) (req *request.Request, output *UpdateVpcLinkOutput) {
	op := &request.Operation{
		Name:       opUpdateVpcLink,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/vpclinks/{vpcLinkId}",
	}

	if input == nil {
		input = &UpdateVpcLinkInput{}
	}

	output = &UpdateVpcLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVpcLink API operation for AmazonApiGatewayV2.
//
// Updates a VPC link.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonApiGatewayV2's
// API operation UpdateVpcLink for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource specified in the request was not found. See the message field
//   for more information.
//
//   * TooManyRequestsException
//   A limit has been exceeded. See the accompanying error message for details.
//
//   * BadRequestException
//   The request is not valid, for example, the input is incomplete or incorrect.
//   See the accompanying error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/UpdateVpcLink
func (c *ApiGatewayV2) UpdateVpcLink(input *UpdateVpcLinkInput) (*UpdateVpcLinkOutput, error) {
	req, out := c.UpdateVpcLinkRequest(input)
	return out, req.Send()
}

// UpdateVpcLinkWithContext is the same as UpdateVpcLink with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVpcLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ApiGatewayV2) UpdateVpcLinkWithContext(ctx aws.Context, input *UpdateVpcLinkInput, opts ...request.Option) (*UpdateVpcLinkOutput, error) {
	req, out := c.UpdateVpcLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Settings for logging access in a stage.
type AccessLogSettings struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Logs log group to receive access logs.
	DestinationArn *string `locationName:"destinationArn" type:"string"`

	// A single line format of the access logs of data, as specified by selected
	// $context variables. The format must include at least $context.requestId.
	Format *string `locationName:"format" type:"string"`
}

// String returns the string representation
func (s AccessLogSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessLogSettings) GoString() string {
	return s.String()
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *AccessLogSettings) SetDestinationArn(v string) *AccessLogSettings {
	s.DestinationArn = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *AccessLogSettings) SetFormat(v string) *AccessLogSettings {
	s.Format = &v
	return s
}

// Represents an API.
type Api struct {
	_ struct{} `type:"structure"`

	// The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com.
	// The stage name is typically appended to this URI to form a complete path
	// to a deployed API stage.
	ApiEndpoint *string `locationName:"apiEndpoint" type:"string"`

	// The API ID.
	ApiId *string `locationName:"apiId" type:"string"`

	// An API key selection expression. Supported only for WebSocket APIs. See API
	// Key Selection Expressions (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// A CORS configuration. Supported only for HTTP APIs.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	// The timestamp when the API was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the API.
	Description *string `locationName:"description" type:"string"`

	// Avoid validating models when creating a deployment. Supported only for WebSocket
	// APIs.
	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	// The validation information during API import. This may include particular
	// properties of your OpenAPI definition which are ignored during import. Supported
	// only for HTTP APIs.
	ImportInfo []*string `locationName:"importInfo" type:"list"`

	// The name of the API.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The API protocol.
	//
	// ProtocolType is a required field
	ProtocolType *string `locationName:"protocolType" type:"string" required:"true" enum:"ProtocolType"`

	// The route selection expression for the API. For HTTP APIs, the routeSelectionExpression
	// must be ${request.method} ${request.path}. If not provided, this will be
	// the default for HTTP APIs. This property is required for WebSocket APIs.
	//
	// RouteSelectionExpression is a required field
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string" required:"true"`

	// A collection of tags associated with the API.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A version identifier for the API.
	Version *string `locationName:"version" type:"string"`

	// The warning messages reported when failonwarnings is turned on during API
	// import.
	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s Api) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Api) GoString() string {
	return s.String()
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *Api) SetApiEndpoint(v string) *Api {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *Api) SetApiId(v string) *Api {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *Api) SetApiKeySelectionExpression(v string) *Api {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *Api) SetCorsConfiguration(v *Cors) *Api {
	s.CorsConfiguration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *Api) SetCreatedDate(v time.Time) *Api {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Api) SetDescription(v string) *Api {
	s.Description = &v
	return s
}

// SetDisableSchemaValidation sets the DisableSchemaValidation field's value.
func (s *Api) SetDisableSchemaValidation(v bool) *Api {
	s.DisableSchemaValidation = &v
	return s
}

// SetImportInfo sets the ImportInfo field's value.
func (s *Api) SetImportInfo(v []*string) *Api {
	s.ImportInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *Api) SetName(v string) *Api {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *Api) SetProtocolType(v string) *Api {
	s.ProtocolType = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *Api) SetRouteSelectionExpression(v string) *Api {
	s.RouteSelectionExpression = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Api) SetTags(v map[string]*string) *Api {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *Api) SetVersion(v string) *Api {
	s.Version = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *Api) SetWarnings(v []*string) *Api {
	s.Warnings = v
	return s
}

// Represents an API mapping.
type ApiMapping struct {
	_ struct{} `type:"structure"`

	// The API identifier.
	//
	// ApiId is a required field
	ApiId *string `locationName:"apiId" type:"string" required:"true"`

	// The API mapping identifier.
	ApiMappingId *string `locationName:"apiMappingId" type:"string"`

	// The API mapping key.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// The API stage.
	//
	// Stage is a required field
	Stage *string `locationName:"stage" type:"string" required:"true"`
}

// String returns the string representation
func (s ApiMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApiMapping) GoString() string {
	return s.String()
}

// SetApiId sets the ApiId field's value.
func (s *ApiMapping) SetApiId(v string) *ApiMapping {
	s.ApiId = &v
	return s
}

// SetApiMappingId sets the ApiMappingId field's value.
func (s *ApiMapping) SetApiMappingId(v string) *ApiMapping {
	s.ApiMappingId = &v
	return s
}

// SetApiMappingKey sets the ApiMappingKey field's value.
func (s *ApiMapping) SetApiMappingKey(v string) *ApiMapping {
	s.ApiMappingKey = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *ApiMapping) SetStage(v string) *ApiMapping {
	s.Stage = &v
	return s
}

// Represents an authorizer.
type Authorizer struct {
	_ struct{} `type:"structure"`

	// Specifies the required credentials as an IAM role for API Gateway to invoke
	// the authorizer. To specify an IAM role for API Gateway to assume, use the
	// role's Amazon Resource Name (ARN). To use resource-based permissions on the
	// Lambda function, specify null. Supported only for REQUEST authorizers.
	AuthorizerCredentialsArn *string `locationName:"authorizerCredentialsArn" type:"string"`

	// The authorizer identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// Authorizer caching is not currently supported. Don't specify this value for
	// authorizers.
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function
	// using incoming request parameters. For HTTP APIs, specify JWT to use JSON
	// Web Tokens.
	AuthorizerType *string `locationName:"authorizerType" type:"string" enum:"AuthorizerType"`

	// The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers,
	// this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations.
	// In general, the URI has this form: arn:aws:apigateway:{region}:lambda:path/{service_api}
	// , where {region} is the same as the region hosting the Lambda function, path
	// indicates that the remaining substring in the URI should be treated as the
	// path to the resource, including the initial /. For Lambda functions, this
	// is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported
	// only for REQUEST authorizers.
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identity source for which authorization is requested.
	//
	// For a REQUEST authorizer, this is optional. The value is a set of one or
	// more mapping expressions of the specified request parameters. Currently,
	// the identity source can be headers, query string parameters, stage variables,
	// and context parameters. For example, if an Auth header and a Name query string
	// parameter are defined as identity sources, this value is route.request.header.Auth,
	// route.request.querystring.Name. These parameters will be used to perform
	// runtime validation for Lambda-based authorizers by verifying all of the identity-related
	// request parameters are present in the request, not null, and non-empty. Only
	// when this is true does the authorizer invoke the authorizer Lambda function.
	// Otherwise, it returns a 401 Unauthorized response without calling the Lambda
	// function.
	//
	// For JWT, a single entry that specifies where to extract the JSON Web Token
	// (JWT) from inbound requests. Currently only header-based and query parameter-based
	// selections are supported, for example "$request.header.Authorization".
	IdentitySource []*string `locationName:"identitySource" type:"list"`

	// The validation expression does not apply to the REQUEST authorizer.
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// Represents the configuration of a JWT authorizer. Required for the JWT authorizer
	// type. Supported only for HTTP APIs.
	JwtConfiguration *JWTConfiguration `locationName:"jwtConfiguration" type:"structure"`

	// The name of the authorizer.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s Authorizer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Authorizer) GoString() string {
	return s.String()
}

// SetAuthorizerCredentialsArn sets the AuthorizerCredentialsArn field's value.
func (s *Authorizer) SetAuthorizerCredentialsArn(v string) *Authorizer {
	s.AuthorizerCredentialsArn = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *Authorizer) SetAuthorizerId(v string) *Authorizer {
	s.AuthorizerId = &v
	return s
}

// SetAuthorizerResultTtlInSeconds sets the AuthorizerResultTtlInSeconds field's value.
func (s *Authorizer) SetAuthorizerResultTtlInSeconds(v int64) *Authorizer {
	s.AuthorizerResultTtlInSeconds = &v
	return s
}

// SetAuthorizerType sets the AuthorizerType field's value.
func (s *Authorizer) SetAuthorizerType(v string) *Authorizer {
	s.AuthorizerType = &v
	return s
}

// SetAuthorizerUri sets the AuthorizerUri field's value.
func (s *Authorizer) SetAuthorizerUri(v string) *Authorizer {
	s.AuthorizerUri = &v
	return s
}

// SetIdentitySource sets the IdentitySource field's value.
func (s *Authorizer) SetIdentitySource(v []*string) *Authorizer {
	s.IdentitySource = v
	return s
}

// SetIdentityValidationExpression sets the IdentityValidationExpression field's value.
func (s *Authorizer) SetIdentityValidationExpression(v string) *Authorizer {
	s.IdentityValidationExpression = &v
	return s
}

// SetJwtConfiguration sets the JwtConfiguration field's value.
func (s *Authorizer) SetJwtConfiguration(v *JWTConfiguration) *Authorizer {
	s.JwtConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *Authorizer) SetName(v string) *Authorizer {
	s.Name = &v
	return s
}

// The request is not valid, for example, the input is incomplete or incorrect.
// See the accompanying error message for details.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Describes the error encountered.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested operation would cause a conflict with the current state of
// a service resource associated with the request. Resolve the conflict before
// retrying this request. See the accompanying error message for details.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Describes the error encountered.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
// for more information.
type Cors struct {
	_ struct{} `type:"structure"`

	// Specifies whether credentials are included in the CORS request. Supported
	// only for HTTP APIs.
	AllowCredentials *bool `locationName:"allowCredentials" type:"boolean"`

	// Represents a collection of allowed headers. Supported only for HTTP APIs.
	AllowHeaders []*string `locationName:"allowHeaders" type:"list"`

	// Represents a collection of allowed HTTP methods. Supported only for HTTP
	// APIs.
	AllowMethods []*string `locationName:"allowMethods" type:"list"`

	// Represents a collection of allowed origins. Supported only for HTTP APIs.
	AllowOrigins []*string `locationName:"allowOrigins" type:"list"`

	// Represents a collection of exposed headers. Supported only for HTTP APIs.
	ExposeHeaders []*string `locationName:"exposeHeaders" type:"list"`

	// The number of seconds that the browser should cache preflight request results.
	// Supported only for HTTP APIs.
	MaxAge *int64 `locationName:"maxAge" type:"integer"`
}

// String returns the string representation
func (s Cors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cors) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Cors) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Cors"}
	if s.MaxAge != nil && *s.MaxAge < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAge", -1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowCredentials sets the AllowCredentials field's value.
func (s *Cors) SetAllowCredentials(v bool) *Cors {
	s.AllowCredentials = &v
	return s
}

// SetAllowHeaders sets the AllowHeaders field's value.
func (s *Cors) SetAllowHeaders(v []*string) *Cors {
	s.AllowHeaders = v
	return s
}

// SetAllowMethods sets the AllowMethods field's value.
func (s *Cors) SetAllowMethods(v []*string) *Cors {
	s.AllowMethods = v
	return s
}

// SetAllowOrigins sets the AllowOrigins field's value.
func (s *Cors) SetAllowOrigins(v []*string) *Cors {
	s.AllowOrigins = v
	return s
}

// SetExposeHeaders sets the ExposeHeaders field's value.
func (s *Cors) SetExposeHeaders(v []*string) *Cors {
	s.ExposeHeaders = v
	return s
}

// SetMaxAge sets the MaxAge field's value.
func (s *Cors) SetMaxAge(v int64) *Cors {
	s.MaxAge = &v
	return s
}

type CreateApiInput struct {
	_ struct{} `type:"structure"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
	// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
	// for more information.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	// Represents an Amazon Resource Name (ARN).
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	// A string with a length between [1-128].
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Represents a protocol type.
	//
	// ProtocolType is a required field
	ProtocolType *string `locationName:"protocolType" type:"string" required:"true" enum:"ProtocolType"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteKey *string `locationName:"routeKey" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A string representation of a URI with a length between [1-2048].
	Target *string `locationName:"target" type:"string"`

	// A string with a length between [1-64].
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s CreateApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApiInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProtocolType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtocolType"))
	}
	if s.CorsConfiguration != nil {
		if err := s.CorsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CorsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *CreateApiInput) SetApiKeySelectionExpression(v string) *CreateApiInput {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *CreateApiInput) SetCorsConfiguration(v *Cors) *CreateApiInput {
	s.CorsConfiguration = v
	return s
}

// SetCredentialsArn sets the CredentialsArn field's value.
func (s *CreateApiInput) SetCredentialsArn(v string) *CreateApiInput {
	s.CredentialsArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApiInput) SetDescription(v string) *CreateApiInput {
	s.Description = &v
	return s
}

// SetDisableSchemaValidation sets the DisableSchemaValidation field's value.
func (s *CreateApiInput) SetDisableSchemaValidation(v bool) *CreateApiInput {
	s.DisableSchemaValidation = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApiInput) SetName(v string) *CreateApiInput {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *CreateApiInput) SetProtocolType(v string) *CreateApiInput {
	s.ProtocolType = &v
	return s
}

// SetRouteKey sets the RouteKey field's value.
func (s *CreateApiInput) SetRouteKey(v string) *CreateApiInput {
	s.RouteKey = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *CreateApiInput) SetRouteSelectionExpression(v string) *CreateApiInput {
	s.RouteSelectionExpression = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApiInput) SetTags(v map[string]*string) *CreateApiInput {
	s.Tags = v
	return s
}

// SetTarget sets the Target field's value.
func (s *CreateApiInput) SetTarget(v string) *CreateApiInput {
	s.Target = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateApiInput) SetVersion(v string) *CreateApiInput {
	s.Version = &v
	return s
}

type CreateApiMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier.
	//
	// ApiId is a required field
	ApiId *string `locationName:"apiId" type:"string" required:"true"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`

	// A string with a length between [1-128].
	//
	// Stage is a required field
	Stage *string `locationName:"stage" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateApiMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApiMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApiMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApiMappingInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Stage == nil {
		invalidParams.Add(request.NewErrParamRequired("Stage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateApiMappingInput) SetApiId(v string) *CreateApiMappingInput {
	s.ApiId = &v
	return s
}

// SetApiMappingKey sets the ApiMappingKey field's value.
func (s *CreateApiMappingInput) SetApiMappingKey(v string) *CreateApiMappingInput {
	s.ApiMappingKey = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateApiMappingInput) SetDomainName(v string) *CreateApiMappingInput {
	s.DomainName = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *CreateApiMappingInput) SetStage(v string) *CreateApiMappingInput {
	s.Stage = &v
	return s
}

type CreateApiMappingOutput struct {
	_ struct{} `type:"structure"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// The identifier.
	ApiMappingId *string `locationName:"apiMappingId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// A string with a length between [1-128].
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation
func (s CreateApiMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApiMappingOutput) GoString() string {
	return s.String()
}

// SetApiId sets the ApiId field's value.
func (s *CreateApiMappingOutput) SetApiId(v string) *CreateApiMappingOutput {
	s.ApiId = &v
	return s
}

// SetApiMappingId sets the ApiMappingId field's value.
func (s *CreateApiMappingOutput) SetApiMappingId(v string) *CreateApiMappingOutput {
	s.ApiMappingId = &v
	return s
}

// SetApiMappingKey sets the ApiMappingKey field's value.
func (s *CreateApiMappingOutput) SetApiMappingKey(v string) *CreateApiMappingOutput {
	s.ApiMappingKey = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *CreateApiMappingOutput) SetStage(v string) *CreateApiMappingOutput {
	s.Stage = &v
	return s
}

type CreateApiOutput struct {
	_ struct{} `type:"structure"`

	ApiEndpoint *string `locationName:"apiEndpoint" type:"string"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
	// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
	// for more information.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	ImportInfo []*string `locationName:"importInfo" type:"list"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// Represents a protocol type.
	ProtocolType *string `locationName:"protocolType" type:"string" enum:"ProtocolType"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A string with a length between [1-64].
	Version *string `locationName:"version" type:"string"`

	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s CreateApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApiOutput) GoString() string {
	return s.String()
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *CreateApiOutput) SetApiEndpoint(v string) *CreateApiOutput {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *CreateApiOutput) SetApiId(v string) *CreateApiOutput {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *CreateApiOutput) SetApiKeySelectionExpression(v string) *CreateApiOutput {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *CreateApiOutput) SetCorsConfiguration(v *Cors) *CreateApiOutput {
	s.CorsConfiguration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreateApiOutput) SetCreatedDate(v time.Time) *CreateApiOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApiOutput) SetDescription(v string) *CreateApiOutput {
	s.Description = &v
	return s
}

// SetDisableSchemaValidation sets the DisableSchemaValidation field's value.
func (s *CreateApiOutput) SetDisableSchemaValidation(v bool) *CreateApiOutput {
	s.DisableSchemaValidation = &v
	return s
}

// SetImportInfo sets the ImportInfo field's value.
func (s *CreateApiOutput) SetImportInfo(v []*string) *CreateApiOutput {
	s.ImportInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApiOutput) SetName(v string) *CreateApiOutput {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *CreateApiOutput) SetProtocolType(v string) *CreateApiOutput {
	s.ProtocolType = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *CreateApiOutput) SetRouteSelectionExpression(v string) *CreateApiOutput {
	s.RouteSelectionExpression = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApiOutput) SetTags(v map[string]*string) *CreateApiOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateApiOutput) SetVersion(v string) *CreateApiOutput {
	s.Version = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *CreateApiOutput) SetWarnings(v []*string) *CreateApiOutput {
	s.Warnings = v
	return s
}

type CreateAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// Represents an Amazon Resource Name (ARN).
	AuthorizerCredentialsArn *string `locationName:"authorizerCredentialsArn" type:"string"`

	// An integer with a value between [0-3600].
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function
	// using incoming request parameters. For HTTP APIs, specify JWT to use JSON
	// Web Tokens.
	//
	// AuthorizerType is a required field
	AuthorizerType *string `locationName:"authorizerType" type:"string" required:"true" enum:"AuthorizerType"`

	// A string representation of a URI with a length between [1-2048].
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identity source for which authorization is requested. For the REQUEST
	// authorizer, this is required when authorization caching is enabled. The value
	// is a comma-separated string of one or more mapping expressions of the specified
	// request parameters. For example, if an Auth header, a Name query string parameter
	// are defined as identity sources, this value is $method.request.header.Auth,
	// $method.request.querystring.Name. These parameters will be used to derive
	// the authorization caching key and to perform runtime validation of the REQUEST
	// authorizer by verifying all of the identity-related request parameters are
	// present, not null and non-empty. Only when this is true does the authorizer
	// invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized
	// response without calling the Lambda function. The valid value is a string
	// of comma-separated mapping expressions of the specified request parameters.
	// When the authorization caching is not enabled, this property is optional.
	//
	// IdentitySource is a required field
	IdentitySource []*string `locationName:"identitySource" type:"list" required:"true"`

	// A string with a length between [0-1024].
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// Represents the configuration of a JWT authorizer. Required for the JWT authorizer
	// type. Supported only for HTTP APIs.
	JwtConfiguration *JWTConfiguration `locationName:"jwtConfiguration" type:"structure"`

	// A string with a length between [1-128].
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAuthorizerInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.AuthorizerType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerType"))
	}
	if s.IdentitySource == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentitySource"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateAuthorizerInput) SetApiId(v string) *CreateAuthorizerInput {
	s.ApiId = &v
	return s
}

// SetAuthorizerCredentialsArn sets the AuthorizerCredentialsArn field's value.
func (s *CreateAuthorizerInput) SetAuthorizerCredentialsArn(v string) *CreateAuthorizerInput {
	s.AuthorizerCredentialsArn = &v
	return s
}

// SetAuthorizerResultTtlInSeconds sets the AuthorizerResultTtlInSeconds field's value.
func (s *CreateAuthorizerInput) SetAuthorizerResultTtlInSeconds(v int64) *CreateAuthorizerInput {
	s.AuthorizerResultTtlInSeconds = &v
	return s
}

// SetAuthorizerType sets the AuthorizerType field's value.
func (s *CreateAuthorizerInput) SetAuthorizerType(v string) *CreateAuthorizerInput {
	s.AuthorizerType = &v
	return s
}

// SetAuthorizerUri sets the AuthorizerUri field's value.
func (s *CreateAuthorizerInput) SetAuthorizerUri(v string) *CreateAuthorizerInput {
	s.AuthorizerUri = &v
	return s
}

// SetIdentitySource sets the IdentitySource field's value.
func (s *CreateAuthorizerInput) SetIdentitySource(v []*string) *CreateAuthorizerInput {
	s.IdentitySource = v
	return s
}

// SetIdentityValidationExpression sets the IdentityValidationExpression field's value.
func (s *CreateAuthorizerInput) SetIdentityValidationExpression(v string) *CreateAuthorizerInput {
	s.IdentityValidationExpression = &v
	return s
}

// SetJwtConfiguration sets the JwtConfiguration field's value.
func (s *CreateAuthorizerInput) SetJwtConfiguration(v *JWTConfiguration) *CreateAuthorizerInput {
	s.JwtConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAuthorizerInput) SetName(v string) *CreateAuthorizerInput {
	s.Name = &v
	return s
}

type CreateAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// Represents an Amazon Resource Name (ARN).
	AuthorizerCredentialsArn *string `locationName:"authorizerCredentialsArn" type:"string"`

	// The identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// An integer with a value between [0-3600].
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function
	// using incoming request parameters. For HTTP APIs, specify JWT to use JSON
	// Web Tokens.
	AuthorizerType *string `locationName:"authorizerType" type:"string" enum:"AuthorizerType"`

	// A string representation of a URI with a length between [1-2048].
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identity source for which authorization is requested. For the REQUEST
	// authorizer, this is required when authorization caching is enabled. The value
	// is a comma-separated string of one or more mapping expressions of the specified
	// request parameters. For example, if an Auth header, a Name query string parameter
	// are defined as identity sources, this value is $method.request.header.Auth,
	// $method.request.querystring.Name. These parameters will be used to derive
	// the authorization caching key and to perform runtime validation of the REQUEST
	// authorizer by verifying all of the identity-related request parameters are
	// present, not null and non-empty. Only when this is true does the authorizer
	// invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized
	// response without calling the Lambda function. The valid value is a string
	// of comma-separated mapping expressions of the specified request parameters.
	// When the authorization caching is not enabled, this property is optional.
	IdentitySource []*string `locationName:"identitySource" type:"list"`

	// A string with a length between [0-1024].
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// Represents the configuration of a JWT authorizer. Required for the JWT authorizer
	// type. Supported only for HTTP APIs.
	JwtConfiguration *JWTConfiguration `locationName:"jwtConfiguration" type:"structure"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CreateAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorizerCredentialsArn sets the AuthorizerCredentialsArn field's value.
func (s *CreateAuthorizerOutput) SetAuthorizerCredentialsArn(v string) *CreateAuthorizerOutput {
	s.AuthorizerCredentialsArn = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *CreateAuthorizerOutput) SetAuthorizerId(v string) *CreateAuthorizerOutput {
	s.AuthorizerId = &v
	return s
}

// SetAuthorizerResultTtlInSeconds sets the AuthorizerResultTtlInSeconds field's value.
func (s *CreateAuthorizerOutput) SetAuthorizerResultTtlInSeconds(v int64) *CreateAuthorizerOutput {
	s.AuthorizerResultTtlInSeconds = &v
	return s
}

// SetAuthorizerType sets the AuthorizerType field's value.
func (s *CreateAuthorizerOutput) SetAuthorizerType(v string) *CreateAuthorizerOutput {
	s.AuthorizerType = &v
	return s
}

// SetAuthorizerUri sets the AuthorizerUri field's value.
func (s *CreateAuthorizerOutput) SetAuthorizerUri(v string) *CreateAuthorizerOutput {
	s.AuthorizerUri = &v
	return s
}

// SetIdentitySource sets the IdentitySource field's value.
func (s *CreateAuthorizerOutput) SetIdentitySource(v []*string) *CreateAuthorizerOutput {
	s.IdentitySource = v
	return s
}

// SetIdentityValidationExpression sets the IdentityValidationExpression field's value.
func (s *CreateAuthorizerOutput) SetIdentityValidationExpression(v string) *CreateAuthorizerOutput {
	s.IdentityValidationExpression = &v
	return s
}

// SetJwtConfiguration sets the JwtConfiguration field's value.
func (s *CreateAuthorizerOutput) SetJwtConfiguration(v *JWTConfiguration) *CreateAuthorizerOutput {
	s.JwtConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAuthorizerOutput) SetName(v string) *CreateAuthorizerOutput {
	s.Name = &v
	return s
}

type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// A string with a length between [1-128].
	StageName *string `locationName:"stageName" type:"string"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateDeploymentInput) SetApiId(v string) *CreateDeploymentInput {
	s.ApiId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDeploymentInput) SetDescription(v string) *CreateDeploymentInput {
	s.Description = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *CreateDeploymentInput) SetStageName(v string) *CreateDeploymentInput {
	s.StageName = &v
	return s
}

type CreateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	AutoDeployed *bool `locationName:"autoDeployed" type:"boolean"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// Represents a deployment status.
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" enum:"DeploymentStatus"`

	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetAutoDeployed sets the AutoDeployed field's value.
func (s *CreateDeploymentOutput) SetAutoDeployed(v bool) *CreateDeploymentOutput {
	s.AutoDeployed = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreateDeploymentOutput) SetCreatedDate(v time.Time) *CreateDeploymentOutput {
	s.CreatedDate = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentOutput) SetDeploymentId(v string) *CreateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *CreateDeploymentOutput) SetDeploymentStatus(v string) *CreateDeploymentOutput {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *CreateDeploymentOutput) SetDeploymentStatusMessage(v string) *CreateDeploymentOutput {
	s.DeploymentStatusMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDeploymentOutput) SetDescription(v string) *CreateDeploymentOutput {
	s.Description = &v
	return s
}

type CreateDomainNameInput struct {
	_ struct{} `type:"structure"`

	// A string with a length between [1-512].
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// The domain name configurations.
	DomainNameConfigurations []*DomainNameConfiguration `locationName:"domainNameConfigurations" type:"list"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainNameInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainNameInput) SetDomainName(v string) *CreateDomainNameInput {
	s.DomainName = &v
	return s
}

// SetDomainNameConfigurations sets the DomainNameConfigurations field's value.
func (s *CreateDomainNameInput) SetDomainNameConfigurations(v []*DomainNameConfiguration) *CreateDomainNameInput {
	s.DomainNameConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainNameInput) SetTags(v map[string]*string) *CreateDomainNameInput {
	s.Tags = v
	return s
}

type CreateDomainNameOutput struct {
	_ struct{} `type:"structure"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiMappingSelectionExpression *string `locationName:"apiMappingSelectionExpression" type:"string"`

	// A string with a length between [1-512].
	DomainName *string `locationName:"domainName" type:"string"`

	// The domain name configurations.
	DomainNameConfigurations []*DomainNameConfiguration `locationName:"domainNameConfigurations" type:"list"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateDomainNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainNameOutput) GoString() string {
	return s.String()
}

// SetApiMappingSelectionExpression sets the ApiMappingSelectionExpression field's value.
func (s *CreateDomainNameOutput) SetApiMappingSelectionExpression(v string) *CreateDomainNameOutput {
	s.ApiMappingSelectionExpression = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainNameOutput) SetDomainName(v string) *CreateDomainNameOutput {
	s.DomainName = &v
	return s
}

// SetDomainNameConfigurations sets the DomainNameConfigurations field's value.
func (s *CreateDomainNameOutput) SetDomainNameConfigurations(v []*DomainNameConfiguration) *CreateDomainNameOutput {
	s.DomainNameConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainNameOutput) SetTags(v map[string]*string) *CreateDomainNameOutput {
	s.Tags = v
	return s
}

type CreateIntegrationInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A string with a length between [1-1024].
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// Represents a connection type.
	ConnectionType *string `locationName:"connectionType" type:"string" enum:"ConnectionType"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// Represents an Amazon Resource Name (ARN).
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// A string with a length between [1-64].
	IntegrationMethod *string `locationName:"integrationMethod" type:"string"`

	// Represents an API method integration type.
	//
	// IntegrationType is a required field
	IntegrationType *string `locationName:"integrationType" type:"string" required:"true" enum:"IntegrationType"`

	// A string representation of a URI with a length between [1-2048].
	IntegrationUri *string `locationName:"integrationUri" type:"string"`

	// Represents passthrough behavior for an integration response. Supported only
	// for WebSocket APIs.
	PassthroughBehavior *string `locationName:"passthroughBehavior" type:"string" enum:"PassthroughBehavior"`

	// A string with a length between [1-64].
	PayloadFormatVersion *string `locationName:"payloadFormatVersion" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`

	// An integer with a value between [50-30000].
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" min:"50" type:"integer"`

	// The TLS configuration for a private integration. If you specify a TLS configuration,
	// private integration traffic uses the HTTPS protocol. Supported only for HTTP
	// APIs.
	TlsConfig *TlsConfigInput `locationName:"tlsConfig" type:"structure"`
}

// String returns the string representation
func (s CreateIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIntegrationInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.IntegrationType == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationType"))
	}
	if s.TimeoutInMillis != nil && *s.TimeoutInMillis < 50 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMillis", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateIntegrationInput) SetApiId(v string) *CreateIntegrationInput {
	s.ApiId = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreateIntegrationInput) SetConnectionId(v string) *CreateIntegrationInput {
	s.ConnectionId = &v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *CreateIntegrationInput) SetConnectionType(v string) *CreateIntegrationInput {
	s.ConnectionType = &v
	return s
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *CreateIntegrationInput) SetContentHandlingStrategy(v string) *CreateIntegrationInput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetCredentialsArn sets the CredentialsArn field's value.
func (s *CreateIntegrationInput) SetCredentialsArn(v string) *CreateIntegrationInput {
	s.CredentialsArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIntegrationInput) SetDescription(v string) *CreateIntegrationInput {
	s.Description = &v
	return s
}

// SetIntegrationMethod sets the IntegrationMethod field's value.
func (s *CreateIntegrationInput) SetIntegrationMethod(v string) *CreateIntegrationInput {
	s.IntegrationMethod = &v
	return s
}

// SetIntegrationType sets the IntegrationType field's value.
func (s *CreateIntegrationInput) SetIntegrationType(v string) *CreateIntegrationInput {
	s.IntegrationType = &v
	return s
}

// SetIntegrationUri sets the IntegrationUri field's value.
func (s *CreateIntegrationInput) SetIntegrationUri(v string) *CreateIntegrationInput {
	s.IntegrationUri = &v
	return s
}

// SetPassthroughBehavior sets the PassthroughBehavior field's value.
func (s *CreateIntegrationInput) SetPassthroughBehavior(v string) *CreateIntegrationInput {
	s.PassthroughBehavior = &v
	return s
}

// SetPayloadFormatVersion sets the PayloadFormatVersion field's value.
func (s *CreateIntegrationInput) SetPayloadFormatVersion(v string) *CreateIntegrationInput {
	s.PayloadFormatVersion = &v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *CreateIntegrationInput) SetRequestParameters(v map[string]*string) *CreateIntegrationInput {
	s.RequestParameters = v
	return s
}

// SetRequestTemplates sets the RequestTemplates field's value.
func (s *CreateIntegrationInput) SetRequestTemplates(v map[string]*string) *CreateIntegrationInput {
	s.RequestTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *CreateIntegrationInput) SetTemplateSelectionExpression(v string) *CreateIntegrationInput {
	s.TemplateSelectionExpression = &v
	return s
}

// SetTimeoutInMillis sets the TimeoutInMillis field's value.
func (s *CreateIntegrationInput) SetTimeoutInMillis(v int64) *CreateIntegrationInput {
	s.TimeoutInMillis = &v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *CreateIntegrationInput) SetTlsConfig(v *TlsConfigInput) *CreateIntegrationInput {
	s.TlsConfig = v
	return s
}

type CreateIntegrationOutput struct {
	_ struct{} `type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	// A string with a length between [1-1024].
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// Represents a connection type.
	ConnectionType *string `locationName:"connectionType" type:"string" enum:"ConnectionType"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// Represents an Amazon Resource Name (ARN).
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The identifier.
	IntegrationId *string `locationName:"integrationId" type:"string"`

	// A string with a length between [1-64].
	IntegrationMethod *string `locationName:"integrationMethod" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	IntegrationResponseSelectionExpression *string `locationName:"integrationResponseSelectionExpression" type:"string"`

	// Represents an API method integration type.
	IntegrationType *string `locationName:"integrationType" type:"string" enum:"IntegrationType"`

	// A string representation of a URI with a length between [1-2048].
	IntegrationUri *string `locationName:"integrationUri" type:"string"`

	// Represents passthrough behavior for an integration response. Supported only
	// for WebSocket APIs.
	PassthroughBehavior *string `locationName:"passthroughBehavior" type:"string" enum:"PassthroughBehavior"`

	// A string with a length between [1-64].
	PayloadFormatVersion *string `locationName:"payloadFormatVersion" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`

	// An integer with a value between [50-30000].
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" min:"50" type:"integer"`

	// The TLS configuration for a private integration. If you specify a TLS configuration,
	// private integration traffic uses the HTTPS protocol. Supported only for HTTP
	// APIs.
	TlsConfig *TlsConfig `locationName:"tlsConfig" type:"structure"`
}

// String returns the string representation
func (s CreateIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIntegrationOutput) GoString() string {
	return s.String()
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *CreateIntegrationOutput) SetApiGatewayManaged(v bool) *CreateIntegrationOutput {
	s.ApiGatewayManaged = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreateIntegrationOutput) SetConnectionId(v string) *CreateIntegrationOutput {
	s.ConnectionId = &v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *CreateIntegrationOutput) SetConnectionType(v string) *CreateIntegrationOutput {
	s.ConnectionType = &v
	return s
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *CreateIntegrationOutput) SetContentHandlingStrategy(v string) *CreateIntegrationOutput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetCredentialsArn sets the CredentialsArn field's value.
func (s *CreateIntegrationOutput) SetCredentialsArn(v string) *CreateIntegrationOutput {
	s.CredentialsArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIntegrationOutput) SetDescription(v string) *CreateIntegrationOutput {
	s.Description = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *CreateIntegrationOutput) SetIntegrationId(v string) *CreateIntegrationOutput {
	s.IntegrationId = &v
	return s
}

// SetIntegrationMethod sets the IntegrationMethod field's value.
func (s *CreateIntegrationOutput) SetIntegrationMethod(v string) *CreateIntegrationOutput {
	s.IntegrationMethod = &v
	return s
}

// SetIntegrationResponseSelectionExpression sets the IntegrationResponseSelectionExpression field's value.
func (s *CreateIntegrationOutput) SetIntegrationResponseSelectionExpression(v string) *CreateIntegrationOutput {
	s.IntegrationResponseSelectionExpression = &v
	return s
}

// SetIntegrationType sets the IntegrationType field's value.
func (s *CreateIntegrationOutput) SetIntegrationType(v string) *CreateIntegrationOutput {
	s.IntegrationType = &v
	return s
}

// SetIntegrationUri sets the IntegrationUri field's value.
func (s *CreateIntegrationOutput) SetIntegrationUri(v string) *CreateIntegrationOutput {
	s.IntegrationUri = &v
	return s
}

// SetPassthroughBehavior sets the PassthroughBehavior field's value.
func (s *CreateIntegrationOutput) SetPassthroughBehavior(v string) *CreateIntegrationOutput {
	s.PassthroughBehavior = &v
	return s
}

// SetPayloadFormatVersion sets the PayloadFormatVersion field's value.
func (s *CreateIntegrationOutput) SetPayloadFormatVersion(v string) *CreateIntegrationOutput {
	s.PayloadFormatVersion = &v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *CreateIntegrationOutput) SetRequestParameters(v map[string]*string) *CreateIntegrationOutput {
	s.RequestParameters = v
	return s
}

// SetRequestTemplates sets the RequestTemplates field's value.
func (s *CreateIntegrationOutput) SetRequestTemplates(v map[string]*string) *CreateIntegrationOutput {
	s.RequestTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *CreateIntegrationOutput) SetTemplateSelectionExpression(v string) *CreateIntegrationOutput {
	s.TemplateSelectionExpression = &v
	return s
}

// SetTimeoutInMillis sets the TimeoutInMillis field's value.
func (s *CreateIntegrationOutput) SetTimeoutInMillis(v int64) *CreateIntegrationOutput {
	s.TimeoutInMillis = &v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *CreateIntegrationOutput) SetTlsConfig(v *TlsConfig) *CreateIntegrationOutput {
	s.TlsConfig = v
	return s
}

type CreateIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	//
	// IntegrationResponseKey is a required field
	IntegrationResponseKey *string `locationName:"integrationResponseKey" type:"string" required:"true"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`
}

// String returns the string representation
func (s CreateIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIntegrationResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIntegrationResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIntegrationResponseInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.IntegrationId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationId"))
	}
	if s.IntegrationId != nil && len(*s.IntegrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationId", 1))
	}
	if s.IntegrationResponseKey == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationResponseKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateIntegrationResponseInput) SetApiId(v string) *CreateIntegrationResponseInput {
	s.ApiId = &v
	return s
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *CreateIntegrationResponseInput) SetContentHandlingStrategy(v string) *CreateIntegrationResponseInput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *CreateIntegrationResponseInput) SetIntegrationId(v string) *CreateIntegrationResponseInput {
	s.IntegrationId = &v
	return s
}

// SetIntegrationResponseKey sets the IntegrationResponseKey field's value.
func (s *CreateIntegrationResponseInput) SetIntegrationResponseKey(v string) *CreateIntegrationResponseInput {
	s.IntegrationResponseKey = &v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *CreateIntegrationResponseInput) SetResponseParameters(v map[string]*string) *CreateIntegrationResponseInput {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *CreateIntegrationResponseInput) SetResponseTemplates(v map[string]*string) *CreateIntegrationResponseInput {
	s.ResponseTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *CreateIntegrationResponseInput) SetTemplateSelectionExpression(v string) *CreateIntegrationResponseInput {
	s.TemplateSelectionExpression = &v
	return s
}

type CreateIntegrationResponseOutput struct {
	_ struct{} `type:"structure"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// The identifier.
	IntegrationResponseId *string `locationName:"integrationResponseId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	IntegrationResponseKey *string `locationName:"integrationResponseKey" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`
}

// String returns the string representation
func (s CreateIntegrationResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIntegrationResponseOutput) GoString() string {
	return s.String()
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *CreateIntegrationResponseOutput) SetContentHandlingStrategy(v string) *CreateIntegrationResponseOutput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetIntegrationResponseId sets the IntegrationResponseId field's value.
func (s *CreateIntegrationResponseOutput) SetIntegrationResponseId(v string) *CreateIntegrationResponseOutput {
	s.IntegrationResponseId = &v
	return s
}

// SetIntegrationResponseKey sets the IntegrationResponseKey field's value.
func (s *CreateIntegrationResponseOutput) SetIntegrationResponseKey(v string) *CreateIntegrationResponseOutput {
	s.IntegrationResponseKey = &v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *CreateIntegrationResponseOutput) SetResponseParameters(v map[string]*string) *CreateIntegrationResponseOutput {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *CreateIntegrationResponseOutput) SetResponseTemplates(v map[string]*string) *CreateIntegrationResponseOutput {
	s.ResponseTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *CreateIntegrationResponseOutput) SetTemplateSelectionExpression(v string) *CreateIntegrationResponseOutput {
	s.TemplateSelectionExpression = &v
	return s
}

type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A string with a length between [1-256].
	ContentType *string `locationName:"contentType" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// A string with a length between [1-128].
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A string with a length between [0-32768].
	//
	// Schema is a required field
	Schema *string `locationName:"schema" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Schema == nil {
		invalidParams.Add(request.NewErrParamRequired("Schema"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateModelInput) SetApiId(v string) *CreateModelInput {
	s.ApiId = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CreateModelInput) SetContentType(v string) *CreateModelInput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateModelInput) SetDescription(v string) *CreateModelInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateModelInput) SetName(v string) *CreateModelInput {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *CreateModelInput) SetSchema(v string) *CreateModelInput {
	s.Schema = &v
	return s
}

type CreateModelOutput struct {
	_ struct{} `type:"structure"`

	// A string with a length between [1-256].
	ContentType *string `locationName:"contentType" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The identifier.
	ModelId *string `locationName:"modelId" type:"string"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A string with a length between [0-32768].
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s CreateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *CreateModelOutput) SetContentType(v string) *CreateModelOutput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateModelOutput) SetDescription(v string) *CreateModelOutput {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *CreateModelOutput) SetModelId(v string) *CreateModelOutput {
	s.ModelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateModelOutput) SetName(v string) *CreateModelOutput {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *CreateModelOutput) SetSchema(v string) *CreateModelOutput {
	s.Schema = &v
	return s
}

type CreateRouteInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on a route. The scopes are used
	// with a JWT authorizer to authorize the method invocation. The authorization
	// works by matching the route scopes against the scopes parsed from the access
	// token in the incoming request. The method invocation is authorized if any
	// route scope matches a claimed scope in the access token. Otherwise, the invocation
	// is not authorized. When the route scope is configured, the client must provide
	// an access token instead of an identity token for authorization purposes.
	AuthorizationScopes []*string `locationName:"authorizationScopes" type:"list"`

	// The authorization type. For WebSocket APIs, valid values are NONE for open
	// access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda
	// authorizer. For HTTP APIs, valid values are NONE for open access, or JWT
	// for using JSON Web Tokens.
	AuthorizationType *string `locationName:"authorizationType" type:"string" enum:"AuthorizationType"`

	// The identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// A string with a length between [1-64].
	OperationName *string `locationName:"operationName" type:"string"`

	// The route models.
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// The route parameters.
	RequestParameters map[string]*ParameterConstraints `locationName:"requestParameters" type:"map"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	//
	// RouteKey is a required field
	RouteKey *string `locationName:"routeKey" type:"string" required:"true"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteResponseSelectionExpression *string `locationName:"routeResponseSelectionExpression" type:"string"`

	// A string with a length between [1-128].
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s CreateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteKey == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateRouteInput) SetApiId(v string) *CreateRouteInput {
	s.ApiId = &v
	return s
}

// SetApiKeyRequired sets the ApiKeyRequired field's value.
func (s *CreateRouteInput) SetApiKeyRequired(v bool) *CreateRouteInput {
	s.ApiKeyRequired = &v
	return s
}

// SetAuthorizationScopes sets the AuthorizationScopes field's value.
func (s *CreateRouteInput) SetAuthorizationScopes(v []*string) *CreateRouteInput {
	s.AuthorizationScopes = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *CreateRouteInput) SetAuthorizationType(v string) *CreateRouteInput {
	s.AuthorizationType = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *CreateRouteInput) SetAuthorizerId(v string) *CreateRouteInput {
	s.AuthorizerId = &v
	return s
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *CreateRouteInput) SetModelSelectionExpression(v string) *CreateRouteInput {
	s.ModelSelectionExpression = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *CreateRouteInput) SetOperationName(v string) *CreateRouteInput {
	s.OperationName = &v
	return s
}

// SetRequestModels sets the RequestModels field's value.
func (s *CreateRouteInput) SetRequestModels(v map[string]*string) *CreateRouteInput {
	s.RequestModels = v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *CreateRouteInput) SetRequestParameters(v map[string]*ParameterConstraints) *CreateRouteInput {
	s.RequestParameters = v
	return s
}

// SetRouteKey sets the RouteKey field's value.
func (s *CreateRouteInput) SetRouteKey(v string) *CreateRouteInput {
	s.RouteKey = &v
	return s
}

// SetRouteResponseSelectionExpression sets the RouteResponseSelectionExpression field's value.
func (s *CreateRouteInput) SetRouteResponseSelectionExpression(v string) *CreateRouteInput {
	s.RouteResponseSelectionExpression = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *CreateRouteInput) SetTarget(v string) *CreateRouteInput {
	s.Target = &v
	return s
}

type CreateRouteOutput struct {
	_ struct{} `type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on a route. The scopes are used
	// with a JWT authorizer to authorize the method invocation. The authorization
	// works by matching the route scopes against the scopes parsed from the access
	// token in the incoming request. The method invocation is authorized if any
	// route scope matches a claimed scope in the access token. Otherwise, the invocation
	// is not authorized. When the route scope is configured, the client must provide
	// an access token instead of an identity token for authorization purposes.
	AuthorizationScopes []*string `locationName:"authorizationScopes" type:"list"`

	// The authorization type. For WebSocket APIs, valid values are NONE for open
	// access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda
	// authorizer. For HTTP APIs, valid values are NONE for open access, or JWT
	// for using JSON Web Tokens.
	AuthorizationType *string `locationName:"authorizationType" type:"string" enum:"AuthorizationType"`

	// The identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// A string with a length between [1-64].
	OperationName *string `locationName:"operationName" type:"string"`

	// The route models.
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// The route parameters.
	RequestParameters map[string]*ParameterConstraints `locationName:"requestParameters" type:"map"`

	// The identifier.
	RouteId *string `locationName:"routeId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteKey *string `locationName:"routeKey" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteResponseSelectionExpression *string `locationName:"routeResponseSelectionExpression" type:"string"`

	// A string with a length between [1-128].
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s CreateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteOutput) GoString() string {
	return s.String()
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *CreateRouteOutput) SetApiGatewayManaged(v bool) *CreateRouteOutput {
	s.ApiGatewayManaged = &v
	return s
}

// SetApiKeyRequired sets the ApiKeyRequired field's value.
func (s *CreateRouteOutput) SetApiKeyRequired(v bool) *CreateRouteOutput {
	s.ApiKeyRequired = &v
	return s
}

// SetAuthorizationScopes sets the AuthorizationScopes field's value.
func (s *CreateRouteOutput) SetAuthorizationScopes(v []*string) *CreateRouteOutput {
	s.AuthorizationScopes = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *CreateRouteOutput) SetAuthorizationType(v string) *CreateRouteOutput {
	s.AuthorizationType = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *CreateRouteOutput) SetAuthorizerId(v string) *CreateRouteOutput {
	s.AuthorizerId = &v
	return s
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *CreateRouteOutput) SetModelSelectionExpression(v string) *CreateRouteOutput {
	s.ModelSelectionExpression = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *CreateRouteOutput) SetOperationName(v string) *CreateRouteOutput {
	s.OperationName = &v
	return s
}

// SetRequestModels sets the RequestModels field's value.
func (s *CreateRouteOutput) SetRequestModels(v map[string]*string) *CreateRouteOutput {
	s.RequestModels = v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *CreateRouteOutput) SetRequestParameters(v map[string]*ParameterConstraints) *CreateRouteOutput {
	s.RequestParameters = v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *CreateRouteOutput) SetRouteId(v string) *CreateRouteOutput {
	s.RouteId = &v
	return s
}

// SetRouteKey sets the RouteKey field's value.
func (s *CreateRouteOutput) SetRouteKey(v string) *CreateRouteOutput {
	s.RouteKey = &v
	return s
}

// SetRouteResponseSelectionExpression sets the RouteResponseSelectionExpression field's value.
func (s *CreateRouteOutput) SetRouteResponseSelectionExpression(v string) *CreateRouteOutput {
	s.RouteResponseSelectionExpression = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *CreateRouteOutput) SetTarget(v string) *CreateRouteOutput {
	s.Target = &v
	return s
}

type CreateRouteResponseInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// The route models.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// The route parameters.
	ResponseParameters map[string]*ParameterConstraints `locationName:"responseParameters" type:"map"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	//
	// RouteResponseKey is a required field
	RouteResponseKey *string `locationName:"routeResponseKey" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRouteResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteResponseInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteId"))
	}
	if s.RouteId != nil && len(*s.RouteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteId", 1))
	}
	if s.RouteResponseKey == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteResponseKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *CreateRouteResponseInput) SetApiId(v string) *CreateRouteResponseInput {
	s.ApiId = &v
	return s
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *CreateRouteResponseInput) SetModelSelectionExpression(v string) *CreateRouteResponseInput {
	s.ModelSelectionExpression = &v
	return s
}

// SetResponseModels sets the ResponseModels field's value.
func (s *CreateRouteResponseInput) SetResponseModels(v map[string]*string) *CreateRouteResponseInput {
	s.ResponseModels = v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *CreateRouteResponseInput) SetResponseParameters(v map[string]*ParameterConstraints) *CreateRouteResponseInput {
	s.ResponseParameters = v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *CreateRouteResponseInput) SetRouteId(v string) *CreateRouteResponseInput {
	s.RouteId = &v
	return s
}

// SetRouteResponseKey sets the RouteResponseKey field's value.
func (s *CreateRouteResponseInput) SetRouteResponseKey(v string) *CreateRouteResponseInput {
	s.RouteResponseKey = &v
	return s
}

type CreateRouteResponseOutput struct {
	_ struct{} `type:"structure"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// The route models.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// The route parameters.
	ResponseParameters map[string]*ParameterConstraints `locationName:"responseParameters" type:"map"`

	// The identifier.
	RouteResponseId *string `locationName:"routeResponseId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteResponseKey *string `locationName:"routeResponseKey" type:"string"`
}

// String returns the string representation
func (s CreateRouteResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRouteResponseOutput) GoString() string {
	return s.String()
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *CreateRouteResponseOutput) SetModelSelectionExpression(v string) *CreateRouteResponseOutput {
	s.ModelSelectionExpression = &v
	return s
}

// SetResponseModels sets the ResponseModels field's value.
func (s *CreateRouteResponseOutput) SetResponseModels(v map[string]*string) *CreateRouteResponseOutput {
	s.ResponseModels = v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *CreateRouteResponseOutput) SetResponseParameters(v map[string]*ParameterConstraints) *CreateRouteResponseOutput {
	s.ResponseParameters = v
	return s
}

// SetRouteResponseId sets the RouteResponseId field's value.
func (s *CreateRouteResponseOutput) SetRouteResponseId(v string) *CreateRouteResponseOutput {
	s.RouteResponseId = &v
	return s
}

// SetRouteResponseKey sets the RouteResponseKey field's value.
func (s *CreateRouteResponseOutput) SetRouteResponseKey(v string) *CreateRouteResponseOutput {
	s.RouteResponseKey = &v
	return s
}

type CreateStageInput struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in a stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// Represents a collection of route settings.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The route settings map.
	RouteSettings map[string]*RouteSettings `locationName:"routeSettings" type:"map"`

	// A string with a length between [1-128].
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" type:"string" required:"true"`

	// The stage variable map.
	StageVariables map[string]*string `locationName:"stageVariables" type:"map"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStageInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *CreateStageInput) SetAccessLogSettings(v *AccessLogSettings) *CreateStageInput {
	s.AccessLogSettings = v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *CreateStageInput) SetApiId(v string) *CreateStageInput {
	s.ApiId = &v
	return s
}

// SetAutoDeploy sets the AutoDeploy field's value.
func (s *CreateStageInput) SetAutoDeploy(v bool) *CreateStageInput {
	s.AutoDeploy = &v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *CreateStageInput) SetClientCertificateId(v string) *CreateStageInput {
	s.ClientCertificateId = &v
	return s
}

// SetDefaultRouteSettings sets the DefaultRouteSettings field's value.
func (s *CreateStageInput) SetDefaultRouteSettings(v *RouteSettings) *CreateStageInput {
	s.DefaultRouteSettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateStageInput) SetDeploymentId(v string) *CreateStageInput {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStageInput) SetDescription(v string) *CreateStageInput {
	s.Description = &v
	return s
}

// SetRouteSettings sets the RouteSettings field's value.
func (s *CreateStageInput) SetRouteSettings(v map[string]*RouteSettings) *CreateStageInput {
	s.RouteSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *CreateStageInput) SetStageName(v string) *CreateStageInput {
	s.StageName = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *CreateStageInput) SetStageVariables(v map[string]*string) *CreateStageInput {
	s.StageVariables = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStageInput) SetTags(v map[string]*string) *CreateStageInput {
	s.Tags = v
	return s
}

type CreateStageOutput struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in a stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// Represents a collection of route settings.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	LastDeploymentStatusMessage *string `locationName:"lastDeploymentStatusMessage" type:"string"`

	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601"`

	// The route settings map.
	RouteSettings map[string]*RouteSettings `locationName:"routeSettings" type:"map"`

	// A string with a length between [1-128].
	StageName *string `locationName:"stageName" type:"string"`

	// The stage variable map.
	StageVariables map[string]*string `locationName:"stageVariables" type:"map"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStageOutput) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *CreateStageOutput) SetAccessLogSettings(v *AccessLogSettings) *CreateStageOutput {
	s.AccessLogSettings = v
	return s
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *CreateStageOutput) SetApiGatewayManaged(v bool) *CreateStageOutput {
	s.ApiGatewayManaged = &v
	return s
}

// SetAutoDeploy sets the AutoDeploy field's value.
func (s *CreateStageOutput) SetAutoDeploy(v bool) *CreateStageOutput {
	s.AutoDeploy = &v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *CreateStageOutput) SetClientCertificateId(v string) *CreateStageOutput {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreateStageOutput) SetCreatedDate(v time.Time) *CreateStageOutput {
	s.CreatedDate = &v
	return s
}

// SetDefaultRouteSettings sets the DefaultRouteSettings field's value.
func (s *CreateStageOutput) SetDefaultRouteSettings(v *RouteSettings) *CreateStageOutput {
	s.DefaultRouteSettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateStageOutput) SetDeploymentId(v string) *CreateStageOutput {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStageOutput) SetDescription(v string) *CreateStageOutput {
	s.Description = &v
	return s
}

// SetLastDeploymentStatusMessage sets the LastDeploymentStatusMessage field's value.
func (s *CreateStageOutput) SetLastDeploymentStatusMessage(v string) *CreateStageOutput {
	s.LastDeploymentStatusMessage = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *CreateStageOutput) SetLastUpdatedDate(v time.Time) *CreateStageOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetRouteSettings sets the RouteSettings field's value.
func (s *CreateStageOutput) SetRouteSettings(v map[string]*RouteSettings) *CreateStageOutput {
	s.RouteSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *CreateStageOutput) SetStageName(v string) *CreateStageOutput {
	s.StageName = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *CreateStageOutput) SetStageVariables(v map[string]*string) *CreateStageOutput {
	s.StageVariables = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStageOutput) SetTags(v map[string]*string) *CreateStageOutput {
	s.Tags = v
	return s
}

type CreateVpcLinkInput struct {
	_ struct{} `type:"structure"`

	// A string with a length between [1-128].
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A list of security group IDs for the VPC link.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// A list of subnet IDs to include in the VPC link.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateVpcLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcLinkInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateVpcLinkInput) SetName(v string) *CreateVpcLinkInput {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateVpcLinkInput) SetSecurityGroupIds(v []*string) *CreateVpcLinkInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateVpcLinkInput) SetSubnetIds(v []*string) *CreateVpcLinkInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVpcLinkInput) SetTags(v map[string]*string) *CreateVpcLinkInput {
	s.Tags = v
	return s
}

type CreateVpcLinkOutput struct {
	_ struct{} `type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A list of security group IDs for the VPC link.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// A list of subnet IDs to include in the VPC link.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The identifier.
	VpcLinkId *string `locationName:"vpcLinkId" type:"string"`

	// The status of the VPC link.
	VpcLinkStatus *string `locationName:"vpcLinkStatus" type:"string" enum:"VpcLinkStatus"`

	// A string with a length between [0-1024].
	VpcLinkStatusMessage *string `locationName:"vpcLinkStatusMessage" type:"string"`

	// The version of the VPC link.
	VpcLinkVersion *string `locationName:"vpcLinkVersion" type:"string" enum:"VpcLinkVersion"`
}

// String returns the string representation
func (s CreateVpcLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcLinkOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreateVpcLinkOutput) SetCreatedDate(v time.Time) *CreateVpcLinkOutput {
	s.CreatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVpcLinkOutput) SetName(v string) *CreateVpcLinkOutput {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateVpcLinkOutput) SetSecurityGroupIds(v []*string) *CreateVpcLinkOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateVpcLinkOutput) SetSubnetIds(v []*string) *CreateVpcLinkOutput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVpcLinkOutput) SetTags(v map[string]*string) *CreateVpcLinkOutput {
	s.Tags = v
	return s
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *CreateVpcLinkOutput) SetVpcLinkId(v string) *CreateVpcLinkOutput {
	s.VpcLinkId = &v
	return s
}

// SetVpcLinkStatus sets the VpcLinkStatus field's value.
func (s *CreateVpcLinkOutput) SetVpcLinkStatus(v string) *CreateVpcLinkOutput {
	s.VpcLinkStatus = &v
	return s
}

// SetVpcLinkStatusMessage sets the VpcLinkStatusMessage field's value.
func (s *CreateVpcLinkOutput) SetVpcLinkStatusMessage(v string) *CreateVpcLinkOutput {
	s.VpcLinkStatusMessage = &v
	return s
}

// SetVpcLinkVersion sets the VpcLinkVersion field's value.
func (s *CreateVpcLinkOutput) SetVpcLinkVersion(v string) *CreateVpcLinkOutput {
	s.VpcLinkVersion = &v
	return s
}

type DeleteAccessLogSettingsInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// StageName is a required field
	StageName *string `location:"uri" locationName:"stageName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccessLogSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessLogSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessLogSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessLogSettingsInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteAccessLogSettingsInput) SetApiId(v string) *DeleteAccessLogSettingsInput {
	s.ApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *DeleteAccessLogSettingsInput) SetStageName(v string) *DeleteAccessLogSettingsInput {
	s.StageName = &v
	return s
}

type DeleteAccessLogSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessLogSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessLogSettingsOutput) GoString() string {
	return s.String()
}

type DeleteApiInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApiInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteApiInput) SetApiId(v string) *DeleteApiInput {
	s.ApiId = &v
	return s
}

type DeleteApiMappingInput struct {
	_ struct{} `type:"structure"`

	// ApiMappingId is a required field
	ApiMappingId *string `location:"uri" locationName:"apiMappingId" type:"string" required:"true"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApiMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApiMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApiMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApiMappingInput"}
	if s.ApiMappingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiMappingId"))
	}
	if s.ApiMappingId != nil && len(*s.ApiMappingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiMappingId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiMappingId sets the ApiMappingId field's value.
func (s *DeleteApiMappingInput) SetApiMappingId(v string) *DeleteApiMappingInput {
	s.ApiMappingId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteApiMappingInput) SetDomainName(v string) *DeleteApiMappingInput {
	s.DomainName = &v
	return s
}

type DeleteApiMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApiMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApiMappingOutput) GoString() string {
	return s.String()
}

type DeleteApiOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApiOutput) GoString() string {
	return s.String()
}

type DeleteAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// AuthorizerId is a required field
	AuthorizerId *string `location:"uri" locationName:"authorizerId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAuthorizerInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.AuthorizerId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerId"))
	}
	if s.AuthorizerId != nil && len(*s.AuthorizerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteAuthorizerInput) SetApiId(v string) *DeleteAuthorizerInput {
	s.ApiId = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *DeleteAuthorizerInput) SetAuthorizerId(v string) *DeleteAuthorizerInput {
	s.AuthorizerId = &v
	return s
}

type DeleteAuthorizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAuthorizerOutput) GoString() string {
	return s.String()
}

type DeleteCorsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCorsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCorsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCorsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCorsConfigurationInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteCorsConfigurationInput) SetApiId(v string) *DeleteCorsConfigurationInput {
	s.ApiId = &v
	return s
}

type DeleteCorsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCorsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCorsConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteDeploymentInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deploymentId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeploymentInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteDeploymentInput) SetApiId(v string) *DeleteDeploymentInput {
	s.ApiId = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *DeleteDeploymentInput) SetDeploymentId(v string) *DeleteDeploymentInput {
	s.DeploymentId = &v
	return s
}

type DeleteDeploymentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentOutput) GoString() string {
	return s.String()
}

type DeleteDomainNameInput struct {
	_ struct{} `type:"structure"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainNameInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainNameInput) SetDomainName(v string) *DeleteDomainNameInput {
	s.DomainName = &v
	return s
}

type DeleteDomainNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainNameOutput) GoString() string {
	return s.String()
}

type DeleteIntegrationInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntegrationInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.IntegrationId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationId"))
	}
	if s.IntegrationId != nil && len(*s.IntegrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteIntegrationInput) SetApiId(v string) *DeleteIntegrationInput {
	s.ApiId = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *DeleteIntegrationInput) SetIntegrationId(v string) *DeleteIntegrationInput {
	s.IntegrationId = &v
	return s
}

type DeleteIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationOutput) GoString() string {
	return s.String()
}

type DeleteIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`

	// IntegrationResponseId is a required field
	IntegrationResponseId *string `location:"uri" locationName:"integrationResponseId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntegrationResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntegrationResponseInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.IntegrationId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationId"))
	}
	if s.IntegrationId != nil && len(*s.IntegrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationId", 1))
	}
	if s.IntegrationResponseId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationResponseId"))
	}
	if s.IntegrationResponseId != nil && len(*s.IntegrationResponseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationResponseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteIntegrationResponseInput) SetApiId(v string) *DeleteIntegrationResponseInput {
	s.ApiId = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *DeleteIntegrationResponseInput) SetIntegrationId(v string) *DeleteIntegrationResponseInput {
	s.IntegrationId = &v
	return s
}

// SetIntegrationResponseId sets the IntegrationResponseId field's value.
func (s *DeleteIntegrationResponseInput) SetIntegrationResponseId(v string) *DeleteIntegrationResponseInput {
	s.IntegrationResponseId = &v
	return s
}

type DeleteIntegrationResponseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIntegrationResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationResponseOutput) GoString() string {
	return s.String()
}

type DeleteModelInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// ModelId is a required field
	ModelId *string `location:"uri" locationName:"modelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteModelInput) SetApiId(v string) *DeleteModelInput {
	s.ApiId = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *DeleteModelInput) SetModelId(v string) *DeleteModelInput {
	s.ModelId = &v
	return s
}

type DeleteModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteModelOutput) GoString() string {
	return s.String()
}

type DeleteRouteInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteId"))
	}
	if s.RouteId != nil && len(*s.RouteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteRouteInput) SetApiId(v string) *DeleteRouteInput {
	s.ApiId = &v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *DeleteRouteInput) SetRouteId(v string) *DeleteRouteInput {
	s.RouteId = &v
	return s
}

type DeleteRouteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteOutput) GoString() string {
	return s.String()
}

type DeleteRouteRequestParameterInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// RequestParameterKey is a required field
	RequestParameterKey *string `location:"uri" locationName:"requestParameterKey" type:"string" required:"true"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteRequestParameterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteRequestParameterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteRequestParameterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteRequestParameterInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RequestParameterKey == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestParameterKey"))
	}
	if s.RequestParameterKey != nil && len(*s.RequestParameterKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestParameterKey", 1))
	}
	if s.RouteId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteId"))
	}
	if s.RouteId != nil && len(*s.RouteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteRouteRequestParameterInput) SetApiId(v string) *DeleteRouteRequestParameterInput {
	s.ApiId = &v
	return s
}

// SetRequestParameterKey sets the RequestParameterKey field's value.
func (s *DeleteRouteRequestParameterInput) SetRequestParameterKey(v string) *DeleteRouteRequestParameterInput {
	s.RequestParameterKey = &v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *DeleteRouteRequestParameterInput) SetRouteId(v string) *DeleteRouteRequestParameterInput {
	s.RouteId = &v
	return s
}

type DeleteRouteRequestParameterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteRequestParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteRequestParameterOutput) GoString() string {
	return s.String()
}

type DeleteRouteResponseInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`

	// RouteResponseId is a required field
	RouteResponseId *string `location:"uri" locationName:"routeResponseId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteResponseInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteId"))
	}
	if s.RouteId != nil && len(*s.RouteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteId", 1))
	}
	if s.RouteResponseId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteResponseId"))
	}
	if s.RouteResponseId != nil && len(*s.RouteResponseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteResponseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteRouteResponseInput) SetApiId(v string) *DeleteRouteResponseInput {
	s.ApiId = &v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *DeleteRouteResponseInput) SetRouteId(v string) *DeleteRouteResponseInput {
	s.RouteId = &v
	return s
}

// SetRouteResponseId sets the RouteResponseId field's value.
func (s *DeleteRouteResponseInput) SetRouteResponseId(v string) *DeleteRouteResponseInput {
	s.RouteResponseId = &v
	return s
}

type DeleteRouteResponseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteResponseOutput) GoString() string {
	return s.String()
}

type DeleteRouteSettingsInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// RouteKey is a required field
	RouteKey *string `location:"uri" locationName:"routeKey" type:"string" required:"true"`

	// StageName is a required field
	StageName *string `location:"uri" locationName:"stageName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteSettingsInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteKey == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteKey"))
	}
	if s.RouteKey != nil && len(*s.RouteKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteKey", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteRouteSettingsInput) SetApiId(v string) *DeleteRouteSettingsInput {
	s.ApiId = &v
	return s
}

// SetRouteKey sets the RouteKey field's value.
func (s *DeleteRouteSettingsInput) SetRouteKey(v string) *DeleteRouteSettingsInput {
	s.RouteKey = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *DeleteRouteSettingsInput) SetStageName(v string) *DeleteRouteSettingsInput {
	s.StageName = &v
	return s
}

type DeleteRouteSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRouteSettingsOutput) GoString() string {
	return s.String()
}

type DeleteStageInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// StageName is a required field
	StageName *string `location:"uri" locationName:"stageName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStageInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *DeleteStageInput) SetApiId(v string) *DeleteStageInput {
	s.ApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *DeleteStageInput) SetStageName(v string) *DeleteStageInput {
	s.StageName = &v
	return s
}

type DeleteStageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStageOutput) GoString() string {
	return s.String()
}

type DeleteVpcLinkInput struct {
	_ struct{} `type:"structure"`

	// VpcLinkId is a required field
	VpcLinkId *string `location:"uri" locationName:"vpcLinkId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcLinkInput"}
	if s.VpcLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcLinkId"))
	}
	if s.VpcLinkId != nil && len(*s.VpcLinkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcLinkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *DeleteVpcLinkInput) SetVpcLinkId(v string) *DeleteVpcLinkInput {
	s.VpcLinkId = &v
	return s
}

type DeleteVpcLinkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpcLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcLinkOutput) GoString() string {
	return s.String()
}

// An immutable representation of an API that can be called by users. A Deployment
// must be associated with a Stage for it to be callable over the internet.
type Deployment struct {
	_ struct{} `type:"structure"`

	// Specifies whether a deployment was automatically released.
	AutoDeployed *bool `locationName:"autoDeployed" type:"boolean"`

	// The date and time when the Deployment resource was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// The identifier for the deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The status of the deployment: PENDING, FAILED, or SUCCEEDED.
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" enum:"DeploymentStatus"`

	// May contain additional feedback on the status of an API deployment.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string"`

	// The description for the deployment.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Deployment) GoString() string {
	return s.String()
}

// SetAutoDeployed sets the AutoDeployed field's value.
func (s *Deployment) SetAutoDeployed(v bool) *Deployment {
	s.AutoDeployed = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *Deployment) SetCreatedDate(v time.Time) *Deployment {
	s.CreatedDate = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Deployment) SetDeploymentId(v string) *Deployment {
	s.DeploymentId = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *Deployment) SetDeploymentStatus(v string) *Deployment {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *Deployment) SetDeploymentStatusMessage(v string) *Deployment {
	s.DeploymentStatusMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Deployment) SetDescription(v string) *Deployment {
	s.Description = &v
	return s
}

// Represents a domain name.
type DomainName struct {
	_ struct{} `type:"structure"`

	// The API mapping selection expression.
	ApiMappingSelectionExpression *string `locationName:"apiMappingSelectionExpression" type:"string"`

	// The name of the DomainName resource.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// The domain name configurations.
	DomainNameConfigurations []*DomainNameConfiguration `locationName:"domainNameConfigurations" type:"list"`

	// The collection of tags associated with a domain name.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DomainName) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainName) GoString() string {
	return s.String()
}

// SetApiMappingSelectionExpression sets the ApiMappingSelectionExpression field's value.
func (s *DomainName) SetApiMappingSelectionExpression(v string) *DomainName {
	s.ApiMappingSelectionExpression = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DomainName) SetDomainName(v string) *DomainName {
	s.DomainName = &v
	return s
}

// SetDomainNameConfigurations sets the DomainNameConfigurations field's value.
func (s *DomainName) SetDomainNameConfigurations(v []*DomainNameConfiguration) *DomainName {
	s.DomainNameConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DomainName) SetTags(v map[string]*string) *DomainName {
	s.Tags = v
	return s
}

// The domain name configuration.
type DomainNameConfiguration struct {
	_ struct{} `type:"structure"`

	// A domain name for the API.
	ApiGatewayDomainName *string `locationName:"apiGatewayDomainName" type:"string"`

	// An AWS-managed certificate that will be used by the edge-optimized endpoint
	// for this domain name. AWS Certificate Manager is the only supported source.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The user-friendly name of the certificate that will be used by the edge-optimized
	// endpoint for this domain name.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The timestamp when the certificate that was used by edge-optimized endpoint
	// for this domain name was uploaded.
	CertificateUploadDate *time.Time `locationName:"certificateUploadDate" type:"timestamp" timestampFormat:"iso8601"`

	// The status of the domain name migration. The valid values are AVAILABLE and
	// UPDATING. If the status is UPDATING, the domain cannot be modified further
	// until the existing operation is complete. If it is AVAILABLE, the domain
	// can be updated.
	DomainNameStatus *string `locationName:"domainNameStatus" type:"string" enum:"DomainNameStatus"`

	// An optional text message containing detailed information about status of
	// the domain name migration.
	DomainNameStatusMessage *string `locationName:"domainNameStatusMessage" type:"string"`

	// The endpoint type.
	EndpointType *string `locationName:"endpointType" type:"string" enum:"EndpointType"`

	// The Amazon Route 53 Hosted Zone ID of the endpoint.
	HostedZoneId *string `locationName:"hostedZoneId" type:"string"`

	// The Transport Layer Security (TLS) version of the security policy for this
	// domain name. The valid values are TLS_1_0 and TLS_1_2.
	SecurityPolicy *string `locationName:"securityPolicy" type:"string" enum:"SecurityPolicy"`
}

// String returns the string representation
func (s DomainNameConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainNameConfiguration) GoString() string {
	return s.String()
}

// SetApiGatewayDomainName sets the ApiGatewayDomainName field's value.
func (s *DomainNameConfiguration) SetApiGatewayDomainName(v string) *DomainNameConfiguration {
	s.ApiGatewayDomainName = &v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *DomainNameConfiguration) SetCertificateArn(v string) *DomainNameConfiguration {
	s.CertificateArn = &v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *DomainNameConfiguration) SetCertificateName(v string) *DomainNameConfiguration {
	s.CertificateName = &v
	return s
}

// SetCertificateUploadDate sets the CertificateUploadDate field's value.
func (s *DomainNameConfiguration) SetCertificateUploadDate(v time.Time) *DomainNameConfiguration {
	s.CertificateUploadDate = &v
	return s
}

// SetDomainNameStatus sets the DomainNameStatus field's value.
func (s *DomainNameConfiguration) SetDomainNameStatus(v string) *DomainNameConfiguration {
	s.DomainNameStatus = &v
	return s
}

// SetDomainNameStatusMessage sets the DomainNameStatusMessage field's value.
func (s *DomainNameConfiguration) SetDomainNameStatusMessage(v string) *DomainNameConfiguration {
	s.DomainNameStatusMessage = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *DomainNameConfiguration) SetEndpointType(v string) *DomainNameConfiguration {
	s.EndpointType = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DomainNameConfiguration) SetHostedZoneId(v string) *DomainNameConfiguration {
	s.HostedZoneId = &v
	return s
}

// SetSecurityPolicy sets the SecurityPolicy field's value.
func (s *DomainNameConfiguration) SetSecurityPolicy(v string) *DomainNameConfiguration {
	s.SecurityPolicy = &v
	return s
}

type ExportApiInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	ExportVersion *string `location:"querystring" locationName:"exportVersion" type:"string"`

	IncludeExtensions *bool `location:"querystring" locationName:"includeExtensions" type:"boolean"`

	// OutputType is a required field
	OutputType *string `location:"querystring" locationName:"outputType" type:"string" required:"true"`

	// Specification is a required field
	Specification *string `location:"uri" locationName:"specification" type:"string" required:"true"`

	StageName *string `location:"querystring" locationName:"stageName" type:"string"`
}

// String returns the string representation
func (s ExportApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportApiInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.OutputType == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputType"))
	}
	if s.Specification == nil {
		invalidParams.Add(request.NewErrParamRequired("Specification"))
	}
	if s.Specification != nil && len(*s.Specification) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Specification", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *ExportApiInput) SetApiId(v string) *ExportApiInput {
	s.ApiId = &v
	return s
}

// SetExportVersion sets the ExportVersion field's value.
func (s *ExportApiInput) SetExportVersion(v string) *ExportApiInput {
	s.ExportVersion = &v
	return s
}

// SetIncludeExtensions sets the IncludeExtensions field's value.
func (s *ExportApiInput) SetIncludeExtensions(v bool) *ExportApiInput {
	s.IncludeExtensions = &v
	return s
}

// SetOutputType sets the OutputType field's value.
func (s *ExportApiInput) SetOutputType(v string) *ExportApiInput {
	s.OutputType = &v
	return s
}

// SetSpecification sets the Specification field's value.
func (s *ExportApiInput) SetSpecification(v string) *ExportApiInput {
	s.Specification = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *ExportApiInput) SetStageName(v string) *ExportApiInput {
	s.StageName = &v
	return s
}

type ExportApiOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// Represents an exported definition of an API in a particular output format,
	// for example, YAML. The API is serialized to the requested specification,
	// for example, OpenAPI 3.0.
	Body []byte `locationName:"body" type:"blob"`
}

// String returns the string representation
func (s ExportApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportApiOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *ExportApiOutput) SetBody(v []byte) *ExportApiOutput {
	s.Body = v
	return s
}

type GetApiInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApiInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetApiInput) SetApiId(v string) *GetApiInput {
	s.ApiId = &v
	return s
}

type GetApiMappingInput struct {
	_ struct{} `type:"structure"`

	// ApiMappingId is a required field
	ApiMappingId *string `location:"uri" locationName:"apiMappingId" type:"string" required:"true"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApiMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApiMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApiMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApiMappingInput"}
	if s.ApiMappingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiMappingId"))
	}
	if s.ApiMappingId != nil && len(*s.ApiMappingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiMappingId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiMappingId sets the ApiMappingId field's value.
func (s *GetApiMappingInput) SetApiMappingId(v string) *GetApiMappingInput {
	s.ApiMappingId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetApiMappingInput) SetDomainName(v string) *GetApiMappingInput {
	s.DomainName = &v
	return s
}

type GetApiMappingOutput struct {
	_ struct{} `type:"structure"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// The identifier.
	ApiMappingId *string `locationName:"apiMappingId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// A string with a length between [1-128].
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation
func (s GetApiMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApiMappingOutput) GoString() string {
	return s.String()
}

// SetApiId sets the ApiId field's value.
func (s *GetApiMappingOutput) SetApiId(v string) *GetApiMappingOutput {
	s.ApiId = &v
	return s
}

// SetApiMappingId sets the ApiMappingId field's value.
func (s *GetApiMappingOutput) SetApiMappingId(v string) *GetApiMappingOutput {
	s.ApiMappingId = &v
	return s
}

// SetApiMappingKey sets the ApiMappingKey field's value.
func (s *GetApiMappingOutput) SetApiMappingKey(v string) *GetApiMappingOutput {
	s.ApiMappingKey = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *GetApiMappingOutput) SetStage(v string) *GetApiMappingOutput {
	s.Stage = &v
	return s
}

type GetApiMappingsInput struct {
	_ struct{} `type:"structure"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetApiMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApiMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApiMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApiMappingsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetApiMappingsInput) SetDomainName(v string) *GetApiMappingsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetApiMappingsInput) SetMaxResults(v string) *GetApiMappingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetApiMappingsInput) SetNextToken(v string) *GetApiMappingsInput {
	s.NextToken = &v
	return s
}

type GetApiMappingsOutput struct {
	_ struct{} `type:"structure"`

	Items []*ApiMapping `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetApiMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApiMappingsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetApiMappingsOutput) SetItems(v []*ApiMapping) *GetApiMappingsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetApiMappingsOutput) SetNextToken(v string) *GetApiMappingsOutput {
	s.NextToken = &v
	return s
}

type GetApiOutput struct {
	_ struct{} `type:"structure"`

	ApiEndpoint *string `locationName:"apiEndpoint" type:"string"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
	// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
	// for more information.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	ImportInfo []*string `locationName:"importInfo" type:"list"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// Represents a protocol type.
	ProtocolType *string `locationName:"protocolType" type:"string" enum:"ProtocolType"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A string with a length between [1-64].
	Version *string `locationName:"version" type:"string"`

	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s GetApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApiOutput) GoString() string {
	return s.String()
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *GetApiOutput) SetApiEndpoint(v string) *GetApiOutput {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *GetApiOutput) SetApiId(v string) *GetApiOutput {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *GetApiOutput) SetApiKeySelectionExpression(v string) *GetApiOutput {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *GetApiOutput) SetCorsConfiguration(v *Cors) *GetApiOutput {
	s.CorsConfiguration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetApiOutput) SetCreatedDate(v time.Time) *GetApiOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetApiOutput) SetDescription(v string) *GetApiOutput {
	s.Description = &v
	return s
}

// SetDisableSchemaValidation sets the DisableSchemaValidation field's value.
func (s *GetApiOutput) SetDisableSchemaValidation(v bool) *GetApiOutput {
	s.DisableSchemaValidation = &v
	return s
}

// SetImportInfo sets the ImportInfo field's value.
func (s *GetApiOutput) SetImportInfo(v []*string) *GetApiOutput {
	s.ImportInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *GetApiOutput) SetName(v string) *GetApiOutput {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *GetApiOutput) SetProtocolType(v string) *GetApiOutput {
	s.ProtocolType = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *GetApiOutput) SetRouteSelectionExpression(v string) *GetApiOutput {
	s.RouteSelectionExpression = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetApiOutput) SetTags(v map[string]*string) *GetApiOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetApiOutput) SetVersion(v string) *GetApiOutput {
	s.Version = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *GetApiOutput) SetWarnings(v []*string) *GetApiOutput {
	s.Warnings = v
	return s
}

type GetApisInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetApisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApisInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetApisInput) SetMaxResults(v string) *GetApisInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetApisInput) SetNextToken(v string) *GetApisInput {
	s.NextToken = &v
	return s
}

type GetApisOutput struct {
	_ struct{} `type:"structure"`

	Items []*Api `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetApisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApisOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetApisOutput) SetItems(v []*Api) *GetApisOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetApisOutput) SetNextToken(v string) *GetApisOutput {
	s.NextToken = &v
	return s
}

type GetAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// AuthorizerId is a required field
	AuthorizerId *string `location:"uri" locationName:"authorizerId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAuthorizerInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.AuthorizerId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerId"))
	}
	if s.AuthorizerId != nil && len(*s.AuthorizerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetAuthorizerInput) SetApiId(v string) *GetAuthorizerInput {
	s.ApiId = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *GetAuthorizerInput) SetAuthorizerId(v string) *GetAuthorizerInput {
	s.AuthorizerId = &v
	return s
}

type GetAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// Represents an Amazon Resource Name (ARN).
	AuthorizerCredentialsArn *string `locationName:"authorizerCredentialsArn" type:"string"`

	// The identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// An integer with a value between [0-3600].
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function
	// using incoming request parameters. For HTTP APIs, specify JWT to use JSON
	// Web Tokens.
	AuthorizerType *string `locationName:"authorizerType" type:"string" enum:"AuthorizerType"`

	// A string representation of a URI with a length between [1-2048].
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identity source for which authorization is requested. For the REQUEST
	// authorizer, this is required when authorization caching is enabled. The value
	// is a comma-separated string of one or more mapping expressions of the specified
	// request parameters. For example, if an Auth header, a Name query string parameter
	// are defined as identity sources, this value is $method.request.header.Auth,
	// $method.request.querystring.Name. These parameters will be used to derive
	// the authorization caching key and to perform runtime validation of the REQUEST
	// authorizer by verifying all of the identity-related request parameters are
	// present, not null and non-empty. Only when this is true does the authorizer
	// invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized
	// response without calling the Lambda function. The valid value is a string
	// of comma-separated mapping expressions of the specified request parameters.
	// When the authorization caching is not enabled, this property is optional.
	IdentitySource []*string `locationName:"identitySource" type:"list"`

	// A string with a length between [0-1024].
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// Represents the configuration of a JWT authorizer. Required for the JWT authorizer
	// type. Supported only for HTTP APIs.
	JwtConfiguration *JWTConfiguration `locationName:"jwtConfiguration" type:"structure"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s GetAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorizerCredentialsArn sets the AuthorizerCredentialsArn field's value.
func (s *GetAuthorizerOutput) SetAuthorizerCredentialsArn(v string) *GetAuthorizerOutput {
	s.AuthorizerCredentialsArn = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *GetAuthorizerOutput) SetAuthorizerId(v string) *GetAuthorizerOutput {
	s.AuthorizerId = &v
	return s
}

// SetAuthorizerResultTtlInSeconds sets the AuthorizerResultTtlInSeconds field's value.
func (s *GetAuthorizerOutput) SetAuthorizerResultTtlInSeconds(v int64) *GetAuthorizerOutput {
	s.AuthorizerResultTtlInSeconds = &v
	return s
}

// SetAuthorizerType sets the AuthorizerType field's value.
func (s *GetAuthorizerOutput) SetAuthorizerType(v string) *GetAuthorizerOutput {
	s.AuthorizerType = &v
	return s
}

// SetAuthorizerUri sets the AuthorizerUri field's value.
func (s *GetAuthorizerOutput) SetAuthorizerUri(v string) *GetAuthorizerOutput {
	s.AuthorizerUri = &v
	return s
}

// SetIdentitySource sets the IdentitySource field's value.
func (s *GetAuthorizerOutput) SetIdentitySource(v []*string) *GetAuthorizerOutput {
	s.IdentitySource = v
	return s
}

// SetIdentityValidationExpression sets the IdentityValidationExpression field's value.
func (s *GetAuthorizerOutput) SetIdentityValidationExpression(v string) *GetAuthorizerOutput {
	s.IdentityValidationExpression = &v
	return s
}

// SetJwtConfiguration sets the JwtConfiguration field's value.
func (s *GetAuthorizerOutput) SetJwtConfiguration(v *JWTConfiguration) *GetAuthorizerOutput {
	s.JwtConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *GetAuthorizerOutput) SetName(v string) *GetAuthorizerOutput {
	s.Name = &v
	return s
}

type GetAuthorizersInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetAuthorizersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAuthorizersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthorizersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAuthorizersInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetAuthorizersInput) SetApiId(v string) *GetAuthorizersInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAuthorizersInput) SetMaxResults(v string) *GetAuthorizersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAuthorizersInput) SetNextToken(v string) *GetAuthorizersInput {
	s.NextToken = &v
	return s
}

type GetAuthorizersOutput struct {
	_ struct{} `type:"structure"`

	Items []*Authorizer `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetAuthorizersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAuthorizersOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetAuthorizersOutput) SetItems(v []*Authorizer) *GetAuthorizersOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAuthorizersOutput) SetNextToken(v string) *GetAuthorizersOutput {
	s.NextToken = &v
	return s
}

type GetDeploymentInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deploymentId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetDeploymentInput) SetApiId(v string) *GetDeploymentInput {
	s.ApiId = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentInput) SetDeploymentId(v string) *GetDeploymentInput {
	s.DeploymentId = &v
	return s
}

type GetDeploymentOutput struct {
	_ struct{} `type:"structure"`

	AutoDeployed *bool `locationName:"autoDeployed" type:"boolean"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// Represents a deployment status.
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" enum:"DeploymentStatus"`

	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s GetDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// SetAutoDeployed sets the AutoDeployed field's value.
func (s *GetDeploymentOutput) SetAutoDeployed(v bool) *GetDeploymentOutput {
	s.AutoDeployed = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetDeploymentOutput) SetCreatedDate(v time.Time) *GetDeploymentOutput {
	s.CreatedDate = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentOutput) SetDeploymentId(v string) *GetDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *GetDeploymentOutput) SetDeploymentStatus(v string) *GetDeploymentOutput {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *GetDeploymentOutput) SetDeploymentStatusMessage(v string) *GetDeploymentOutput {
	s.DeploymentStatusMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDeploymentOutput) SetDescription(v string) *GetDeploymentOutput {
	s.Description = &v
	return s
}

type GetDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentsInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetDeploymentsInput) SetApiId(v string) *GetDeploymentsInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDeploymentsInput) SetMaxResults(v string) *GetDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDeploymentsInput) SetNextToken(v string) *GetDeploymentsInput {
	s.NextToken = &v
	return s
}

type GetDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	Items []*Deployment `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetDeploymentsOutput) SetItems(v []*Deployment) *GetDeploymentsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDeploymentsOutput) SetNextToken(v string) *GetDeploymentsOutput {
	s.NextToken = &v
	return s
}

type GetDomainNameInput struct {
	_ struct{} `type:"structure"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainNameInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainNameInput) SetDomainName(v string) *GetDomainNameInput {
	s.DomainName = &v
	return s
}

type GetDomainNameOutput struct {
	_ struct{} `type:"structure"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiMappingSelectionExpression *string `locationName:"apiMappingSelectionExpression" type:"string"`

	// A string with a length between [1-512].
	DomainName *string `locationName:"domainName" type:"string"`

	// The domain name configurations.
	DomainNameConfigurations []*DomainNameConfiguration `locationName:"domainNameConfigurations" type:"list"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetDomainNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainNameOutput) GoString() string {
	return s.String()
}

// SetApiMappingSelectionExpression sets the ApiMappingSelectionExpression field's value.
func (s *GetDomainNameOutput) SetApiMappingSelectionExpression(v string) *GetDomainNameOutput {
	s.ApiMappingSelectionExpression = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainNameOutput) SetDomainName(v string) *GetDomainNameOutput {
	s.DomainName = &v
	return s
}

// SetDomainNameConfigurations sets the DomainNameConfigurations field's value.
func (s *GetDomainNameOutput) SetDomainNameConfigurations(v []*DomainNameConfiguration) *GetDomainNameOutput {
	s.DomainNameConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDomainNameOutput) SetTags(v map[string]*string) *GetDomainNameOutput {
	s.Tags = v
	return s
}

type GetDomainNamesInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainNamesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDomainNamesInput) SetMaxResults(v string) *GetDomainNamesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDomainNamesInput) SetNextToken(v string) *GetDomainNamesInput {
	s.NextToken = &v
	return s
}

type GetDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	Items []*DomainName `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainNamesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetDomainNamesOutput) SetItems(v []*DomainName) *GetDomainNamesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDomainNamesOutput) SetNextToken(v string) *GetDomainNamesOutput {
	s.NextToken = &v
	return s
}

type GetIntegrationInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntegrationInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.IntegrationId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationId"))
	}
	if s.IntegrationId != nil && len(*s.IntegrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetIntegrationInput) SetApiId(v string) *GetIntegrationInput {
	s.ApiId = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *GetIntegrationInput) SetIntegrationId(v string) *GetIntegrationInput {
	s.IntegrationId = &v
	return s
}

type GetIntegrationOutput struct {
	_ struct{} `type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	// A string with a length between [1-1024].
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// Represents a connection type.
	ConnectionType *string `locationName:"connectionType" type:"string" enum:"ConnectionType"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// Represents an Amazon Resource Name (ARN).
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The identifier.
	IntegrationId *string `locationName:"integrationId" type:"string"`

	// A string with a length between [1-64].
	IntegrationMethod *string `locationName:"integrationMethod" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	IntegrationResponseSelectionExpression *string `locationName:"integrationResponseSelectionExpression" type:"string"`

	// Represents an API method integration type.
	IntegrationType *string `locationName:"integrationType" type:"string" enum:"IntegrationType"`

	// A string representation of a URI with a length between [1-2048].
	IntegrationUri *string `locationName:"integrationUri" type:"string"`

	// Represents passthrough behavior for an integration response. Supported only
	// for WebSocket APIs.
	PassthroughBehavior *string `locationName:"passthroughBehavior" type:"string" enum:"PassthroughBehavior"`

	// A string with a length between [1-64].
	PayloadFormatVersion *string `locationName:"payloadFormatVersion" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`

	// An integer with a value between [50-30000].
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" min:"50" type:"integer"`

	// The TLS configuration for a private integration. If you specify a TLS configuration,
	// private integration traffic uses the HTTPS protocol. Supported only for HTTP
	// APIs.
	TlsConfig *TlsConfig `locationName:"tlsConfig" type:"structure"`
}

// String returns the string representation
func (s GetIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationOutput) GoString() string {
	return s.String()
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *GetIntegrationOutput) SetApiGatewayManaged(v bool) *GetIntegrationOutput {
	s.ApiGatewayManaged = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *GetIntegrationOutput) SetConnectionId(v string) *GetIntegrationOutput {
	s.ConnectionId = &v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *GetIntegrationOutput) SetConnectionType(v string) *GetIntegrationOutput {
	s.ConnectionType = &v
	return s
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *GetIntegrationOutput) SetContentHandlingStrategy(v string) *GetIntegrationOutput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetCredentialsArn sets the CredentialsArn field's value.
func (s *GetIntegrationOutput) SetCredentialsArn(v string) *GetIntegrationOutput {
	s.CredentialsArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetIntegrationOutput) SetDescription(v string) *GetIntegrationOutput {
	s.Description = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *GetIntegrationOutput) SetIntegrationId(v string) *GetIntegrationOutput {
	s.IntegrationId = &v
	return s
}

// SetIntegrationMethod sets the IntegrationMethod field's value.
func (s *GetIntegrationOutput) SetIntegrationMethod(v string) *GetIntegrationOutput {
	s.IntegrationMethod = &v
	return s
}

// SetIntegrationResponseSelectionExpression sets the IntegrationResponseSelectionExpression field's value.
func (s *GetIntegrationOutput) SetIntegrationResponseSelectionExpression(v string) *GetIntegrationOutput {
	s.IntegrationResponseSelectionExpression = &v
	return s
}

// SetIntegrationType sets the IntegrationType field's value.
func (s *GetIntegrationOutput) SetIntegrationType(v string) *GetIntegrationOutput {
	s.IntegrationType = &v
	return s
}

// SetIntegrationUri sets the IntegrationUri field's value.
func (s *GetIntegrationOutput) SetIntegrationUri(v string) *GetIntegrationOutput {
	s.IntegrationUri = &v
	return s
}

// SetPassthroughBehavior sets the PassthroughBehavior field's value.
func (s *GetIntegrationOutput) SetPassthroughBehavior(v string) *GetIntegrationOutput {
	s.PassthroughBehavior = &v
	return s
}

// SetPayloadFormatVersion sets the PayloadFormatVersion field's value.
func (s *GetIntegrationOutput) SetPayloadFormatVersion(v string) *GetIntegrationOutput {
	s.PayloadFormatVersion = &v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *GetIntegrationOutput) SetRequestParameters(v map[string]*string) *GetIntegrationOutput {
	s.RequestParameters = v
	return s
}

// SetRequestTemplates sets the RequestTemplates field's value.
func (s *GetIntegrationOutput) SetRequestTemplates(v map[string]*string) *GetIntegrationOutput {
	s.RequestTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *GetIntegrationOutput) SetTemplateSelectionExpression(v string) *GetIntegrationOutput {
	s.TemplateSelectionExpression = &v
	return s
}

// SetTimeoutInMillis sets the TimeoutInMillis field's value.
func (s *GetIntegrationOutput) SetTimeoutInMillis(v int64) *GetIntegrationOutput {
	s.TimeoutInMillis = &v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *GetIntegrationOutput) SetTlsConfig(v *TlsConfig) *GetIntegrationOutput {
	s.TlsConfig = v
	return s
}

type GetIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`

	// IntegrationResponseId is a required field
	IntegrationResponseId *string `location:"uri" locationName:"integrationResponseId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntegrationResponseInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.IntegrationId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationId"))
	}
	if s.IntegrationId != nil && len(*s.IntegrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationId", 1))
	}
	if s.IntegrationResponseId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationResponseId"))
	}
	if s.IntegrationResponseId != nil && len(*s.IntegrationResponseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationResponseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetIntegrationResponseInput) SetApiId(v string) *GetIntegrationResponseInput {
	s.ApiId = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *GetIntegrationResponseInput) SetIntegrationId(v string) *GetIntegrationResponseInput {
	s.IntegrationId = &v
	return s
}

// SetIntegrationResponseId sets the IntegrationResponseId field's value.
func (s *GetIntegrationResponseInput) SetIntegrationResponseId(v string) *GetIntegrationResponseInput {
	s.IntegrationResponseId = &v
	return s
}

type GetIntegrationResponseOutput struct {
	_ struct{} `type:"structure"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// The identifier.
	IntegrationResponseId *string `locationName:"integrationResponseId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	IntegrationResponseKey *string `locationName:"integrationResponseKey" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`
}

// String returns the string representation
func (s GetIntegrationResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationResponseOutput) GoString() string {
	return s.String()
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *GetIntegrationResponseOutput) SetContentHandlingStrategy(v string) *GetIntegrationResponseOutput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetIntegrationResponseId sets the IntegrationResponseId field's value.
func (s *GetIntegrationResponseOutput) SetIntegrationResponseId(v string) *GetIntegrationResponseOutput {
	s.IntegrationResponseId = &v
	return s
}

// SetIntegrationResponseKey sets the IntegrationResponseKey field's value.
func (s *GetIntegrationResponseOutput) SetIntegrationResponseKey(v string) *GetIntegrationResponseOutput {
	s.IntegrationResponseKey = &v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *GetIntegrationResponseOutput) SetResponseParameters(v map[string]*string) *GetIntegrationResponseOutput {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *GetIntegrationResponseOutput) SetResponseTemplates(v map[string]*string) *GetIntegrationResponseOutput {
	s.ResponseTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *GetIntegrationResponseOutput) SetTemplateSelectionExpression(v string) *GetIntegrationResponseOutput {
	s.TemplateSelectionExpression = &v
	return s
}

type GetIntegrationResponsesInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntegrationResponsesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationResponsesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationResponsesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntegrationResponsesInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.IntegrationId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationId"))
	}
	if s.IntegrationId != nil && len(*s.IntegrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetIntegrationResponsesInput) SetApiId(v string) *GetIntegrationResponsesInput {
	s.ApiId = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *GetIntegrationResponsesInput) SetIntegrationId(v string) *GetIntegrationResponsesInput {
	s.IntegrationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetIntegrationResponsesInput) SetMaxResults(v string) *GetIntegrationResponsesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetIntegrationResponsesInput) SetNextToken(v string) *GetIntegrationResponsesInput {
	s.NextToken = &v
	return s
}

type GetIntegrationResponsesOutput struct {
	_ struct{} `type:"structure"`

	Items []*IntegrationResponse `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntegrationResponsesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationResponsesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetIntegrationResponsesOutput) SetItems(v []*IntegrationResponse) *GetIntegrationResponsesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetIntegrationResponsesOutput) SetNextToken(v string) *GetIntegrationResponsesOutput {
	s.NextToken = &v
	return s
}

type GetIntegrationsInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntegrationsInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetIntegrationsInput) SetApiId(v string) *GetIntegrationsInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetIntegrationsInput) SetMaxResults(v string) *GetIntegrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetIntegrationsInput) SetNextToken(v string) *GetIntegrationsInput {
	s.NextToken = &v
	return s
}

type GetIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	Items []*Integration `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetIntegrationsOutput) SetItems(v []*Integration) *GetIntegrationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetIntegrationsOutput) SetNextToken(v string) *GetIntegrationsOutput {
	s.NextToken = &v
	return s
}

type GetModelInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// ModelId is a required field
	ModelId *string `location:"uri" locationName:"modelId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetModelInput) SetApiId(v string) *GetModelInput {
	s.ApiId = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *GetModelInput) SetModelId(v string) *GetModelInput {
	s.ModelId = &v
	return s
}

type GetModelOutput struct {
	_ struct{} `type:"structure"`

	// A string with a length between [1-256].
	ContentType *string `locationName:"contentType" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The identifier.
	ModelId *string `locationName:"modelId" type:"string"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A string with a length between [0-32768].
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s GetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *GetModelOutput) SetContentType(v string) *GetModelOutput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetModelOutput) SetDescription(v string) *GetModelOutput {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *GetModelOutput) SetModelId(v string) *GetModelOutput {
	s.ModelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetModelOutput) SetName(v string) *GetModelOutput {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *GetModelOutput) SetSchema(v string) *GetModelOutput {
	s.Schema = &v
	return s
}

type GetModelTemplateInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// ModelId is a required field
	ModelId *string `location:"uri" locationName:"modelId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelTemplateInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetModelTemplateInput) SetApiId(v string) *GetModelTemplateInput {
	s.ApiId = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *GetModelTemplateInput) SetModelId(v string) *GetModelTemplateInput {
	s.ModelId = &v
	return s
}

type GetModelTemplateOutput struct {
	_ struct{} `type:"structure"`

	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s GetModelTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelTemplateOutput) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *GetModelTemplateOutput) SetValue(v string) *GetModelTemplateOutput {
	s.Value = &v
	return s
}

type GetModelsInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelsInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetModelsInput) SetApiId(v string) *GetModelsInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetModelsInput) SetMaxResults(v string) *GetModelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetModelsInput) SetNextToken(v string) *GetModelsInput {
	s.NextToken = &v
	return s
}

type GetModelsOutput struct {
	_ struct{} `type:"structure"`

	Items []*Model `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetModelsOutput) SetItems(v []*Model) *GetModelsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetModelsOutput) SetNextToken(v string) *GetModelsOutput {
	s.NextToken = &v
	return s
}

type GetRouteInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRouteInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteId"))
	}
	if s.RouteId != nil && len(*s.RouteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetRouteInput) SetApiId(v string) *GetRouteInput {
	s.ApiId = &v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *GetRouteInput) SetRouteId(v string) *GetRouteInput {
	s.RouteId = &v
	return s
}

type GetRouteOutput struct {
	_ struct{} `type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on a route. The scopes are used
	// with a JWT authorizer to authorize the method invocation. The authorization
	// works by matching the route scopes against the scopes parsed from the access
	// token in the incoming request. The method invocation is authorized if any
	// route scope matches a claimed scope in the access token. Otherwise, the invocation
	// is not authorized. When the route scope is configured, the client must provide
	// an access token instead of an identity token for authorization purposes.
	AuthorizationScopes []*string `locationName:"authorizationScopes" type:"list"`

	// The authorization type. For WebSocket APIs, valid values are NONE for open
	// access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda
	// authorizer. For HTTP APIs, valid values are NONE for open access, or JWT
	// for using JSON Web Tokens.
	AuthorizationType *string `locationName:"authorizationType" type:"string" enum:"AuthorizationType"`

	// The identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// A string with a length between [1-64].
	OperationName *string `locationName:"operationName" type:"string"`

	// The route models.
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// The route parameters.
	RequestParameters map[string]*ParameterConstraints `locationName:"requestParameters" type:"map"`

	// The identifier.
	RouteId *string `locationName:"routeId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteKey *string `locationName:"routeKey" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteResponseSelectionExpression *string `locationName:"routeResponseSelectionExpression" type:"string"`

	// A string with a length between [1-128].
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s GetRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRouteOutput) GoString() string {
	return s.String()
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *GetRouteOutput) SetApiGatewayManaged(v bool) *GetRouteOutput {
	s.ApiGatewayManaged = &v
	return s
}

// SetApiKeyRequired sets the ApiKeyRequired field's value.
func (s *GetRouteOutput) SetApiKeyRequired(v bool) *GetRouteOutput {
	s.ApiKeyRequired = &v
	return s
}

// SetAuthorizationScopes sets the AuthorizationScopes field's value.
func (s *GetRouteOutput) SetAuthorizationScopes(v []*string) *GetRouteOutput {
	s.AuthorizationScopes = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *GetRouteOutput) SetAuthorizationType(v string) *GetRouteOutput {
	s.AuthorizationType = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *GetRouteOutput) SetAuthorizerId(v string) *GetRouteOutput {
	s.AuthorizerId = &v
	return s
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *GetRouteOutput) SetModelSelectionExpression(v string) *GetRouteOutput {
	s.ModelSelectionExpression = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *GetRouteOutput) SetOperationName(v string) *GetRouteOutput {
	s.OperationName = &v
	return s
}

// SetRequestModels sets the RequestModels field's value.
func (s *GetRouteOutput) SetRequestModels(v map[string]*string) *GetRouteOutput {
	s.RequestModels = v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *GetRouteOutput) SetRequestParameters(v map[string]*ParameterConstraints) *GetRouteOutput {
	s.RequestParameters = v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *GetRouteOutput) SetRouteId(v string) *GetRouteOutput {
	s.RouteId = &v
	return s
}

// SetRouteKey sets the RouteKey field's value.
func (s *GetRouteOutput) SetRouteKey(v string) *GetRouteOutput {
	s.RouteKey = &v
	return s
}

// SetRouteResponseSelectionExpression sets the RouteResponseSelectionExpression field's value.
func (s *GetRouteOutput) SetRouteResponseSelectionExpression(v string) *GetRouteOutput {
	s.RouteResponseSelectionExpression = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *GetRouteOutput) SetTarget(v string) *GetRouteOutput {
	s.Target = &v
	return s
}

type GetRouteResponseInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`

	// RouteResponseId is a required field
	RouteResponseId *string `location:"uri" locationName:"routeResponseId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRouteResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRouteResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRouteResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRouteResponseInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteId"))
	}
	if s.RouteId != nil && len(*s.RouteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteId", 1))
	}
	if s.RouteResponseId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteResponseId"))
	}
	if s.RouteResponseId != nil && len(*s.RouteResponseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteResponseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetRouteResponseInput) SetApiId(v string) *GetRouteResponseInput {
	s.ApiId = &v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *GetRouteResponseInput) SetRouteId(v string) *GetRouteResponseInput {
	s.RouteId = &v
	return s
}

// SetRouteResponseId sets the RouteResponseId field's value.
func (s *GetRouteResponseInput) SetRouteResponseId(v string) *GetRouteResponseInput {
	s.RouteResponseId = &v
	return s
}

type GetRouteResponseOutput struct {
	_ struct{} `type:"structure"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// The route models.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// The route parameters.
	ResponseParameters map[string]*ParameterConstraints `locationName:"responseParameters" type:"map"`

	// The identifier.
	RouteResponseId *string `locationName:"routeResponseId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteResponseKey *string `locationName:"routeResponseKey" type:"string"`
}

// String returns the string representation
func (s GetRouteResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRouteResponseOutput) GoString() string {
	return s.String()
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *GetRouteResponseOutput) SetModelSelectionExpression(v string) *GetRouteResponseOutput {
	s.ModelSelectionExpression = &v
	return s
}

// SetResponseModels sets the ResponseModels field's value.
func (s *GetRouteResponseOutput) SetResponseModels(v map[string]*string) *GetRouteResponseOutput {
	s.ResponseModels = v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *GetRouteResponseOutput) SetResponseParameters(v map[string]*ParameterConstraints) *GetRouteResponseOutput {
	s.ResponseParameters = v
	return s
}

// SetRouteResponseId sets the RouteResponseId field's value.
func (s *GetRouteResponseOutput) SetRouteResponseId(v string) *GetRouteResponseOutput {
	s.RouteResponseId = &v
	return s
}

// SetRouteResponseKey sets the RouteResponseKey field's value.
func (s *GetRouteResponseOutput) SetRouteResponseKey(v string) *GetRouteResponseOutput {
	s.RouteResponseKey = &v
	return s
}

type GetRouteResponsesInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRouteResponsesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRouteResponsesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRouteResponsesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRouteResponsesInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteId"))
	}
	if s.RouteId != nil && len(*s.RouteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetRouteResponsesInput) SetApiId(v string) *GetRouteResponsesInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetRouteResponsesInput) SetMaxResults(v string) *GetRouteResponsesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetRouteResponsesInput) SetNextToken(v string) *GetRouteResponsesInput {
	s.NextToken = &v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *GetRouteResponsesInput) SetRouteId(v string) *GetRouteResponsesInput {
	s.RouteId = &v
	return s
}

type GetRouteResponsesOutput struct {
	_ struct{} `type:"structure"`

	Items []*RouteResponse `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetRouteResponsesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRouteResponsesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetRouteResponsesOutput) SetItems(v []*RouteResponse) *GetRouteResponsesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetRouteResponsesOutput) SetNextToken(v string) *GetRouteResponsesOutput {
	s.NextToken = &v
	return s
}

type GetRoutesInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRoutesInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetRoutesInput) SetApiId(v string) *GetRoutesInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetRoutesInput) SetMaxResults(v string) *GetRoutesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetRoutesInput) SetNextToken(v string) *GetRoutesInput {
	s.NextToken = &v
	return s
}

type GetRoutesOutput struct {
	_ struct{} `type:"structure"`

	Items []*Route `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoutesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetRoutesOutput) SetItems(v []*Route) *GetRoutesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetRoutesOutput) SetNextToken(v string) *GetRoutesOutput {
	s.NextToken = &v
	return s
}

type GetStageInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// StageName is a required field
	StageName *string `location:"uri" locationName:"stageName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStageInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetStageInput) SetApiId(v string) *GetStageInput {
	s.ApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *GetStageInput) SetStageName(v string) *GetStageInput {
	s.StageName = &v
	return s
}

type GetStageOutput struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in a stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// Represents a collection of route settings.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	LastDeploymentStatusMessage *string `locationName:"lastDeploymentStatusMessage" type:"string"`

	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601"`

	// The route settings map.
	RouteSettings map[string]*RouteSettings `locationName:"routeSettings" type:"map"`

	// A string with a length between [1-128].
	StageName *string `locationName:"stageName" type:"string"`

	// The stage variable map.
	StageVariables map[string]*string `locationName:"stageVariables" type:"map"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStageOutput) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *GetStageOutput) SetAccessLogSettings(v *AccessLogSettings) *GetStageOutput {
	s.AccessLogSettings = v
	return s
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *GetStageOutput) SetApiGatewayManaged(v bool) *GetStageOutput {
	s.ApiGatewayManaged = &v
	return s
}

// SetAutoDeploy sets the AutoDeploy field's value.
func (s *GetStageOutput) SetAutoDeploy(v bool) *GetStageOutput {
	s.AutoDeploy = &v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *GetStageOutput) SetClientCertificateId(v string) *GetStageOutput {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetStageOutput) SetCreatedDate(v time.Time) *GetStageOutput {
	s.CreatedDate = &v
	return s
}

// SetDefaultRouteSettings sets the DefaultRouteSettings field's value.
func (s *GetStageOutput) SetDefaultRouteSettings(v *RouteSettings) *GetStageOutput {
	s.DefaultRouteSettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetStageOutput) SetDeploymentId(v string) *GetStageOutput {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetStageOutput) SetDescription(v string) *GetStageOutput {
	s.Description = &v
	return s
}

// SetLastDeploymentStatusMessage sets the LastDeploymentStatusMessage field's value.
func (s *GetStageOutput) SetLastDeploymentStatusMessage(v string) *GetStageOutput {
	s.LastDeploymentStatusMessage = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *GetStageOutput) SetLastUpdatedDate(v time.Time) *GetStageOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetRouteSettings sets the RouteSettings field's value.
func (s *GetStageOutput) SetRouteSettings(v map[string]*RouteSettings) *GetStageOutput {
	s.RouteSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *GetStageOutput) SetStageName(v string) *GetStageOutput {
	s.StageName = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *GetStageOutput) SetStageVariables(v map[string]*string) *GetStageOutput {
	s.StageVariables = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetStageOutput) SetTags(v map[string]*string) *GetStageOutput {
	s.Tags = v
	return s
}

type GetStagesInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetStagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStagesInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *GetStagesInput) SetApiId(v string) *GetStagesInput {
	s.ApiId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetStagesInput) SetMaxResults(v string) *GetStagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetStagesInput) SetNextToken(v string) *GetStagesInput {
	s.NextToken = &v
	return s
}

type GetStagesOutput struct {
	_ struct{} `type:"structure"`

	Items []*Stage `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetStagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStagesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetStagesOutput) SetItems(v []*Stage) *GetStagesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetStagesOutput) SetNextToken(v string) *GetStagesOutput {
	s.NextToken = &v
	return s
}

type GetTagsInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetTagsInput) SetResourceArn(v string) *GetTagsInput {
	s.ResourceArn = &v
	return s
}

type GetTagsOutput struct {
	_ struct{} `type:"structure"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *GetTagsOutput) SetTags(v map[string]*string) *GetTagsOutput {
	s.Tags = v
	return s
}

type GetVpcLinkInput struct {
	_ struct{} `type:"structure"`

	// VpcLinkId is a required field
	VpcLinkId *string `location:"uri" locationName:"vpcLinkId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVpcLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVpcLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVpcLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVpcLinkInput"}
	if s.VpcLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcLinkId"))
	}
	if s.VpcLinkId != nil && len(*s.VpcLinkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcLinkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *GetVpcLinkInput) SetVpcLinkId(v string) *GetVpcLinkInput {
	s.VpcLinkId = &v
	return s
}

type GetVpcLinkOutput struct {
	_ struct{} `type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A list of security group IDs for the VPC link.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// A list of subnet IDs to include in the VPC link.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The identifier.
	VpcLinkId *string `locationName:"vpcLinkId" type:"string"`

	// The status of the VPC link.
	VpcLinkStatus *string `locationName:"vpcLinkStatus" type:"string" enum:"VpcLinkStatus"`

	// A string with a length between [0-1024].
	VpcLinkStatusMessage *string `locationName:"vpcLinkStatusMessage" type:"string"`

	// The version of the VPC link.
	VpcLinkVersion *string `locationName:"vpcLinkVersion" type:"string" enum:"VpcLinkVersion"`
}

// String returns the string representation
func (s GetVpcLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVpcLinkOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetVpcLinkOutput) SetCreatedDate(v time.Time) *GetVpcLinkOutput {
	s.CreatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetVpcLinkOutput) SetName(v string) *GetVpcLinkOutput {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *GetVpcLinkOutput) SetSecurityGroupIds(v []*string) *GetVpcLinkOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *GetVpcLinkOutput) SetSubnetIds(v []*string) *GetVpcLinkOutput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetVpcLinkOutput) SetTags(v map[string]*string) *GetVpcLinkOutput {
	s.Tags = v
	return s
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *GetVpcLinkOutput) SetVpcLinkId(v string) *GetVpcLinkOutput {
	s.VpcLinkId = &v
	return s
}

// SetVpcLinkStatus sets the VpcLinkStatus field's value.
func (s *GetVpcLinkOutput) SetVpcLinkStatus(v string) *GetVpcLinkOutput {
	s.VpcLinkStatus = &v
	return s
}

// SetVpcLinkStatusMessage sets the VpcLinkStatusMessage field's value.
func (s *GetVpcLinkOutput) SetVpcLinkStatusMessage(v string) *GetVpcLinkOutput {
	s.VpcLinkStatusMessage = &v
	return s
}

// SetVpcLinkVersion sets the VpcLinkVersion field's value.
func (s *GetVpcLinkOutput) SetVpcLinkVersion(v string) *GetVpcLinkOutput {
	s.VpcLinkVersion = &v
	return s
}

type GetVpcLinksInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetVpcLinksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVpcLinksInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetVpcLinksInput) SetMaxResults(v string) *GetVpcLinksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetVpcLinksInput) SetNextToken(v string) *GetVpcLinksInput {
	s.NextToken = &v
	return s
}

type GetVpcLinksOutput struct {
	_ struct{} `type:"structure"`

	Items []*VpcLink `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetVpcLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVpcLinksOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetVpcLinksOutput) SetItems(v []*VpcLink) *GetVpcLinksOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetVpcLinksOutput) SetNextToken(v string) *GetVpcLinksOutput {
	s.NextToken = &v
	return s
}

type ImportApiInput struct {
	_ struct{} `type:"structure"`

	Basepath *string `location:"querystring" locationName:"basepath" type:"string"`

	// Body is a required field
	Body *string `locationName:"body" type:"string" required:"true"`

	FailOnWarnings *bool `location:"querystring" locationName:"failOnWarnings" type:"boolean"`
}

// String returns the string representation
func (s ImportApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportApiInput"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasepath sets the Basepath field's value.
func (s *ImportApiInput) SetBasepath(v string) *ImportApiInput {
	s.Basepath = &v
	return s
}

// SetBody sets the Body field's value.
func (s *ImportApiInput) SetBody(v string) *ImportApiInput {
	s.Body = &v
	return s
}

// SetFailOnWarnings sets the FailOnWarnings field's value.
func (s *ImportApiInput) SetFailOnWarnings(v bool) *ImportApiInput {
	s.FailOnWarnings = &v
	return s
}

type ImportApiOutput struct {
	_ struct{} `type:"structure"`

	ApiEndpoint *string `locationName:"apiEndpoint" type:"string"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
	// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
	// for more information.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	ImportInfo []*string `locationName:"importInfo" type:"list"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// Represents a protocol type.
	ProtocolType *string `locationName:"protocolType" type:"string" enum:"ProtocolType"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A string with a length between [1-64].
	Version *string `locationName:"version" type:"string"`

	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s ImportApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportApiOutput) GoString() string {
	return s.String()
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *ImportApiOutput) SetApiEndpoint(v string) *ImportApiOutput {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *ImportApiOutput) SetApiId(v string) *ImportApiOutput {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *ImportApiOutput) SetApiKeySelectionExpression(v string) *ImportApiOutput {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *ImportApiOutput) SetCorsConfiguration(v *Cors) *ImportApiOutput {
	s.CorsConfiguration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ImportApiOutput) SetCreatedDate(v time.Time) *ImportApiOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ImportApiOutput) SetDescription(v string) *ImportApiOutput {
	s.Description = &v
	return s
}

// SetDisableSchemaValidation sets the DisableSchemaValidation field's value.
func (s *ImportApiOutput) SetDisableSchemaValidation(v bool) *ImportApiOutput {
	s.DisableSchemaValidation = &v
	return s
}

// SetImportInfo sets the ImportInfo field's value.
func (s *ImportApiOutput) SetImportInfo(v []*string) *ImportApiOutput {
	s.ImportInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *ImportApiOutput) SetName(v string) *ImportApiOutput {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *ImportApiOutput) SetProtocolType(v string) *ImportApiOutput {
	s.ProtocolType = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *ImportApiOutput) SetRouteSelectionExpression(v string) *ImportApiOutput {
	s.RouteSelectionExpression = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportApiOutput) SetTags(v map[string]*string) *ImportApiOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ImportApiOutput) SetVersion(v string) *ImportApiOutput {
	s.Version = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *ImportApiOutput) SetWarnings(v []*string) *ImportApiOutput {
	s.Warnings = v
	return s
}

// Represents an integration.
type Integration struct {
	_ struct{} `type:"structure"`

	// Specifies whether an integration is managed by API Gateway. If you created
	// an API using using quick create, the resulting integration is managed by
	// API Gateway. You can update a managed integration, but you can't delete it.
	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	// The ID of the VPC link for a private integration. Supported only for HTTP
	// APIs.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The type of the network connection to the integration endpoint. Specify INTERNET
	// for connections through the public routable internet or VPC_LINK for private
	// connections between API Gateway and resources in a VPC. The default value
	// is INTERNET.
	ConnectionType *string `locationName:"connectionType" type:"string" enum:"ConnectionType"`

	// Supported only for WebSocket APIs. Specifies how to handle response payload
	// content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT,
	// with the following behaviors:
	//
	// CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string
	// to the corresponding binary blob.
	//
	// CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded
	// string.
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the route response or method response without
	// modification.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// Specifies the credentials required for the integration, if any. For AWS integrations,
	// three options are available. To specify an IAM Role for API Gateway to assume,
	// use the role's Amazon Resource Name (ARN). To require that the caller's identity
	// be passed through from the request, specify the string arn:aws:iam::*:user/*.
	// To use resource-based permissions on supported AWS services, specify null.
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// Represents the description of an integration.
	Description *string `locationName:"description" type:"string"`

	// Represents the identifier of an integration.
	IntegrationId *string `locationName:"integrationId" type:"string"`

	// Specifies the integration's HTTP method type.
	IntegrationMethod *string `locationName:"integrationMethod" type:"string"`

	// The integration response selection expression for the integration. Supported
	// only for WebSocket APIs. See Integration Response Selection Expressions (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions).
	IntegrationResponseSelectionExpression *string `locationName:"integrationResponseSelectionExpression" type:"string"`

	// The integration type of an integration. One of the following:
	//
	// AWS: for integrating the route or method request with an AWS service action,
	// including the Lambda function-invoking action. With the Lambda function-invoking
	// action, this is referred to as the Lambda custom integration. With any other
	// AWS service action, this is known as AWS integration. Supported only for
	// WebSocket APIs.
	//
	// AWS_PROXY: for integrating the route or method request with the Lambda function-invoking
	// action with the client request passed through as-is. This integration is
	// also referred to as Lambda proxy integration.
	//
	// HTTP: for integrating the route or method request with an HTTP endpoint.
	// This integration is also referred to as the HTTP custom integration. Supported
	// only for WebSocket APIs.
	//
	// HTTP_PROXY: for integrating the route or method request with an HTTP endpoint,
	// with the client request passed through as-is. This is also referred to as
	// HTTP proxy integration.
	//
	// MOCK: for integrating the route or method request with API Gateway as a "loopback"
	// endpoint without invoking any backend. Supported only for WebSocket APIs.
	IntegrationType *string `locationName:"integrationType" type:"string" enum:"IntegrationType"`

	// For a Lambda integration, specify the URI of a Lambda function.
	//
	// For an HTTP integration, specify a fully-qualified URL.
	//
	// For an HTTP API private integration, specify the ARN of an Application Load
	// Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
	// If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances
	// to identify resources. You can use query parameters to target specific resources.
	// To learn more, see DiscoverInstances (https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html).
	// For private integrations, all resources must be owned by the same AWS account.
	IntegrationUri *string `locationName:"integrationUri" type:"string"`

	// Specifies the pass-through behavior for incoming requests based on the Content-Type
	// header in the request, and the available mapping templates specified as the
	// requestTemplates property on the Integration resource. There are three valid
	// values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket
	// APIs.
	//
	// WHEN_NO_MATCH passes the request body for unmapped content types through
	// to the integration backend without transformation.
	//
	// NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type
	// response.
	//
	// WHEN_NO_TEMPLATES allows pass-through when the integration has no content
	// types mapped to templates. However, if there is at least one content type
	// defined, unmapped content types will be rejected with the same HTTP 415 Unsupported
	// Media Type response.
	PassthroughBehavior *string `locationName:"passthroughBehavior" type:"string" enum:"PassthroughBehavior"`

	// Specifies the format of the payload sent to an integration. Required for
	// HTTP APIs.
	PayloadFormatVersion *string `locationName:"payloadFormatVersion" type:"string"`

	// A key-value map specifying request parameters that are passed from the method
	// request to the backend. The key is an integration request parameter name
	// and the associated value is a method request parameter value or static value
	// that must be enclosed within single quotes and pre-encoded as required by
	// the backend. The method request parameter value must match the pattern of
	// method.request.{location}.{name} , where {location} is querystring, path,
	// or header; and {name} must be a valid and unique method request parameter
	// name. Supported only for WebSocket APIs.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// Represents a map of Velocity templates that are applied on the request payload
	// based on the value of the Content-Type header sent by the client. The content
	// type value is the key in this map, and the template (as a String) is the
	// value. Supported only for WebSocket APIs.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// The template selection expression for the integration. Supported only for
	// WebSocket APIs.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`

	// Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and
	// between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is
	// 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" min:"50" type:"integer"`

	// The TLS configuration for a private integration. If you specify a TLS configuration,
	// private integration traffic uses the HTTPS protocol. Supported only for HTTP
	// APIs.
	TlsConfig *TlsConfig `locationName:"tlsConfig" type:"structure"`
}

// String returns the string representation
func (s Integration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Integration) GoString() string {
	return s.String()
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *Integration) SetApiGatewayManaged(v bool) *Integration {
	s.ApiGatewayManaged = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *Integration) SetConnectionId(v string) *Integration {
	s.ConnectionId = &v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *Integration) SetConnectionType(v string) *Integration {
	s.ConnectionType = &v
	return s
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *Integration) SetContentHandlingStrategy(v string) *Integration {
	s.ContentHandlingStrategy = &v
	return s
}

// SetCredentialsArn sets the CredentialsArn field's value.
func (s *Integration) SetCredentialsArn(v string) *Integration {
	s.CredentialsArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Integration) SetDescription(v string) *Integration {
	s.Description = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *Integration) SetIntegrationId(v string) *Integration {
	s.IntegrationId = &v
	return s
}

// SetIntegrationMethod sets the IntegrationMethod field's value.
func (s *Integration) SetIntegrationMethod(v string) *Integration {
	s.IntegrationMethod = &v
	return s
}

// SetIntegrationResponseSelectionExpression sets the IntegrationResponseSelectionExpression field's value.
func (s *Integration) SetIntegrationResponseSelectionExpression(v string) *Integration {
	s.IntegrationResponseSelectionExpression = &v
	return s
}

// SetIntegrationType sets the IntegrationType field's value.
func (s *Integration) SetIntegrationType(v string) *Integration {
	s.IntegrationType = &v
	return s
}

// SetIntegrationUri sets the IntegrationUri field's value.
func (s *Integration) SetIntegrationUri(v string) *Integration {
	s.IntegrationUri = &v
	return s
}

// SetPassthroughBehavior sets the PassthroughBehavior field's value.
func (s *Integration) SetPassthroughBehavior(v string) *Integration {
	s.PassthroughBehavior = &v
	return s
}

// SetPayloadFormatVersion sets the PayloadFormatVersion field's value.
func (s *Integration) SetPayloadFormatVersion(v string) *Integration {
	s.PayloadFormatVersion = &v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *Integration) SetRequestParameters(v map[string]*string) *Integration {
	s.RequestParameters = v
	return s
}

// SetRequestTemplates sets the RequestTemplates field's value.
func (s *Integration) SetRequestTemplates(v map[string]*string) *Integration {
	s.RequestTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *Integration) SetTemplateSelectionExpression(v string) *Integration {
	s.TemplateSelectionExpression = &v
	return s
}

// SetTimeoutInMillis sets the TimeoutInMillis field's value.
func (s *Integration) SetTimeoutInMillis(v int64) *Integration {
	s.TimeoutInMillis = &v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *Integration) SetTlsConfig(v *TlsConfig) *Integration {
	s.TlsConfig = v
	return s
}

// Represents an integration response.
type IntegrationResponse struct {
	_ struct{} `type:"structure"`

	// Supported only for WebSocket APIs. Specifies how to handle response payload
	// content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT,
	// with the following behaviors:
	//
	// CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string
	// to the corresponding binary blob.
	//
	// CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded
	// string.
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the route response or method response without
	// modification.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// The integration response ID.
	IntegrationResponseId *string `locationName:"integrationResponseId" type:"string"`

	// The integration response key.
	//
	// IntegrationResponseKey is a required field
	IntegrationResponseKey *string `locationName:"integrationResponseKey" type:"string" required:"true"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// The collection of response templates for the integration response as a string-to-string
	// map of key-value pairs. Response templates are represented as a key/value
	// map, with a content-type as the key and a template as the value.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// The template selection expressions for the integration response.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`
}

// String returns the string representation
func (s IntegrationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntegrationResponse) GoString() string {
	return s.String()
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *IntegrationResponse) SetContentHandlingStrategy(v string) *IntegrationResponse {
	s.ContentHandlingStrategy = &v
	return s
}

// SetIntegrationResponseId sets the IntegrationResponseId field's value.
func (s *IntegrationResponse) SetIntegrationResponseId(v string) *IntegrationResponse {
	s.IntegrationResponseId = &v
	return s
}

// SetIntegrationResponseKey sets the IntegrationResponseKey field's value.
func (s *IntegrationResponse) SetIntegrationResponseKey(v string) *IntegrationResponse {
	s.IntegrationResponseKey = &v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *IntegrationResponse) SetResponseParameters(v map[string]*string) *IntegrationResponse {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *IntegrationResponse) SetResponseTemplates(v map[string]*string) *IntegrationResponse {
	s.ResponseTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *IntegrationResponse) SetTemplateSelectionExpression(v string) *IntegrationResponse {
	s.TemplateSelectionExpression = &v
	return s
}

// Represents the configuration of a JWT authorizer. Required for the JWT authorizer
// type. Supported only for HTTP APIs.
type JWTConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of the intended recipients of the JWT. A valid JWT must provide an
	// aud that matches at least one entry in this list. See RFC 7519 (https://tools.ietf.org/html/rfc7519#section-4.1.3).
	// Supported only for HTTP APIs.
	Audience []*string `locationName:"audience" type:"list"`

	// The base domain of the identity provider that issues JSON Web Tokens. For
	// example, an Amazon Cognito user pool has the following format: https://cognito-idp.{region}.amazonaws.com/{userPoolId}
	// . Required for the JWT authorizer type. Supported only for HTTP APIs.
	Issuer *string `locationName:"issuer" type:"string"`
}

// String returns the string representation
func (s JWTConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JWTConfiguration) GoString() string {
	return s.String()
}

// SetAudience sets the Audience field's value.
func (s *JWTConfiguration) SetAudience(v []*string) *JWTConfiguration {
	s.Audience = v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *JWTConfiguration) SetIssuer(v string) *JWTConfiguration {
	s.Issuer = &v
	return s
}

// Represents a data model for an API. Supported only for WebSocket APIs. See
// Create Models and Mapping Templates for Request and Response Mappings (https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html).
type Model struct {
	_ struct{} `type:"structure"`

	// The content-type for the model, for example, "application/json".
	ContentType *string `locationName:"contentType" type:"string"`

	// The description of the model.
	Description *string `locationName:"description" type:"string"`

	// The model identifier.
	ModelId *string `locationName:"modelId" type:"string"`

	// The name of the model. Must be alphanumeric.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The schema for the model. For application/json models, this should be JSON
	// schema draft 4 model.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Model) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *Model) SetContentType(v string) *Model {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Model) SetDescription(v string) *Model {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *Model) SetModelId(v string) *Model {
	s.ModelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Model) SetName(v string) *Model {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *Model) SetSchema(v string) *Model {
	s.Schema = &v
	return s
}

// The resource specified in the request was not found. See the message field
// for more information.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Describes the error encountered.
	Message_ *string `locationName:"message" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Validation constraints imposed on parameters of a request (path, query string,
// headers).
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// Whether or not the parameter is required.
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterConstraints) GoString() string {
	return s.String()
}

// SetRequired sets the Required field's value.
func (s *ParameterConstraints) SetRequired(v bool) *ParameterConstraints {
	s.Required = &v
	return s
}

type ReimportApiInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	Basepath *string `location:"querystring" locationName:"basepath" type:"string"`

	// Body is a required field
	Body *string `locationName:"body" type:"string" required:"true"`

	FailOnWarnings *bool `location:"querystring" locationName:"failOnWarnings" type:"boolean"`
}

// String returns the string representation
func (s ReimportApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReimportApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReimportApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReimportApiInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *ReimportApiInput) SetApiId(v string) *ReimportApiInput {
	s.ApiId = &v
	return s
}

// SetBasepath sets the Basepath field's value.
func (s *ReimportApiInput) SetBasepath(v string) *ReimportApiInput {
	s.Basepath = &v
	return s
}

// SetBody sets the Body field's value.
func (s *ReimportApiInput) SetBody(v string) *ReimportApiInput {
	s.Body = &v
	return s
}

// SetFailOnWarnings sets the FailOnWarnings field's value.
func (s *ReimportApiInput) SetFailOnWarnings(v bool) *ReimportApiInput {
	s.FailOnWarnings = &v
	return s
}

type ReimportApiOutput struct {
	_ struct{} `type:"structure"`

	ApiEndpoint *string `locationName:"apiEndpoint" type:"string"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
	// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
	// for more information.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	ImportInfo []*string `locationName:"importInfo" type:"list"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// Represents a protocol type.
	ProtocolType *string `locationName:"protocolType" type:"string" enum:"ProtocolType"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A string with a length between [1-64].
	Version *string `locationName:"version" type:"string"`

	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s ReimportApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReimportApiOutput) GoString() string {
	return s.String()
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *ReimportApiOutput) SetApiEndpoint(v string) *ReimportApiOutput {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *ReimportApiOutput) SetApiId(v string) *ReimportApiOutput {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *ReimportApiOutput) SetApiKeySelectionExpression(v string) *ReimportApiOutput {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *ReimportApiOutput) SetCorsConfiguration(v *Cors) *ReimportApiOutput {
	s.CorsConfiguration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ReimportApiOutput) SetCreatedDate(v time.Time) *ReimportApiOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReimportApiOutput) SetDescription(v string) *ReimportApiOutput {
	s.Description = &v
	return s
}

// SetDisableSchemaValidation sets the DisableSchemaValidation field's value.
func (s *ReimportApiOutput) SetDisableSchemaValidation(v bool) *ReimportApiOutput {
	s.DisableSchemaValidation = &v
	return s
}

// SetImportInfo sets the ImportInfo field's value.
func (s *ReimportApiOutput) SetImportInfo(v []*string) *ReimportApiOutput {
	s.ImportInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *ReimportApiOutput) SetName(v string) *ReimportApiOutput {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *ReimportApiOutput) SetProtocolType(v string) *ReimportApiOutput {
	s.ProtocolType = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *ReimportApiOutput) SetRouteSelectionExpression(v string) *ReimportApiOutput {
	s.RouteSelectionExpression = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ReimportApiOutput) SetTags(v map[string]*string) *ReimportApiOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ReimportApiOutput) SetVersion(v string) *ReimportApiOutput {
	s.Version = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *ReimportApiOutput) SetWarnings(v []*string) *ReimportApiOutput {
	s.Warnings = v
	return s
}

// Represents a route.
type Route struct {
	_ struct{} `type:"structure"`

	// Specifies whether a route is managed by API Gateway. If you created an API
	// using quick create, the $default route is managed by API Gateway. You can't
	// modify the $default route key.
	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	// Specifies whether an API key is required for this route. Supported only for
	// WebSocket APIs.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on a route. The scopes are used
	// with a JWT authorizer to authorize the method invocation. The authorization
	// works by matching the route scopes against the scopes parsed from the access
	// token in the incoming request. The method invocation is authorized if any
	// route scope matches a claimed scope in the access token. Otherwise, the invocation
	// is not authorized. When the route scope is configured, the client must provide
	// an access token instead of an identity token for authorization purposes.
	AuthorizationScopes []*string `locationName:"authorizationScopes" type:"list"`

	// The authorization type for the route. For WebSocket APIs, valid values are
	// NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for
	// using a Lambda authorizer For HTTP APIs, valid values are NONE for open access,
	// or JWT for using JSON Web Tokens.
	AuthorizationType *string `locationName:"authorizationType" type:"string" enum:"AuthorizationType"`

	// The identifier of the Authorizer resource to be associated with this route.
	// The authorizer identifier is generated by API Gateway when you created the
	// authorizer.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// The model selection expression for the route. Supported only for WebSocket
	// APIs.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// The operation name for the route.
	OperationName *string `locationName:"operationName" type:"string"`

	// The request models for the route. Supported only for WebSocket APIs.
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// The request parameters for the route. Supported only for WebSocket APIs.
	RequestParameters map[string]*ParameterConstraints `locationName:"requestParameters" type:"map"`

	// The route ID.
	RouteId *string `locationName:"routeId" type:"string"`

	// The route key for the route.
	//
	// RouteKey is a required field
	RouteKey *string `locationName:"routeKey" type:"string" required:"true"`

	// The route response selection expression for the route. Supported only for
	// WebSocket APIs.
	RouteResponseSelectionExpression *string `locationName:"routeResponseSelectionExpression" type:"string"`

	// The target for the route.
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s Route) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Route) GoString() string {
	return s.String()
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *Route) SetApiGatewayManaged(v bool) *Route {
	s.ApiGatewayManaged = &v
	return s
}

// SetApiKeyRequired sets the ApiKeyRequired field's value.
func (s *Route) SetApiKeyRequired(v bool) *Route {
	s.ApiKeyRequired = &v
	return s
}

// SetAuthorizationScopes sets the AuthorizationScopes field's value.
func (s *Route) SetAuthorizationScopes(v []*string) *Route {
	s.AuthorizationScopes = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *Route) SetAuthorizationType(v string) *Route {
	s.AuthorizationType = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *Route) SetAuthorizerId(v string) *Route {
	s.AuthorizerId = &v
	return s
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *Route) SetModelSelectionExpression(v string) *Route {
	s.ModelSelectionExpression = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *Route) SetOperationName(v string) *Route {
	s.OperationName = &v
	return s
}

// SetRequestModels sets the RequestModels field's value.
func (s *Route) SetRequestModels(v map[string]*string) *Route {
	s.RequestModels = v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *Route) SetRequestParameters(v map[string]*ParameterConstraints) *Route {
	s.RequestParameters = v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *Route) SetRouteId(v string) *Route {
	s.RouteId = &v
	return s
}

// SetRouteKey sets the RouteKey field's value.
func (s *Route) SetRouteKey(v string) *Route {
	s.RouteKey = &v
	return s
}

// SetRouteResponseSelectionExpression sets the RouteResponseSelectionExpression field's value.
func (s *Route) SetRouteResponseSelectionExpression(v string) *Route {
	s.RouteResponseSelectionExpression = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *Route) SetTarget(v string) *Route {
	s.Target = &v
	return s
}

// Represents a route response.
type RouteResponse struct {
	_ struct{} `type:"structure"`

	// Represents the model selection expression of a route response. Supported
	// only for WebSocket APIs.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// Represents the response models of a route response.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// Represents the response parameters of a route response.
	ResponseParameters map[string]*ParameterConstraints `locationName:"responseParameters" type:"map"`

	// Represents the identifier of a route response.
	RouteResponseId *string `locationName:"routeResponseId" type:"string"`

	// Represents the route response key of a route response.
	//
	// RouteResponseKey is a required field
	RouteResponseKey *string `locationName:"routeResponseKey" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteResponse) GoString() string {
	return s.String()
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *RouteResponse) SetModelSelectionExpression(v string) *RouteResponse {
	s.ModelSelectionExpression = &v
	return s
}

// SetResponseModels sets the ResponseModels field's value.
func (s *RouteResponse) SetResponseModels(v map[string]*string) *RouteResponse {
	s.ResponseModels = v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *RouteResponse) SetResponseParameters(v map[string]*ParameterConstraints) *RouteResponse {
	s.ResponseParameters = v
	return s
}

// SetRouteResponseId sets the RouteResponseId field's value.
func (s *RouteResponse) SetRouteResponseId(v string) *RouteResponse {
	s.RouteResponseId = &v
	return s
}

// SetRouteResponseKey sets the RouteResponseKey field's value.
func (s *RouteResponse) SetRouteResponseKey(v string) *RouteResponse {
	s.RouteResponseKey = &v
	return s
}

// Represents a collection of route settings.
type RouteSettings struct {
	_ struct{} `type:"structure"`

	// Specifies whether (true) or not (false) data trace logging is enabled for
	// this route. This property affects the log entries pushed to Amazon CloudWatch
	// Logs. Supported only for WebSocket APIs.
	DataTraceEnabled *bool `locationName:"dataTraceEnabled" type:"boolean"`

	// Specifies whether detailed metrics are enabled.
	DetailedMetricsEnabled *bool `locationName:"detailedMetricsEnabled" type:"boolean"`

	// Specifies the logging level for this route: INFO, ERROR, or OFF. This property
	// affects the log entries pushed to Amazon CloudWatch Logs. Supported only
	// for WebSocket APIs.
	LoggingLevel *string `locationName:"loggingLevel" type:"string" enum:"LoggingLevel"`

	// Specifies the throttling burst limit.
	ThrottlingBurstLimit *int64 `locationName:"throttlingBurstLimit" type:"integer"`

	// Specifies the throttling rate limit.
	ThrottlingRateLimit *float64 `locationName:"throttlingRateLimit" type:"double"`
}

// String returns the string representation
func (s RouteSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteSettings) GoString() string {
	return s.String()
}

// SetDataTraceEnabled sets the DataTraceEnabled field's value.
func (s *RouteSettings) SetDataTraceEnabled(v bool) *RouteSettings {
	s.DataTraceEnabled = &v
	return s
}

// SetDetailedMetricsEnabled sets the DetailedMetricsEnabled field's value.
func (s *RouteSettings) SetDetailedMetricsEnabled(v bool) *RouteSettings {
	s.DetailedMetricsEnabled = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *RouteSettings) SetLoggingLevel(v string) *RouteSettings {
	s.LoggingLevel = &v
	return s
}

// SetThrottlingBurstLimit sets the ThrottlingBurstLimit field's value.
func (s *RouteSettings) SetThrottlingBurstLimit(v int64) *RouteSettings {
	s.ThrottlingBurstLimit = &v
	return s
}

// SetThrottlingRateLimit sets the ThrottlingRateLimit field's value.
func (s *RouteSettings) SetThrottlingRateLimit(v float64) *RouteSettings {
	s.ThrottlingRateLimit = &v
	return s
}

// Represents an API stage.
type Stage struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in this stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	// Specifies whether a stage is managed by API Gateway. If you created an API
	// using quick create, the $default stage is managed by API Gateway. You can't
	// modify the $default stage.
	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	// Specifies whether updates to an API automatically trigger a new deployment.
	// The default value is false.
	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier of a client certificate for a Stage. Supported only for WebSocket
	// APIs.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// The timestamp when the stage was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// Default route settings for the stage.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier of the Deployment that the Stage is associated with. Can't
	// be updated if autoDeploy is enabled.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The description of the stage.
	Description *string `locationName:"description" type:"string"`

	// Describes the status of the last deployment of a stage. Supported only for
	// stages with autoDeploy enabled.
	LastDeploymentStatusMessage *string `locationName:"lastDeploymentStatusMessage" type:"string"`

	// The timestamp when the stage was last updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601"`

	// Route settings for the stage, by routeKey.
	RouteSettings map[string]*RouteSettings `locationName:"routeSettings" type:"map"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" type:"string" required:"true"`

	// A map that defines the stage variables for a stage resource. Variable names
	// can have alphanumeric and underscore characters, and the values must match
	// [A-Za-z0-9-._~:/?#&=,]+.
	StageVariables map[string]*string `locationName:"stageVariables" type:"map"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stage) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *Stage) SetAccessLogSettings(v *AccessLogSettings) *Stage {
	s.AccessLogSettings = v
	return s
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *Stage) SetApiGatewayManaged(v bool) *Stage {
	s.ApiGatewayManaged = &v
	return s
}

// SetAutoDeploy sets the AutoDeploy field's value.
func (s *Stage) SetAutoDeploy(v bool) *Stage {
	s.AutoDeploy = &v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *Stage) SetClientCertificateId(v string) *Stage {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *Stage) SetCreatedDate(v time.Time) *Stage {
	s.CreatedDate = &v
	return s
}

// SetDefaultRouteSettings sets the DefaultRouteSettings field's value.
func (s *Stage) SetDefaultRouteSettings(v *RouteSettings) *Stage {
	s.DefaultRouteSettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Stage) SetDeploymentId(v string) *Stage {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Stage) SetDescription(v string) *Stage {
	s.Description = &v
	return s
}

// SetLastDeploymentStatusMessage sets the LastDeploymentStatusMessage field's value.
func (s *Stage) SetLastDeploymentStatusMessage(v string) *Stage {
	s.LastDeploymentStatusMessage = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *Stage) SetLastUpdatedDate(v time.Time) *Stage {
	s.LastUpdatedDate = &v
	return s
}

// SetRouteSettings sets the RouteSettings field's value.
func (s *Stage) SetRouteSettings(v map[string]*RouteSettings) *Stage {
	s.RouteSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *Stage) SetStageName(v string) *Stage {
	s.StageName = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *Stage) SetStageVariables(v map[string]*string) *Stage {
	s.StageVariables = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Stage) SetTags(v map[string]*string) *Stage {
	s.Tags = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The TLS configuration for a private integration. If you specify a TLS configuration,
// private integration traffic uses the HTTPS protocol. Supported only for HTTP
// APIs.
type TlsConfig struct {
	_ struct{} `type:"structure"`

	// If you specify a server name, API Gateway uses it to verify the hostname
	// on the integration's certificate. The server name is also included in the
	// TLS handshake to support Server Name Indication (SNI) or virtual hosting.
	ServerNameToVerify *string `locationName:"serverNameToVerify" type:"string"`
}

// String returns the string representation
func (s TlsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TlsConfig) GoString() string {
	return s.String()
}

// SetServerNameToVerify sets the ServerNameToVerify field's value.
func (s *TlsConfig) SetServerNameToVerify(v string) *TlsConfig {
	s.ServerNameToVerify = &v
	return s
}

// The TLS configuration for a private integration. If you specify a TLS configuration,
// private integration traffic uses the HTTPS protocol. Supported only for HTTP
// APIs.
type TlsConfigInput struct {
	_ struct{} `type:"structure"`

	// If you specify a server name, API Gateway uses it to verify the hostname
	// on the integration's certificate. The server name is also included in the
	// TLS handshake to support Server Name Indication (SNI) or virtual hosting.
	ServerNameToVerify *string `locationName:"serverNameToVerify" type:"string"`
}

// String returns the string representation
func (s TlsConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TlsConfigInput) GoString() string {
	return s.String()
}

// SetServerNameToVerify sets the ServerNameToVerify field's value.
func (s *TlsConfigInput) SetServerNameToVerify(v string) *TlsConfigInput {
	s.ServerNameToVerify = &v
	return s
}

// A limit has been exceeded. See the accompanying error message for details.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	LimitType *string `locationName:"limitType" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApiInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
	// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
	// for more information.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	// Represents an Amazon Resource Name (ARN).
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteKey *string `locationName:"routeKey" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string"`

	// A string representation of a URI with a length between [1-2048].
	Target *string `locationName:"target" type:"string"`

	// A string with a length between [1-64].
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s UpdateApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApiInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.CorsConfiguration != nil {
		if err := s.CorsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CorsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateApiInput) SetApiId(v string) *UpdateApiInput {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *UpdateApiInput) SetApiKeySelectionExpression(v string) *UpdateApiInput {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *UpdateApiInput) SetCorsConfiguration(v *Cors) *UpdateApiInput {
	s.CorsConfiguration = v
	return s
}

// SetCredentialsArn sets the CredentialsArn field's value.
func (s *UpdateApiInput) SetCredentialsArn(v string) *UpdateApiInput {
	s.CredentialsArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApiInput) SetDescription(v string) *UpdateApiInput {
	s.Description = &v
	return s
}

// SetDisableSchemaValidation sets the DisableSchemaValidation field's value.
func (s *UpdateApiInput) SetDisableSchemaValidation(v bool) *UpdateApiInput {
	s.DisableSchemaValidation = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApiInput) SetName(v string) *UpdateApiInput {
	s.Name = &v
	return s
}

// SetRouteKey sets the RouteKey field's value.
func (s *UpdateApiInput) SetRouteKey(v string) *UpdateApiInput {
	s.RouteKey = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *UpdateApiInput) SetRouteSelectionExpression(v string) *UpdateApiInput {
	s.RouteSelectionExpression = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *UpdateApiInput) SetTarget(v string) *UpdateApiInput {
	s.Target = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateApiInput) SetVersion(v string) *UpdateApiInput {
	s.Version = &v
	return s
}

type UpdateApiMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier.
	//
	// ApiId is a required field
	ApiId *string `locationName:"apiId" type:"string" required:"true"`

	// ApiMappingId is a required field
	ApiMappingId *string `location:"uri" locationName:"apiMappingId" type:"string" required:"true"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`

	// A string with a length between [1-128].
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation
func (s UpdateApiMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApiMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApiMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApiMappingInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiMappingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiMappingId"))
	}
	if s.ApiMappingId != nil && len(*s.ApiMappingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiMappingId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateApiMappingInput) SetApiId(v string) *UpdateApiMappingInput {
	s.ApiId = &v
	return s
}

// SetApiMappingId sets the ApiMappingId field's value.
func (s *UpdateApiMappingInput) SetApiMappingId(v string) *UpdateApiMappingInput {
	s.ApiMappingId = &v
	return s
}

// SetApiMappingKey sets the ApiMappingKey field's value.
func (s *UpdateApiMappingInput) SetApiMappingKey(v string) *UpdateApiMappingInput {
	s.ApiMappingKey = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateApiMappingInput) SetDomainName(v string) *UpdateApiMappingInput {
	s.DomainName = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *UpdateApiMappingInput) SetStage(v string) *UpdateApiMappingInput {
	s.Stage = &v
	return s
}

type UpdateApiMappingOutput struct {
	_ struct{} `type:"structure"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// The identifier.
	ApiMappingId *string `locationName:"apiMappingId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// A string with a length between [1-128].
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation
func (s UpdateApiMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApiMappingOutput) GoString() string {
	return s.String()
}

// SetApiId sets the ApiId field's value.
func (s *UpdateApiMappingOutput) SetApiId(v string) *UpdateApiMappingOutput {
	s.ApiId = &v
	return s
}

// SetApiMappingId sets the ApiMappingId field's value.
func (s *UpdateApiMappingOutput) SetApiMappingId(v string) *UpdateApiMappingOutput {
	s.ApiMappingId = &v
	return s
}

// SetApiMappingKey sets the ApiMappingKey field's value.
func (s *UpdateApiMappingOutput) SetApiMappingKey(v string) *UpdateApiMappingOutput {
	s.ApiMappingKey = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *UpdateApiMappingOutput) SetStage(v string) *UpdateApiMappingOutput {
	s.Stage = &v
	return s
}

type UpdateApiOutput struct {
	_ struct{} `type:"structure"`

	ApiEndpoint *string `locationName:"apiEndpoint" type:"string"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
	// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
	// for more information.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	ImportInfo []*string `locationName:"importInfo" type:"list"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// Represents a protocol type.
	ProtocolType *string `locationName:"protocolType" type:"string" enum:"ProtocolType"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A string with a length between [1-64].
	Version *string `locationName:"version" type:"string"`

	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s UpdateApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApiOutput) GoString() string {
	return s.String()
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *UpdateApiOutput) SetApiEndpoint(v string) *UpdateApiOutput {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *UpdateApiOutput) SetApiId(v string) *UpdateApiOutput {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *UpdateApiOutput) SetApiKeySelectionExpression(v string) *UpdateApiOutput {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *UpdateApiOutput) SetCorsConfiguration(v *Cors) *UpdateApiOutput {
	s.CorsConfiguration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *UpdateApiOutput) SetCreatedDate(v time.Time) *UpdateApiOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApiOutput) SetDescription(v string) *UpdateApiOutput {
	s.Description = &v
	return s
}

// SetDisableSchemaValidation sets the DisableSchemaValidation field's value.
func (s *UpdateApiOutput) SetDisableSchemaValidation(v bool) *UpdateApiOutput {
	s.DisableSchemaValidation = &v
	return s
}

// SetImportInfo sets the ImportInfo field's value.
func (s *UpdateApiOutput) SetImportInfo(v []*string) *UpdateApiOutput {
	s.ImportInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApiOutput) SetName(v string) *UpdateApiOutput {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *UpdateApiOutput) SetProtocolType(v string) *UpdateApiOutput {
	s.ProtocolType = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *UpdateApiOutput) SetRouteSelectionExpression(v string) *UpdateApiOutput {
	s.RouteSelectionExpression = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateApiOutput) SetTags(v map[string]*string) *UpdateApiOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateApiOutput) SetVersion(v string) *UpdateApiOutput {
	s.Version = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *UpdateApiOutput) SetWarnings(v []*string) *UpdateApiOutput {
	s.Warnings = v
	return s
}

type UpdateAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// Represents an Amazon Resource Name (ARN).
	AuthorizerCredentialsArn *string `locationName:"authorizerCredentialsArn" type:"string"`

	// AuthorizerId is a required field
	AuthorizerId *string `location:"uri" locationName:"authorizerId" type:"string" required:"true"`

	// An integer with a value between [0-3600].
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function
	// using incoming request parameters. For HTTP APIs, specify JWT to use JSON
	// Web Tokens.
	AuthorizerType *string `locationName:"authorizerType" type:"string" enum:"AuthorizerType"`

	// A string representation of a URI with a length between [1-2048].
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identity source for which authorization is requested. For the REQUEST
	// authorizer, this is required when authorization caching is enabled. The value
	// is a comma-separated string of one or more mapping expressions of the specified
	// request parameters. For example, if an Auth header, a Name query string parameter
	// are defined as identity sources, this value is $method.request.header.Auth,
	// $method.request.querystring.Name. These parameters will be used to derive
	// the authorization caching key and to perform runtime validation of the REQUEST
	// authorizer by verifying all of the identity-related request parameters are
	// present, not null and non-empty. Only when this is true does the authorizer
	// invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized
	// response without calling the Lambda function. The valid value is a string
	// of comma-separated mapping expressions of the specified request parameters.
	// When the authorization caching is not enabled, this property is optional.
	IdentitySource []*string `locationName:"identitySource" type:"list"`

	// A string with a length between [0-1024].
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// Represents the configuration of a JWT authorizer. Required for the JWT authorizer
	// type. Supported only for HTTP APIs.
	JwtConfiguration *JWTConfiguration `locationName:"jwtConfiguration" type:"structure"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAuthorizerInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.AuthorizerId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerId"))
	}
	if s.AuthorizerId != nil && len(*s.AuthorizerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateAuthorizerInput) SetApiId(v string) *UpdateAuthorizerInput {
	s.ApiId = &v
	return s
}

// SetAuthorizerCredentialsArn sets the AuthorizerCredentialsArn field's value.
func (s *UpdateAuthorizerInput) SetAuthorizerCredentialsArn(v string) *UpdateAuthorizerInput {
	s.AuthorizerCredentialsArn = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *UpdateAuthorizerInput) SetAuthorizerId(v string) *UpdateAuthorizerInput {
	s.AuthorizerId = &v
	return s
}

// SetAuthorizerResultTtlInSeconds sets the AuthorizerResultTtlInSeconds field's value.
func (s *UpdateAuthorizerInput) SetAuthorizerResultTtlInSeconds(v int64) *UpdateAuthorizerInput {
	s.AuthorizerResultTtlInSeconds = &v
	return s
}

// SetAuthorizerType sets the AuthorizerType field's value.
func (s *UpdateAuthorizerInput) SetAuthorizerType(v string) *UpdateAuthorizerInput {
	s.AuthorizerType = &v
	return s
}

// SetAuthorizerUri sets the AuthorizerUri field's value.
func (s *UpdateAuthorizerInput) SetAuthorizerUri(v string) *UpdateAuthorizerInput {
	s.AuthorizerUri = &v
	return s
}

// SetIdentitySource sets the IdentitySource field's value.
func (s *UpdateAuthorizerInput) SetIdentitySource(v []*string) *UpdateAuthorizerInput {
	s.IdentitySource = v
	return s
}

// SetIdentityValidationExpression sets the IdentityValidationExpression field's value.
func (s *UpdateAuthorizerInput) SetIdentityValidationExpression(v string) *UpdateAuthorizerInput {
	s.IdentityValidationExpression = &v
	return s
}

// SetJwtConfiguration sets the JwtConfiguration field's value.
func (s *UpdateAuthorizerInput) SetJwtConfiguration(v *JWTConfiguration) *UpdateAuthorizerInput {
	s.JwtConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAuthorizerInput) SetName(v string) *UpdateAuthorizerInput {
	s.Name = &v
	return s
}

type UpdateAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	// Represents an Amazon Resource Name (ARN).
	AuthorizerCredentialsArn *string `locationName:"authorizerCredentialsArn" type:"string"`

	// The identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// An integer with a value between [0-3600].
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function
	// using incoming request parameters. For HTTP APIs, specify JWT to use JSON
	// Web Tokens.
	AuthorizerType *string `locationName:"authorizerType" type:"string" enum:"AuthorizerType"`

	// A string representation of a URI with a length between [1-2048].
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identity source for which authorization is requested. For the REQUEST
	// authorizer, this is required when authorization caching is enabled. The value
	// is a comma-separated string of one or more mapping expressions of the specified
	// request parameters. For example, if an Auth header, a Name query string parameter
	// are defined as identity sources, this value is $method.request.header.Auth,
	// $method.request.querystring.Name. These parameters will be used to derive
	// the authorization caching key and to perform runtime validation of the REQUEST
	// authorizer by verifying all of the identity-related request parameters are
	// present, not null and non-empty. Only when this is true does the authorizer
	// invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized
	// response without calling the Lambda function. The valid value is a string
	// of comma-separated mapping expressions of the specified request parameters.
	// When the authorization caching is not enabled, this property is optional.
	IdentitySource []*string `locationName:"identitySource" type:"list"`

	// A string with a length between [0-1024].
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// Represents the configuration of a JWT authorizer. Required for the JWT authorizer
	// type. Supported only for HTTP APIs.
	JwtConfiguration *JWTConfiguration `locationName:"jwtConfiguration" type:"structure"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorizerCredentialsArn sets the AuthorizerCredentialsArn field's value.
func (s *UpdateAuthorizerOutput) SetAuthorizerCredentialsArn(v string) *UpdateAuthorizerOutput {
	s.AuthorizerCredentialsArn = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *UpdateAuthorizerOutput) SetAuthorizerId(v string) *UpdateAuthorizerOutput {
	s.AuthorizerId = &v
	return s
}

// SetAuthorizerResultTtlInSeconds sets the AuthorizerResultTtlInSeconds field's value.
func (s *UpdateAuthorizerOutput) SetAuthorizerResultTtlInSeconds(v int64) *UpdateAuthorizerOutput {
	s.AuthorizerResultTtlInSeconds = &v
	return s
}

// SetAuthorizerType sets the AuthorizerType field's value.
func (s *UpdateAuthorizerOutput) SetAuthorizerType(v string) *UpdateAuthorizerOutput {
	s.AuthorizerType = &v
	return s
}

// SetAuthorizerUri sets the AuthorizerUri field's value.
func (s *UpdateAuthorizerOutput) SetAuthorizerUri(v string) *UpdateAuthorizerOutput {
	s.AuthorizerUri = &v
	return s
}

// SetIdentitySource sets the IdentitySource field's value.
func (s *UpdateAuthorizerOutput) SetIdentitySource(v []*string) *UpdateAuthorizerOutput {
	s.IdentitySource = v
	return s
}

// SetIdentityValidationExpression sets the IdentityValidationExpression field's value.
func (s *UpdateAuthorizerOutput) SetIdentityValidationExpression(v string) *UpdateAuthorizerOutput {
	s.IdentityValidationExpression = &v
	return s
}

// SetJwtConfiguration sets the JwtConfiguration field's value.
func (s *UpdateAuthorizerOutput) SetJwtConfiguration(v *JWTConfiguration) *UpdateAuthorizerOutput {
	s.JwtConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAuthorizerOutput) SetName(v string) *UpdateAuthorizerOutput {
	s.Name = &v
	return s
}

type UpdateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deploymentId" type:"string" required:"true"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s UpdateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeploymentInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateDeploymentInput) SetApiId(v string) *UpdateDeploymentInput {
	s.ApiId = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *UpdateDeploymentInput) SetDeploymentId(v string) *UpdateDeploymentInput {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDeploymentInput) SetDescription(v string) *UpdateDeploymentInput {
	s.Description = &v
	return s
}

type UpdateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	AutoDeployed *bool `locationName:"autoDeployed" type:"boolean"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// Represents a deployment status.
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" enum:"DeploymentStatus"`

	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s UpdateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentOutput) GoString() string {
	return s.String()
}

// SetAutoDeployed sets the AutoDeployed field's value.
func (s *UpdateDeploymentOutput) SetAutoDeployed(v bool) *UpdateDeploymentOutput {
	s.AutoDeployed = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *UpdateDeploymentOutput) SetCreatedDate(v time.Time) *UpdateDeploymentOutput {
	s.CreatedDate = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *UpdateDeploymentOutput) SetDeploymentId(v string) *UpdateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *UpdateDeploymentOutput) SetDeploymentStatus(v string) *UpdateDeploymentOutput {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *UpdateDeploymentOutput) SetDeploymentStatusMessage(v string) *UpdateDeploymentOutput {
	s.DeploymentStatusMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDeploymentOutput) SetDescription(v string) *UpdateDeploymentOutput {
	s.Description = &v
	return s
}

type UpdateDomainNameInput struct {
	_ struct{} `type:"structure"`

	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`

	// The domain name configurations.
	DomainNameConfigurations []*DomainNameConfiguration `locationName:"domainNameConfigurations" type:"list"`
}

// String returns the string representation
func (s UpdateDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainNameInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainNameInput) SetDomainName(v string) *UpdateDomainNameInput {
	s.DomainName = &v
	return s
}

// SetDomainNameConfigurations sets the DomainNameConfigurations field's value.
func (s *UpdateDomainNameInput) SetDomainNameConfigurations(v []*DomainNameConfiguration) *UpdateDomainNameInput {
	s.DomainNameConfigurations = v
	return s
}

type UpdateDomainNameOutput struct {
	_ struct{} `type:"structure"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiMappingSelectionExpression *string `locationName:"apiMappingSelectionExpression" type:"string"`

	// A string with a length between [1-512].
	DomainName *string `locationName:"domainName" type:"string"`

	// The domain name configurations.
	DomainNameConfigurations []*DomainNameConfiguration `locationName:"domainNameConfigurations" type:"list"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s UpdateDomainNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainNameOutput) GoString() string {
	return s.String()
}

// SetApiMappingSelectionExpression sets the ApiMappingSelectionExpression field's value.
func (s *UpdateDomainNameOutput) SetApiMappingSelectionExpression(v string) *UpdateDomainNameOutput {
	s.ApiMappingSelectionExpression = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainNameOutput) SetDomainName(v string) *UpdateDomainNameOutput {
	s.DomainName = &v
	return s
}

// SetDomainNameConfigurations sets the DomainNameConfigurations field's value.
func (s *UpdateDomainNameOutput) SetDomainNameConfigurations(v []*DomainNameConfiguration) *UpdateDomainNameOutput {
	s.DomainNameConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateDomainNameOutput) SetTags(v map[string]*string) *UpdateDomainNameOutput {
	s.Tags = v
	return s
}

type UpdateIntegrationInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A string with a length between [1-1024].
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// Represents a connection type.
	ConnectionType *string `locationName:"connectionType" type:"string" enum:"ConnectionType"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// Represents an Amazon Resource Name (ARN).
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`

	// A string with a length between [1-64].
	IntegrationMethod *string `locationName:"integrationMethod" type:"string"`

	// Represents an API method integration type.
	IntegrationType *string `locationName:"integrationType" type:"string" enum:"IntegrationType"`

	// A string representation of a URI with a length between [1-2048].
	IntegrationUri *string `locationName:"integrationUri" type:"string"`

	// Represents passthrough behavior for an integration response. Supported only
	// for WebSocket APIs.
	PassthroughBehavior *string `locationName:"passthroughBehavior" type:"string" enum:"PassthroughBehavior"`

	// A string with a length between [1-64].
	PayloadFormatVersion *string `locationName:"payloadFormatVersion" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`

	// An integer with a value between [50-30000].
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" min:"50" type:"integer"`

	// The TLS configuration for a private integration. If you specify a TLS configuration,
	// private integration traffic uses the HTTPS protocol. Supported only for HTTP
	// APIs.
	TlsConfig *TlsConfigInput `locationName:"tlsConfig" type:"structure"`
}

// String returns the string representation
func (s UpdateIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIntegrationInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.IntegrationId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationId"))
	}
	if s.IntegrationId != nil && len(*s.IntegrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationId", 1))
	}
	if s.TimeoutInMillis != nil && *s.TimeoutInMillis < 50 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMillis", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateIntegrationInput) SetApiId(v string) *UpdateIntegrationInput {
	s.ApiId = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *UpdateIntegrationInput) SetConnectionId(v string) *UpdateIntegrationInput {
	s.ConnectionId = &v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *UpdateIntegrationInput) SetConnectionType(v string) *UpdateIntegrationInput {
	s.ConnectionType = &v
	return s
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *UpdateIntegrationInput) SetContentHandlingStrategy(v string) *UpdateIntegrationInput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetCredentialsArn sets the CredentialsArn field's value.
func (s *UpdateIntegrationInput) SetCredentialsArn(v string) *UpdateIntegrationInput {
	s.CredentialsArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateIntegrationInput) SetDescription(v string) *UpdateIntegrationInput {
	s.Description = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *UpdateIntegrationInput) SetIntegrationId(v string) *UpdateIntegrationInput {
	s.IntegrationId = &v
	return s
}

// SetIntegrationMethod sets the IntegrationMethod field's value.
func (s *UpdateIntegrationInput) SetIntegrationMethod(v string) *UpdateIntegrationInput {
	s.IntegrationMethod = &v
	return s
}

// SetIntegrationType sets the IntegrationType field's value.
func (s *UpdateIntegrationInput) SetIntegrationType(v string) *UpdateIntegrationInput {
	s.IntegrationType = &v
	return s
}

// SetIntegrationUri sets the IntegrationUri field's value.
func (s *UpdateIntegrationInput) SetIntegrationUri(v string) *UpdateIntegrationInput {
	s.IntegrationUri = &v
	return s
}

// SetPassthroughBehavior sets the PassthroughBehavior field's value.
func (s *UpdateIntegrationInput) SetPassthroughBehavior(v string) *UpdateIntegrationInput {
	s.PassthroughBehavior = &v
	return s
}

// SetPayloadFormatVersion sets the PayloadFormatVersion field's value.
func (s *UpdateIntegrationInput) SetPayloadFormatVersion(v string) *UpdateIntegrationInput {
	s.PayloadFormatVersion = &v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *UpdateIntegrationInput) SetRequestParameters(v map[string]*string) *UpdateIntegrationInput {
	s.RequestParameters = v
	return s
}

// SetRequestTemplates sets the RequestTemplates field's value.
func (s *UpdateIntegrationInput) SetRequestTemplates(v map[string]*string) *UpdateIntegrationInput {
	s.RequestTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *UpdateIntegrationInput) SetTemplateSelectionExpression(v string) *UpdateIntegrationInput {
	s.TemplateSelectionExpression = &v
	return s
}

// SetTimeoutInMillis sets the TimeoutInMillis field's value.
func (s *UpdateIntegrationInput) SetTimeoutInMillis(v int64) *UpdateIntegrationInput {
	s.TimeoutInMillis = &v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *UpdateIntegrationInput) SetTlsConfig(v *TlsConfigInput) *UpdateIntegrationInput {
	s.TlsConfig = v
	return s
}

type UpdateIntegrationOutput struct {
	_ struct{} `type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	// A string with a length between [1-1024].
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// Represents a connection type.
	ConnectionType *string `locationName:"connectionType" type:"string" enum:"ConnectionType"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// Represents an Amazon Resource Name (ARN).
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The identifier.
	IntegrationId *string `locationName:"integrationId" type:"string"`

	// A string with a length between [1-64].
	IntegrationMethod *string `locationName:"integrationMethod" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	IntegrationResponseSelectionExpression *string `locationName:"integrationResponseSelectionExpression" type:"string"`

	// Represents an API method integration type.
	IntegrationType *string `locationName:"integrationType" type:"string" enum:"IntegrationType"`

	// A string representation of a URI with a length between [1-2048].
	IntegrationUri *string `locationName:"integrationUri" type:"string"`

	// Represents passthrough behavior for an integration response. Supported only
	// for WebSocket APIs.
	PassthroughBehavior *string `locationName:"passthroughBehavior" type:"string" enum:"PassthroughBehavior"`

	// A string with a length between [1-64].
	PayloadFormatVersion *string `locationName:"payloadFormatVersion" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`

	// An integer with a value between [50-30000].
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" min:"50" type:"integer"`

	// The TLS configuration for a private integration. If you specify a TLS configuration,
	// private integration traffic uses the HTTPS protocol. Supported only for HTTP
	// APIs.
	TlsConfig *TlsConfig `locationName:"tlsConfig" type:"structure"`
}

// String returns the string representation
func (s UpdateIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIntegrationOutput) GoString() string {
	return s.String()
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *UpdateIntegrationOutput) SetApiGatewayManaged(v bool) *UpdateIntegrationOutput {
	s.ApiGatewayManaged = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *UpdateIntegrationOutput) SetConnectionId(v string) *UpdateIntegrationOutput {
	s.ConnectionId = &v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *UpdateIntegrationOutput) SetConnectionType(v string) *UpdateIntegrationOutput {
	s.ConnectionType = &v
	return s
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *UpdateIntegrationOutput) SetContentHandlingStrategy(v string) *UpdateIntegrationOutput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetCredentialsArn sets the CredentialsArn field's value.
func (s *UpdateIntegrationOutput) SetCredentialsArn(v string) *UpdateIntegrationOutput {
	s.CredentialsArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateIntegrationOutput) SetDescription(v string) *UpdateIntegrationOutput {
	s.Description = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *UpdateIntegrationOutput) SetIntegrationId(v string) *UpdateIntegrationOutput {
	s.IntegrationId = &v
	return s
}

// SetIntegrationMethod sets the IntegrationMethod field's value.
func (s *UpdateIntegrationOutput) SetIntegrationMethod(v string) *UpdateIntegrationOutput {
	s.IntegrationMethod = &v
	return s
}

// SetIntegrationResponseSelectionExpression sets the IntegrationResponseSelectionExpression field's value.
func (s *UpdateIntegrationOutput) SetIntegrationResponseSelectionExpression(v string) *UpdateIntegrationOutput {
	s.IntegrationResponseSelectionExpression = &v
	return s
}

// SetIntegrationType sets the IntegrationType field's value.
func (s *UpdateIntegrationOutput) SetIntegrationType(v string) *UpdateIntegrationOutput {
	s.IntegrationType = &v
	return s
}

// SetIntegrationUri sets the IntegrationUri field's value.
func (s *UpdateIntegrationOutput) SetIntegrationUri(v string) *UpdateIntegrationOutput {
	s.IntegrationUri = &v
	return s
}

// SetPassthroughBehavior sets the PassthroughBehavior field's value.
func (s *UpdateIntegrationOutput) SetPassthroughBehavior(v string) *UpdateIntegrationOutput {
	s.PassthroughBehavior = &v
	return s
}

// SetPayloadFormatVersion sets the PayloadFormatVersion field's value.
func (s *UpdateIntegrationOutput) SetPayloadFormatVersion(v string) *UpdateIntegrationOutput {
	s.PayloadFormatVersion = &v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *UpdateIntegrationOutput) SetRequestParameters(v map[string]*string) *UpdateIntegrationOutput {
	s.RequestParameters = v
	return s
}

// SetRequestTemplates sets the RequestTemplates field's value.
func (s *UpdateIntegrationOutput) SetRequestTemplates(v map[string]*string) *UpdateIntegrationOutput {
	s.RequestTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *UpdateIntegrationOutput) SetTemplateSelectionExpression(v string) *UpdateIntegrationOutput {
	s.TemplateSelectionExpression = &v
	return s
}

// SetTimeoutInMillis sets the TimeoutInMillis field's value.
func (s *UpdateIntegrationOutput) SetTimeoutInMillis(v int64) *UpdateIntegrationOutput {
	s.TimeoutInMillis = &v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *UpdateIntegrationOutput) SetTlsConfig(v *TlsConfig) *UpdateIntegrationOutput {
	s.TlsConfig = v
	return s
}

type UpdateIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`

	// IntegrationResponseId is a required field
	IntegrationResponseId *string `location:"uri" locationName:"integrationResponseId" type:"string" required:"true"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	IntegrationResponseKey *string `locationName:"integrationResponseKey" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`
}

// String returns the string representation
func (s UpdateIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIntegrationResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIntegrationResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIntegrationResponseInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.IntegrationId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationId"))
	}
	if s.IntegrationId != nil && len(*s.IntegrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationId", 1))
	}
	if s.IntegrationResponseId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationResponseId"))
	}
	if s.IntegrationResponseId != nil && len(*s.IntegrationResponseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationResponseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateIntegrationResponseInput) SetApiId(v string) *UpdateIntegrationResponseInput {
	s.ApiId = &v
	return s
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *UpdateIntegrationResponseInput) SetContentHandlingStrategy(v string) *UpdateIntegrationResponseInput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetIntegrationId sets the IntegrationId field's value.
func (s *UpdateIntegrationResponseInput) SetIntegrationId(v string) *UpdateIntegrationResponseInput {
	s.IntegrationId = &v
	return s
}

// SetIntegrationResponseId sets the IntegrationResponseId field's value.
func (s *UpdateIntegrationResponseInput) SetIntegrationResponseId(v string) *UpdateIntegrationResponseInput {
	s.IntegrationResponseId = &v
	return s
}

// SetIntegrationResponseKey sets the IntegrationResponseKey field's value.
func (s *UpdateIntegrationResponseInput) SetIntegrationResponseKey(v string) *UpdateIntegrationResponseInput {
	s.IntegrationResponseKey = &v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *UpdateIntegrationResponseInput) SetResponseParameters(v map[string]*string) *UpdateIntegrationResponseInput {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *UpdateIntegrationResponseInput) SetResponseTemplates(v map[string]*string) *UpdateIntegrationResponseInput {
	s.ResponseTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *UpdateIntegrationResponseInput) SetTemplateSelectionExpression(v string) *UpdateIntegrationResponseInput {
	s.TemplateSelectionExpression = &v
	return s
}

type UpdateIntegrationResponseOutput struct {
	_ struct{} `type:"structure"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy *string `locationName:"contentHandlingStrategy" type:"string" enum:"ContentHandlingStrategy"`

	// The identifier.
	IntegrationResponseId *string `locationName:"integrationResponseId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	IntegrationResponseKey *string `locationName:"integrationResponseKey" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`
}

// String returns the string representation
func (s UpdateIntegrationResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIntegrationResponseOutput) GoString() string {
	return s.String()
}

// SetContentHandlingStrategy sets the ContentHandlingStrategy field's value.
func (s *UpdateIntegrationResponseOutput) SetContentHandlingStrategy(v string) *UpdateIntegrationResponseOutput {
	s.ContentHandlingStrategy = &v
	return s
}

// SetIntegrationResponseId sets the IntegrationResponseId field's value.
func (s *UpdateIntegrationResponseOutput) SetIntegrationResponseId(v string) *UpdateIntegrationResponseOutput {
	s.IntegrationResponseId = &v
	return s
}

// SetIntegrationResponseKey sets the IntegrationResponseKey field's value.
func (s *UpdateIntegrationResponseOutput) SetIntegrationResponseKey(v string) *UpdateIntegrationResponseOutput {
	s.IntegrationResponseKey = &v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *UpdateIntegrationResponseOutput) SetResponseParameters(v map[string]*string) *UpdateIntegrationResponseOutput {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *UpdateIntegrationResponseOutput) SetResponseTemplates(v map[string]*string) *UpdateIntegrationResponseOutput {
	s.ResponseTemplates = v
	return s
}

// SetTemplateSelectionExpression sets the TemplateSelectionExpression field's value.
func (s *UpdateIntegrationResponseOutput) SetTemplateSelectionExpression(v string) *UpdateIntegrationResponseOutput {
	s.TemplateSelectionExpression = &v
	return s
}

type UpdateModelInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// A string with a length between [1-256].
	ContentType *string `locationName:"contentType" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// ModelId is a required field
	ModelId *string `location:"uri" locationName:"modelId" type:"string" required:"true"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A string with a length between [0-32768].
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s UpdateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateModelInput) SetApiId(v string) *UpdateModelInput {
	s.ApiId = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *UpdateModelInput) SetContentType(v string) *UpdateModelInput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateModelInput) SetDescription(v string) *UpdateModelInput {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelInput) SetModelId(v string) *UpdateModelInput {
	s.ModelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateModelInput) SetName(v string) *UpdateModelInput {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *UpdateModelInput) SetSchema(v string) *UpdateModelInput {
	s.Schema = &v
	return s
}

type UpdateModelOutput struct {
	_ struct{} `type:"structure"`

	// A string with a length between [1-256].
	ContentType *string `locationName:"contentType" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The identifier.
	ModelId *string `locationName:"modelId" type:"string"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A string with a length between [0-32768].
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s UpdateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *UpdateModelOutput) SetContentType(v string) *UpdateModelOutput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateModelOutput) SetDescription(v string) *UpdateModelOutput {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelOutput) SetModelId(v string) *UpdateModelOutput {
	s.ModelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateModelOutput) SetName(v string) *UpdateModelOutput {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *UpdateModelOutput) SetSchema(v string) *UpdateModelOutput {
	s.Schema = &v
	return s
}

type UpdateRouteInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on a route. The scopes are used
	// with a JWT authorizer to authorize the method invocation. The authorization
	// works by matching the route scopes against the scopes parsed from the access
	// token in the incoming request. The method invocation is authorized if any
	// route scope matches a claimed scope in the access token. Otherwise, the invocation
	// is not authorized. When the route scope is configured, the client must provide
	// an access token instead of an identity token for authorization purposes.
	AuthorizationScopes []*string `locationName:"authorizationScopes" type:"list"`

	// The authorization type. For WebSocket APIs, valid values are NONE for open
	// access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda
	// authorizer. For HTTP APIs, valid values are NONE for open access, or JWT
	// for using JSON Web Tokens.
	AuthorizationType *string `locationName:"authorizationType" type:"string" enum:"AuthorizationType"`

	// The identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// A string with a length between [1-64].
	OperationName *string `locationName:"operationName" type:"string"`

	// The route models.
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// The route parameters.
	RequestParameters map[string]*ParameterConstraints `locationName:"requestParameters" type:"map"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteKey *string `locationName:"routeKey" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteResponseSelectionExpression *string `locationName:"routeResponseSelectionExpression" type:"string"`

	// A string with a length between [1-128].
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s UpdateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRouteInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteId"))
	}
	if s.RouteId != nil && len(*s.RouteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateRouteInput) SetApiId(v string) *UpdateRouteInput {
	s.ApiId = &v
	return s
}

// SetApiKeyRequired sets the ApiKeyRequired field's value.
func (s *UpdateRouteInput) SetApiKeyRequired(v bool) *UpdateRouteInput {
	s.ApiKeyRequired = &v
	return s
}

// SetAuthorizationScopes sets the AuthorizationScopes field's value.
func (s *UpdateRouteInput) SetAuthorizationScopes(v []*string) *UpdateRouteInput {
	s.AuthorizationScopes = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *UpdateRouteInput) SetAuthorizationType(v string) *UpdateRouteInput {
	s.AuthorizationType = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *UpdateRouteInput) SetAuthorizerId(v string) *UpdateRouteInput {
	s.AuthorizerId = &v
	return s
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *UpdateRouteInput) SetModelSelectionExpression(v string) *UpdateRouteInput {
	s.ModelSelectionExpression = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *UpdateRouteInput) SetOperationName(v string) *UpdateRouteInput {
	s.OperationName = &v
	return s
}

// SetRequestModels sets the RequestModels field's value.
func (s *UpdateRouteInput) SetRequestModels(v map[string]*string) *UpdateRouteInput {
	s.RequestModels = v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *UpdateRouteInput) SetRequestParameters(v map[string]*ParameterConstraints) *UpdateRouteInput {
	s.RequestParameters = v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *UpdateRouteInput) SetRouteId(v string) *UpdateRouteInput {
	s.RouteId = &v
	return s
}

// SetRouteKey sets the RouteKey field's value.
func (s *UpdateRouteInput) SetRouteKey(v string) *UpdateRouteInput {
	s.RouteKey = &v
	return s
}

// SetRouteResponseSelectionExpression sets the RouteResponseSelectionExpression field's value.
func (s *UpdateRouteInput) SetRouteResponseSelectionExpression(v string) *UpdateRouteInput {
	s.RouteResponseSelectionExpression = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *UpdateRouteInput) SetTarget(v string) *UpdateRouteInput {
	s.Target = &v
	return s
}

type UpdateRouteOutput struct {
	_ struct{} `type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on a route. The scopes are used
	// with a JWT authorizer to authorize the method invocation. The authorization
	// works by matching the route scopes against the scopes parsed from the access
	// token in the incoming request. The method invocation is authorized if any
	// route scope matches a claimed scope in the access token. Otherwise, the invocation
	// is not authorized. When the route scope is configured, the client must provide
	// an access token instead of an identity token for authorization purposes.
	AuthorizationScopes []*string `locationName:"authorizationScopes" type:"list"`

	// The authorization type. For WebSocket APIs, valid values are NONE for open
	// access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda
	// authorizer. For HTTP APIs, valid values are NONE for open access, or JWT
	// for using JSON Web Tokens.
	AuthorizationType *string `locationName:"authorizationType" type:"string" enum:"AuthorizationType"`

	// The identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// A string with a length between [1-64].
	OperationName *string `locationName:"operationName" type:"string"`

	// The route models.
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// The route parameters.
	RequestParameters map[string]*ParameterConstraints `locationName:"requestParameters" type:"map"`

	// The identifier.
	RouteId *string `locationName:"routeId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteKey *string `locationName:"routeKey" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteResponseSelectionExpression *string `locationName:"routeResponseSelectionExpression" type:"string"`

	// A string with a length between [1-128].
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s UpdateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRouteOutput) GoString() string {
	return s.String()
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *UpdateRouteOutput) SetApiGatewayManaged(v bool) *UpdateRouteOutput {
	s.ApiGatewayManaged = &v
	return s
}

// SetApiKeyRequired sets the ApiKeyRequired field's value.
func (s *UpdateRouteOutput) SetApiKeyRequired(v bool) *UpdateRouteOutput {
	s.ApiKeyRequired = &v
	return s
}

// SetAuthorizationScopes sets the AuthorizationScopes field's value.
func (s *UpdateRouteOutput) SetAuthorizationScopes(v []*string) *UpdateRouteOutput {
	s.AuthorizationScopes = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *UpdateRouteOutput) SetAuthorizationType(v string) *UpdateRouteOutput {
	s.AuthorizationType = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *UpdateRouteOutput) SetAuthorizerId(v string) *UpdateRouteOutput {
	s.AuthorizerId = &v
	return s
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *UpdateRouteOutput) SetModelSelectionExpression(v string) *UpdateRouteOutput {
	s.ModelSelectionExpression = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *UpdateRouteOutput) SetOperationName(v string) *UpdateRouteOutput {
	s.OperationName = &v
	return s
}

// SetRequestModels sets the RequestModels field's value.
func (s *UpdateRouteOutput) SetRequestModels(v map[string]*string) *UpdateRouteOutput {
	s.RequestModels = v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *UpdateRouteOutput) SetRequestParameters(v map[string]*ParameterConstraints) *UpdateRouteOutput {
	s.RequestParameters = v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *UpdateRouteOutput) SetRouteId(v string) *UpdateRouteOutput {
	s.RouteId = &v
	return s
}

// SetRouteKey sets the RouteKey field's value.
func (s *UpdateRouteOutput) SetRouteKey(v string) *UpdateRouteOutput {
	s.RouteKey = &v
	return s
}

// SetRouteResponseSelectionExpression sets the RouteResponseSelectionExpression field's value.
func (s *UpdateRouteOutput) SetRouteResponseSelectionExpression(v string) *UpdateRouteOutput {
	s.RouteResponseSelectionExpression = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *UpdateRouteOutput) SetTarget(v string) *UpdateRouteOutput {
	s.Target = &v
	return s
}

type UpdateRouteResponseInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// The route models.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// The route parameters.
	ResponseParameters map[string]*ParameterConstraints `locationName:"responseParameters" type:"map"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`

	// RouteResponseId is a required field
	RouteResponseId *string `location:"uri" locationName:"routeResponseId" type:"string" required:"true"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteResponseKey *string `locationName:"routeResponseKey" type:"string"`
}

// String returns the string representation
func (s UpdateRouteResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRouteResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRouteResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRouteResponseInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.RouteId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteId"))
	}
	if s.RouteId != nil && len(*s.RouteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteId", 1))
	}
	if s.RouteResponseId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteResponseId"))
	}
	if s.RouteResponseId != nil && len(*s.RouteResponseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteResponseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiId sets the ApiId field's value.
func (s *UpdateRouteResponseInput) SetApiId(v string) *UpdateRouteResponseInput {
	s.ApiId = &v
	return s
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *UpdateRouteResponseInput) SetModelSelectionExpression(v string) *UpdateRouteResponseInput {
	s.ModelSelectionExpression = &v
	return s
}

// SetResponseModels sets the ResponseModels field's value.
func (s *UpdateRouteResponseInput) SetResponseModels(v map[string]*string) *UpdateRouteResponseInput {
	s.ResponseModels = v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *UpdateRouteResponseInput) SetResponseParameters(v map[string]*ParameterConstraints) *UpdateRouteResponseInput {
	s.ResponseParameters = v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *UpdateRouteResponseInput) SetRouteId(v string) *UpdateRouteResponseInput {
	s.RouteId = &v
	return s
}

// SetRouteResponseId sets the RouteResponseId field's value.
func (s *UpdateRouteResponseInput) SetRouteResponseId(v string) *UpdateRouteResponseInput {
	s.RouteResponseId = &v
	return s
}

// SetRouteResponseKey sets the RouteResponseKey field's value.
func (s *UpdateRouteResponseInput) SetRouteResponseKey(v string) *UpdateRouteResponseInput {
	s.RouteResponseKey = &v
	return s
}

type UpdateRouteResponseOutput struct {
	_ struct{} `type:"structure"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// The route models.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// The route parameters.
	ResponseParameters map[string]*ParameterConstraints `locationName:"responseParameters" type:"map"`

	// The identifier.
	RouteResponseId *string `locationName:"routeResponseId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	RouteResponseKey *string `locationName:"routeResponseKey" type:"string"`
}

// String returns the string representation
func (s UpdateRouteResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRouteResponseOutput) GoString() string {
	return s.String()
}

// SetModelSelectionExpression sets the ModelSelectionExpression field's value.
func (s *UpdateRouteResponseOutput) SetModelSelectionExpression(v string) *UpdateRouteResponseOutput {
	s.ModelSelectionExpression = &v
	return s
}

// SetResponseModels sets the ResponseModels field's value.
func (s *UpdateRouteResponseOutput) SetResponseModels(v map[string]*string) *UpdateRouteResponseOutput {
	s.ResponseModels = v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *UpdateRouteResponseOutput) SetResponseParameters(v map[string]*ParameterConstraints) *UpdateRouteResponseOutput {
	s.ResponseParameters = v
	return s
}

// SetRouteResponseId sets the RouteResponseId field's value.
func (s *UpdateRouteResponseOutput) SetRouteResponseId(v string) *UpdateRouteResponseOutput {
	s.RouteResponseId = &v
	return s
}

// SetRouteResponseKey sets the RouteResponseKey field's value.
func (s *UpdateRouteResponseOutput) SetRouteResponseKey(v string) *UpdateRouteResponseOutput {
	s.RouteResponseKey = &v
	return s
}

type UpdateStageInput struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in a stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// Represents a collection of route settings.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The route settings map.
	RouteSettings map[string]*RouteSettings `locationName:"routeSettings" type:"map"`

	// StageName is a required field
	StageName *string `location:"uri" locationName:"stageName" type:"string" required:"true"`

	// The stage variable map.
	StageVariables map[string]*string `locationName:"stageVariables" type:"map"`
}

// String returns the string representation
func (s UpdateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStageInput"}
	if s.ApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiId"))
	}
	if s.ApiId != nil && len(*s.ApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *UpdateStageInput) SetAccessLogSettings(v *AccessLogSettings) *UpdateStageInput {
	s.AccessLogSettings = v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *UpdateStageInput) SetApiId(v string) *UpdateStageInput {
	s.ApiId = &v
	return s
}

// SetAutoDeploy sets the AutoDeploy field's value.
func (s *UpdateStageInput) SetAutoDeploy(v bool) *UpdateStageInput {
	s.AutoDeploy = &v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *UpdateStageInput) SetClientCertificateId(v string) *UpdateStageInput {
	s.ClientCertificateId = &v
	return s
}

// SetDefaultRouteSettings sets the DefaultRouteSettings field's value.
func (s *UpdateStageInput) SetDefaultRouteSettings(v *RouteSettings) *UpdateStageInput {
	s.DefaultRouteSettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *UpdateStageInput) SetDeploymentId(v string) *UpdateStageInput {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateStageInput) SetDescription(v string) *UpdateStageInput {
	s.Description = &v
	return s
}

// SetRouteSettings sets the RouteSettings field's value.
func (s *UpdateStageInput) SetRouteSettings(v map[string]*RouteSettings) *UpdateStageInput {
	s.RouteSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *UpdateStageInput) SetStageName(v string) *UpdateStageInput {
	s.StageName = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *UpdateStageInput) SetStageVariables(v map[string]*string) *UpdateStageInput {
	s.StageVariables = v
	return s
}

type UpdateStageOutput struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in a stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// Represents a collection of route settings.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	LastDeploymentStatusMessage *string `locationName:"lastDeploymentStatusMessage" type:"string"`

	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601"`

	// The route settings map.
	RouteSettings map[string]*RouteSettings `locationName:"routeSettings" type:"map"`

	// A string with a length between [1-128].
	StageName *string `locationName:"stageName" type:"string"`

	// The stage variable map.
	StageVariables map[string]*string `locationName:"stageVariables" type:"map"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s UpdateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStageOutput) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *UpdateStageOutput) SetAccessLogSettings(v *AccessLogSettings) *UpdateStageOutput {
	s.AccessLogSettings = v
	return s
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *UpdateStageOutput) SetApiGatewayManaged(v bool) *UpdateStageOutput {
	s.ApiGatewayManaged = &v
	return s
}

// SetAutoDeploy sets the AutoDeploy field's value.
func (s *UpdateStageOutput) SetAutoDeploy(v bool) *UpdateStageOutput {
	s.AutoDeploy = &v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *UpdateStageOutput) SetClientCertificateId(v string) *UpdateStageOutput {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *UpdateStageOutput) SetCreatedDate(v time.Time) *UpdateStageOutput {
	s.CreatedDate = &v
	return s
}

// SetDefaultRouteSettings sets the DefaultRouteSettings field's value.
func (s *UpdateStageOutput) SetDefaultRouteSettings(v *RouteSettings) *UpdateStageOutput {
	s.DefaultRouteSettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *UpdateStageOutput) SetDeploymentId(v string) *UpdateStageOutput {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateStageOutput) SetDescription(v string) *UpdateStageOutput {
	s.Description = &v
	return s
}

// SetLastDeploymentStatusMessage sets the LastDeploymentStatusMessage field's value.
func (s *UpdateStageOutput) SetLastDeploymentStatusMessage(v string) *UpdateStageOutput {
	s.LastDeploymentStatusMessage = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *UpdateStageOutput) SetLastUpdatedDate(v time.Time) *UpdateStageOutput {
	s.LastUpdatedDate = &v
	return s
}

// SetRouteSettings sets the RouteSettings field's value.
func (s *UpdateStageOutput) SetRouteSettings(v map[string]*RouteSettings) *UpdateStageOutput {
	s.RouteSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *UpdateStageOutput) SetStageName(v string) *UpdateStageOutput {
	s.StageName = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *UpdateStageOutput) SetStageVariables(v map[string]*string) *UpdateStageOutput {
	s.StageVariables = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateStageOutput) SetTags(v map[string]*string) *UpdateStageOutput {
	s.Tags = v
	return s
}

type UpdateVpcLinkInput struct {
	_ struct{} `type:"structure"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// VpcLinkId is a required field
	VpcLinkId *string `location:"uri" locationName:"vpcLinkId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVpcLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVpcLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVpcLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVpcLinkInput"}
	if s.VpcLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcLinkId"))
	}
	if s.VpcLinkId != nil && len(*s.VpcLinkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcLinkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateVpcLinkInput) SetName(v string) *UpdateVpcLinkInput {
	s.Name = &v
	return s
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *UpdateVpcLinkInput) SetVpcLinkId(v string) *UpdateVpcLinkInput {
	s.VpcLinkId = &v
	return s
}

type UpdateVpcLinkOutput struct {
	_ struct{} `type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A list of security group IDs for the VPC link.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// A list of subnet IDs to include in the VPC link.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The identifier.
	VpcLinkId *string `locationName:"vpcLinkId" type:"string"`

	// The status of the VPC link.
	VpcLinkStatus *string `locationName:"vpcLinkStatus" type:"string" enum:"VpcLinkStatus"`

	// A string with a length between [0-1024].
	VpcLinkStatusMessage *string `locationName:"vpcLinkStatusMessage" type:"string"`

	// The version of the VPC link.
	VpcLinkVersion *string `locationName:"vpcLinkVersion" type:"string" enum:"VpcLinkVersion"`
}

// String returns the string representation
func (s UpdateVpcLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVpcLinkOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *UpdateVpcLinkOutput) SetCreatedDate(v time.Time) *UpdateVpcLinkOutput {
	s.CreatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateVpcLinkOutput) SetName(v string) *UpdateVpcLinkOutput {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateVpcLinkOutput) SetSecurityGroupIds(v []*string) *UpdateVpcLinkOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *UpdateVpcLinkOutput) SetSubnetIds(v []*string) *UpdateVpcLinkOutput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateVpcLinkOutput) SetTags(v map[string]*string) *UpdateVpcLinkOutput {
	s.Tags = v
	return s
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *UpdateVpcLinkOutput) SetVpcLinkId(v string) *UpdateVpcLinkOutput {
	s.VpcLinkId = &v
	return s
}

// SetVpcLinkStatus sets the VpcLinkStatus field's value.
func (s *UpdateVpcLinkOutput) SetVpcLinkStatus(v string) *UpdateVpcLinkOutput {
	s.VpcLinkStatus = &v
	return s
}

// SetVpcLinkStatusMessage sets the VpcLinkStatusMessage field's value.
func (s *UpdateVpcLinkOutput) SetVpcLinkStatusMessage(v string) *UpdateVpcLinkOutput {
	s.VpcLinkStatusMessage = &v
	return s
}

// SetVpcLinkVersion sets the VpcLinkVersion field's value.
func (s *UpdateVpcLinkOutput) SetVpcLinkVersion(v string) *UpdateVpcLinkOutput {
	s.VpcLinkVersion = &v
	return s
}

// Represents a VPC link.
type VpcLink struct {
	_ struct{} `type:"structure"`

	// The timestamp when the VPC link was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the VPC link.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A list of security group IDs for the VPC link.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list" required:"true"`

	// A list of subnet IDs to include in the VPC link.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`

	// Tags for the VPC link.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the VPC link.
	//
	// VpcLinkId is a required field
	VpcLinkId *string `locationName:"vpcLinkId" type:"string" required:"true"`

	// The status of the VPC link.
	VpcLinkStatus *string `locationName:"vpcLinkStatus" type:"string" enum:"VpcLinkStatus"`

	// A message summarizing the cause of the status of the VPC link.
	VpcLinkStatusMessage *string `locationName:"vpcLinkStatusMessage" type:"string"`

	// The version of the VPC link.
	VpcLinkVersion *string `locationName:"vpcLinkVersion" type:"string" enum:"VpcLinkVersion"`
}

// String returns the string representation
func (s VpcLink) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcLink) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *VpcLink) SetCreatedDate(v time.Time) *VpcLink {
	s.CreatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *VpcLink) SetName(v string) *VpcLink {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcLink) SetSecurityGroupIds(v []*string) *VpcLink {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcLink) SetSubnetIds(v []*string) *VpcLink {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *VpcLink) SetTags(v map[string]*string) *VpcLink {
	s.Tags = v
	return s
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *VpcLink) SetVpcLinkId(v string) *VpcLink {
	s.VpcLinkId = &v
	return s
}

// SetVpcLinkStatus sets the VpcLinkStatus field's value.
func (s *VpcLink) SetVpcLinkStatus(v string) *VpcLink {
	s.VpcLinkStatus = &v
	return s
}

// SetVpcLinkStatusMessage sets the VpcLinkStatusMessage field's value.
func (s *VpcLink) SetVpcLinkStatusMessage(v string) *VpcLink {
	s.VpcLinkStatusMessage = &v
	return s
}

// SetVpcLinkVersion sets the VpcLinkVersion field's value.
func (s *VpcLink) SetVpcLinkVersion(v string) *VpcLink {
	s.VpcLinkVersion = &v
	return s
}

// The authorization type. For WebSocket APIs, valid values are NONE for open
// access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda
// authorizer. For HTTP APIs, valid values are NONE for open access, or JWT
// for using JSON Web Tokens.
const (
	// AuthorizationTypeNone is a AuthorizationType enum value
	AuthorizationTypeNone = "NONE"

	// AuthorizationTypeAwsIam is a AuthorizationType enum value
	AuthorizationTypeAwsIam = "AWS_IAM"

	// AuthorizationTypeCustom is a AuthorizationType enum value
	AuthorizationTypeCustom = "CUSTOM"

	// AuthorizationTypeJwt is a AuthorizationType enum value
	AuthorizationTypeJwt = "JWT"
)

// The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function
// using incoming request parameters. For HTTP APIs, specify JWT to use JSON
// Web Tokens.
const (
	// AuthorizerTypeRequest is a AuthorizerType enum value
	AuthorizerTypeRequest = "REQUEST"

	// AuthorizerTypeJwt is a AuthorizerType enum value
	AuthorizerTypeJwt = "JWT"
)

// Represents a connection type.
const (
	// ConnectionTypeInternet is a ConnectionType enum value
	ConnectionTypeInternet = "INTERNET"

	// ConnectionTypeVpcLink is a ConnectionType enum value
	ConnectionTypeVpcLink = "VPC_LINK"
)

// Specifies how to handle response payload content type conversions. Supported
// only for WebSocket APIs.
const (
	// ContentHandlingStrategyConvertToBinary is a ContentHandlingStrategy enum value
	ContentHandlingStrategyConvertToBinary = "CONVERT_TO_BINARY"

	// ContentHandlingStrategyConvertToText is a ContentHandlingStrategy enum value
	ContentHandlingStrategyConvertToText = "CONVERT_TO_TEXT"
)

// Represents a deployment status.
const (
	// DeploymentStatusPending is a DeploymentStatus enum value
	DeploymentStatusPending = "PENDING"

	// DeploymentStatusFailed is a DeploymentStatus enum value
	DeploymentStatusFailed = "FAILED"

	// DeploymentStatusDeployed is a DeploymentStatus enum value
	DeploymentStatusDeployed = "DEPLOYED"
)

// The status of the domain name migration. The valid values are AVAILABLE and
// UPDATING. If the status is UPDATING, the domain cannot be modified further
// until the existing operation is complete. If it is AVAILABLE, the domain
// can be updated.
const (
	// DomainNameStatusAvailable is a DomainNameStatus enum value
	DomainNameStatusAvailable = "AVAILABLE"

	// DomainNameStatusUpdating is a DomainNameStatus enum value
	DomainNameStatusUpdating = "UPDATING"
)

// Represents an endpoint type.
const (
	// EndpointTypeRegional is a EndpointType enum value
	EndpointTypeRegional = "REGIONAL"

	// EndpointTypeEdge is a EndpointType enum value
	EndpointTypeEdge = "EDGE"
)

// Represents an API method integration type.
const (
	// IntegrationTypeAws is a IntegrationType enum value
	IntegrationTypeAws = "AWS"

	// IntegrationTypeHttp is a IntegrationType enum value
	IntegrationTypeHttp = "HTTP"

	// IntegrationTypeMock is a IntegrationType enum value
	IntegrationTypeMock = "MOCK"

	// IntegrationTypeHttpProxy is a IntegrationType enum value
	IntegrationTypeHttpProxy = "HTTP_PROXY"

	// IntegrationTypeAwsProxy is a IntegrationType enum value
	IntegrationTypeAwsProxy = "AWS_PROXY"
)

// The logging level.
const (
	// LoggingLevelError is a LoggingLevel enum value
	LoggingLevelError = "ERROR"

	// LoggingLevelInfo is a LoggingLevel enum value
	LoggingLevelInfo = "INFO"

	// LoggingLevelOff is a LoggingLevel enum value
	LoggingLevelOff = "OFF"
)

// Represents passthrough behavior for an integration response. Supported only
// for WebSocket APIs.
const (
	// PassthroughBehaviorWhenNoMatch is a PassthroughBehavior enum value
	PassthroughBehaviorWhenNoMatch = "WHEN_NO_MATCH"

	// PassthroughBehaviorNever is a PassthroughBehavior enum value
	PassthroughBehaviorNever = "NEVER"

	// PassthroughBehaviorWhenNoTemplates is a PassthroughBehavior enum value
	PassthroughBehaviorWhenNoTemplates = "WHEN_NO_TEMPLATES"
)

// Represents a protocol type.
const (
	// ProtocolTypeWebsocket is a ProtocolType enum value
	ProtocolTypeWebsocket = "WEBSOCKET"

	// ProtocolTypeHttp is a ProtocolType enum value
	ProtocolTypeHttp = "HTTP"
)

// The Transport Layer Security (TLS) version of the security policy for this
// domain name. The valid values are TLS_1_0 and TLS_1_2.
const (
	// SecurityPolicyTls10 is a SecurityPolicy enum value
	SecurityPolicyTls10 = "TLS_1_0"

	// SecurityPolicyTls12 is a SecurityPolicy enum value
	SecurityPolicyTls12 = "TLS_1_2"
)

// The status of the VPC link.
const (
	// VpcLinkStatusPending is a VpcLinkStatus enum value
	VpcLinkStatusPending = "PENDING"

	// VpcLinkStatusAvailable is a VpcLinkStatus enum value
	VpcLinkStatusAvailable = "AVAILABLE"

	// VpcLinkStatusDeleting is a VpcLinkStatus enum value
	VpcLinkStatusDeleting = "DELETING"

	// VpcLinkStatusFailed is a VpcLinkStatus enum value
	VpcLinkStatusFailed = "FAILED"

	// VpcLinkStatusInactive is a VpcLinkStatus enum value
	VpcLinkStatusInactive = "INACTIVE"
)

// The version of the VPC link.
const (
	// VpcLinkVersionV2 is a VpcLinkVersion enum value
	VpcLinkVersionV2 = "V2"
)
