/*
 * Portable string handling routines.
 * $Id: string.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__STD_STRINGS_H__
#define	__STD_STRINGS_H__

#ifndef	__STD_TYPES_H__
#include <std/types.h>
#endif

#include <string.h>
#include <ctype.h>

#ifndef	STRCASECMP_F_MISSING
#define	stricmp(s1, s2)	strcasecmp(s1, s2)
#define	strnicmp(s1, s2, n) strncasecmp(s1, s2, n)
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	__NAMESPACE
#define	__SPACES	__NAMESPACE(__SPACES)
#endif

extern	char	__SPACES[];

#ifdef	STRICMP_F_MISSING
#ifdef	__NAMESPACE
#define	stricmp		__NAMESPACE(stricmp)
#define	strnicmp	__NAMESPACE(strnicmp)
#endif

int	stricmp(const char *s1, const char *s2);
int	strnicmp(const char *s1, const char *s2, size_t n);
#endif

#ifdef	STRLWR_F_MISSING

#ifdef	__NAMESPACE
#define	strupr	__NAMESPACE(strupr)
#define	strlwr	__NAMESPACE(strlwr)
#endif

char	*strlwr(char *s1);
char	*strupr(char *s2);
#endif

#ifdef	STRDUP_F_MISSING

#ifdef	__NAMESPACE
#define	strdup	__NAMESPACE(strdup)
#endif

char *strdup(const char *s);
#endif

#ifdef	STRISTR_F_MISSING
#ifdef	__NAMESPACE
#define	stristr		__NAMESPACE(stristr)
#endif

char	*stristr(char *s1, const char *s2);
#endif

#ifdef	__cplusplus
}
#endif

#endif
