/* 
 * Define constants used by other string services and case insensitive
 * compare and conversion functions missing in some libc distributions.
 * $Id: string.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <std/string.h>

#ifdef	STRLWR_F_MISSING

char    *strlwr(char *s)
{
	char    *old;

	if(!s)
		return NULL;
		
	old=s;
	while(*s = (char)tolower(*s))
		++s;
	
	return old;
}

char    *strupr(char *s)
{
	char    *old;

	if(!s)
		return NULL;
		
	old=s;
	while(*s = (char)toupper(*s))
		++s;
	return old;
}

#endif

#ifdef	STRDUP_F_MISSING

char	*strdup(str)
char	*str;
{
	char	*new = (char *)malloc(strlen(str) + 1);
	if(!new)
		return NULL;

	return strcpy(new, str);
}

#endif

#ifdef	STRICMP_F_MISSING

int stricmp(const char *s1, const char *s2)
{
	int t;

	while(*s1 && *s2)
	{
		if (t=tolower(*s1)-tolower(*s2))
			return  t;

		++s1;
		++s2;
	}
	return tolower(*s1)-tolower(*s2);
}

int strnicmp(const char *s1,const char *s2, size_t n)
{
	int t;

	while (n--)
	{
		if (t=tolower(*s1)-tolower(*s2))
			return  t;

		if (!*s1)
			return 0;

		++s1;
		++s2;
	}
	return 0;
}

#endif

#ifdef	STRISTR_F_MISSING

char	*stristr(char *s1, const char *s2)
{
	int	len = strlen(s2);
	int	count = strlen(s1) - len + 1;

	while(count--)
	{
		if(!strnicmp(s1, s2, len))
			return s1;
		++s1;
	}
	return NULL;
}

#endif
		
