/*
 * Portable process handling routines.
 * $Id: process.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__STD_PROCESS_H__
#define	__STD_PROCESS_H__

#ifndef	__STD_TYPES_H__
#include <std/types.h>
#endif

#ifndef	__STD_LIMITS_H__
#include <std/limits.h>
#endif

#ifndef	POSIX2_LIM_H_MISSING
#include <posix2_lim.h>
#endif

#ifndef	POSIX_OPT_H_MISSING
#include <posix_opt.h>
#endif

#ifndef	UNISTD_H_MISSING
#include <unistd.h>
#endif

#ifndef	_SC_OPEN_MAX
#ifndef	CONFNAME_H_MISSING
#include <confname.h>
#else
#ifndef	SYSCONF_H_MISSING
#include <sysconf.h>
#endif
#endif
#endif

#ifndef	PROCESS_H_MISSING
#include <process.h>
#endif

#ifndef	WAIT_H_MISSING
#include <wait.h>
#else
#ifndef	SYS_WAIT_H_MISSING
#include <sys/wait.h>
#endif
#endif

#ifndef ENV_H_MISSING
#include <env.h>
#endif

#ifndef	SYSEXITS_H_MISSING
#include <sysexits.h>
#else
#include <std/sysexits.h>
#endif

/* We now re-evaluate system limits using runtime sysconf() values */ 

#ifdef	_SC_ARG_MAX
#undef	ARG_MAX
#define	ARG_MAX (sysconf(_SC_ARG_MAX))
#endif

#ifdef	_SC_CHILD_MAX
#undef	CHILD_MAX
#define	CHILD_MAX (sysconf(_SC_CHILD_MAX))
#endif

#ifdef	_SC_NGROUPS_MAX
#undef	NGROUPS_MAX
#define	NGROUPS_MAX (sysconf(_SC_NGROUPS_MAX))
#endif

#ifdef	_SC_OPEN_MAX
#undef	OPEN_MAX
#define	OPEN_MAX (sysconf(_SC_OPEN_MAX))
#endif

#ifdef	_SC_STREAM_MAX
#undef	STREAM_MAX
#define	STREAM_MAX (sysconf(_SC_STREAM_MAX))
#endif

#ifdef	_SC_TZNAME_MAX
#undef	TZNAME_MAX
#define	TZNAME_MAX (sysconf(_SC_TZNAME_MAX))
#endif

#ifdef	PID_T_MISSING
typedef	int pid_t;
#endif

#endif
