/*
 * Specify process for soft realtime scheduling treatment.
 * $Id: priority.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */
 
#include <proc/process.h>
#include <std/time.h>

#ifndef	SYS_RESOURCE_H_MISSING
#include <sys/resource.h>
#endif

#ifndef	SETPRIORITY_F_MISSING

int	priority(int pri)
{
#ifdef	_POSIX_PRIORITY_SCHEDULING
	#define	_P	__P

	#include <sched.h>

	struct	sched_param p;
#endif
	int newpri = getpriority(PRIO_PROCESS, 0) - pri - 1;

	if(setpriority(PRIO_PROCESS, 0, newpri))
		return -1;

#ifdef	_POSIX_MEMLOCK
	#include <linux/mman.h>

	if(mlockall(MCL_CURRENT | MCL_FUTURE))
		return -1;
#endif

#ifdef	_POSIX_PRIORITY_SCHEDULING
	if(pri > 0)
	{
		p.sched_priority = sched_get_priority_min(SCHED_RR) + pri - 1;
		if(sched_setscheduler(0, SCHED_RR, &p))
			return -1;
	} 
#endif
	
	return 0;
}

#else

int	priority(int priority)
{
	return nice(- priority - 1);
}
#endif

#ifdef	_POSIX_PRIORITY_SCHEDULING
#include <sched.h>

void	yield(void)
{
	sched_yield();
}
#else

void	yield(void)
{
	sleep(0);
}
#endif
	

