/* 
 * Alternate thread-safe string token parsing.
 * $Id: token.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/string.h>

char *token(char **ptr, const char *tok)
{
        char *p;
        char *brk;
                            
        if(strblank(*ptr))
                return NULL;

        p = strltrim(*ptr, tok);
        brk = strpbrk(p, tok);
        if(brk)
        {
                *brk = 0;
                *ptr = strltrim(++brk, tok);
                if(!(**ptr))
                        *ptr = NULL;        
        }
        else
                *ptr = NULL;
        return p;
}

char *field(char **ptr, const char *tok)
{
        char *p = *ptr;
	char *brk;

        if(strblank(p))
                return NULL;

        brk = strpbrk(p, tok);
        if(brk)
        {
                *brk = 0;
                *ptr = ++brk;
        }
        else
                *ptr = NULL;

        return p;
}
