/*
 * Memory pool creation.
 * $Id: mempool.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/memory.h>
#include <std/files.h>
#include <std/math.h>
#include <std/process.h>

static  void    *fault(MEMPOOL *mem, int request)
{
        fputs("* mempool: memory pool exhausted\n", stderr);
	exit(EX_SOFTWARE);
}

MEMPOOL *mempool(int psize, int pcount)
{
        char *page;
        MEMPAGE *first;
        MEMPOOL *pool;

	psize = align(psize, __MEMALIGN);
        if(NULL == (page = (char *)malloc(psize)))
                return NULL;

	first = (MEMPAGE *)page;
	pool = (MEMPOOL *)(page + sizeof(MEMPAGE));

        first->page_next = NULL;
        first->page_used = sizeof(MEMPOOL);

        pool->mem_psize = psize - sizeof(MEMPAGE);
        pool->mem_pcount = pcount;
        pool->mem_pused = 1;
        pool->mem_pfault = fault;
        pool->mem_reuse = NULL;
        pool->mem_last = first;
	pool->mem_free = NULL;
        return pool;
}






