/* 
 * Portable routines to create argv[] argument lists for exec and spawn. 
 * $Id: getargv.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/string.h>

int	getargv(char *base[], char *cbuf)
{
	int	arg	=	0;
	int	qflag = 0;
	int	sflag = 1;

	while(*cbuf)
	{
    	switch(*cbuf)
		{
		case ' ':
		case '\t':
			if(qflag)
				break;
			if(!sflag)
			{
				*cbuf = 0;
				sflag = 1;
			}
			break;
		case '\"':
			if(!qflag)
			{
				*cbuf = 0;
				base[arg++] = cbuf + 1;
				sflag = 0;
				qflag = 1;
			}
			else
			{
				*cbuf = 0;
				sflag = 1;
				qflag = 0;
			}
		        break;
		default:
			if(sflag)
			{
				base[arg++] = cbuf;
				sflag = 0;	
			}
		}
		++cbuf;
	}
	base[arg] = NULL;
	return arg;
}

