/*
 * Portable file and directory name functions.
 * $Id: filename.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/files.h>
#include <std/string.h>
#include <std/math.h>

char *dirname(char *path)
{
	char *p = basename(path);
	if(p == path)
		return ".";
	
	*(--p) = 0;
	return path;
}

char *basename(const char *path)
{
	char *p = strrchr(path, '/');
#if defined(_MSDOS) || defined(_OS2) || defined(_WIN32)
	char *p1 = strrchr(path, '\\');
	p = max(p, p1);
#endif
	
	if(p)
		return ++p;
	else
		return (char *)path;
}

char *extfname(const char *path)
{
	char *e = strrchr(pathfname(path), '.');

	if(e)
		return e;
	else
		return "";
}

bool	ispath(const char *p)
{
	if(strchr(p, '/'))
		return TRUE;
#if defined(_MSDOS) || defined(_OS2) || defined(_WIN32)
	if(strchr(p, '\\'))
		return TRUE;
#endif
	return FALSE;
}

bool	isroot(const char *p)
{
#if defined(_MSDOS) || defined(_OS2) || defined(_WIN32)
	if(!strncmp(p, "\\\\", 2))
		return TRUE;
	
	if(p[1] == ':')
		return TRUE;	
#else
	if(*p == '/')
		return TRUE;
#endif
	return FALSE;
}




