/*
 * Convert ASCII text into binary value.
 * $Id: atob.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and use, see product license.
 *
 * Functions:
 *	atob() - convert null terminated ASCII string to boolean value.
 */

#include <other/strcvt.h>

/*
 * Convert null terminated ASCII string to boolean value.
 *
 * Abstract:
 *	The input string can be numeric; such as "0" or "1", or alpha;
 *	such as "T" for true, "F" for false, or "Y" or "N".  Only the
 *	first character of the string is examined.  Upper/lower case is
 *	ignored.	
 *
 * Parameters:
 *	str - null terminated ASCII string.
 *
 * Returns:
 *	logical value of input string.
 *
 * Exceptions:
 *	Any unrecognized string value, or a NULL string, return FALSE.
 */

bool atob(const char *str)
{
	if(!str)
		return FALSE;
		
	switch(*str)
	{
	case '0':
	case 'f':
	case 'F':
	case 'n':
	case 'N':
		return FALSE;
	}
	return TRUE;
}
