/*
 * Convert network mask or address string into a "BIND" filter mask.
 * $Id: netaddr.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <net/socket.h>
#include <std/string.h>

struct	in_addr *getnetaddr(const char *mask)
{
	static	struct	in_addr addr;
	struct	in_addr	*aptr;
	struct	hostent	*hp;

	if(!mask)
		mask = "0.0.0.0";

	hp = gethost(mask);
	if(!hp)
		return NULL;
		
	while((aptr = (struct in_addr *)*(hp->h_addr_list)++) != NULL)
		addr = *aptr;

	return &addr;
}
