#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"


gboolean line_numbers  = FALSE;
gboolean hyper_include = FALSE;
gboolean backup_html   = FALSE;

GtkWidget *Aboot;

gchar* INFile;
gchar* OUTFile;
gchar* SCSFile;
gchar* Ext;
gchar* Flags = '\0';



void
on_checkbutton1_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
 if  (line_numbers == FALSE) {line_numbers = TRUE;}
 else {line_numbers = FALSE;}
}


void
on_checkhyperlinks_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

 if  (hyper_include == FALSE) {hyper_include = TRUE;}
 else {hyper_include = FALSE;}
}


void
on_checkbackup_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
 if  (backup_html == FALSE) {
  backup_html = TRUE;
  system("gmessage \".old will be appended to the old html filename.\" &");
 }
 else {backup_html = FALSE;}
}


void
on_preview_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
 gchar* view;

 view = g_strdup_printf("galeon %s &",OUTFile);
 system(view);
}


void
on_button1_released                    (GtkButton       *button,
                                        gpointer         user_data)
{
 Aboot = create_about1();
 gtk_widget_show (Aboot);
}


void
on_button2_released                    (GtkButton       *button,
                                        gpointer         user_data)
{
 gchar*   command;
 gchar*   swi;
 GString* switches;

 switches = g_string_new("");
 if(line_numbers == TRUE)  {
  switches = g_string_append(switches, " -l");
 }
 if(hyper_include == TRUE) {
  switches = g_string_append(switches, " -h");
 }
 if(backup_html == TRUE)   {
  switches = g_string_append(switches, " -b");
 }
 if(Flags != '\0') {
  switches = g_string_append(switches, " ");
  switches = g_string_append(switches, Flags);
 }
 swi = switches->str;

 command = g_strdup_printf("cat %s | webcpp - %s -c=%s.scs -t=%s %s && gmessage \"command executed.\"",
                            INFile,OUTFile,SCSFile,Ext,swi);

 printf("command is %s.\n", command);

 system(command);

 g_string_free(switches,TRUE);
}


void
on_ifile_entry_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
 INFile = gtk_entry_get_text(GTK_ENTRY(editable));
}


void
on_ofile_entry_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
 OUTFile = gtk_entry_get_text(GTK_ENTRY(editable));
}


void
on_switches_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
 Flags = gtk_entry_get_text(GTK_ENTRY(editable));
}


void
on_scheme_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
 SCSFile = gtk_entry_get_text(GTK_ENTRY(editable));
}


void
on_filetype_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
 gchar* Type;
 Type = gtk_entry_get_text(GTK_ENTRY(editable));

 if(!g_strcasecmp(Type, "C source")) {
   Ext = "c";
 } else if (!g_strcasecmp(Type, "C++ source")) {
   Ext = "cpp";
 } else if (!g_strcasecmp(Type, "C/C++ header")) {
   Ext = "hh";
 } else if (!g_strcasecmp(Type, "Java")) {
   Ext = "java";
 } else if (!g_strcasecmp(Type, "Markup")) {
   Ext = "html";
 } else if (!g_strcasecmp(Type, "Perl")) {
   Ext = "pl";
 } else if (!g_strcasecmp(Type, "Python")) {
   Ext = "py";
 } else if (!g_strcasecmp(Type, "Shell")) {
   Ext = "sh";
 } else if (!g_strcasecmp(Type, "Text")) {
   Ext = "txt";
 } else {
   Ext = "cpp";
 }
}

