/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iostream>
#include <vector>
#include <string>
#include <cctype>
#include "style.h"
#include "lang.h"
#include "langc.h"
#include "langasm.h"
#include "langcpp.h"
#include "langphp.h"
#include "langhtml.h"
#include "langjava.h"
#include "langperl.h"
#include "langshell.h"
#include "langpython.h"
using namespace std;

// determines the filetype for syntax highlighting ----------------------------
int Style::getExtension(string filename)
{
 int ext,dot;
 string extension = "";

 dot = filename.rfind(".");
 if(dot != -1) {
  extension = filename.substr(dot+1, filename.size() - dot);
 }

 for(int i=0; i < extension.size(); i++) {
  extension[i]=tolower(extension[i]);
 }

 // HeadBang
 if      (extension == "cc")   {ext = 0;}  // 0 for C++
 else if (extension == "cs")   {ext = 0;}
 else if (extension == "cpp")  {ext = 0;}
 else if (extension == "coo")  {ext = 0;}
 else if (extension == "c++")  {ext = 0;}
 else if (extension == "cxx")  {ext = 0;}
 else if (extension == "rc")   {ext = 0;}
 else if (extension == "h")    {ext = 0;}
 else if (extension == "hh")   {ext = 0;}
 else if (extension == "hpp")  {ext = 0;}
 else if (extension == "hxx")  {ext = 0;}  // and header files
 else if (extension == "c")    {ext = 1;}  // 1 for C files
 else if (extension == "java") {ext = 2;}  // 2 for Java files
 else if (extension == "inc")  {ext = 3;}
 else if (extension == "php4") {ext = 3;}
 else if (extension == "php3") {ext = 3;}
 else if (extension == "php")  {ext = 3;}  // 3 for PHP
 // HashBang
 else if (extension == "sh")   {ext = 4;}  // 4 for UNIX shell
 else if (extension == "cgi")  {ext = 5;}
 else if (extension == "plex") {ext = 5;}
 else if (extension == "plx")  {ext = 5;}
 else if (extension == "pl")   {ext = 5;}
 else if (extension == "pm")   {ext = 5;}  // 5 for PERL 5
 else if (extension == "pyw")  {ext = 6;}
 else if (extension == "py")   {ext = 6;}  // 6 for python
 // GangBang
 else if (extension == "shtml"){ext = 7;}
 else if (extension == "html") {ext = 7;}
 else if (extension == "htm")  {ext = 7;}
 else if (extension == "xml")  {ext = 7;}
 else if (extension == "sgml") {ext = 7;}  // 7 for markup
 // BangBang
 else if (extension == "s")    {ext = 8;}
 else if (extension == "asm")  {ext = 8;}  // 8 for assembly

 else ext = 9;

 return ext;
}
//-----------------------------------------------------------------------------
// determines the filetype for syntax highlighting ----------------------------
string Style::checkExtension(string filename) {

 filetype = getExtension(filename);

 switch (filetype) {
  case (0): slang = new LangCpp;    return "C++ or header file";
  case (1): slang = new LangC;      return "'C' file";
  case (2): slang = new LangJava;   return "Java file";
  case (3): slang = new LangPhp;    return "PHP script";
  case (4): slang = new LangShell;  return "UNIX shell script";
  case (5): slang = new LangPerl;   return "Perl script";
  case (6): slang = new LangPython; return "Python script";
  case (7): slang = new LangHtml;   return "Markup file";
  case (8): slang = new LangAsm;    return "Assembly file";
  default : slang = new LangCpp;    return "unsupported filetype";
 }
}
//-----------------------------------------------------------------------------
/*
bool Style::isNumBounds(int index) {

 if(isspace(buffer[index])) {return true;}
 if(buffer[index] == '[')   {return true;}
 if(buffer[index] == ']')   {return true;}
 if(buffer[index] == '(')   {return true;}
 if(buffer[index] == ')')   {return true;}
 if(buffer[index] == '=')   {return true;}
 if(buffer[index] == '+')   {return true;}
 if(buffer[index] == '-')   {return true;}
 if(buffer[index] == '*')   {return true;}
 if(buffer[index] == '/')   {return true;}
 if(buffer[index] == '%')   {return true;}

 return false;
}
*/
//-----------------------------------------------------------------------------
void Style::numCheck()
{
 if(buffer[0] == '#') {return;}

 vector<int> nums;
 vector<int> ends;
 int end;
 int insert;

 // grab indexes of all numbers into the vector
 for(int i=0; i < (int)buffer.size(); i++) {

//  if(isdigit(buffer[i]) && isNumBounds(buffer[i-1])) {
  if(isdigit(buffer[i]) && !isalpha(buffer[i-1])) {
   end = i;
   while(isdigit(buffer[end+1]) || (buffer[end+1] == '.' && isdigit(buffer[end+2]))) {end++;}
//   if(!isInsideIt(i,"\"","\"")) {
   nums.push_back(i);
   ends.push_back(end);
   i=end;
  }
 }

 // now colour each number
 for(int j=0; j < (int)ends.size(); j++) {

  if(j == 0) {insert = 0;}
  else       {insert += 27;}

  colour_NUM(nums[j]+insert, ends[j]+insert);
 }

}
//-----------------------------------------------------------------------------
void Style::strCheck()
{
 if(incomment) {return;}
 int index,offset;
 index = 0;

  index = buffer.find("\"",index);
  if(index == -1) {return;}
  eraseTags(index,buffer.find("\"",index+1));

  while (index < string::npos) {

//   fIO.ofile << "\nin strCheck() index:" << index
//             << " buffersize: " << buffer.size() << "\n";

  if(buffer[index -1] == '\\') {
   if(buffer[index -2] == '\'' && buffer[index +1] == '\'') {
    index = buffer.find("\"",index+1);
   }
  }
  if(index == -1) {return;}

  while(isInsideIt(index,"'","'")){
   index = buffer.find("\"",index +1);
   if(index == -1) {return;}
  }

  while(buffer[index -1] == '\\' && buffer[index -2] != '\\') {
   index = buffer.find("\"",index +1);
   if(index == -1) {return;}
  }


//  fIO.ofile << "\nin strCheck() " << buffer << endl;
  if(index != -1) {
   colour_STR(index);
  }

  if(instring) {offset = index + 21;}
  else {offset = index + 7;}

  index = buffer.find("\"",offset);
  if(index == -1) {return;}
  if(index > buffer.size()){return;}
 }

}
//-----------------------------------------------------------------------------
void Style::keysCheck() {   // call keyCheck() method
 if(instring) {return;}
 if(incomment){return;}
 slang->keyCheck(buffer, ColourOf.KeyWords(), csson);
} //---------------------------------------------------------------------------
// makes sure things don't "disappear" in the HTML ----------------------------
void Style::Angle_Brackets() {

 for (int i=0; i < (int)buffer.size(); i++) {
  if (buffer.substr(i,1) == "<") buffer.replace(i,1, "&lt;");
  else if (buffer.substr(i,1) == ">") buffer.replace(i,1, "&gt;");
 }
} //---------------------------------------------------------------------------
// search if index is between start and end -----------------------------------
bool Style::isInsideIt(int index, string start, string end) {

 if(buffer.find(start,0) == -1) {return false;}

 if(buffer.find(start,0) < index) {
  if(buffer.find(end,index) != -1) {
   return true;
  } else return false;
 } else return false;

 return false;

/*
 int open  = buffer.find(start,0);
 int close = buffer.find(end,open+1);

 if(open == -1)  {return false;}
 if(close == -1) {return false;}

 while(buffer[close-1] == '\\') {
  close = buffer.find(end,close+1);
  if(close == -1) {return false;}
 }

 if(open < index && close > index) {
  return true;
 }

 return false;
*/
}
//-----------------------------------------------------------------------------
void Style::colour_NUM(int s, int f) {

 // abort is in a comment (multiline)
 // or in a string (multiline)
 if(incomment) {return;}
 if(instring)  {return;}

 int offset = 21;
 string fntag = "<font COLOR=" + ColourOf.Numbers() + ">";
 string cltag = "</font>";

 if(cssfile != "") {
  fntag = "<font CLASS=numbers>";
 }

 // insert the font tags
 buffer.insert(s, fntag);
 buffer.insert(f+offset, cltag);
}
//-----------------------------------------------------------------------------
void Style::colour_STR(int index) {

 if(index > buffer.size()){return;}

 string fntag = "<font COLOR=" + ColourOf.Characters() + ">";
 string cltag = "</font>";

 if(cssfile != "") {
  fntag = "<font CLASS=strings>";
 }

 // open string tag
 if(!instring) {
  buffer.insert(index, fntag);
 } else {
  buffer.insert(index+1, cltag);
 }
 // or close string tag
 // depending on whether or not in a string

 instring = !instring;
}
//-----------------------------------------------------------------------------
void Style::colour_CMNT(int index) {

 // don't highlight inside of a string
 if(instring) {return;}

 string fntag = "<font COLOR=" + ColourOf.Comments() + ">";
 string cltag = "</font>";

 if(cssfile != "") {
  fntag = "<font CLASS=comment>";
 }

 // no highlighting inside of comments
 eraseTags(index,0);

 // insert the font tags
 buffer.insert(index, fntag);
 buffer.insert(buffer.size(), cltag);

} //---------------------------------------------------------------------------
// erase font tags ------------------------------------------------------------
void Style::eraseTags(int start, int fin) {

 if(fin == 0)  {fin = buffer.size();}
 if(fin == -1) {fin = buffer.size();}

 int erase1, erase2;
 int offset1, offset2;
 string srchstr;


 // search the string for Stylesheet tags
 if(cssfile != "") {
  srchstr = "<font CLASS=";
  offset1 = 20;
  offset2 = 7;
 } else {
  srchstr = "<font COLOR=#";
  offset1 = 20;
  offset2 = 7;
 }
 // or search for hard-coded colour tags

 // erase all the colours previously made
 while(buffer.find(srchstr,start) != -1 && buffer.find(srchstr,start) < fin) {

  //erasing font tags
  erase1 = buffer.find(srchstr,start);
  if(erase1 != -1 && erase1 < fin) {
   buffer.erase(erase1,offset1);
  }
  erase2 = buffer.find("</font>",start);
  if(erase2 != -1 && erase2 < fin) {
   buffer.erase(erase2,offset2);
  }

  //erasing bold tags
  if(cssfile == "") {
   erase1 = buffer.find("<b>",start);
   if(erase1 != -1 && erase1 < fin) {
    buffer.erase(erase1,3);
   }
   erase2 = buffer.find("</b>",start);
   if(erase2 != -1 && erase2 < fin) {
    buffer.erase(erase2,4);
   }
  }

 }
}
//-----------------------------------------------------------------------------
// turn margin on/off ---------------------------------------------------------
void Style::toggleMargin() {margin = !margin;}
//-----------------------------------------------------------------------------
// prints the line number in the margin ---------------------------------------
void Style::mkMargin() {

 string space = "";
 string fntag = "<font COLOR=" + ColourOf.Comments() + ">";
 string cltag = ":</font> ";

 if(cssfile != "") {
  fntag = "<font CLASS=comment>";
 }

 // setting margin alignment
 if(lncnt < 1000) {space += " ";}
 if(lncnt < 100)  {space += " ";}
 if(lncnt < 10)   {space += " ";}

 // to STDOUT or file? Depends on output redirection switch
 if(redir_O) {cout << space << fntag << lncnt << cltag;}
 else   {fIO.ofile << space << fntag << lncnt << cltag;}

} //---------------------------------------------------------------------------
int Style::getLineCount() {return lncnt;}  // get the current line number
//-----------------------------------------------------------------------------
// write initial html tags ----------------------------------------------------
void Style::openhtml(string name) {

 string gen, openht, htbody;
 string background;

 // use picture or background colour
 if(picture == "") {
  background = "bgcolor=" + ColourOf.BackGround();
 }
 else background = "background=\"" + picture + "\"";

 gen    = "<!-- file generated with webcpp 0.6.7 http://webcpp.sf.net -->\n";
 openht = "<html>\n<head>\n<title>" + name + "</title>\n";
 htbody = "<body "  + background +
          " text="  + ColourOf.NormalText() +
          " link="  + ColourOf.Characters() +
          " vlink=" + ColourOf.Comments() +
          " alink=" + ColourOf.KeyWords() + ">\n<pre>\n";

 // use a stylesheet, if specified
 if(cssfile != "") {
  openht += "<link rel=\"stylesheet\" type=\"text/css\" href=\""
         + cssfile + "\"/>\n</head>\n";
  htbody = "<body>\n<pre>\n";
 } else {openht += "</head>\n";}

 // to STDOUT or file? Depends on output redirection switch
 if(redir_O) {
  cout << "Content-Type: text/html\n\n"
       << gen << openht << htbody;
 } else {fIO.ofile << gen << openht << htbody;}
} //---------------------------------------------------------------------------
// write closing html tags ----------------------------------------------------
void Style::closehtml() {

 string endht;

 if(made) {

  endht = "</pre>\n<hr size=4>\n\
<table cellpadding=3 cellspacing=3 bgcolor=#000000><tr>\n\
<td bgcolor=#ff0000><tt><font size=+2 color=#000000>w</font></tt></td>\n\
<td bgcolor=#ffbb00><tt><font size=+2 color=#000000>e</font></tt></td>\n\
<td bgcolor=#ffff00><tt><font size=+2 color=#000000>b</font></tt></td>\n\
<td bgcolor=#00ff00><tt><font size=+2 color=#000000>c</font></tt></td>\n\
<td bgcolor=#0000ff><tt><font size=+2 color=#000000>p</font></tt></td>\n\
<td bgcolor=#bb00ff><tt><font size=+2 color=#000000>p</font></tt></td>\n\
</tr><tr><td colspan=6>\n\
<a href=\"http://webcpp.sf.net\">\
<center><b><font color=#ffffff>web c plus plus</font></b></center>\n\
</a>\
</td></tr>\n\
</table>\n\n</body>\n</html>\n";
 }

 else {
  endht = "</pre>\n</body>\n</html>\n";
 }

 if(redir_O) {cout << endht;}
 else   {fIO.ofile << endht;}
} //---------------------------------------------------------------------------
// return bool value of redirection switch state ------------------------------
bool Style::isIstd() {return redir_I;}
bool Style::isOstd() {return redir_O;}
//-----------------------------------------------------------------------------
void Style::toggleIswitch() {             // toggles Input redirection switch

 redir_I = !redir_I;
}
//-----------------------------------------------------------------------------
void Style::toggleOswitch() {             // toggles Output redirection switch

 redir_O = !redir_O;
} //---------------------------------------------------------------------------
// sets the CSS filename ------------------------------------------------------
void Style::setCSSfile(string name) {

 if(name.find(".css") != name.size()-4 && name.find(".CSS") != name.size() -4){
   cerr << "this is not a CSS file, using default settings\n";
   csson = false;
 }
 else cssfile = name;
} //---------------------------------------------------------------------------
// sets the background picture ------------------------------------------------
void Style::setBGPicture(string filename) {picture = filename;}
// toggle option switches -----------------------------------------------------
void Style::toggleCSSSwitch()      {csson = !csson;}
void Style::toggleHyperSwitch()    {hyper = !hyper;}
void Style::toggleMadewithSwitch() {made  = !made;}
//-----------------------------------------------------------------------------

