#!/usr/bin/perl -w

# this has been edited to fit chromatic's suggestions below

use strict;

my $scs = shift or die "Usage: $0 <scsfile>\n";
(my $css = $scs) =~ s/\.scs\z/.css/;

open(SCSFILE, "<$scs") or die "$!: cannot read $scs";
open(CSSFILE, ">$css") or die "$!: cannot write to $css";

my @scheme = <SCSFILE>;
chomp @scheme;
close(SCSFILE);

select(CSSFILE);

print<<"EOF";
/*** Webcpp 0.6.0+ compatible StyleSheet http://webcpp.sf.net ***/

body {
background-color: $scheme[0]
}

a:link    {color:$scheme[5]}
a:visited {color:$scheme[6]}
a:active  {color:$scheme[3]}
a:hover   {color:$scheme[1]}

pre {
color: $scheme[2]
}

font {
font-size:100%
}

font.preproc {     /* preprocessor */
color: $scheme[1]
}

font.nortext {     /* normal text */
color: $scheme[2]
}

font.keyword {     /* keyword */
color: $scheme[3];
font-weight: bold
}

font.numbers {     /* number */
color: $scheme[4]
}

font.strings {     /* string */
color: $scheme[5]
}

font.comment {     /* comment */
color: $scheme[6];
font-style: italic
}
EOF

close(CSSFILE);
select(STDOUT);
print("woo-hooo!!\n");
