/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "hashbanger.h"
#include "hypersystem.h"
#include <cctype>
using namespace std;

HashBanger::HashBanger() {

 buffer   = "";
 picture  = "";
 cssfile  = "";
 lncnt    = 1;
 filetype = 9;

 incomment = false;
 instring  = false;
 inquote   = false;

 made    = false;
 margin  = false;
 redir_I = false;
 redir_O = false;
 csson   = false;
}

// find any variables ---------------------------------------------------------
void HashBanger::varCheck() {

 if(filetype == 6) {return;}
// buffer = buffer + " ";

 int index;
 int test;

 index = buffer.find("$",0);
 test  = buffer.find("#",0);
 if(test != -1 && test < index) {return;}
 while(index < string::npos) {

 // if(buffer[index -1] == '\\') {index = buffer.find("$",0);}
  if(index != -1) {colour_VAR(index);}
  index = buffer.find("$",index +22);
 }

 // do the same for Perl, but with arrays and hashes
 if(filetype == 5) {

  index = buffer.find("@",0);
  if(test != -1 && test < index) {return;}
  while(index < string::npos) {

   if(buffer[index -1] == '\\') {index = -1;}
   if(index != -1) {colour_VAR(index);}
   index = buffer.find("$",index +22);
  }

  index = buffer.find("%",0);
  if(test != -1 && test < index) {return;}
  while(index < string::npos) {

 //  if(buffer[index -1] == '\\') {index = -1;}
   if(index != -1) {colour_VAR(index);}
   index = buffer.find("$",index +22);
  }
 }

}
// colourize the variables ----------------------------------------------------
void HashBanger::colour_VAR(int index) {

 int end =0;

 string fntag = "<font COLOR=" + ColourOf.PreProcessor() + ">";

 if(cssfile != "") {
  fntag = "<font CLASS=preproc>";
 }
 buffer.insert(index, fntag);

 int i = index+21;
 while(!end && i < buffer.size()) {

  if(!isalnum(buffer[i])) {
   if(buffer[i] == '_')   {i++;}
   if(isspace(buffer[i])) {end = i;}
   if(ispunct(buffer[i])) {end = i;}
   if(buffer[i] == '=')   {end = i;}
   if(buffer[i] == ',')   {end = i;}
   if(buffer[i] == '{')   {end = i;}
   if(buffer[i] == '[')   {end = i;}
   if(buffer[i] == '(')   {end = i;}
   if(buffer[i] == '\'')  {end = i;}
   if(buffer[i] == '\n')  {end = i;}
  }
  if(i == buffer.size() -1) {end = i+1;}
  else i++;
 }

 if(buffer[end -1] == '\"') {end--;}
 if(buffer[end -1] == ')')  {end--;}
 buffer.insert(end, "</font>");
}
//-----------------------------------------------------------------------------
void HashBanger::singleQuote()
{
 if(incomment) {return;}
 int index,offset;
 index = 0;

  index = buffer.find("'",index);
  if(index == -1) {return;}
  eraseTags(index,buffer.find("'",index+1));

  while (index < string::npos) {

  if(buffer[index -1] == '\\') {
   if(buffer[index -2] == '\'' && buffer[index +1] == '\'') {
    index = buffer.find("'",index+1);
   }
  }
  if(index == -1) {return;}

  while(isInsideIt(index,"\"","\"")){
   index = buffer.find("'",index +1);
   if(index == -1) {return;}
  }

  while(buffer[index -1] == '\\' && buffer[index -2] != '\\') {
   index = buffer.find("'",index +1);
   if(index == -1) {return;}
  }

  if(index != -1) {
   colour_QUO(index);
  }

  if(instring) {offset = index + 21;}
  else {offset = index + 7;}

  index = buffer.find("'",offset);
  if(index == -1) {return;}
  if(index > buffer.size()){return;}
 }

}
//-----------------------------------------------------------------------------
void HashBanger::colour_QUO(int index) {

 if(index > buffer.size()){return;}

 string fntag = "<font COLOR=" + ColourOf.Characters() + ">";
 string cltag = "</font>";

 if(cssfile != "") {
  fntag = "<font CLASS=strings>";
 }

 if(!inquote) {
  buffer.insert(index, fntag);
 } else {
  buffer.insert(index+1, cltag);
 }

 inquote = !inquote;
}
// check for comments ---------------------------------------------------------
void HashBanger::cmntCheck() {

 if(instring || inquote) {return;}

 int index = buffer.find("#",0);
 if(index != -1 && buffer[index -1] != '\\') {

  if(index != 0) {

   while(buffer[index -1] == '=' && index < string::npos) {
    index = buffer.find("#",index+1);
   }
  }
  if(index == -1) {return;}
//  if(buffer[index -1] == '\"')  {return;}
  if(buffer[index -8] == '$')  {return;}
  if(buffer[index -1] == '\\') {return;}

  if(!isInsideIt(index,"\"","\"") && !isInsideIt(index,"'","'")) {
   colour_CMNT(index);
  }

 }
}
//-----------------------------------------------------------------------------
//
void HashBanger::Colourizer() {

 if(redir_I) {getline(cin,buffer);}
 else  {getline(fIO.ifile,buffer);}
 buffer = buffer + "";

 if(margin) {
  mkMargin();
 }
 Angle_Brackets();
 numCheck();   // check and colour numbers, if any
 varCheck();
 keysCheck();  // and keywords
 strCheck();   // and strings
// singleQuote();

 if(!instring && !inquote) {
  HyperSystem::tagMe(buffer);
  HyperSystem::nameMe(buffer);
  HyperSystem::linkMe(buffer);
 }

 cmntCheck();  // do # comments

 if(redir_O) {cout << buffer << endl;}
 else   {fIO.ofile << buffer << endl;}
 buffer = "";
 lncnt++;
}//----------------------------------------------------------------------------

