
/* Cfour (C++ Common Console Classes) v1.1
 * Copyright (C) 2001 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef _C4_FILE_H
#define _C4_FILE_H

#include <iostream>
#include <fstream>
#include <string>
using namespace std;


class CFfile {

 public:

  CFfile();
  CFfile(string filename, char io);
  CFfile(string filein, string fileout);
  ~CFfile();

  bool openR(string &INfile) ;  // open file for reading
  bool openW(string &OUTfile);  // open file for writing
  bool open(string &filename, char io); // open, specify

  void closeR();  // close the input file
  void closeW();  // close the output file
  void close();   // close

  bool exists(string fname);
  void backup(string fname, string bname); // backup (copy) a file

// protected:

  ifstream ifile;  // input file
  ofstream ofile;  // output file
};

#endif  // _C4_FILE_H
