/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "bangbanger.h"
#include "hypersystem.h"

BangBanger::BangBanger() {

 buffer  = "";
 picture = "";
 lncnt   = 1;
 filetype = 9;

 incomment = false;
 instring  = false;

 made    = false;
 margin  = false;
 redir_I = false;
 redir_O = false;
 cssfile = "";
 csson = false;
}

BangBanger::~BangBanger(){}



void BangBanger::labelCheck() {

 int end, beg;
 end = buffer.find(":",0);
 beg = buffer.rfind(" ",end);

 if(beg == -1) {beg = 0;}
 if(end != -1) {
  colour_LBL(beg, end);
 }
}

void BangBanger::colour_LBL(int beg, int end) {

 string fntag = "<font COLOR=" + ColourOf.PreProcessor() + ">";

 if(cssfile != "") {
  fntag = "<font CLASS=preproc>";
 }

 buffer.insert(beg,fntag);
 buffer.insert(end+21,"</font>");
}

void BangBanger::colour_MACRO() {

 if(buffer[0] != '%') {return;}

 string fntag = "<font COLOR=" + ColourOf.Numbers() + ">";
 string cltag = "</font>";

 if(cssfile != "") {
  fntag = "<font CLASS=numbers>";
 }

 buffer += " ";
 buffer.insert(0, fntag);
 buffer.insert(buffer.find(" ", buffer.find(" ",0)+1), cltag);
}

/*  VIRTUAL METHODS  */

// check for comments ---------------------------------------------------------
void BangBanger::cmntCheck() {

 int index = buffer.find(";",0);
 if(index != -1) {
  if(!isInsideIt(index,"\"","\"")) {colour_CMNT(index);}
 }
}
// the syntax highlight checking ----------------------------------------------
void BangBanger::Colourizer() {

 if(redir_I) {getline(cin,buffer);}
 else  {getline(fIO.ifile,buffer);}
 buffer = buffer + "";

 if(margin) {
  mkMargin();
 }
 Angle_Brackets();
 numCheck();     // check and colour numbers, if any
 labelCheck();   // check for tags
 colour_MACRO(); // check for macros
 keysCheck();    // and keywords
 strCheck();     // and strings

 if(!instring) {
  HyperSystem::tagMe(buffer);
  HyperSystem::nameMe(buffer);
  HyperSystem::linkMe(buffer);
 }

 cmntCheck();  // do ; comments

 if(redir_O) {cout << buffer << endl;}
 else   {fIO.ofile << buffer << endl;}
 buffer = "";
 lncnt++;
}//----------------------------------------------------------------------------

