/* linuXtree copyright (c) 1998 Dan Stahlke under the GPL
   See file 'COPYING' for details */

#include "all.h"

#define UID_CACHE 32

struct {
  char name[8];
  int num;
} uid_ucache[UID_CACHE],uid_gcache[UID_CACHE];

int uid_ucachep,uid_gcachep;
int myuid,mygid;

void uid_init(void) {
  int n;
  uid_ucachep=uid_gcachep=0;
  for(n=0;n<UID_CACHE;n++) {
    uid_ucache[n].name[0]=0;
    uid_ucache[n].num=-1;
    uid_gcache[n].name[0]=0;
    uid_gcache[n].num=-1;
  }
  myuid=(int)getuid();
  mygid=(int)getgid();
}

const char *uid_uidtoname(int uid) {
  int n;
  for(n=0;n<UID_CACHE;n++)
    if(uid_ucache[n].num==uid) return uid_ucache[n].name;
  strcpy(uid_ucache[uid_ucachep].name,uid_uidtoname_real(uid));
  uid_ucache[uid_ucachep].num=uid;
  n=uid_ucachep;
  uid_ucachep++;
  uid_ucachep%=UID_CACHE;
  return uid_ucache[n].name;
}

const char *uid_gidtoname(int gid) {
  int n;
  for(n=0;n<UID_CACHE;n++)
    if(uid_gcache[n].num==gid) return uid_gcache[n].name;
  strcpy(uid_gcache[uid_gcachep].name,uid_gidtoname_real(gid));
  uid_gcache[uid_gcachep].num=gid;
  n=uid_gcachep;
  uid_gcachep++;
  uid_gcachep%=UID_CACHE;
  return uid_gcache[n].name;
}

char uid_namenumber[32];

const char *uid_uidtoname_real(int uid) {
  struct passwd *pw;
  if(uid==0) return "root";
  pw=getpwuid(uid);
  if(pw==NULL) {
    sprintf(uid_namenumber,"%d",uid);
    return uid_namenumber;
  } else
    return pw->pw_name;
}

const char *uid_gidtoname_real(int uid) {
  struct group *pw;
  if(uid==0) return "root";
  pw=getgrgid(uid);
  if(pw==NULL) {
    sprintf(uid_namenumber,"%d",uid);
    return uid_namenumber;
  } else
    return pw->gr_name;
}

int uid_nametouid(const char *s) {
  struct passwd *pw;
  if((s[0]>='0')&&(s[0]<='9')) return atol(s);
  pw=getpwnam(s);
  if(!pw) return -1;
  return pw->pw_uid;
}

int uid_nametogid(const char *s) {
  struct group *pw;
  if((s[0]>='0')&&(s[0]<='9')) return atol(s);
  pw=getgrnam(s);
  if(!pw) return -1;
  return pw->gr_gid;
}

const char *uid_homedir(int uid) {
  struct passwd *pw;
  pw=getpwuid(uid);
  if(!pw) return NULL;
  return pw->pw_dir;
}

int uid_okread(int num) {
  int u,g,m;
  u=myuid;
  g=mygid;

  m=data_lpinfo(num).st_mode;
  if(!u) return 1;
  if(S_ISDIR(m)) {
    if(data_lpinfo(num).st_uid==u) return (m&(S_IRUSR|S_IXUSR))==(S_IRUSR|S_IXUSR);
    if(data_lpinfo(num).st_gid==g) return (m&(S_IRGRP|S_IXGRP))==(S_IRGRP|S_IXGRP);
    if ((m&(S_IROTH|S_IXOTH))==(S_IROTH|S_IXOTH)) return 1;
  } else {
    if(data_lpinfo(num).st_uid==u) return (m&S_IRUSR)==S_IRUSR;
    if(data_lpinfo(num).st_gid==g) return (m&S_IRGRP)==S_IRGRP;
    if ((m&S_IROTH)==S_IROTH) return 1;
  }
  return 0;
}

int uid_okwrite(int num) {
  int u,g,m;
  u=myuid;
  g=mygid;
  m=data_lpinfo(num).st_mode;
  if(!u) {
    u=data_lpinfo(num).st_uid;
    g=data_lpinfo(num).st_gid;
  }
  if(S_ISDIR(m)) {
    if(data_lpinfo(num).st_uid==u) return (m&(S_IWUSR|S_IXUSR))==(S_IWUSR|S_IXUSR);
    if(data_lpinfo(num).st_gid==g) return (m&(S_IWGRP|S_IXGRP))==(S_IWGRP|S_IXGRP);
    if ((m&(S_IWOTH|S_IXOTH))==(S_IWOTH|S_IXOTH)) return 1;
  } else {
    if(data_lpinfo(num).st_uid==u) return (m&S_IWUSR)==S_IWUSR;
    if(data_lpinfo(num).st_gid==g) return (m&S_IWGRP)==S_IWGRP;
    if ((m&S_IWOTH)==S_IWOTH) return 1;
  }
  return 0;
}

int uid_okexec(int num) {
  int u,g,m;
  u=myuid;
  g=mygid;
  m=data_lpinfo(num).st_mode;
  if(!u) {
    u=data_lpinfo(num).st_uid;
    g=data_lpinfo(num).st_gid;
  }
  if(S_ISDIR(m)) {
    return 0;
  } else {
    if(data_lpinfo(num).st_uid==u) return (m&S_IXUSR)==S_IXUSR;
    if(data_lpinfo(num).st_gid==g) return (m&S_IXGRP)==S_IXGRP;
    if ((m&S_IXOTH)==S_IXOTH) return 1;
  }
  return 0;
}

/* check to see if we can delete/rename stuff in a dir */
/* FIXME - find out exactly how sticky bit is supposed to work */

int uid_okdirop(int num) {
  int u,dnum;
  num=data_updir(dnum=num);
  u=myuid;
  if(!u) return 1;
  if(!(uid_okwrite(num)&&uid_okread(num))) return 0;
  if(data_lpinfo(num).st_uid==u) return 1;
  if((data_lpinfo(num).st_mode&01000)&&
     (data_lpinfo(dnum).st_uid!=u)) return 0;
  return 1;
}
