/* linuXtree copyright (c) 1998 Dan Stahlke under the GPL
   See file 'COPYING' for details */

#include "all.h"

#define scrollamt 1

#define updatepcur     {pcur=gui_printable_curspos(buf,p);}


#define printwholeline {mvwprintw(win,yl,xl,"%-*.*s",xs,xs,           \
                        gui_printable(0,buf)+pleft);                  \
                        }

#define doscroll_left  {updatepcur;                                   \
                        while(((pcur-pleft)<1)&&(pleft>0)) {          \
                        pleft-=scrollamt;                             \
                        }}

#define doscroll_right {updatepcur;                                   \
                        while((pcur-pleft)>=(xs)) {                   \
                        pleft+=scrollamt;                             \
                        }}

char **usernamelist;
char **groupnamelist;
char ***prevlines;
int *prevlinenum;

extern int keep_msbar;
extern int filelist;
extern int currentdir;
extern int dispmode;

void readln_init(void) {
  struct passwd *pent;
  struct group *gent;
  char strnum[32];
  int n,siz;

  siz=0;
  usernamelist=malloc(sizeof(char *));
  if(!usernamelist) outofmem("readln_init");
  usernamelist[0]=NULL;
  while((pent=getpwent())) {
    usernamelist=realloc(usernamelist,(siz+3)*sizeof(char *));
    if(!usernamelist) outofmem("readln_init");
    usernamelist[siz]=malloc(strlen(pent->pw_name)+1);
    strcpy(usernamelist[siz],pent->pw_name);
    siz++;
    sprintf(strnum,"%d",pent->pw_uid);
    usernamelist[siz]=malloc(strlen(strnum)+1);
    strcpy(usernamelist[siz],strnum);
    siz++;
    usernamelist[siz]=NULL;
  }

  siz=0;
  groupnamelist=malloc(sizeof(char *));
  if(!groupnamelist) outofmem("readln_init");
  groupnamelist[0]=NULL;
  while((gent=getgrent())) {
    groupnamelist=realloc(groupnamelist,(siz+3)*sizeof(char *));
    if(!groupnamelist) outofmem("readln_init");
    groupnamelist[siz]=malloc(strlen(gent->gr_name)+1);
    strcpy(groupnamelist[siz],gent->gr_name);
    siz++;
    sprintf(strnum,"%d",gent->gr_gid);
    groupnamelist[siz]=malloc(strlen(strnum)+1);
    strcpy(groupnamelist[siz],strnum);
    siz++;
    groupnamelist[siz]=NULL;
  }

  prevlines=malloc(PV_HOWMANY*sizeof(char **));
  prevlinenum=malloc(PV_HOWMANY*sizeof(int));
  if((!prevlines)||(!prevlinenum)) outofmem("readln_init");
  for(n=0;n<PV_HOWMANY;n++) {
    prevlines[n]=malloc(sizeof(char *));
    if(!prevlines[n]) outofmem("readln_init");
    prevlines[n][0]=NULL;
    prevlinenum[n]=0;
  }
}

/*
void readln_savestate(void) {
  int a,b;
  char *fn,*home;
  FILE *f;

  home=getenv("HOME");
  if(!home) home="~";
  fn=malloc(strlen("/.lxt-state")+strlen(home)+1);
  sprintf(fn,"%s/.lxt-state",home);
  f=fopen(fn,"w");
  if(!f) return;
  fprintf(f,"# State file for lxt version %s, do not edit\n",VERSION);
  fprintf(f,"begin readln:\n");
  for(a=0;a<PV_HOWMANY;a++) {
    fprintf(f,"type %d of %d (num=%d):\n",a+1,PV_HOWMANY,prevlinenum[a]);
    for(b=0;b<prevlinenum[a];b++) fprintf(f,"%s\n",prevlines[a][b]);
  }
  fprintf(f,"end readln\n");
  fclose(f);
}
*/

/* update prevlist and reset the background color and cursor leave */
#define NEWPREVLINE prevlines[prevtype][prevlinenum[prevtype]]
void readln_doexit(const char *buf,int prevtype,WINDOW *win) {
  int n,i;
  char *s;
  if(buf[0]&&(prevtype!=PV_DISABLE)) {
    for(n=0;n<prevlinenum[prevtype];n++) {
      if(!strcmp(prevlines[prevtype][n],buf)) {
        s=prevlines[prevtype][n];
        for(i=n;i<(prevlinenum[prevtype]-1);i++)
          prevlines[prevtype][i]=prevlines[prevtype][i+1];
        prevlines[prevtype][prevlinenum[prevtype]-1]=s;
        wbkgdset(win,COLOR_PAIR(C_NORMAL)|A_BOLD);
        leaveok(stdscr,TRUE);
        return;
      }
    }
    NEWPREVLINE=malloc(strlen(buf)+1);
    if(!NEWPREVLINE) outofmem("readln_read");
    strcpy(NEWPREVLINE,buf);
    prevlinenum[prevtype]++;
    prevlines[prevtype]=realloc(prevlines[prevtype],
      (prevlinenum[prevtype]+1)*sizeof(char *));
    if(!prevlines[prevtype]) outofmem("readln_read");
    NEWPREVLINE=NULL;
  }
  wbkgdset(win,COLOR_PAIR(C_NORMAL)|A_BOLD);
  leaveok(stdscr,TRUE);
  return;
}

int readln_read(WINDOW *win,int yl,int xl,int xs,int len,char *buf,
                int fieldmode,int prevtype) {
  int p,pleft,pcur,c,n,quotenext,linenum;
  char *bakbuf;

  pleft=0;
  p=0;
  quotenext=0;

  linenum=0; /* to please gcc */
  bakbuf=0;  /* to please gcc */

  if((prevtype==PV_NOPATHFILENAME)&&(dispmode!=DISP_FILE))
    crapout("readln_read","PV_NOPATHFILENAME type used in wrong dispmode");
  if((prevtype==PV_NOPATHDIRNAME)&&(dispmode!=DISP_TREE))
    crapout("readln_read","PV_NOPATHDIRNAME type used in wrong dispmode");

  if(prevtype!=PV_DISABLE) {
    if((prevtype<0)||(prevtype>=PV_HOWMANY))
      crapout("readln_read","prevtype out of range");
    linenum=prevlinenum[prevtype];
    bakbuf=malloc(len);
    if(!bakbuf) outofmem("readln_read");
  }

  wmove(win,yl,xl);
  whline(win,COLOR_PAIR(C_NORMAL)|' ',xs);
  mvwprintw(win,yl,xl,"%-*.*s",xs,xs,"Wait...");
  wrefresh(win);

  while(buf[p]) {
    p++;
    doscroll_right;
  }

  wbkgdset(win,COLOR_PAIR(C_HILITE));
  wmove(win,yl,xl);
  whline(win,COLOR_PAIR(C_HILITE)|' ',xs);
  leaveok(stdscr,FALSE);
  printwholeline;
    
  for(;;) {
    gui_drawtime();
    updatepcur;
    mvwinch(win,yl,xl-pleft+pcur);
    wrefresh(win);
    timeout(100);
    while((c=getch())==ERR) {
      gui_drawtime();
      mvwinch(win,yl,xl-pleft+pcur);
      wrefresh(win);
    }
    if(quotenext) {
      if(c&&(c<256)) {
        if(strlen(buf)<(len-1)) {
          for(n=strlen(buf);n>=p;n--) buf[n+1]=buf[n];
          buf[p++]=c;
          doscroll_right;
          printwholeline;
        }
      } else {if(!config.silent) beep(); doupdate();}
      quotenext=0;
      keypad(stdscr,TRUE);
    } else
    switch(c) {
    case KEY_UP:
      if(fieldmode==FM_RETARROW) {
        readln_doexit(buf,prevtype,win); return KEY_UP;
      }
      if(prevtype!=PV_DISABLE) {
        if(linenum) {
          if(linenum==prevlinenum[prevtype]) {
            strcpy(bakbuf,buf);
            if((linenum>1)&&!strcmp(buf,prevlines[prevtype][linenum-1]))
              linenum--;
          }
          linenum--;
          strncpy(buf,prevlines[prevtype][linenum],len-1);
          buf[len-1]=0;
          for(p=pleft=0;buf[p];p++) doscroll_right;
          printwholeline;
        }
      }
      break;
    case KEY_DOWN:
      if(fieldmode==FM_RETARROW) {
        readln_doexit(buf,prevtype,win); return KEY_DOWN;
      }
      if(prevtype!=PV_DISABLE) {
        if((linenum+1)<prevlinenum[prevtype]) {
          linenum++;
          strncpy(buf,prevlines[prevtype][linenum],len-1);
          buf[len-1]=0;
        } else if(linenum<prevlinenum[prevtype]) {
          linenum++;
          strcpy(buf,bakbuf);
        }
        for(p=pleft=0;buf[p];p++) doscroll_right;
        printwholeline;
      }
      break;
    case KEY_ENTER:
    case '\r':
    case '\n':
      readln_doexit(buf,prevtype,win);
      if(fieldmode==FM_RETARROW) return KEY_ENTER;
      return 0;
      break;
    case KEY_BACKSPACE:
    case '\b':
      if(p) {
        p--;
        for(n=p;buf[n];n++) buf[n]=buf[n+1];
        doscroll_left;
        printwholeline;
      }
      break;
    case '\a':            /* ctrl-g aborts */
      buf[0]=0;
      readln_doexit(buf,prevtype,win);
      if(fieldmode==FM_RETARROW) return '\a';
      return 1;
      break;
    case 'u'-'a'+1:    /* ctrl-u kills to beginning of line */
      for(n=0;buf[n+p-1];n++) buf[n]=buf[n+p];
      p=pleft=0;
      printwholeline;
      break;
    case 'v'-'a'+1:    /* ctrl-v quotes next char */
      quotenext=1;
      keypad(stdscr,FALSE);
      break;
    case KEY_HOME:
    case 1:
      if(p) {
        while(p) {
          p--;
          doscroll_left;
        }
        printwholeline;
      }
      break;
    case KEY_END:
    case 5:
      if(buf[p]) {
        while(buf[p]) {
          p++;
          doscroll_right;
        }
        printwholeline;
      }
      break;
    case KEY_LEFT:
      if(p) {
        p--;
        doscroll_left;
        printwholeline;
      }
      break;
    case KEY_RIGHT:
      if(buf[p]) {
        p++;
        doscroll_right;
        printwholeline;
      }
      break;
    default:
      if(c=='\t') {
        if(fieldmode==FM_TABNEXT) {readln_doexit(buf,prevtype,win); return 0;}
        if(fieldmode==FM_TABCOMPLETE) {
          /* FIXME - allow tab in middle of line */
          readln_docomplete(buf,len,prevtype);
          while(buf[p]) {
            p++;
            doscroll_right;
          }
          printwholeline;
          break;
        }
      }
      if(((c=='/')||(c=='~'))&&(prevtype==PV_NOPATHFILENAME)) break;
      if(((c=='/')||(c=='~'))&&(prevtype==PV_NOPATHDIRNAME)) break;
      if(((c<'0')||(c>'7'))&&(prevtype==PV_UMASK)) break;
      if((c<256)&&(c>31))
        if(strlen(buf)<(len-1)) {
          for(n=strlen(buf);n>=p;n--) buf[n+1]=buf[n];
          buf[p++]=c;
          doscroll_right;
          printwholeline;
        }
      break;
    }
  }
}

int readln_getchar(WINDOW *win,const char *prompt,const char *valid) {
  int quit=0,c,xc,yc;
  c=0; /* to keep compiler happy */
  werase(win);
  leaveok(stdscr,FALSE);
  mvwprintw(win,0,1,"%s",prompt);
  wnoutrefresh(win);
  doupdate();
  getyx(win,yc,xc);
  timeout(100);
  while(!quit) {
    if((c=getch())==ERR) {
      gui_drawtime();
      mvwinch(win,yc,xc);
      wrefresh(win);
    } else {
      if(strchr(valid,c)) quit=1;
    }
  }
  werase(win);
  wnoutrefresh(win);
  doupdate();
  return c;
}

void readln_matchlist(char *buf,int maxlen,char **items) {
  char *outbuf,*p;
  int firstdone,line,n;

  outbuf=malloc(maxlen);
  if(!outbuf) outofmem("readln_docomplete");
  firstdone=0;
  for(line=0;;line++) {
    p=items[line];
    if(!p) break;
    if(strncmp(buf,p,strlen(buf))) continue;
    if(firstdone) {
      for(n=0;(p[n]==outbuf[n])&&(n<maxlen);n++);
      outbuf[n]=0;
    } else {
      strncpy(outbuf,p,maxlen-1);
      outbuf[maxlen-1]=0;
      firstdone=1;
    }
  }
  if(firstdone) strcpy(buf,outbuf);
  return;
}

void readln_docomplete(char *buf,int maxlen,int prevtype) {
  int n,i;
  const char *pathnam,*p;
  char pathbuf[PATH_MAX+2];
  char *filebuf,*q;
  char tmppath[PATH_MAX+1];
  char tmpnam[MAXNAMLEN+2];
  char complete[MAXNAMLEN+1];
  DIR *dir;
  struct dirent *ent;
  int firstdone;
  int oldkeepmsbar;
  int node;

  switch(prevtype) {
  case PV_NOPATHFILENAME:
    if(!filelist) crapout("readln_docomplete","filelist is zero");
    firstdone=0;
    for(node=filelist;node;node=data_nextlist(node)) {
      p=data_name(node);
      if(strncmp(buf,p,strlen(buf))) continue;
      if(firstdone) {
        for(n=0;p[n]==complete[n];n++);
        complete[n]=0;
      } else {
        strcpy(complete,p);
        firstdone=1;
      }
    }
    if(firstdone) strcpy(buf,complete);
    return;
  case PV_PATHNAME:
  case PV_DIRNAME:
  case PV_NOPATHDIRNAME:
    if((prevtype!=PV_NOPATHDIRNAME)&&(buf[0]=='~')&&(!strchr(buf,'/'))) {
      firstdone=0;
      for(i=0;usernamelist[i];i++) {
        q=usernamelist[i];
        if(strncmp(buf+1,q,strlen(buf+1))) continue;
        sprintf(tmpnam,"%s/",q);
        if(firstdone) {
          for(n=0;tmpnam[n]==complete[n];n++);
          complete[n]=0;
        } else {
          strcpy(complete,tmpnam);
          firstdone=1;
        }
      }
      if(firstdone) strcpy(buf+1,complete);
      return;
    }

    if(prevtype==PV_NOPATHDIRNAME) {
      pathnam=data_fullname(currentdir);
      filebuf=buf;
    } else {
      sprintf(pathbuf,"%sa",buf);
      oldkeepmsbar=keep_msbar;
      keep_msbar=3;
      p=comm_parsepath(comm_makeabsolute(pathbuf,currentdir));
      keep_msbar=oldkeepmsbar;
      if(!p) return;
      strcpy(pathbuf,p);
      *strrchr(pathbuf,'/')=0;
      if(!pathbuf[0]) strcpy(pathbuf,"/");
      pathnam=pathbuf;
      q=strrchr(buf,'/');
      if(q) filebuf=q+1;
      else  filebuf=buf;
    }
    firstdone=0;
    dir=opendir(pathnam);
    if(!dir) return;
    for(;;) {
      ent=readdir(dir);
      if(!ent) break;
      if(!strcmp(ent->d_name,".")) continue;
      if(!strcmp(ent->d_name,"..")) continue;
      if(strncmp(filebuf,ent->d_name,strlen(filebuf))) continue;
      if(strlen(pathnam)+strlen(ent->d_name)+1<PATH_MAX) {
        sprintf(tmppath,"%s/%s",pathnam,ent->d_name);
        if(config.followlinkdirs?data_fs_isdir_links(tmppath)
                                :data_fs_isdir_nolinks(tmppath)) {
          if(prevtype==PV_NOPATHDIRNAME) strcpy(tmpnam,ent->d_name);
          else                           sprintf(tmpnam,"%s/",ent->d_name);
        } else {
          strcpy(tmpnam,ent->d_name);
          if(prevtype==PV_DIRNAME) continue;
          if(prevtype==PV_NOPATHDIRNAME) continue;
        }
      } else strcpy(tmpnam,ent->d_name);
      if(firstdone) {
        for(n=0;tmpnam[n]==complete[n];n++);
        complete[n]=0;
      } else {
        strcpy(complete,tmpnam);
        firstdone=1;
      }
    }
    closedir(dir);
    if(firstdone) if(maxlen-(filebuf-buf)-1)
      strncpy(filebuf,complete,maxlen-(filebuf-buf)-1);
    return;
  case PV_UNAME:
    readln_matchlist(buf,maxlen,usernamelist);
    return;
  case PV_GNAME:
    readln_matchlist(buf,maxlen,groupnamelist);
    return;
  default:
    readln_matchlist(buf,maxlen,prevlines[prevtype]);
    return;
  }
  crapout("readln_docomplete","end of function reached");
}
