/* linuXtree copyright (c) 1998 Dan Stahlke under the GPL
   See file 'COPYING' for details */

#define LOOKUP_NONX 0
#define LOOKUP_X 1
#define LOOKUP_PIPE 2

extern struct configtype config;

struct externaltype {
  char *fspec;
  char *com;
  char *xcom;
  char *pipe;
  struct externaltype *next;
};

struct configtype {
  int rawmode;
  int silent;
  int tagtoggle;
  int preservetag;
  int autorestatdirs;
  int autorestatfiles;
  int followlinks;
  int followlinkdirs;
  int clearkeybuffer;
  int viewpowtwo;
  int logtocurdir;
  int defaultreadln;
  int animatedlogging;
  char *editor;
  char *archivebranch;
  char *archivetagged;
  int inX;
  struct externaltype *external;
};

void config_init(int argc,char *argv[]);
void config_readfile(const char *fn);
int config_setoption(const char *buf);
const char *config_lookupext(const char *fn,int mode);
void config_fileerror(const char *buf,const char *error);
void config_cmdhelp(void);
void config_opthelp(const char *opt);
void print_config(void);
int config_verifyformat(const char *fmt,const char *opts);
void config_readopt(const char *fullbuf,const char *str,char *outbuf,const char **nextopt);

void config_dispconfig(void);
void config_initruntimeconfig(void);
void config_runtimeconfig(void);
void config_saveconfig(const char *fn);
void config_saveconfig_F(FILE *f);
char *config_slashquote(char *buf,char *s);
void config_freetmpsaved(void);
void config_tmpsave(void);
void config_tmprestore(void);
void config_exitconfig(void);
