/* linuXtree copyright (c) 1998 Dan Stahlke under the GPL
   See file 'COPYING' for details */

#include "all.h"

int quitnow;
int cancelled=0;
extern int windowsup;
extern int keep_msbar;
extern int gui_wantresize,dispmode;

int main(int argc,char *argv[]) {
  int n,c,status;

  for(n=1;n<argc;n++) if(!strcmp(argv[n],"-v")) {
#ifdef __DATE__
    printf("\nlinuXtree "VERSION", compiled on "__DATE__"\n");
#else
    printf("\nlinuXtree "VERSION"\n");
#endif
    printf("copyright (c) 1998 Dan Stahlke under the GPL\n");
    printf("See file 'COPYING' for details\n\n");
    exit(0);
  }

  quitnow=0;
  windowsup=0;
  printf("\nlinuXtree %s copyright (c) 1998 Dan Stahlke under the GPL\n",VERSION);
  printf("See file 'COPYING' for details\n\n");

  /* this should be in data.c, but it is here because config.c needs this
     to be setup if 'lxt -recover' is called */
  for(n=0;n<TREEDATACHUNKS;n++) {
    treedata[n]=NULL;
    treeholes[n]=0;
  }

  printf("running config_init\n");
  config_init(argc,argv);
  printf("running uid_init\n");
  uid_init();
  printf("running data_init\n");
  data_init();
  printf("running command_init\n");
  comm_init();
  printf("running gui_init\n");
  gui_init();
  view_init();

  for(quitnow=0;!quitnow;) {
    data_restatstuffiftouched();
    gui_drawmode();
    if(cancelled) gui_mildbeep("Aborted!");
    /* next line clears most of key buffer, but keeps the first key */
    timeout(0);
    if(config.clearkeybuffer) is_cancel();
    cancelled=0;
    timeout(100);
    while((c=getch())==ERR) {
      if(gui_wantresize) {
        gui_stopcurses();
        gui_startcurses();
        gui_initdispmode(dispmode);
        gui_wantresize=0;
      }
      gui_drawtime();
      view_updatepipe();
      waitpid(-1,&status,WNOHANG); /* get rid of old processes */
    }
    keep_msbar=0;
    gui_processkey(c);
  }

  gui_stopcurses();
  clearscreen();
  return 0;
}

int is_cancel(void) {
  int c,x;
  if(cancelled) return 1;
  timeout(0);
  c=getch();
  if(c=='\a') return (cancelled=1);
  if(c==ERR) return 0;
  do { x=getch(); if(x=='\a') return (cancelled=1); } while(x!=ERR);
  ungetch(c);
  return 0;
}

void set_cancel(void) {
  cancelled=1;
}

void small_nap(void) {
  struct timespec req;
  req.tv_sec=0;
  req.tv_nsec=10000000;
  nanosleep(&req,NULL);
}

void outofmem(const char *fn) {
  gui_stopcurses();
  fprintf(stderr,"\n\nOut of memory in function %s!!!\n",fn);
  exit(1);
}

void crapout(const char *fn,const char *fmt, ...) {
  va_list argp;
  sleep(1);
  gui_stopcurses();
  fprintf(stderr,"\n\nError!\n");
  fprintf(stderr,"The following error occured in function %s():\n  ",fn);
  va_start(argp, fmt);
  vfprintf(stderr, fmt, argp);
  va_end(argp);
  fprintf(stderr,"\nIf you can figure out how to reproduce this bug, send a bug report to:\n  %s\n\n",EMAIL);
  if(treedata[0]) {
    fprintf(stderr,"Dumping filetree...\n");
    data_savetree();
    fprintf(stderr,"Send me the file zzz-dumptree, which contains the list of files logged\n  at the time of the crash\n\n");
  }
  exit(1);
}

void crapout_nobug(const char *fmt, ...) {
  va_list argp;
  sleep(1);
  gui_stopcurses();
  fprintf(stderr,"\n\nError!\n");
  fprintf(stderr,"The following error has occured:\n  ");
  va_start(argp, fmt);
  vfprintf(stderr, fmt, argp);
  va_end(argp);
  fprintf(stderr,"\n\n");
  exit(1);
}

void clearscreen(void) {
  system("/usr/bin/clear");
}
