/**** what is displayed when '?' is pressed ****/

#define HELP_TREE "     --- help for tree mode ---  \n\n\
 key       | function                   \n\
 ----------|--------------              \n\
 +         | log/relog dir              \n\
 -         | unlog dir                  \n\
 *         | log branch                 \n\
 pgup/pgdn | page up/page down          \n\
 up/down   | move around                \n\
 home/end  | go to top/bottom           \n\
 enter     | log dir or go into dir     \n\
 left      | unlog . or ..              \n\
 right     | log dir or go down         \n\
 tab       | rename, chown, chmod, etc.	\n\
 g         | goto (chdir)               \n\
 m         | make dir                   \n\
 d         | delete dir                 \n\
 r         | rename dir                 \n\
 s         | make symbolic link		\n\
 t         | tag files in dir           \n\
 u         | untag files in dir         \n\
 f         | change filespec            \n\
 i         | invert filespec            \n\
 x         | execute			\n\
 q         | quit                       \n\
 s         | show all files             \n\
 b         | show all files in branch   \n\
 o         | mount/unmount		\n\
           |                            \n\
 C-s       | show all tagged files	\n\
 C-b       | show all tagged files in branch	\n\
 C-r       | restat dir                 \n\
 C-t       | recursively tag dir and all contents   \n\
 C-u       | recursively untag dir and all contents \n\
           |                            \n\
 M-o       | configure			\n\
 M-f       | choose list format         \n\
 M-s       | sort criteria		\n\
 M-a       | make archive (tar.gz)	\n\
 M-m       | move branch                \n\
 M-p       | prune branch (rm -rf)      \n\
 M-d       | show debug info on right   \n\
"

#define HELP_FILE "     --- help for file mode ---  \n\n\
 key       | function                   \n\
 ----------|--------------              \n\
 pgup/pgdn | page up/page down		\n\
 arrows    | move around		\n\
 home/end  | go to top/bottom		\n\
 enter     | go back to tree		\n\
 tab       | rename, chown, chmod, etc.	\n\
 v         | view			\n\
 t         | set/toggle tag		\n\
 u         | untag			\n\
 d         | delete			\n\
 r         | rename			\n\
 m         | move			\n\
 c         | copy			\n\
 s         | make symbolic link		\n\
 o         | open with external program	\n\
 e         | edit			\n\
 f         | change filespec            \n\
 i         | invert filespec            \n\
 x         | execute                    \n\
 q         | quit			\n\
           |                            \n\
 C-r       | relog current dir		\n\
 C-t       | tag all files		\n\
 C-u       | untag all files		\n\
 C-n       | invert tag of all files	\n\
 C-d       | delete tagged files	\n\
 C-c       | copy tagged files		\n\
 C-v       | move tagged files		\n\
 C-a       | chmod tagged files		\n\
 C-o       | chown,chgrp tagged files	\n\
 C-g       | grep all tagged files	\n\
           |                            \n\
 M-o       | configure			\n\
 M-f       | choose list format         \n\
 M-s       | sort criteria		\n\
 M-t       | tag by filespec		\n\
 M-u       | untag by filespec		\n\
 M-d       | show debug info on right   \n\
"

#define HELP_VIEW "     --- help for view mode ---  \n\n\
 key       | function                   \n\
 ----------|--------------              \n\
 pgup/pgdn | page up/page down		\n\
 b/space   | page up/page down          \n\
 up/down   | scroll			\n\
 home/end  | go to top/bottom		\n\
 t         | text mode			\n\
 d         | dump mode			\n\
 m         | toggle mask		\n\
 h         | hex mode			\n\
 f/p       | pipe mode                  \n\
 /         | search forward             \n\
 \\         | search backwards           \n\
 M-u       | toggle hiliting of matched items \n\
 v/q       | exit viewer		\n\
 enter     | exit viewer		\n\
 \n\
 Pipes:\n\
   When asked for a pipe, type the command you want to pipe the text\n\
   through.  On the command line, %p is replaced with the full path name\n\
   of the file being viewed, %d is replaced with the directory, and %f\n\
   is replaced with the filename.\n\
   Enter a blank line to return to non-pipe mode.\n\
"

/**** the descriptions of the config options ****/

#define CHELP_EDITHEADER \
"          Configuration Editor\n%s\n\n\
Keys:\n\
  arrows - move\n\
  space  - toggle value\n\
  enter  - toggle value / edit string\n\
  s      - save configuration as default\n\
  r      - undo changes\n\
  q      - quit\n\
--------------------------------------------"

/*
   note that if you were to grep this file for the long echo command below,
   you would need to type:
   grep "\\\"echo \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"" help.h
*/

#define CHELP_CONFHEADER \
"# linuXtree config file\n\
# blank lines and lines beginning with # are ignored\n\
# maximum line length is 800 chars\n\
# any option in this file can also be specified on the command line\n\
\n\
# \":\" seperates fields, use \"\\:\" to interpret the colon literally, \"\\\\\" to\n\
# interpret a backslash literally, other escape sequences are not recognized.\n\
# Quotes are not interpreted by lxt (but quotes and backslashes are interpreted\n\
# by sh when commands are run).  Note: to type the command that echos a\n\
# backslash to stdout you would need to do \"echo \\\\\\\\\", because lxt will\n\
# read this as \"echo \\\\\" and the shell would read that as \"echo \\\".\n\
\n\
##############################################################################\n"

#define CHELP_RAWMODE \
"# rawmode:hide     puts ? for unprintable chars in filenames\n\
# rawmode:octal    prints unprintable chars in octal\n\
# rawmode:control  is like octal except chars 1-26 are printed as ^[A-Z]"

#define CHELP_SILENT \
"# silent:1 makes lxt never make a beep noise"

#define CHELP_TAGTOGGLE \
"# tagtoggle:0 makes 't' tag\n\
# tagtoggle:1 makes 't' toggle tag"

#define CHELP_PRESERVETAG \
"# preservetag:0 untags files when they are moved\n\
# preservetag:1 keeps tag status across moves"

#define CHELP_AUTORESTATDIRS \
"# autorestatdirs:1 will restat the current dir if the modification time of\n\
# the dir has changed since the last time the screen was redrawn."

#define CHELP_AUTORESTATFILES \
"# autorestatfiles:1 will restat files as the cursor passes over them."

#define CHELP_FOLLOWLINKS \
"# followlinks:1 makes lxt look at the mode of the thing links point to,\n\
# rather than the link itself.  When a file type is printed in all caps\n\
# (eg: \"REGULAR\", \"DIR\", etc.) it means the file is a link to a file of\n\
# that type.  If the file type is \"link\", then the link is broken and\n\
# doesn't point to anything."

#define CHELP_FOLLOWLINKDIRS \
"# followlinkdirs:1 makes links to dirs show up in the tree."

#define CHELP_CLEARKEYBUFFER \
"# clearkeybuffer:1 will make the keyboard buffer not fill up when you hold\n\
# down a key.  So, if you press the arrows faster than the screen can redraw,\n\
# the cursor will stop moving as soon as you stop pressing the key if this\n\
# option is set, but the cursor will keep going if this option is not set."

#define CHELP_VIEWPOWTWO \
"# viewpowtwo:1 will force hex and dump view modes to have a width that is a\n\
# power of two.  This is a nicer way to do it, but it may not use the whole\n\
# screen with most screen widths.  viewpowtwo:0 will use the largest width\n\
# that will fit on the screen.  For screens with a width of 80, viewpowtwo:1\n\
# is recommended."

#define CHELP_LOGTOCURDIR \
"# logtocurdir:0 will start you out in root\n\
# logtocurdir:1 will start you out in the directory you started lxt from"

#define CHELP_DEFAULTREADLN \
"# defaultreadln:1 will put the current file name in the edit field when you\n\
# are asked for a new name with the rename command.  You can edit the name\n\
# or press crtl-U and enter a new name."

#define CHELP_ANIMATEDLOGGING \
"# animatedlogging:1 makes it so the screen is updated for each step of logging\n\
# to a dir"

#define CHELP_EDITOR \
"# editor for 'e' command\n\
# format is editor:command\n\
# %f is replaced with name of file\n\
# %d is replaced with directory\n\
# %p is replaced with full path of file"

#define CHELP_ARCHIVEBRANCH \
"# command for creating archive of a branch\n\
# %a is replaced with name of archive\n\
# %b is replaced with path of branch to be archived"

#define CHELP_ARCHIVETAGGED \
"# command for creating archive of tagged files\n\
# %a is replaced with name of archive\n\
# %b is replaced with path for the root dir of archive\n\
# %c is replaced with name of file containing list of files to be archived"

#define CHELP_EXTERNAL \
"# external viewers for open command and pipe command\n\
# format is external:filespec:command:xcommand:pipe\n\
#\n\
# command runs when not in X (blank means do nothing when not in X)\n\
# xcommand runs when in X (blank means do nothing when in X, \".\" means\n\
#   run the same command as would be run when not in X).  On the command\n\
#   line, if no colon is given after \"command\", then \"xcommand\" will\n\
#   be as if you gave \".\"
# pipe is the default pipe used in view mode (optional)\n\
#\n\
# %f is replaced with name of file\n\
# %d is replaced with directory\n\
# %p is replaced with full path of file\n\
#\n\
# the filespec is matched against the full pathname, and the first\n\
# matching entry is used."
