/* linuXtree copyright (c) 1998 Dan Stahlke under the GPL
   See file 'COPYING' for details */

#define DISP_TREE 1
#define DISP_FILE 2
#define DISP_VIEW 3
#define DISP_HELP 4
#define DISP_CONF 5

#define D_FORM_LONG 0
#define D_FORM_SHORTA 1
#define D_FORM_SHORTB 2
#define D_FORM_NAMEONLY 3
#define D_FORM_TWOCOL 4
#define D_FORM_TRICOL 5
#define D_FORM_NUM 6      /* how many total modes */

#define D_FILE_NONE 0
#define D_FILE_NORM 1
#define D_FILE_BRANCH 2
#define D_FILE_SHOWALL 3
#define D_FILE_TAGBRANCH 4
#define D_FILE_TAGSHOWALL 5

#define RAWMODE_HIDE 0      /* question marks for unprintable chars */
#define RAWMODE_OCTAL 1     /* octal for unprintable chars */
#define RAWMODE_CONTROL 2   /* like octal, but ^[A-Z] for chars 1-26 */

#define C_NORMAL 1
#define C_HILITE 2
#define C_MENU   3
#define C_WARN   4
#define C_TAGGED 5
#define C_HITAG  6
#define C_BOLD   7
#define C_UNDERLINE 8
#define C_VIEWEOF   9

void gui_init(void);
void gui_saveenviron(void);
void gui_restoreenviron(void);
void gui_startcurses(void);
void gui_stopcurses(void);
void gui_resize(int sig);
void gui_refreshscreen(void);
void gui_initdispmode(int mode);

void gui_drawmode(void);
void gui_drawonename(int num,int y,int h,int shift,char *treelines);
void gui_drawtree(void);
void gui_drawfile(void);
void gui_displaycurrentname(void);
const char *gui_linkname(const char *fname);
void gui_drawtime(void);
void gui_startpatience(const char *s);
void gui_updatepatience(void);
void gui_endpatience(void);
void gui_drawstatus(void);
void gui_drawnodestatus(int node);
const char *gui_fmodename(int node,int brief);
const char *gui_time(time_t t);
int gui_positioncursor(int node);
void gui_synctocurrentnode_bar(void);
void gui_synctocurrentnode_bar_nice(void);
void gui_updatecurrentnode(void);

void gui_processkey(int c);
void gui_symbolpress(int c);
void gui_letterpress(int c);
void gui_controlpress(int c);
void gui_metapress(int c);
void gui_specialpress(int c);

void gui_listlong(int node,int wy,int wx,WINDOW *win);

const char *gui_printable(int maxlen,const char *in);
const char *gui_printable_quoted(int maxlen,const char *in);
int gui_printable_curspos(const char *in,int pin);

void gui_setwantdraw(void);
void gui_setwantdrawall(void);

void gui_mildbeep(const char *fmt, ...);
void gui_printmsg(const char *fmt, ...);
void gui_printmsg_wait(const char *fmt, ...);

