/* linuXtree copyright (c) 1998 Dan Stahlke under the GPL
   See file 'COPYING' for details */

#define TREEBLOCKSIZE 256
#define TREEDATACHUNKS 10000

#define SORT_ALPHA 0
#define SORT_PATH 1
#define SORT_DATE 2
#define SORT_SIZE 3
#define SORT_DIRECTION 256

struct treedata_type {
  int referer;              /* points to "..", -1 if this entry unused */
  int prev;                 /* prev file in "." (alpha sorted) */
  int next;                 /* next file in "." (alpha sorted) */
  int point;                /* points to where dir leads */
  struct stat lsinfo;       /* info about file (links not followed, lstat) */
  struct stat lpinfo;       /* info about file (links are followed,  stat) */
  int statlogged;           /* is the file counted in file/dir statistics? */
  int isdir;                /* dir or link to dir (if link to dir enabled) */
  char name[MAXNAMLEN+1];   /* name of file */
  int depth;                /* how many dirs deep... 0=root */
  int tagged;               /* is the file tagged? */
  int prevlist;             /* prev file in current list (0 is none) */
  int nextlist;             /* next file in current list (0 is none) */
  int shown;                /* does file match filespec? (only makes sense within filelist) */
};

#if TREEBLOCKSIZE==256
  extern struct treedata_type *treedata[];
  extern int treeholes[];
  #define datanode(n) (treedata[(n)>>8]+((n)&255))
#else
  struct treedata_type *datanode(int n);
#endif
void data_init(void);
void data_clear(int n);
void data_chopnode(int n);
int data_findfree(void);
void data_initnode(int node);
void data_statlog(int node);
void data_unstatlog(int node);
int data_guardcurrentnode(int n);
int data_matchfilespec(const char *name);
void data_breaklist(int node);
int data_makelistfromdir(int dirnode);
int data_makelistfromtagged(int startnode);
int data_makelistofbranch(int startnode);
void data_restatloggeddirs(int topdir);
void data_restatstuffiftouched(void);
void data_restatiftouched(int dir);
void data_logdir(int num);
char *data_resettreelines(char *in);
char *data_nexttreelines(char *in,int node);
char *data_prevtreelines(char *in,int node);
char *data_updatetreelines(char *in,int node);
void data_restatdir(int node);
int data_restatfileifdirlogged(const char *fn);
int data_restatfilename(int dirnode,const char *fn);
int data_restatnode(int node);
int data_restatnode_noresort(int node);
void data_insertintolist(int new);
void data_deletefromlist(int node);
int data_logtodir(const char *dirname);
void data_logbranch(int node);
int data_findname(int node,const char *name);
int data_findinlist(const char *name);
const char *data_squishfullname(const char *name);
int data_findfullname(const char *name);
void data_unlogdir(int node);
void data_updatesort(int node);
int data_mergesortlist(int startnode,int method);
void data_mergesortdir(int startnode,int method);
int data_mergesort(int startnode,int method,
         int (*nextfunc)(int),int (*prevfunc)(int),void (*movefunc)(int,int));
void data_mergelists(int *n1,int *n2,int *p1,int *p2,int method,
         int (*nextfunc)(int),int (*prevfunc)(int),void (*movefunc)(int,int));
int data_comparenodes(int na,int nb,int method);
void data_toplist(int dirnode,int method,int size,int list[]);
int data_listpos(int num);
int data_treepos(int num);
int data_nexttree(int num);
int data_prevtree(int num);
int data_nextfile(int num);
int data_nextdir(int num);
int data_prevfile(int num);
int data_prevdir(int num);
int data_depth(int num);
int data_tagged(int num);
void data_settag(int num,int val);
void data_settagdir(int num,int val);
const char *data_fullname(int num);
void data_fixdepth(int node);
void data_recursetree(int startnode,void (*func)(int node));
void data_recursedir(int startnode,void (*func)(int node));
int data_hasfile(int node);
int data_hasmatching(int node);
int data_exists(const char *fn);
int data_fs_isdir_nolinks(const char *fn);
int data_fs_isdir_links(const char *fn);
int data_downdir(int node);
int data_updir(int node);
int data_nextnode(int node);
int data_prevnode(int node);
int data_nextlist(int node);
int data_prevlist(int node);
int data_firstshown(void);
int data_nextshown(int node);
int data_prevshown(int node);
int data_isdir(int num);
int data_isregular(int num);
int data_islnk(int num);
int data_goodlink(int num);
const char *data_name(int num);
struct stat data_info(int num);
struct stat data_lsinfo(int num);
struct stat data_lpinfo(int num);

void data_savetree(void);
void data_restoretree(void);

#ifdef DEBUG
void data_dumptree(void);
void data_dumpnode(int n);
void data_dumplinkage(int node);
#endif
#ifdef DEBUGNODE
void data_dumpused(void);
#endif

