/* linuXtree copyright (c) 1998 Dan Stahlke under the GPL
   See file 'COPYING' for details */

/* Set this to the length of the maximum path on your system, if it's not
   defined in the include files.  If you make it smaller than the actual
   maximum path length for your system, then lxt will crash or do horrible
   unpredictible things when you deal with paths that are longer than this
   number. */
/* #define PATH_MAX 4096 */

/* maybe this fixes things on some systems */
#ifndef PATH_MAX
  #ifndef MAXPATHLEN
    #error "No PATH_MAX or MAXPATHLEN defined.  Edit compatible.h and define it yourself."
  #endif
  #define PATH_MAX MAXPATHLEN
#endif

#ifndef S_ISVTX
  #define S_ISVTX 001000
#endif

#ifndef HAVE_LCHOWN
#  define lchown chown
#endif

#ifndef HAVE_WGETBKGD
#  define wgetbkgd(win) getbkgd(win)
#endif

#ifndef HAVE_MKDIR
  int mkdir(const char *name,mode_t mode);
#endif

#ifndef HAVE_RMDIR
  int rmdir(const char *name);
#endif

#ifndef HAVE_STRERROR
  char *strerror(int n);
#endif

#ifndef HAVE_VSNPRINTF
  int vsnprintf(char *sout,size_t maxnum,const char *format,va_list ap);
#endif

#ifndef HAVE_VFPRINTF
  int vfprintf(FILE *fout,const char *fmt,va_list ap);
#endif

#ifndef HAVE_SNPRINTF
  int snprintf(char *str,size_t n,const char *format,...);
#endif

#if defined (HAVE_STATFS) || defined (HAVE_STATVFS)
#  define HAVE_MY_STATFS
  struct my_statfs_struct {
    long totalkbytes;
    long availkbytes;
    long usedkbytes;
  };
  int my_statfs(const char *fn,struct my_statfs_struct *ret);
#endif

#if defined (GETMNTENT_BSD) || defined (GETMNTENT_SOLARIS)
#  define HAVE_MY_GETMNTENT
#  define MNT_FSTAB 0
#  define MNT_MTAB 1
  struct my_mntent {
    char *mnt_fsname;    /* name of mounted file system */
    char *mnt_dir;       /* file system path prefix */
    char *mnt_type;      /* mount type (see mntent.h) */
    char *mnt_opts;      /* mount options (see mntent.h) */
  };
  FILE *my_setmntent(int which);
  struct my_mntent *my_getmntent(FILE *f);
  int my_endmntent(FILE *f);
#endif

#ifdef HAVE_POSIX_REGCOMP
#  define my_regex_t regex_t
#  define my_regmatch_t regmatch_t
#  define my_regcomp regcomp
#  define my_regerror regerror
#  define my_regexec regexec
#  define my_regfree regfree
#else
  typedef struct {
    char *s;
    int flags;
  } my_regex_t;
  typedef struct {
    int rm_so,rm_eo;
  } my_regmatch_t;
  int my_regcomp(my_regex_t *preg,const char *regex,int cflags);
  int my_regexec(const my_regex_t *preg,const char *string,
                 size_t nmatch,my_regmatch_t pmatch[],int eflags);
  size_t my_regerror(int errcode,const my_regex_t *preg,char
                     *errbuf,size_t errbuf_size);
  void my_regfree(my_regex_t *preg);
#endif
