/* linuXtree copyright (c) 1998 Dan Stahlke under the GPL
   See file 'COPYING' for details */

/* this file contains a bunch of nasty hacks that make lxt work as good as
   possible on crappy operating systems that don't have all the usual stuff */

#include "all.h"

#ifndef HAVE_MKDIR
int mkdir(const char *name,mode_t mode) {
  int ret;
  ret=comm_runcommand(NULL,"mkdir %a","a",name);
  if(ret) return ret;
  return chmod(name,mode);
}
#endif

#ifndef HAVE_RMDIR
int rmdir(const char *name) {
  return comm_runcommand(NULL,"rmdir %a","a",name);
}
#endif

#ifndef HAVE_STRERROR
char comp_errstr[(sizeof(int)*8+2)/3+1];
char *strerror(int n) {
  sprintf(comp_errstr,"%d",n);
  return comp_errstr;
}
#endif

/* these ghetto-rigged functions don't offer even close to full functionality,
   but they are better than nothing */
#ifndef HAVE_VSNPRINTF
#define check_num {if(num>=(maxnum-1)) {sout[maxnum-1]=0; return -1;}}
int vsnprintf(char *sout,size_t maxnum,const char *format,va_list ap) {
  int p,num,ret;
  char *p_s;
  int p_d;

  num=0;
  for(p=0;format[p];p++) {
    if(format[p]=='%') {
      p++;
      if(format[p]=='s') {
        p_s=va_arg(ap,char *);
        strncpy(sout+num,p_s,maxnum-num);
        num+=strlen(p_s);
        check_num;
      } else if(format[p]=='d') {
        p_d=va_arg(ap,int);
        ret=snprintf(sout+num,maxnum-num,"%d",p_d);
        if(ret==-1) return -1;
        num+=ret;
        check_num;
      } else {
        sout[num++]='%';
        check_num;
        sout[num++]=format[p];
        check_num;
      }
    } else {
      sout[num++]=format[p];
      check_num;
    }
  }
  sout[num]=0;
  return num;
}
#endif

#ifndef HAVE_VFPRINTF
int vfprintf(FILE *fout,const char *fmt,va_list ap) {
  int ret;
  char buf[1000];
  ret=vsnprintf(buf,1000,fmt,ap);
  if(ret==-1) ret=1000;
  fprintf(fout,"%s",buf);
  return ret;
}
#endif

#ifndef HAVE_SNPRINTF
int snprintf(char *str,size_t n,const char *format,...) {
  va_list argp;
  int ret;
  va_start(argp,format);
  ret=vsnprintf(str,n,format,argp);
  va_end(argp);
  return ret;
}
#endif

#if defined (HAVE_STATFS) || defined (HAVE_STATVFS)
  int my_statfs(const char *fn,struct my_statfs_struct *ret) {
    int a,block;
#ifdef HAVE_STATVFS
    struct statvfs buf;
    a=statvfs(fn,&buf);
#else
    struct statfs buf;
    a=statfs(fn,&buf);
#endif
    if(a) {
      ret->totalkbytes=ret->availkbytes=ret->usedkbytes=0;
      return 1;
    }
#ifdef STATFS_FRSIZE
    block=buf.f_frsize;
#else
    block=buf.f_bsize;
#endif
    ret->totalkbytes=(long)((float)buf.f_blocks*block/1024);
    ret->availkbytes=(long)((float)buf.f_bavail*block/1024);
    ret->usedkbytes=(long)((float)(buf.f_blocks-buf.f_bfree)*block/1024);
    return 0;
  }
#endif

#ifdef GETMNTENT_BSD
  FILE *my_setmntent(int which) {
    char *fn;
    if(which==MNT_FSTAB) fn="/etc/fstab";
    else if(which==MNT_MTAB) fn="/etc/mtab";
    else {fn=""; crapout("my_setmntent","invalid mount file");}
    return setmntent(fn,"r");
  }
  struct my_mntent mntent_ret;
  struct my_mntent *my_getmntent(FILE *f) {
    struct mntent *val;
    val=getmntent(f);
    if(!val) return NULL;
    mntent_ret.mnt_fsname=val->mnt_fsname;
    mntent_ret.mnt_dir=val->mnt_dir;
    mntent_ret.mnt_type=val->mnt_type;
    mntent_ret.mnt_opts=val->mnt_opts;
    return &mntent_ret;
  }
  int my_endmntent(FILE *f) { return endmntent(f); }
#elif defined (GETMNTENT_SOLARIS)
  FILE *my_setmntent(int which) {
    char *fn;
    if(which==MNT_FSTAB) fn="/etc/fstab";
    else if(which==MNT_MTAB) fn="/etc/mnttab";
    else crapout("my_setmntent","invalid mount file");
    return fopen(fn,"r");
  }
  struct my_mntent mntent_ret;
  struct my_mntent *my_getmntent(FILE *f) {
    struct mnttab val;
    if(getmntent(f,*val)) return NULL;
    mntent_ret.mnt_fsname=val.mnt_special;
    mntent_ret.mnt_dir=val.mnt_mountp;
    mntent_ret.mnt_type=val.mnt_fstype;
    mntent_ret.mnt_opts=val.mnt_mntopts;
    return &mntent_ret;
  }
  int my_endmntent(FILE *f) { fclose(f); return 1; }
#endif /* defined (GETMNTENT_*) */

#ifdef HAVE_POSIX_REGCOMP
/* this part taken care of in compatible.h */
#else
#define REGCOMP_OUTOFMEM 1
int my_regcomp(my_regex_t *preg,const char *regex,int cflags) {
  preg->s=malloc(sizeof(regex)+1);
  if(!preg->s) return REGCOMP_OUTOFMEM;
  strcpy(preg->s,regex);
  preg->flags=cflags;
  return 0;
}

int my_regexec(const my_regex_t *preg,const char *string,
               size_t nmatch,my_regmatch_t pmatch[],int eflags) {
  const char *loc;
  if(nmatch>1) crapout("my_regexec","nmatch>1");
  loc=strstr(string,preg->s);
  if(loc) {
    if(nmatch>=1) {
      pmatch[0].rm_so=loc-string;
      pmatch[0].rm_eo=loc-string+strlen(preg->s);
    }
    return 0;
  } else {
    if(nmatch>=1) {
      pmatch[0].rm_so=-1;
      pmatch[0].rm_eo=-1;
    }
    return 1;
  }
}

size_t my_regerror(int errcode,const my_regex_t *preg,char *errbuf,
                   size_t errbuf_size) {
  char *s;
  switch(errcode) {
  case REGCOMP_OUTOFMEM:
    s="Out of memory";
    break;
  default:
    crapout("my_regerror","unknown errcode");
  }
  if(errbuf&&errbuf_size) {
    strncpy(errbuf,s,errbuf_size-1);
    errbuf[errbuf_size-1]=0;
  }
  return strlen(s);
}

void my_regfree(my_regex_t *preg) {
  free(preg->s);
}
#endif
