/* linuXtree copyright (c) 1998 Dan Stahlke under the GPL
   See file 'COPYING' for details */

void comm_init(void);
void comm_mount(void);
void comm_filespec(void);
void comm_invertfilespec(void);
void comm_updatefilespec(void);
void comm_tagbyfilespec(int state);
void comm_editstatinfo(void);
void comm_symlink(void);
void comm_exec(void);
void comm_archive(void);
void comm_archive_tree_tagged(int rootnode);
void comm_mvbranch(void);
void comm_rmbranch(void);
void comm_chdir(void);
void comm_gotofile(void);

void comm_tag_grep(void);
int comm_greptagged(int node,va_list argp);
void comm_tag_chown(void);
int comm_chowntagged(int node,va_list argp);
void comm_tag_chmod(void);
int comm_chmodtagged(int node,va_list argp);
void comm_tag_rmfile(void);
int comm_delete_noask(int node, va_list argp);
void comm_tag_cpfile(void);
int comm_cptagged(int node, va_list argp);
void comm_tag_mvfile(void);
int comm_mvtagged(int node, va_list argp);
int comm_existtag(void);
void comm_tag_foreach(int (*func)(int node, va_list argp),const char *confstr, ...);
void comm_makedir(void);
void comm_rmdir(void);

void comm_rmfile(void);
void comm_cpfile(void);
void comm_mvfile(void);
void comm_rename(void);
void comm_open(int waitkey);
void comm_edit(void);
void comm_doublechecknode(void);
int comm_askoverwrite(const char *fn);
int comm_prompt_norm(char *s,int maxchars,const char *def,int def_override,const char *prompt,int prevtype);
int comm_prompt_path(char *s,int maxchars,const char *def,int def_override,const char *prompt);
int comm_prompt_dir(char *s,int maxchars,const char *def,int def_override,const char *prompt);
int readln_read_updir(WINDOW *win,int yl,int xl,int xs,int len,char *buf,int tabmode,int prevtype);
int comm_prompt_updir(char *s,int maxchars,const char *def,int def_override,const char *prompt,int tabmode,int prevtype);
int comm_prompt(char *s,int maxchars,const char *def,int def_override,const char *prompt,int tabmode,int prevtype);
int comm_yesno(const char *prompt);
int comm_runexternal(const char *command,int waitkey);
int comm_configrunf(int waitkey,const char *fmt,const char *opts, ...);
const char *comm_configparsef_wrap(const char *fmt,const char *opts, ...);
const char *comm_configparsef(const char *fmt,const char *opts, va_list ap);
int comm_runcommand(const char *dispstr,const char *fmt,const char *opts, ...);
const char *comm_makeabsolute(const char *s,int curnode);
const char *comm_parsepath(const char *in);
int comm_verifydir(const char *to);
int comm_checksame(const char *a,const char *b);
int comm_checklength(const char *fn);
