dnl Check if the stat(v)fs structure has f_frsize element

AC_DEFUN(AC_STATFS_FRSIZE,[
if test $ac_cv_func_statvfs = yes ; then

AC_MSG_CHECKING([if statvfs structure has f_frsize element])
echo "#include <sys/types.h>" >tmpconf.h
if test $ac_cv_header_sys_vfs_h = yes ; then
  echo "#include <sys/vfs.h>" >>tmpconf.h
fi
if test $ac_cv_header_sys_statvfs_h = yes ; then
  echo "#include <sys/statvfs.h>" >>tmpconf.h
fi
AC_TRY_LINK([
  #include "tmpconf.h"
],[
  struct statvfs *a;
  long b;
  b=(long)a->f_frsize;
],AC_DEFINE(STATFS_FRSIZE,,[Define if struct stat(v)fs has f_frsize element]) AC_MSG_RESULT(yes),AC_MSG_RESULT(no))
rm tmpconf.h

elif test $ac_cv_func_statfs = yes ; then

AC_MSG_CHECKING([if statfs structure has f_frsize element])
echo "#include <sys/types.h>" >tmpconf.h
if test $ac_cv_header_sys_vfs_h = yes ; then
  echo "#include <sys/vfs.h>" >>tmpconf.h
fi
if test $ac_cv_header_sys_statvfs_h = yes ; then
  echo "#include <sys/statvfs.h>" >>tmpconf.h
fi
AC_TRY_LINK([
  #include "tmpconf.h"
],[
  struct statfs *a;
  long b;
  b=(long)a->f_frsize;
],AC_DEFINE(STATFS_FRSIZE,,[Define if struct stat(v)fs has f_frsize element]) AC_MSG_RESULT(yes),AC_MSG_RESULT(no))
rm tmpconf.h

fi
])

dnl Check type of getmntent function

AC_DEFUN(AC_TYPE_GETMNTENT,[
if test $ac_cv_func_getmntent = yes ; then
AC_MSG_CHECKING([type of getmntent function])
echo "#include <stdio.h>" >tmpconf.h
if test $ac_cv_header_mntent_h = yes ; then
  echo "#include <mntent.h>" >>tmpconf.h
fi
if test $ac_cv_header_sys_mntent_h = yes ; then
  echo "#include <sys/mntent.h>" >>tmpconf.h
fi
if test $ac_cv_header_sys_mnttab_h = yes ; then
  echo "#include <sys/mnttab.h>" >>tmpconf.h
fi

AC_TRY_LINK([
  #include "tmpconf.h"
],[
  struct mntent *a;
  char *b;
  FILE *f;
  a=getmntent(f);
  b=a->mnt_fsname;
],AC_DEFINE(GETMNTENT_BSD,,[Define if getmntent is BSD-style]) AC_MSG_RESULT(BSD),
AC_TRY_LINK([
  #include "tmpconf.h"
],[
  struct mnttab *a;
  char *b;
  FILE *f;
  getmntent(f,a);
  b=a->mnt_special;
],AC_DEFINE(GETMNTENT_SOLARIS,,[Define if getmntent is Solaris-style]) AC_MSG_RESULT(Solaris),
AC_MSG_RESULT(unknown)
))

rm tmpconf.h
fi
])

dnl Following macro is ripped off from less-340
AC_DEFUN(AC_TYPE_REGEX,[
dnl Regular expressions (regcmp) are in -lgen on Solaris 2,
dnl and in -lintl on SCO Unix.
AC_CHECK_LIB(gen, regcmp)
AC_CHECK_LIB(intl, regcmp)
AC_CHECK_LIB(PW, regcmp)
dnl Checks for regular expression functions.
have_regex=no
have_posix_regex=unknown
AC_MSG_CHECKING(for regcomp)
dnl Some versions of Solaris have a regcomp() function, but it doesn't work!
dnl So we run a test program.  If we're cross-compiling, do it the old way.
AC_TRY_RUN([
#include <sys/types.h>
#include <regex.h>
main() { regex_t r; regmatch_t rm;
if (regcomp(&r, "abc", 0)) exit(1);
if (regexec(&r, "xabcy", 1, &rm, 0)) exit(1);
if (rm.rm_so != 1) exit(1); /* check for correct offset */
exit(0); }],
  have_posix_regex=yes, have_posix_regex=no, have_posix_regex=unknown)
if test $have_posix_regex = yes; then
  AC_MSG_RESULT(using POSIX regcomp)
  AC_DEFINE(HAVE_POSIX_REGCOMP,,[Define if you have POSIX regcomp])
  have_regex=yes
elif test $have_posix_regex = unknown; then
  AC_TRY_LINK([
#include <sys/types.h>
#include <regex.h>],
  [regex_t *r; regfree(r);],
  AC_MSG_RESULT(using POSIX regcomp)
  AC_DEFINE(HAVE_POSIX_REGCOMP,,[Define if you have POSIX regcomp]) have_regex=yes)
else
  AC_MSG_RESULT(no)
fi
if test $have_regex = no; then
AC_CHECK_FUNC(regcmp, 
AC_MSG_RESULT(using regcmp); AC_DEFINE(HAVE_REGCMP,,[Define if you have System V regcmp]) have_regex=yes)
fi
if test $have_regex = no; then
AC_TRY_LINK([
#include "regexp.h"], [regcomp("");],
AC_MSG_RESULT(using V8 regcomp); AC_DEFINE(HAVE_V8_REGCOMP,,[Define if you have the Henry Spencer V8 regcomp and regexp.h]) have_regex=yes)
fi
if test $have_regex = no && test -f ${srcdir}/regex.c; then
AC_MSG_RESULT(using POSIX regcomp -- local source); AC_DEFINE(HAVE_POSIX_REGCOMP,,[Define if you have POSIX regcomp]) REGEX_O='regex.$(O)' AC_SUBST(REGEX_O) have_regex=yes
fi
if test $have_regex = no && test -f ${srcdir}/regexp.c; then
AC_MSG_RESULT(using V8 regcomp -- local source); AC_DEFINE(HAVE_V8_REGCOMP,,[Define if you have the Henry Spencer V8 regcomp and regexp.h]) AC_DEFINE(HAVE_REGEXEC2,,[regexec2]) REGEX_O='regexp.$(O)' AC_SUBST(REGEX_O) have_regex=yes
fi
if test $have_regex = no; then
AC_MSG_RESULT(using re_comp); AC_CHECK_FUNC(re_comp, AC_DEFINE(HAVE_RE_COMP,,[Define if you have BSD re_comp]) have_regex=yes)
fi
if test $have_regex = no; then
AC_MSG_RESULT(cannot find regular expression library); AC_DEFINE(NO_REGEX,,[Define if you don't have regex])
fi
])
