/* xstack.h -- prototypes and #defines for the stuff in stack.c. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#ifndef _GIT_XSTACK_H
#define _GIT_XSTACK_H


#include "stdc.h"


typedef struct
{
    void *data;         /* the stack data.  */
    int esize;          /* # of bytes in a stack element.  */
    int point;          /* # of elements in the stack.  */
} xstack_t;


xstack_t *xstack_init __P((int));
void      xstack_end  __P((xstack_t *));

void  xstack_push     __P((xstack_t *, void *));
void *xstack_pop      __P((xstack_t *, void *));
void *xstack_preview  __P((xstack_t *, void *, int));
void  xstack_truncate __P((xstack_t *, int));
int   xstack_point    __P((xstack_t *));


#endif  /* _GIT_XSTACK_H */
