/*****************************************************************

		GC3 KEYSTROKE MANAGER

 The code in this file is responsible for:

	* maintaining key bindings
	* reading keystrokes from the keyboard
	* command line editing and recall
	* keystroke macros

 (c) 1993 by Graham Wheeler

****************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "gc3.h"
#include "gckey.h"

#ifdef DEBUG
extern FILE		*debug;
#endif

static char cmdHist[HIST_LEN][256];
static int histNum = 0, histNow = 0;

#if __MSDOS__
#include <conio.h> /* for putch in BEEP, and clrscr */

static int keycodeTbl[MAX_KEYS] = {
	/* Cursor keys */
	KEY_UP, KEY_DOWN, KEY_LEFT, KEY_RIGHT,
	KEY_PGUP, KEY_PGDN, KEY_HOME, KEY_END,
	KEY_CTRL_LEFT, KEY_CTRL_RIGHT, 0, 0,
	KEY_CTRL_PGUP, KEY_CTRL_PGDN, KEY_CTRL_HOME, KEY_CTRL_END,
	KEY_INS, KEY_DEL, KEY_BACKSPC,
	/* #19 */
	0,
	/* Function Keys 20-29 */
	KEY_F1, KEY_F2, KEY_F3, KEY_F4, KEY_F5,
	KEY_F6, KEY_F7, KEY_F8, KEY_F9, KEY_F0,
	/* Ctrl-Keys 30-55 */
	1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13,
	14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
	/* #56-#59 */
	0, 0, 0, 0,
	/* Meta-0 .. Meta-9 */
	KEY_ALT_0, KEY_ALT_1, KEY_ALT_2, KEY_ALT_3, KEY_ALT_4,
	KEY_ALT_5, KEY_ALT_6, KEY_ALT_7, KEY_ALT_8, KEY_ALT_9,
	/* Meta-A .. Meta-Z 70-95 */
	KEY_ALT_A, KEY_ALT_B, KEY_ALT_C, KEY_ALT_D, KEY_ALT_E,
	KEY_ALT_F, KEY_ALT_G, KEY_ALT_H, KEY_ALT_I, KEY_ALT_J,
	KEY_ALT_K, KEY_ALT_L, KEY_ALT_M, KEY_ALT_N, KEY_ALT_O,
	KEY_ALT_P, KEY_ALT_Q, KEY_ALT_R, KEY_ALT_S, KEY_ALT_T,
	KEY_ALT_U, KEY_ALT_V, KEY_ALT_W, KEY_ALT_X, KEY_ALT_Y,
	KEY_ALT_Z,
	/* #96 - #99 */
	0, 0, 0, 0,
	/* Printable ASCII */
	        32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
	90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
	100,101,102,103,104,105,106,107,108,109,
	110,111,112,113,114,115,116,117,118,119,
	120,121,122,123,124,125,126,
	/* #195..#239 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 
	/* Command line edit keys */
	KEY_CTRL_HOME,
	KEY_HOME, KEY_END, KEY_LEFT, KEY_RIGHT,
	KEY_DEL, KEY_BACKSPC, KEY_INS, 27,
	KEY_ALT_L, KEY_ALT_R, 
	KEY_ALT_P, KEY_ALT_N,
	KEY_CTRL_LEFT, KEY_CTRL_RIGHT,
	KEY_CTRL_PGUP, KEY_CTRL_PGDN
};

#else

static int keycodeTbl[MAX_KEYS] = {
	/* Cursor keys */
	KEY_UP, KEY_DOWN, KEY_LEFT, KEY_RIGHT,
	KEY_PPAGE, KEY_NPAGE, KEY_HOME, KEY_END,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, '\b',
	/* #19 */
	0,
	/* Function Keys 20-29 */
	KEY_F1, KEY_F2, KEY_F3, KEY_F4, KEY_F5,
	KEY_F6, KEY_F7, KEY_F8, KEY_F9, KEY_F0,
	/* Ctrl-Keys 30-55 */
	1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13,
	14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
	/* #56-#59 */
	0, 0, 0, 0,
	/* Meta-0 .. Meta-9 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	/* Meta-A .. Meta-Z 70-95 */
	0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0,
	/* #96 - #99 */
	0, 0, 0, 0,
	/* Printable ASCII */
	        32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
	90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
	100,101,102,103,104,105,106,107,108,109,
	110,111,112,113,114,115,116,117,118,119,
	120,121,122,123,124,125,126,
	/* #195..#239 */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0,
	/* Command line edit keys */
	0, KEY_HOME, KEY_END, KEY_LEFT, KEY_RIGHT,
	0, '\b', 0, 27,
	0, 0, 
	0, 0,
	0, 0,
	0, 0
};

#endif

keydef_t KeyTbl[MAX_KEYS];

#if	__STDC__
void clearKeyTable(void) {
#else
void clearKeyTable() {
#endif
	int i;
	for (i=0;i<MAX_KEYS;i++) KeyTbl[i].ip = 0;
}

/**********************************************************
	KEYSTROKE MACROS...
***********************************************************/

static short
	Record=0,
	PlayBack=0,
	MacNum=0,
	MacPos=0,
	MacLen[NUMMACROS]={0};
static int
	Macros[NUMMACROS][MACROLEN];

#ifdef __STDC__
void endRecord(void) {
#else
void endRecord() {
#endif
	if (Record) {
		Record=0;
		MacLen[MacNum]=MacPos-1;
     		showMsg("Recording complete");
	}
}

#ifdef __STDC__
void recordMacro(short MNum) {
#else
void recordMacro(MNum) 
	short MNum;
{
#endif
	int cnf;
	if (Record) endRecord();
	else if (PlayBack)
		showMsg("Cannot record macro while playing back");
	else if (MNum < 0 || MNum >= NUMMACROS)
		showMsg("Illegal macro number");
	else {
		if (MacLen[MNum]) {
			clearCmdWin();
			showMsg("Overwrite existing macro y/n?");
			BEEP;
			cnf = readKey();
		} else cnf='Y';
		if (cnf=='Y' || cnf=='y') {
			Record=1;
			MacPos=0;
			MacLen[MNum]=0;
			MacNum=MNum;
			showMsg("Recording macro");
		} else {
			Record=0;
			clearCmdWin();
		}
	}
}

#ifdef __STDC__
void playMacro(short MNum) {
#else
void playMacro(MNum)
	short MNum;
{
#endif
	if (Record) showMsg("Cannot play a macro while already recording");
	else if (PlayBack) showMsg("Can play a macro while already playing");
	else if (MNum < 0 || MNum >=NUMMACROS)
		showMsg("Invalid macro number - cannot play back");
	else {
		PlayBack = 1;
		MacNum = MNum;
		MacPos = 0;
	}
}

#if __STDC__
int my_getch(void) {
#else
int my_getch() {
#endif
	int rtn;
	if (PlayBack) {
		rtn = Macros[MacNum][MacPos++];
		if (MacPos>=MacLen[MacNum]) PlayBack=0;
	} else rtn=readKey();
	if (Record) {
		if (MacPos>=MACROLEN) {
			showMsg("Macro length exceeded");
			Record=0;
			MacLen[MacNum]=MACROLEN;
		} else Macros[MacNum][MacPos++] = rtn;
	}
	return rtn;
}

#ifdef __STDC__
static int execKey(int i) {
#else
static int execKey(i)
	int i;
{
#endif
	if (i<8) {
		switch(i) {
		case 0: cursorUp();	break;
		case 1: cursorDown();	break;
		case 2: l=0; cd2old();	break;
		case 3: l=1; cd2old();	break;
		case 4: cursorPgUp();	break;
		case 5: cursorPgDn();	break;
		case 6: cursorHome();	break;
		case 7: cursorEnd();	break;
		}
	/* Yes, a user-defined function */
	} else if (KeyTbl[i].ip) {
		if (execute(KeyTbl[i].ip,0)) return 999; /* quit */
	}
	return i;
}

/************************************************************
	 COMMAND LINE EDITING....
*************************************************************/

#define CED_INSFNAME	239
#define CED_HOME	240
#define CED_END		241
#define CED_LEFT	242
#define CED_RIGHT	243
#define CED_DEL		244
#define CED_BKSPC	245
#define CED_MODE	246
#define CED_CLEAR	247
#define CED_DELLEFT	248
#define CED_DELRIGHT	249
#define CED_DELLWORD	250
#define CED_DELRWORD	251
#define CED_LWORD	252
#define CED_RWORD	253
#define CED_PREV	254
#define CED_NEXT	255

#if __STDC__
char *getPrevCmd(void) {
#else
char *getPrevCmd() {
#endif
	if (histNum) {
		histNow--;
		if (histNow<0) histNow = histNum-1;
		return cmdHist[histNow];
	}
	return NULL;
}

#if __STDC__
char *getNextCmd(void) {
#else
char *getNextCmd() {
#endif
	if (histNum) {
		histNow++;
		if (histNow >= histNum) histNow = 0;
		return cmdHist[histNow];
	}
	return NULL;
}

#if __STDC__
int EditString(int c, char *start, char **end, char **now,
			int *insmode, int maxlen) {
#else
int EditString(c, start, end, now, insmode, maxlen)
	int c;
	char *start, **end, **now;
	int *insmode, maxlen;
{
#endif
	char *tptr;
	int chList[80], chN=1, i;
#ifdef DEBUG
	fprintf(debug,"In EditString(%X, %s, ..., %d), histNum = %d\n",
				c,start,maxlen,histNum);
#endif
	if (c==keycodeTbl[CED_INSFNAME]) { /* Insert file name */
		int buf = getBuffer(300);
		char *n = lookupVar(0,buf);
#ifdef DEBUG
		fprintf(debug,"-> file name insert\n");
#endif
		chList[0] = ' ';
		while ((chList[chN++] = (int)(*n++)) != (int)'\0');
		chList[chN-1] = ' ';
		chList[chN] = '0';
		releaseBuffer(buf,100);
	} else chList[0] = c;
	for (i=0;i<chN;i++) {
		c = chList[i];
		if (c==keycodeTbl[CED_CLEAR]) { /* clear line */
#ifdef DEBUG
			fprintf(debug,"-> clear line\n");
#endif
			if (*start) {
				*now=*end=start;
				*start=0;
			} else {
				clearCmdWin();
				return 1;
			}
		} else if (c==keycodeTbl[CED_BKSPC]) { /* backspace */
#ifdef DEBUG
			fprintf(debug,"-> backspace\n");
#endif
			if ((tptr=*now-1) >= start) {
				tptr=*now-1;
				while (tptr<*end) {
					*tptr = *(tptr+1);
					tptr++;
				}
				(*now)--; (*end)--;
			}
		} else if (c==keycodeTbl[CED_DEL]) { /* DEL */
#ifdef DEBUG
			fprintf(debug,"-> Delete\n");
#endif
			if (*now < *end) { /* Delete under cursor */
				tptr=*now;
				while (tptr<*end) {
					*tptr = *(tptr+1);
					tptr++;
				}
				(*end)--;
				if (*now > *end) *now=*end;
	      		}
		} else if (c==keycodeTbl[CED_MODE]) { /* Toggle insert mode */
#ifdef DEBUG
			fprintf(debug,"-> toggle mode\n");
#endif
			*insmode = (1 - *insmode);
		} else if (c==keycodeTbl[CED_RIGHT]) { /* right */
#ifdef DEBUG
			fprintf(debug,"-> move right\n");
#endif
			if (*now<*end) (*now)++;
		} else if (c==keycodeTbl[CED_LEFT]) { /* left */
#ifdef DEBUG
			fprintf(debug,"-> move left\n");
#endif
			if (*now>start) (*now)--;
		} else if (c==keycodeTbl[CED_LWORD]) { /* word left */
			int f= 0;
#ifdef DEBUG
			fprintf(debug,"-> move word left\n");
#endif
			if (*now>start) (*now)--;
			while (*now>start && isspace((int)**now)) (*now)--;
			while (*now>=start && !isspace((int)**now)) {
				(*now)--;
				f=1;
			}
			if (f) (*now)++;
		} else if (c==keycodeTbl[CED_RWORD]) { /* word right */
#ifdef DEBUG
			fprintf(debug,"-> move word right\n");
#endif
			while (*now<*end && !isspace((int)**now)) (*now)++;
			while (*now<*end && isspace((int)**now)) (*now)++;
		} else if (c==keycodeTbl[CED_HOME]) {
			*now = start; /* home */
#ifdef DEBUG
			fprintf(debug,"-> move home\n");
#endif
		} else if (c==keycodeTbl[CED_END]) {
			*now = *end; /* end */
#ifdef DEBUG
			fprintf(debug,"-> move to end\n");
#endif
		} else if (histNum && c==keycodeTbl[CED_PREV]) {
			char *tmp = getPrevCmd();
#ifdef DEBUG
			fprintf(debug,"-> get previous command\n");
#endif
			if (tmp) {
				strncpy(start,tmp,(unsigned)maxlen);
				*end = *now = start + strlen(start);
			} else BEEP;
		} else if (histNum && c==keycodeTbl[CED_NEXT]) { 
			char *tmp = getNextCmd();
#ifdef DEBUG
			fprintf(debug,"-> get next command\n");
#endif
			if (tmp) {
				strncpy(start,tmp,(unsigned)maxlen);
				*end = *now = start + strlen(start);
			} else BEEP;
		} else if (c==keycodeTbl[CED_DELLEFT]) { /* */
			int i = 0;
#ifdef DEBUG
			fprintf(debug,"-> delete left\n");
#endif
			while ((start[i++] = *((*now)++))!='\0');
			*now = start;
			*end = start+i-1;
		} else if (c==keycodeTbl[CED_DELRIGHT]) { /* */
#ifdef DEBUG
			fprintf(debug,"-> delete right\n");
#endif
			*end = *now;
			*(*end) = '\0';
		} else if (c==keycodeTbl[CED_DELLWORD]) { /* */
			char *rst = *now, *t1;
#ifdef DEBUG
			fprintf(debug,"-> delete word left\n");
#endif
			if (rst>start) rst--;
			while (rst>start && isspace((int)*rst)) rst--;
			while (rst>start && !isspace((int)*rst)) rst--;
			t1 = *now; *now = rst;
			while ((*rst++ = *t1++)!='\0');
			*end = rst-1;
		} else if (c==keycodeTbl[CED_DELRWORD]) { /* */
			char *rst = *now, *t1;
#ifdef DEBUG
			fprintf(debug,"-> delete word right\n");
#endif
			while (*rst && isspace((int)*rst)) rst++;
			while (*rst && !isspace((int)*rst)) rst++;
			while (*rst && isspace((int)*rst)) rst++;
			t1 = *now;
			while ((*t1++ = *rst++)!='\0');
			*end = t1-1;
		} else if (c>=0 && c<128 && isprint(c&0xFF)) {
			if (*insmode || (chN>1) || (*now >= *end)) {
				/* If inserting, shift line to make space */
				if ((*end-start)<maxlen) {
					tptr = ++(*end);
					while (tptr>*now) {
						*tptr = *(tptr-1);
						tptr--;
					}
				} else BEEP;
			}
			/* Put the character in at the appropriate position */
#ifdef DEBUG
			fprintf(debug,"-> Inserting character %c (%X)\n",(char)c,c);
#endif
			*((*now)++) = (char)c;
			*(*end)=0;
			if ((*end-start)>=maxlen) return 1;
		} else {
			if ((i = getKeyBinding(c,0))>=0) {
				if (i>8 && KeyTbl[i].ip) {
#ifdef DEBUG
					fprintf(debug,"-> Got bound key\n");
#endif
					*now=*end=start;
					*start=0;
					escapeCh = c;
				} else	{
					int old_l = l;
#ifdef DEBUG
					fprintf(debug,"-> got primitive key\n");
#endif
					execKey(i);
					if (l == old_l) return 0;
				}
				return i;
			} else	{
#ifdef DEBUG
				fprintf(debug,"-> got unbound key\n");
#endif
			}
		}
	}
	return 0;
}

#if __STDC__
void saveHist(char *b) {
#else
void saveHist(b)
	char *b;
{
#endif
	/* Put line in the history ring */
	if (histNum<HIST_LEN) histNow = histNum++;
	strcpy(cmdHist[histNow],b);
	histNow = (histNow+1)%HIST_LEN;
}

/***********************************************************
	CHANGE KEY BINDINGS, LOOK UP A KEY BINDING...
************************************************************/

#ifdef __STDC__
void setKeycode(short key, int code) {
#else
void setKeycode(key, code)
	short key;
	int code;
{
#endif
	keycodeTbl[key] = code;
}

#if __STDC__
int getKeyBinding(int ch, int doIt) {
#else
int getKeyBinding(ch, doIt)
	int ch, doIt;
{
#endif
	int i;
	/* Check user bindings */
	for (i=NUM_PRIM_KEYS;i<START_ESC_KEYS;i++) 
	        if (keycodeTbl[i]==ch && KeyTbl[i].ip!=0)
			goto gotIt;
	if (metaMode==1 || metaKey == 27) {
		for (;i<START_CED_KEYS;i++) 
		        if (keycodeTbl[i]==ch && KeyTbl[i].ip!=0)
				goto gotIt;
	} else if (metaMode>1) {
		/* Check meta keys */
		if (isupper(ch)) i = 70+ch-(int)'A';
		else if (islower(ch)) i = 70+ch-(int)'a';
		else if (isdigit(ch)) i = 60+ch-(int)'0';
		else goto chkPrim;
		goto gotIt;
	}
chkPrim:
	/* Check primitives */
	for (i=0;i<NUM_PRIM_KEYS;i++) 
	        if (keycodeTbl[i]==ch) goto gotIt;
	i = -1;
gotIt:
	metaMode = 0;
 	if (i!=-1 && doIt) return execKey(i);
	return i;
}

