/* tools.c: PnP config tool main module */
/*
 * $Header: /root/pnp/tools/RCS/tools.h,v 1.1 1996/06/24 23:31:22 root Exp $
 *
 * $Log: tools.h,v $
 * Revision 1.1  1996/06/24  23:31:22  root
 * Initial revision
 *
 *
 */

/*
 * (c) Copyright 1996  D.W.Howells <dwh@nexor.co.uk>,
 */

#ifndef _TOOLS_H_
#define _TOOLS_H_

#include <stdio.h>
#include <ncurses/curses.h>
#include "../module/pnp.h"

struct pnp_dev {
    struct pnp_dev *pd_next;
    char	*pd_ident;
    char	*pd_desc;
    char	*pd_irq[2];
    char	*pd_dma[2];
    char	*pd_io[8];
    char	*pd_mem[4];
};

extern struct pnp_dev *dev_list;

struct pnp_index {
    char	pi_interface[6];
    int		pi_csn;
    int		pi_dev;
    char	pi_ident[8];
    char	pi_driver[9];
    char	pi_data[51];
    struct pnp_dev *pi_device;
    pnpioctl	pi_ioc;
};

extern int pnpconf;
extern WINDOW *topwin, *listwin, *vworkwin, *workwin, *barwin, *vconfwin,
*confwin, *extrawin;
extern struct pnp_index *index_list[];
extern int index_count, index_current;

extern int read_devicelist(void);
extern void draw_device_list(void);
extern int down_device_list(void);
extern int up_device_list(void);

extern void info_display(void);
extern void configure_device(void);

extern int pnp_read_index(void);

extern void popup(const char *, const char *, const char *);

#endif _TOOLS_H_
