#include <stdio.h>
#include <linux/sched.h>

main(int argc, char *argv[])
	{

	int tmp;
	struct timeval interval;
	static struct sched_param param;
	
#ifndef RTRUN
	if ((tmp = sched_get_priority_max(SCHED_FIFO)) == -1)	{
		perror("sched_get_priority_max fails");
	}
	else	{
		fprintf(stderr,"sched_get_priority_max = %d.\n", tmp);
	}

	if ((tmp = sched_get_priority_min(SCHED_FIFO)) == -1)	{
		perror("sched_get_priority_min fails");
	}
	else	{
		fprintf(stderr,"sched_get_priority_min = %d.\n", tmp);
	}

	param.sched_priority = tmp;


	if ((tmp = sched_rr_get_interval(getpid(), &interval)) == -1)	{
		perror("sched_get_rr_interval fails");
	}
	else	{
		fprintf(stderr,"sched_get_rr_interval = %d, %d.\n", interval.tv_sec, interval.tv_usec);
	}
#endif /* RTRUN */

#ifdef DEBUG
	fprintf(stderr,"sched_setscheduler to RT (0x%x) ...\n", &param);
#endif /* DEBUG */

#ifdef RTRUN
	if ((argc < 3) || (sscanf(argv[1], "%d", &param.sched_priority) != 1))	{
		fprintf(stderr,"Usage: rtrun pri program args ...\n");
		exit(0);
	}
#endif
	if ((tmp = sched_setscheduler(getpid(), SCHED_FIFO, &param)) == -1)	{
		perror("sched_setscheduler fails");
	}

#ifdef RTRUN
	fprintf(stderr, "%s\n", argv[2]);
	if (!execvp(argv[2], &argv[2]))	{
		perror("rtrun exec fails");
		exit(-1);
	}
#else /*  RTRUN */

	if ((tmp = sched_getscheduler(getpid())) == -1)	{
		perror("sched_get_rr_interval fails");
	}
	else	{
		fprintf(stderr,"sched_getscheduler = %d.\n", tmp);
	}

	fprintf(stderr,"sched_setscheduler to TS...\n");

	if ((tmp = sched_setscheduler(getpid(), SCHED_TS, &param)) == -1)	{
		perror("sched_setscheduler fails");
	}
#endif
}
