/*
 * beepd
 *
 * Author: Erik Gilling, konkers@prairienet.org
 * Copywright 1996 Erik Gilling
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#include <stdio.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>

void usage( void );
int daemonize ( void );
void sig_handler( int sig );
void loadsnd( void );
void playsnd( void );

#define WRITE_CHUNK_SIZE 100

int conf_buffered = 0;
char *sndbuf;
char *tmpsndbuf;
char *sndfile = 0;
int sndsize;
int sndfd;
int aufd = -1;
int sndplaying = 0;
int sndoffset;
int gDone = 0;

main( int argc, char *argv[] )
{
    
    int i;
    int numdes;
    fd_set readfds, rfds;
    struct timeval notime;
    int beepfd;
    int theErr;
    char tmpbuf[20];
    
    if( argc < 2 )
    {
	usage();
	return -1;
    }
    
    argv++; argc--;
    while( argc )
    {
	if( ! strcmp( *argv, "-b") )
	{
	    conf_buffered = 1;
	    argv++; argc--;
	    continue;
	}
	
	if( ! strcmp( *argv, "-f") )
	{
	   argv++; argc--;
	   if( argc == 0 )
	   {
	       usage();
	       return -1;
	   }
	   sndfile = *argv++; argc--;
	   continue;
	}

	if( argc > 0 )
	{
	    usage();
	    return -1;
	}
    }
    if( ! sndfile )
    {
	usage();
	exit (-1);
    }

    if( daemonize() < 0 )
    {
	syslog( LOG_INFO, "daemonize failed");
    }
    
    loadsnd();
    
    if( ! conf_buffered )
    {
	tmpsndbuf = (char *) malloc( 1000 );
    }
    
    if( (beepfd = open( "/dev/beep", O_RDONLY ) ) < 0 )
    {
	syslog( LOG_INFO, "Cant open /dev/beep" );
	exit( -1 );
    }
    
    FD_ZERO( &readfds );
    FD_SET( beepfd, &readfds );
    while( ! gDone )
    {
	
	rfds = readfds;
	
	if( sndplaying )
	{
	    notime.tv_sec = 0;
	    notime.tv_usec = 0;
	}
	else
	{
	    notime.tv_sec = 10;
	    notime.tv_usec = 0;
	}
	
	numdes = select( 100, &rfds, NULL, NULL, &notime );
	
	if( (numdes > 0 ) && FD_ISSET( beepfd, &rfds ) )
	{
	    read( beepfd, tmpbuf, (sizeof(int) * 2) );
	    sndoffset = 0;
	    if( ! conf_buffered )
	    {
		lseek( sndfd, 0 , SEEK_SET );
	    }
	    sndplaying = 1;
	    if( aufd < 0 )
	    {
		if( (aufd = open( "/dev/audio", O_WRONLY ) ) < 0 )
		{
		    syslog( LOG_INFO, "Cant open /dev/audio" );
		    sndplaying = 0;
		}
	    }
	
	}

	if( sndplaying )
	{
	    playsnd();
	}
    }

}

void playsnd( void )
{
    int readamt;
    
    if( (readamt = sndsize - sndoffset ) >= WRITE_CHUNK_SIZE )
	readamt = WRITE_CHUNK_SIZE;

    if( conf_buffered )
    {
	tmpsndbuf = sndbuf + sndoffset;
	
    }
    else
    {
	readamt = read( sndfd, tmpsndbuf, readamt );
    }

    if( write( aufd, tmpsndbuf, readamt ) != readamt )
    {
	syslog( LOG_INFO, "write problem" );
    }
    sndoffset += readamt;
    if( readamt < WRITE_CHUNK_SIZE )
    {
	sndplaying = 0;
	close(aufd);
	aufd = -1;
    }
    
    closelog();

}

void loadsnd( void )
{
    struct stat sndstat;

    if( ( sndfd = open( sndfile, O_RDONLY ) ) < 0 )
    {
	syslog( LOG_INFO, "Cant open sndfile" );
	exit( -1 );
    }
    
    if( fstat( sndfd, &sndstat )  < 0 )
    {
	syslog( LOG_INFO, "Cant fstat sndfile" );
	exit( -1 );
    }

    sndsize = sndstat.st_size;

    if( conf_buffered )
    {
	sndbuf = (char *) malloc( sndsize );
	read( sndfd, sndbuf, sndsize );
	close( sndfd );
    }
    else
    {
	lseek( sndfd, 0 , SEEK_SET );
    }
}

int daemonize ( void )
{

    openlog( "beepd", LOG_PID, LOG_DAEMON);
    
    signal(SIGHUP, SIG_IGN);
    signal(SIGINT, SIG_IGN);
    signal(SIGQUIT, SIG_IGN);
    signal(SIGTSTP, SIG_DFL);
    signal(SIGTTOU, SIG_DFL);
    signal(SIGTTIN, SIG_DFL);

    setpgrp();
    
    switch( fork() )
    {
	case -1:
	    printf("error: fork");
	    return -1;
	
	case 0:
	    break;

	default:
	    exit( 0 );
    }
    
    close( 0 );
    close( 1 );

    switch( fork() )
    {
	case -1:
	    printf("error: fork");
	    return -1;
	
	case 0:
	    break;

	default:
	    exit( 0 );
    }



    signal(SIGHUP, SIG_IGN);
    signal(SIGINT, SIG_IGN);
    signal(SIGQUIT, SIG_IGN);
    signal(SIGPIPE, SIG_IGN);         /* Broken pipe */


    signal(SIGTSTP, SIG_DFL);
    signal(SIGCONT, SIG_DFL);
    signal(SIGTTOU, SIG_DFL);
    signal(SIGTTIN, SIG_DFL);
    

    signal(SIGTERM, sig_handler);
    signal(SIGSEGV, sig_handler);     /* Segmentation fault */
    signal(SIGBUS,  sig_handler);     /* Bus error */
    
    

    return 0;
}

void usage( void )
{
    printf( "Usage:  beepd [-b] -f <au file>\n\tb: load au file into memory\n\tf: file to load\nversion 0.0.1\n");
}

void sig_handler( int sig )
{
    switch( sig )
    {
	case SIGTERM:
	    syslog( LOG_INFO, "sigterm");
	    gDone = 1;
	    return;
	    
	case SIGSEGV:
	    syslog( LOG_INFO, "segv");
	    exit( -20 );
	    break;
	    
	default:
	    exit( 1 );
    }
}
