/*
(C) 1998 Patrick Lambert <drow@fastethernet.net>

This program is free software. You can use, distribute and modify it if
you let this legal note in all future versions, and if the program made
stays under free software. (see sscript.doc)

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

Latest version of Socket Script is always available from
http://devplanet.fastethernet.net/sscript.html
*/

#define VERSION 114
#include "sscript.h"

#ifdef RAWLINUX
#include <linux/kernel.h>
#include <linux/sys.h>
#endif

#ifdef USE_DES
#include <des.h>
#endif

#ifdef PASSWORD
#include <termios.h>
#endif

#include <syslog.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/ioctl.h>

#ifdef DEV_STAT
#include <net/if.h>
#endif

#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/file.h>

#ifdef POSIX
#include <pwd.h>
#include <sys/utsname.h>
#endif

#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include <math.h>

#ifndef FNDELAY
#define FNDELAY O_NONBLOCK
#endif

#ifndef IPPROTO_IP
#define IPPROTO_IP 0
#endif

/* signal handling */
void handle_segv()
{
 char templog[512];
 sprintf(templog,"[%ld] Segmentation fault while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: Segmentation fault. I suggest you check your script for any typos.\ncurrently processing=%s",temp);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Erreur de protection de memoire. Vous devriez verifier votre script pour des erreurs possibles.\ncurrently processing=%s",temp);
 else if(lang==2)
 sprintf(templog,"Error Interno: Falla en Segmentacin. Sugiero que cheques tu script para ver si no hay errores en ortografa.\ncurrently processing=%s",temp);
 if(!set_signals_off) {
  msgbox("error",templog,strlen(templog)); }
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: Segmentation fault. I suggest you check your script for any typos. If the problem is an internal bug, please contact the author.\nerrno=%d\ncurrently processing=%s\npid=%d\n",errno,temp,pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Erreur de protection de memoire. Vous devriez verifier votre script pour des erreurs possibles.\nerrno=%d\ncurrently processing=%s\npid=%d\n",errno,temp,pid);
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: Falla en Segmentacin. Sugiero que cheques tu script para ver si no hay errores en ortografa.errno=%d\ncurrently processing=%s\npid=%d\n",errno,temp,pid);
 }
#endif
 if(strcasecmp(cron,"")) system(cron);
 exit(1);
}

void handle_hup()
{
 char templog[512];
 sprintf(templog,"[%ld] Hangup while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: Hangup. Someone kill'ed -HUP this program... [pid=%d]",pid);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Hangup. Quelqu'un a tuer votre script...");
 else if(lang==2)
 sprintf(templog,"Error Interno: Hangup.");
 if(!set_signals_off) { 
  msgbox("error",templog,strlen(templog)); }
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: Hangup. Someone kill'ed -HUP this program... [pid=%d]\n",pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Hangup. Quelqu'un a tuer votre script...\n");
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: Hangup.\n");
 }
#endif
 if(strcasecmp(cron,"")) system(cron);
 exit(1);
}

void handle_int()
{
 char templog[512];
 sprintf(templog,"[%ld] Interrupt while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: Interrupt. Exiting... [pid=%d]",pid);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Interrupt. Sort... [pid=%d]",pid);
 else if(lang==2)
 sprintf(templog,"Error Interno: Interrupcin. Saliendo... [pid=%d]",pid);
 if(!set_signals_off) msgbox("error",templog,strlen(templog));
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: Interrupt. Exiting... [pid=%d]\n",pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Interrupt. Sort... [pid=%d]\n",pid);
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: Interrupcin. Saliendo... [pid=%d]\n",pid);
 }
#endif
 if(strcasecmp(cron,"")) system(cron);
 exit(1);
}

void handle_pipe()
{
 char templog[512];
 sprintf(templog,"[%ld] Broken pipe while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: Broken pipe. I tried to write when the connection was off [pid=%d]",pid);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Connection ferme. J'ai essaye d'ecrire quand la connection etait ferme.");
 else if(lang==2)
 sprintf(templog,"Error Interno: Pipa rota. Trat de escribir cuando la conexion estaba");
 if(!set_signals_off) { 
  msgbox("error",templog,strlen(templog)); }
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: Broken pipe. I tried to write when the connection wasn't established [pid=%d].\n",pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Connection ferme. J'ai essaye d'ecrire quand la connection etait ferme.\n");
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: Pipa rota. Trat de escribir cuando la conexion estaba\n");
 }
#endif
 if(strcasecmp(cron,"")) system(cron);
 exit(1);
}

void handle_io()
{
 char templog[512];
 sprintf(templog,"[%ld] I/O error while processing [%s] [pid=%d]\n",time(NULL),temp,pid);
 appendlog(templog);
#ifdef GUI
 if(lang==0)
 sprintf(templog,"Internal error: I/O error [pid=%d]",pid);
 else if(lang==1)
 sprintf(templog,"Erreur interne: Erreur d'E/S [pid=%d]",pid);
 else if(lang==2)
 sprintf(templog,"Error Interno: I/O error [pid=%d]",pid);
 if(!set_signals_off) { 
 msgbox("error",templog,NULL,0); }
#else
 if(lang==0)
 {
 if(!set_signals_off) printf("*** Internal error: I/O error [pid=%d].\n",pid);
 }
 else if(lang==1)
 {
 if(!set_signals_off) printf("*** Erreur interne: Erreur d'E/S [pid=%d]\n",pid);
 }
 else if(lang==2)
 {
 if(!set_signals_off) printf("*** Error Interno: I/O error [pid=%d]\n",pid);
 }
#endif
 if(strcasecmp(cron,"")) system(cron);
 exit(1);
}

char *info(int i)
{
#ifdef RAWLINUX
 char data[255];
 struct sysinfo s_info;
 sysinfo(&s_info);
 sprintf(data,"%ld %ld %ld %ld %ld %ld %ld %ld %ld %ld %ld",s_info.uptime,s_info.loads[0],s_info.loads[1],s_info.loads[2],s_info.totalram,s_info.freeram,s_info.sharedram,s_info.bufferram,s_info.totalswap,s_info.freeswap,s_info.procs);
 strcpy(global_var,data); /* to avoid return of local var warning */
 return (char *)global_var;
#endif
} 

char *lindex(char *input_string, int word_number)
{
 char *tokens[1024];
 static char tmpstring[1024];
 int i;
 strncpy(tmpstring,input_string,1024);
 tokens[i=0] = strtok(tmpstring, " ");
 while ((tokens[++i] = strtok(NULL, " ")));
 tokens[i] = NULL;
 return(tokens[word_number]);
}

int main(int argc, char *argv[])
{
 /* necessary variables that don't need to be global */
 int j,sockfd=0,len,port,debug,res,lenght,i,chop,loop=1,userhost=0;
 int temp3,listen_len,sockfd2,result,server_oriented=0,is_a_service=0;
 int pain_in_the=0,reversechop=0,current_for,max_for,min_for,strictwrite=0;
 int goto_on=0,strictcheck=0,from_len,othersck,rsck=0,tracing=0;
 int windows=0, cnt, opt=1, inputchop=0, timer_var=-1, moda;
 long timer=0;
 char server[50],buf[1024],inchar;
 char master[255]="",virtual[50],inall[1024],temp2[255],matching[1024];
 char nick[255],user[255],temp4[512],filename[255],subnumber[255];
 char remote_ip[50]="", include_files[4][255], setremoteecho=0;
 char in[1024][512];               /* our 1024 variables */
 struct sockaddr_in address;       /* client socket */
 struct sockaddr_in listen_addr;   /* server socket */
 struct sockaddr_in la;            /* virtual binding */
 struct sockaddr_in from_addr;     /* resolver */
 struct sockaddr_in other_addr;    /* various connets */
 struct sockaddr_in r_addr;        /* remote connect */
 struct stat stat_buf;             /* file stats */
#ifdef POSIX
 struct utsname unamebuf;  /* this doesn't work on non-posix systems */
#endif
#ifdef USE_MOD
 FILE *modb;
#endif
 time_t lt;
 FILE *fp, *fpa, *fpb, *fpaccess;
 /* end of vars declarations - starting initializing them */
 set_signals_off=0;
 pid=0;
 continous=0;
 lasterror=0;
#ifdef USE_SOCKS
 SOCKSinit(argv[0]);
#endif
 pid = getpid(); /* for client-side scripts */
 /* for the include command */
 for(i=0;i<4;i++) { strcpy(include_files[i],""); }
 strcpy(cron,"");
 strcpy(logfilename,LOGFILE);
 /* env variable temp_dir */
 strcpy(TMP_DIR,TEMP_DIR);
 if(getenv("TMP_DIR")!=NULL && strcasecmp(getenv("TMP_DIR"),"") && strlen(getenv("TMP_DIR"))<50)
 strcpy(TMP_DIR,getenv("TMP_DIR"));
 if(getenv("TEMP_DIR")!=NULL && strcasecmp(getenv("TEMP_DIR"),"") && strlen(getenv("TEMP_DIR"))<50)
 strcpy(TMP_DIR,getenv("TEMP_DIR"));
 lang=0;
 /* multi-language support - this would need some updates */
 if(getenv("LANG")!=NULL)
 {
  if(!strcasecmp(getenv("LANG"),"french")) lang=1;
  if(!strcasecmp(getenv("LANG"),"francais")) lang=1;
  if(!strcasecmp(getenv("LANG"),"spanish")) lang=2;
  if(!strcasecmp(getenv("LANG"),"espanol")) lang=2;
 }
 if(argv[1]==NULL)
 {
  strcpy(filename,"sscript.file");
 }
 else 
 {
  if(strlen(argv[1])>250) lasterror=101;
  if(lang==0)
  if(strlen(argv[1])>250) printf("*** Warning: File name too long.\n");
  else if(lang==1)
  if(strlen(argv[1])>250) printf("*** Attention: Nom de fichier trop long\n");
  else if(lang==2)
  if(strlen(argv[1])>250) printf("*** Peligro: Nombre de arch ivo es muy grande.\n");
  strcpy(filename,argv[1]);
 }
 if(!strcasecmp(filename,"-version"))
 {
  printf("1.14\n");
  exit(0);
 }
#ifdef GTK
 /* GTK init */
 gtk_init(&argc, &argv);
 /* startup screen */
#ifdef STARTUP_SCREEN
 if(!strcasecmp(filename,"sscript.file"))
 {
  gui_startup();
  if(lindex(queryGlVar,0)==NULL) exit(0);
  if(!strcasecmp(lindex(queryGlVar,0),"4")) exit(0);
  if(!strcasecmp(lindex(queryGlVar,0),"3"))
  {
   debugger(lindex(queryGlVar,1));
   exit(0);
  }
  if(!strcasecmp(lindex(queryGlVar,0),"2"))
  {
   composer(lindex(queryGlVar,1), argc, argv);
   exit(0);
  }
  if(!strcasecmp(lindex(queryGlVar,0),"1")) strcpy(filename,lindex(queryGlVar,1));
 }
#endif /* startup */
#endif /* gtk */
 /* launch debugger */
 if(!strcasecmp(filename,"-d"))
 {
  if(argv[2]==NULL) 
  {
   fprintf(stderr,"Syntax: sscript -d <script>\n");
   exit(1);
  }
  debugger(argv[2]);
  exit(0);
 }
#ifdef GTK
 if(!strcasecmp(filename,"-help"))
 {
  if(argv[2]==NULL || strcasecmp(argv[2],"docs")) help(1, argc, argv, NULL);
  else viewfile("docs/sscript.doc",argc,argv);
  exit(0);
 }
 /* launch composer */
 if(!strcasecmp(filename,"-c"))
 {
  if(argv[2]==NULL) { printf("Syntax: sscript -c <script>\n"); exit(1); }
  composer(argv[2], argc, argv);
  exit(0);
 }
#ifdef HEADER
 if(lang==0)
 msgbox("header","Socket Script v1.14 by Drow <drow@wildstar.net>\nPlease see the documentation in docs/sscript.doc",50);
 else if(lang==1)
 msgbox("header","Socket Script v1.14 par Drow <drow@wildstar.net>\nVoir la documentation dans docs/sscript.doc",50);
 else if(lang==2)
 msgbox("header","Script de Socket v1.14 por Drow <drow@wildstar.net>\nPor Favor ve la documentacion en docs/sscript.doc",50);
 if(!strcasecmp(filename,"-version")) exit(0);
#endif /* header */
#else /* gtk */
 if(!strcasecmp(filename,"-help"))
 {
  if(argv[2]==NULL || strcasecmp(argv[2],"docs")) help(0, argc, argv, NULL);
  else system("more docs/sscript.doc");
  exit(0);
 }
 if(!strcasecmp(filename,"-c"))
 {
  /* for now it launches EDITOR.. but someday I might make a built in */
  if(argv[2]==NULL) { printf("Syntax: sscript -c <script>\n"); exit(1); }
  if(lang==0)
  {
   printf("Not in graphical mode, can't launch composer.\n");
   printf("Trying to launch: %s\n",EDITOR);
  }
  else if(lang==1)
  {
   printf("Pas en mode graphique. Incapable d'ouvrir le composer.\n");
   printf("Essayons: %s\n",EDITOR);
  }
  else if(lang==2)
  {
   printf("No en modo grafico, no se puede lanzar compositor.\n");
   printf("Tratando de lanzar: %s\n",EDITOR);
  }
  sleep(2);
  sprintf(temp4,"%s %s\n",EDITOR,argv[2]);
  system(temp4);
  exit(0);
 }
#ifdef HEADER
 if(lang==0)
 printf("\nSocket Script v1.14 by Drow <drow@wildstar.net>\nLoading script...\n");
 else if(lang==1)
 printf("\nSocket Script v1.14 par Drow <drow@wildstar.net>\nOverture du script...\n");
 else if(lang==2)
 printf("\nSocket Script v1.14 por Drow <drow@wildstar.net>\nCargando script...\n");
 if(!strcasecmp(filename,"-version")) exit(0);
#endif /* header */
#endif /* gtk */
 /* check for setuid root. bad thing. */
 if(geteuid()==0 && getuid()!=0)
 {
  if(lang==0)
  printf("*** Can't run while being setuid root (eUID=%d UID=%d)\n",geteuid(),getuid());
  else if(lang==1)
  printf("*** Ne pas mettre ce programme root! (eUID=%d UID=%d)\n",geteuid(),getuid());
  else if(lang==2)
  printf("*** No se puede correr estando en setuid root (eUID=%d UID=%d)\n",geteuid(),getuid());
  exit(1);
 }
#ifndef NO_LOG_ENTRY /* useful if we want to specify our own logfile */
 sprintf(temp4,"[%ld] SScript starting: %s\n",time(NULL),filename);
 appendlog(temp4);
#endif
 /* ERSS */
 if(!strcasecmp(filename,"-r"))
 {
  if(argv[2]==NULL || argv[3]==NULL || argv[4]==NULL)
  {
   printf("*** Syntax: sscript -r <remote ip> <port> <filename>\n");
   exit(1);
  }
  sprintf(filename,"%s/.ss%ld.file",TMP_DIR,time(NULL));
  remote(argv[2],atoi(argv[3]),argv[4],filename);
 }
 if(!(fp=fopen(filename,"r")))
 {
#ifdef GUI
  if(lang==0)
  sprintf(temp4,"Script %s not found. Try sscript -help.",filename);
  else if(lang==1)
  sprintf(temp4,"Script %s n'existe pas. Voir sscript -help.",filename);
  else if(lang==2)
  sprintf(temp4,"Script %s no encontrado. Prueba sscript -help.",filename);
  msgbox("error",temp4,strlen(temp4));
#else
  if(lang==0)
  fprintf(stderr,"*** Script %s not found. Try sscript -help\n",filename);
  else if(lang==1)
  fprintf(stderr,"*** Script %s n'existe pas. Voir sscript -help\n",filename);
  else if(lang==2)
  fprintf(stderr,"*** Script %s no encontrado. Prueba sscript -help.\n",filename);
#endif
  exit(1);
 }
 /* check if it's a project file (*.prj) */
 if( filename[strlen(filename)-1]=='j' && filename[strlen(filename)-2]=='r' && filename[strlen(filename)-3]=='p')
 {
#ifdef GUI
  if(lang==0)
  msgbox("info","Project file detected... merging scripts...",45);
  else if(lang==1)
  msgbox("info","Fichier project detecte... ouverture des scripts...",45);
  else if(lang==2)
  msgbox("info","Archivo de proyacto detectado... uniendo scripts...",45);
#else
  if(lang==0)
  printf("Project file detected... merging scripts...\n");
  else if(lang==1)
  printf("Fichier project detecte... ouverture des scripts...\n");
  else if(lang==2)
  printf("Archivo de proyacto detectado... uniendo scripts...\n");
#endif
  sprintf(filename,"/tmp/.ss%ld.script",time(NULL));
  /* prevents unauthorized tmp hacking */
  sprintf(temp4,"rm -f %s 2>/dev/null",filename);
  system(temp4);
  while(fgets(temp,255,fp)!=NULL)
  {
   if(lindex(temp,0)!=NULL && lindex(temp,1)!=NULL)
   if(temp[0]=='$')
   {
    temp[strlen(temp)-1]=' ';
    sprintf(temp4,"cat %s >> %s 2>> sscript.log \n",lindex(temp,1),filename);
    system(temp4);
   }
  }
  fclose(fp);
  sprintf(temp4,"chmod 600 %s",filename);
  system(temp4);
  fp=fopen(filename,"r");
 }
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: No header.",25);
  else if(lang==1)
  msgbox("error","Erreur script: Pas d'entete.",25);
  else if(lang==2)
  msgbox("error","Error en Script: no hay titulo.",25);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: No header.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Pas d'entete.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: no hay titulo.\n");
#endif
  exit(1);
 }
 if(strcasecmp(lindex(temp,0),"server"))
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Script must start with server <ip>.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Le script doit commencer avec server <ip>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: Script debe empezar con servidor <ip>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Script must start with server <ip>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Le script doit commencer avec server <ip>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Script debe empezar con servidor <ip>.\n");
#endif
  exit(1);
 }
 strcpy(server,(char *)lindex(temp,1));
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Expected port <port> and got EOF.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais port <port>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: puerto esperado <port>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected port <port> and got EOF.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais port <port>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: puerto esperado <port>.\n");
#endif
  exit(1);
 }
 if(strcasecmp(lindex(temp,0),"port"))
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Expected port <port>.",30);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais port <port>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: puerto esperado <port>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected port <port>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais port <port>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: puerto esperado <port>.\n");
#endif
  exit(1);
 }
 port = atoi(lindex(temp,1));
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Expected debug <mode> and got EOF.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais debug <mode>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: esperado debug <moda>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected debug <mode> and got EOF.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais debug <mode>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: esperado debug <moda>.\n");
#endif
  exit(1);
 }
 if(strcasecmp(lindex(temp,0),"debug"))
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Expected debug <mode>.",25);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais debug <mode>.",45);  
  else if(lang==2)
  msgbox("error","Error en Script: esperado debug <moda>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected debug <mode>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais debug <mode>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: esperado debug <moda>.\n");
#endif
  exit(1);
 }
 debug = atoi(lindex(temp,1));
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Expected chop <mode> and got EOF.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais chop <mode>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: Chop esperado <moda>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected chop <mode> and got EOF.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais chop <mode>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Chop esperado <moda>.\n");
#endif
  exit(1);
 }
 if(strcasecmp(lindex(temp,0),"chop"))
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Expected chop <mode>.",25);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais chop <mode>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: Chop esperado <moda>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected chop <mode>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais chop <mode>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Chop esperado <moda>.\n");
#endif
  exit(1);
 }
 chop = atoi(lindex(temp,1));
 if(fgets(temp,255,fp)==NULL)
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Expected virtual <ip> and got EOF.",45);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais virtual <ip>.",45);
  else if(lang==2)
  msgbox("error","Error en Script: Virtual esperado <ip>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected virtual <ip> and got EOF.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais virtual <ip>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Virtual esperado <ip>.\n");
#endif
  exit(1);
 }
 if(strcasecmp(lindex(temp,0),"virtual"))
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Expected virtual <ip>.",25);
  else if(lang==1)
  msgbox("error","Erreur script: Attendais virtual <ip>.",45);  
  else if(lang==2)
  msgbox("error","Error en Script: Virtual esperado <ip>.",45);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Expected virtual <ip>.\n");
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Attendais virtual <ip>.\n");
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: Virtual esperado <ip>.\n");
#endif
  exit(1);
 }
 strcpy(virtual,(char *)lindex(temp,1));
 /* we don't show the following if in GUI mode */
#ifdef HEADER
#ifndef GUI
 if(lang==0)
 {
  if(strcasecmp(server,"0")) printf("Connecting to %s port %d\n",server,port);
  else printf("Listening to port %d\n",port);
  if(debug) printf("Debug mode ON\n");
  if(!debug) printf("Debug mode OFF\n");
 }
 else if(lang==1)
 {
  if(strcasecmp(server,"0")) printf("Branchement sur %s port %d\n",server,port);
  else printf("Ecoute sur %d...\n",port);
  if(debug) printf("Debug mode active\n");
  if(!debug) printf("Debug mode non active\n");
 }
 else if(lang==2)
 {
  if(strcasecmp(server,"0")) printf("Conectando a puerto %s %d\n",server,port);
  else printf("Escuchando al puerto %d...\n",port);
  if(debug) printf("Modo debug ACTIVADO\n");
  if(!debug) printf("Modo debug NON ACTIVADO\n");
 }
#endif /* text-only */
#endif /* header */
#ifdef FORK_START
 if(!strcasecmp(server,"0"))
 /* server-oriented script */
 if(pid=fork())
 {
#ifndef GUI
  if(lang==0)
  printf("Going into the background, port %d...[pid=%d]\n",port,pid);
  else if(lang==1)
  printf("Allant en arriere-plan, port %d...[pid=%d]\n",port,pid);
  else if(lang==2)
  printf("Yendo hacia la portada, puerto %d...[pid=%d]\n",port,pid);
#endif /* text-only */
  exit(0);
 }
#endif /* fork start */
 /* connecting */
 if(!strcasecmp(server,"no-connection"))
 { /* no-connection script */ }
 else if(strcasecmp(server,"0"))
 {
  /* client-oriented script */
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if(sockfd<1)
  {
#ifdef GUI
   if(lang==0)
   msgbox("error","Internal error: Socket failed.",25);
   else if(lang==1)
   msgbox("error","Erreur interne: Socket erreur.",25);
   else if(lang==2)
   msgbox("error","Error Interno: Fallo el Socket.",25);
#else
   if(lang==0)
   fprintf(stderr,"*** Internal error: Socket failed [%d].\n",errno);
   else if(lang==1)
   fprintf(stderr,"*** Erreur interne: Socket erreur. [%d].\n",errno);
   else if(lang==2)
   fprintf(stderr,"*** Error Interno: Fallo el Socket. [%d].\n",errno);
#endif
   exit(1);
  }
  address.sin_family = AF_INET;
  address.sin_addr.s_addr = inet_addr(server);
  address.sin_port = htons(port);
  len = sizeof(address);
  if(strcasecmp(virtual,"0"))
  {
   la.sin_family = AF_INET;
   la.sin_addr.s_addr = inet_addr(virtual);
   la.sin_port = 0;
   bind(sockfd, (struct sockaddr *)&la, sizeof(la));
  }
  result = connect(sockfd, (struct sockaddr *)&address, len);
  if(result==-1)
  {
#ifdef GUI
   if(lang==0)
   msgbox("error","Script error: Can't connect to remote host.",30);
   else if(lang==1)
   msgbox("error","Erreur script: Incapable de me connecter.",30);
   else if(lang==2)
   msgbox("error","Error en Script: No se puede conectar a host remoto.",30);
#else
   if(lang==0)
   fprintf(stderr,"*** Script error: Can't connect to %s port %d [%d].\n",server,port,errno);
   else if(lang==1)
   fprintf(stderr,"*** Erreur script: Incapable de me connecter sur %s port %d [%d].\n",server,port,errno);
   else if(lang==2)
   fprintf(stderr,"*** Error en Script: No se puede conectar a host remoto %s %d [%d].\n",server,port,errno);
#endif
   exit(1);
  }
 }
 else
 {
  /* server-oriented script */
  server_oriented = 1;
  sockfd2 = socket(AF_INET, SOCK_STREAM, 0);
  if(sockfd2<1)
  {
#ifdef GUI
   if(lang==0)
   msgbox("error","Internal error: Socket failed.",25);
   else if(lang==1)
   msgbox("error","Erreur interne: Socket erreur.",25);
   else if(lang==2)
   msgbox("error","Error Interno: Fallo el Socket.",25);
#else
   if(lang==0)
   fprintf(stderr,"*** Internal error: Socket failed [%d].\n",errno);
   else if(lang==1)
   fprintf(stderr,"*** Erreur interne: Socket erreur. [%d].\n",errno);
   else if(lang==2)
   fprintf(stderr,"*** Error Interno: Fallo el Socket. [%d].\n",errno);
#endif
   exit(1);
  }
  listen_addr.sin_family = AF_INET;
  listen_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  listen_addr.sin_port = htons(port);
  listen_len = sizeof(listen_addr); 
  if(geteuid()==0)
   setsockopt(sockfd2, SOL_SOCKET, SO_REUSEADDR, (char *) &opt, sizeof(int));
  /* ok how do you unlink something if the program gets kill'ed -5 ? */
  if(bind(sockfd2, (struct sockaddr *)&listen_addr, listen_len))
  {
#ifdef GUI
   if(lang==0)
   msgbox("error","Internal error: Binding failed. Wait a few minutes and try again or recompile the server.",80);
   else if(lang==1)
   msgbox("error","Erreur interne: Erreur de l'attribution de l'addresse locale. Attendez quelque minutes et reessayez, ou recompilez le server.",80);
   else if(lang==2)
   msgbox("error","Error Interno: Union Fallo. Espera unos minutos y vuelve a intent ar o recompila el servidor.",80);
#else
   if(lang==0)
   fprintf(stderr,"*** Internal error: Binding failed. Wait a few minutes and try again or recompile the server.\n");
   else if(lang==1)
   fprintf(stderr,"*** Erreur interne: Erreur de l'attribution de l'addresse locale. Attendez quelque minutes et reessayez, ou recompilez le server.\n");
   else if(lang==2)
   fprintf(stderr,"*** Error Interno: Union Fallo. Espera unos minutos y vuelve a intent ar o recompila el servidor.\n");
#endif /* gui */
   exit(1);
  }
  listen(sockfd2, 5);
  for(;;)
  {
   if(sockfd!=(int)NULL) close(sockfd);
   sockfd = accept(sockfd2, (struct sockaddr *)&address, &len);
   if(pid=fork()) break;
  }
#ifdef GET_REMOTE_IP
  from_len=sizeof(from_addr);
  memset(&from_addr, 0, sizeof(from_addr));
  if(getpeername(sockfd, (struct sockaddr *)&from_addr,&from_len) < 0)
  {
   sprintf(temp4,"[%ld] Connection from unknown host [pid=%d]\n",time(NULL),pid);
   appendlog(temp4);
  }
  else
  {
   sprintf(temp4,"[%ld] Connection from %s [pid=%d]\n",time(NULL),inet_ntoa(from_addr.sin_addr),pid);
   appendlog(temp4);
   strcpy(remote_ip,inet_ntoa(from_addr.sin_addr));
  }
#endif /* remote ip */
 } 
/* main loop */
 signal(SIGSEGV, handle_segv);
 signal(SIGINT, handle_int);
 signal(SIGPIPE, handle_pipe);
 signal(SIGHUP, handle_hup);
 signal(SIGIO, handle_io);
 strcpy(in[0],"");
 for(i=0;argv[i]!=NULL;i++)
 {
  strcat(in[0],argv[i]);
  strcat(in[0]," ");
 }
 if(argv[2]!=NULL && !strcasecmp(argv[2],"-l"))
 {
  for(i=6;i<atoi(argv[3]);i++) fgets(temp,255,fp);
 }
 while(fgets(temp,255,fp)!=NULL)
 {
  temp[strlen(temp)-1]=' ';
  if(lindex(temp,0)==NULL || lindex(temp,0)==NULL) continue;
  if(tracing) addtrace(lasterror);
  if(tracing) addtrace(-1);
  if( timer_var!=-1 && time(NULL) > timer )
  {
   strcpy(in[timer_var],"1 ");
   timer_var=-1;
  }
  if(!strcasecmp(lindex(temp,0),"command"))
  {
   strncpy(temp4,in[atoi(lindex(temp,1))],254);
   strcpy(temp,temp4);
  }
  if(!strcasecmp(lindex(temp,0),"say"))
  {
#ifdef SOUND
   say_it(argc, argv, in[atoi(lindex(temp,1))]);
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"db"))
  {
#ifdef DB
   if(!strcasecmp(lindex(temp,1),"create"))
   {
    dbf = gdbm_open(lindex(temp,2), 512, GDBM_NEWDB, 00664, NULL);
    if(dbf==NULL) lasterror=126;
   }
   if(!strcasecmp(lindex(temp,1),"open-write"))
   {
    dbf = gdbm_open(lindex(temp,2), 512, GDBM_WRCREAT, 00664, NULL);
    if(dbf==NULL) lasterror=126;
   }
   if(!strcasecmp(lindex(temp,1),"open-read"))
   {
    dbf = gdbm_open(lindex(temp,2), 512, GDBM_READER, 00664, NULL);
    if(dbf==NULL) lasterror=126;
   }
   if(!strcasecmp(lindex(temp,1),"close"))
   {
    gdbm_close (dbf);
   }
   if(!strcasecmp(lindex(temp,1),"insert"))
   {
    db_data.dsize = strlen(lrange(temp,3));
    db_data.dptr = lrange(temp,3);
    db_key.dsize = strlen(lindex(temp,2));
    db_key.dptr = lindex(temp,2);
    if(gdbm_store(dbf, db_key, db_data, GDBM_REPLACE)!=0)
    lasterror=127;
   }
   if(!strcasecmp(lindex(temp,1),"get"))
   {
    db_data.dptr = NULL;
    db_key.dsize = strlen(lindex(temp,2));
    db_key.dptr = lindex(temp,2);
    db_data = gdbm_fetch(dbf, db_key);
    strncpy(in[atoi(lindex(temp,3))],db_data.dptr,512);
    free(db_data.dptr);
   }
   if(!strcasecmp(lindex(temp,1),"delete"))
   {
    db_key.dsize = strlen(lindex(temp,2));  
    db_key.dptr = lindex(temp,2);
    gdbm_delete(dbf, db_key);
   }
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"pgp"))
  {
   if(!strcasecmp(lindex(temp,1),"generate"))
   {
    sprintf(temp4,"pgpk -g");
    printf("Starting PGPk to make your keys...\n");
    system(temp4);
    printf("\n\nNow that your keys have been created, you need to extract your public key to be able to put it on a web site or somewhere so someone can take it and use to send you encrypted files.\n");
    printf("Enter the first word of your user ID you just entered: ");
    gets(temp2);
    sprintf(temp4,"pgpk -x %s -o %s",temp2,lindex(temp,2));
    system(temp4);
   }
   if(!strcasecmp(lindex(temp,1),"add-key"))
   {
    sprintf(temp4,"pgpk -a %s",lindex(temp,2));
    printf("Starting PGPk to add this key...\n");
    system(temp4);
   }
   if(!strcasecmp(lindex(temp,1),"encrypt"))
   {
    sprintf(temp4,"pgpe -a -r %s -a %s",lindex(temp,2),lindex(temp,3));
    printf("Starting PGPe to encrypt %s...\n",lindex(temp,3));
    system(temp4);
   }
   if(!strcasecmp(lindex(temp,1),"decrypt"))
   {
    sprintf(temp4,"pgpv %s -o %s",lindex(temp,2),lindex(temp,3));
    printf("Starting PGPv to decrypt %s...\n",lindex(temp,3));
    system(temp4);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"encryptfile"))
  {
   des_file(1, in);
  }
  else if(!strcasecmp(lindex(temp,0),"decryptfile"))
  {
   des_file(2, in);
  }
  else if(!strcasecmp(lindex(temp,0),"servicename"))
  {
   sprintf(in[atoi(lindex(temp,2))],"%d",get_service(lindex(temp,1)));
  }
  else if(!strcasecmp(lindex(temp,0),"varchop"))
  {
   if(strlen(in[atoi(lindex(temp,1))])>0)
   in[atoi(lindex(temp,1))][strlen(in[atoi(lindex(temp,1))])-1]='\0';
  }
  else if(!strcasecmp(lindex(temp,0),"clear"))
  {
   system("tput clear");
  }
  else if(!strcasecmp(lindex(temp,0),"ascii"))
  {
   if(!strcasecmp(lindex(temp,1),"toupper"))
   {
    for(i=0;in[atoi(lindex(temp,2))][i]!='\0';i++)
    {
     in[atoi(lindex(temp,3))][i]=toupper(in[atoi(lindex(temp,2))][i]);
     if(i>510) break;
    }
   }
   if(!strcasecmp(lindex(temp,1),"tolower"))
   {
    for(i=0;in[atoi(lindex(temp,2))][i]!='\0';i++)
    {
     in[atoi(lindex(temp,3))][i]=tolower(in[atoi(lindex(temp,2))][i]);
     if(i>510) break;
    }
   }
   if(!strcasecmp(lindex(temp,1),"isnumber"))
   {
    if(isdigit(in[atoi(lindex(temp,2))][0]))
    strcpy(in[atoi(lindex(temp,3))],"1");
    else strcpy(in[atoi(lindex(temp,3))],"0");
   }
  }
  else if(!strcasecmp(lindex(temp,0),"utime"))
  {
   sprintf(in[atoi(lindex(temp,1))],"%ld",time(NULL));
  }
  else if(!strcasecmp(lindex(temp,0),"timer"))
  {
   timer = (time(NULL) + atoi(lindex(temp,1)));
   timer_var=atoi(lindex(temp,2));
  }
  else if(!strcasecmp(lindex(temp,0),"redir"))
  {
   redir(sockfd, rsck);
  }
  else if(!strcasecmp(lindex(temp,0),"listen"))
  {
   sprintf(in[atoi(lindex(temp,1))],"%d ;",listen_select(sockfd, rsck));
  }
  else if(!strcasecmp(lindex(temp,0),"multilisten"))
  {
   if(!strcasecmp(lindex(temp,1),"1")) multilisten(in, fileno(stdin), sockfd);
   if(!strcasecmp(lindex(temp,1),"2")) multilisten(in, fileno(stdin), rsck);
   if(!strcasecmp(lindex(temp,1),"3")) multilisten(in, sockfd, rsck);
  }
  else if(!strcasecmp(lindex(temp,0),"modem"))
  {
#ifdef USE_MOD
   if(!strcasecmp(lindex(temp,1),"dial"))
   {
    if((moda=dial(lindex(temp,2)))<0) lasterror=124;
    modb = fdopen(moda, "r+");
   }
   if(!strcasecmp(lindex(temp,1),"hangup")) hangup(moda);
   if(!strcasecmp(lindex(temp,1),"write")) fprintf(modb, in[atoi(lindex(temp,2))]);
   if(!strcasecmp(lindex(temp,1),"read"))
   {
    bzero(buf, 1024);
    fgets(buf, 511, modb);
    strncpy(in[atoi(lindex(temp,2))],buf,512);
   }
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"serial"))
  {
#ifdef USE_SERIAL
   if(!strcasecmp(lindex(temp,1),"init")) init_serial(lindex(temp,2));
   if(!strcasecmp(lindex(temp,1),"speed")) serial_speed(atoi(lindex(temp,2)));
   if(!strcasecmp(lindex(temp,1),"type")) set_parity(atoi(lindex(temp,2)));
   if(!strcasecmp(lindex(temp,1),"end")) end_serial();
   if(!strcasecmp(lindex(temp,1),"write")) serial_write(in[atoi(lindex(temp,2))]);
   if(!strcasecmp(lindex(temp,1),"read")) strncpy(in[atoi(lindex(temp,2))],(char *)serial_read(),512);
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"zipstring"))
  {
#ifdef USE_LIBZ
   zip_string(in[atoi(lindex(temp,1))],lindex(temp,2));
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"unzipstring"))
  {
#ifdef USE_LIBZ
   strncpy(in[atoi(lindex(temp,1))],(char *)unzip_string(lindex(temp,2)),511);
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"unzipfile"))
  {
#ifdef USE_LIBZ
   unzip_file(lindex(temp,1),lindex(temp,2));
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"zipfile"))
  {
#ifdef USE_LIBZ
   zip_file(lindex(temp,1),lindex(temp,2));
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"printparams"))
  {
   if(set_signals_off) printf("SIGNALS_OFF = 1\n");
   if(!set_signals_off) printf("SIGNALS_OFF = 0\n");
   if(setremoteecho) printf("REMOTE_ECHO = 1\n");
   if(!setremoteecho) printf("REMOTE_ECHO = 0\n");
   if(windows) printf("WINDOWS_COMP = 1\n");
   if(!windows) printf("WINDOWS_COMP = 0\n");
   if(tracing) printf("TRACING = 1\n");
   if(!tracing) printf("TRACING = 0\n");
   if(strictcheck) printf("STRICT_CHECK = 1\n");
   if(!strictcheck) printf("STRICT_CHECK = 0\n");
   printf("LOGFILE = %s\n",logfilename);
   if(userhost) printf("USER_HOST = 1\n");
   if(!userhost) printf("USER_HOST = 0\n");
   if(is_a_service) printf("IRC_SERVICE = 1\n");
   if(!is_a_service) printf("IRC_SERVICE = 0\n");
   if(strictwrite) printf("STRICT_WRITE = 1\n");
   if(!strictwrite) printf("STRICT_WRITE = 0\n");
   printf("MASTER_FILE = %s\n",master);
   if(inputchop) printf("INPUT_CHOP = 1\n");
   if(!inputchop) printf("INPUT_CHOP = 0\n");
   if(reversechop) printf("REVERSE_CHOP = 1\n");
   if(!reversechop) printf("REVERSE_CHOP = 0\n");
  }
  else if(!strcasecmp(lindex(temp,0),"setsignalsoff"))
  {
   set_signals_off=1;
  }
  else if(!strcasecmp(lindex(temp,0),"setremoteecho"))
  {
   setremoteecho=1;
  }
#ifdef POSIX
  else if(!strcasecmp(lindex(temp,0),"uname"))
  {
   uname(&unamebuf);
   sprintf(in[atoi(lindex(temp,1))],"%s %s %s %s %s %s ;",unamebuf.sysname,unamebuf.nodename,unamebuf.release,unamebuf.version,unamebuf.machine,unamebuf.domainname);
  }
#endif
  else if(!strcasecmp(lindex(temp,0),"setwindows"))
  {
   windows=1;
  }
  else if(!strcasecmp(lindex(temp,0),"settrace"))
  {
   fpa=fopen("trace.log","w");
   if(fpa!=NULL) fclose(fpa);
   tracing=1;
  }
  else if(!strcasecmp(lindex(temp,0),"random"))
  {
   srandom(time(NULL));
   sprintf(in[atoi(lindex(temp,1))],"%d",random() % atoi(lindex2(temp,2)));
  }
  else if(!strcasecmp(lindex(temp,0),"loop") && !strcasecmp(lindex(temp,1),"end"))
  {
   if(loop!=0)
   {
    if(fp!=NULL) fclose(fp);
    strcpy(temp2,lindex(temp,2));
    fp=fopen(filename,"r");
    if(fp==NULL || fileno(fp)<0) printf("*** Can't open the script!\n");
    while(fgets(temp,255,fp)!=NULL)
    {
     if(!strcasecmp(lindex(temp,0),"loop") && !strcasecmp(lindex(temp,1),"start") && !strcasecmp(lindex(temp,2),temp2))
     break;
    }
    if(temp==NULL || strcasecmp(lindex(temp,0),"loop"))
     printf("*** Warning: Didn't find matching loop\n");
   }
   else
   {
    loop = 1;
   }
  }
  else if(!strcasecmp(lindex(temp,0),"save"))
  {
   fpa=fopen(lindex(temp,2),"w");
   if(fpa==NULL || fileno(fpa)<0) lasterror=103;
   else
   {
    fputs(in[atoi(lindex(temp,1))],fpa);
    fputs("\n",fpa);
    if(fpa!=NULL) fclose(fpa);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"cron"))
  {
   strcpy(cron,lrange(temp,1));
  }
  else if(!strcasecmp(lindex(temp,0),"setstrictcheck"))
  {
   strictcheck = 1;
  }
  else if(!strcasecmp(lindex(temp,0),"setlogfile"))
  {
   strcpy(logfilename,lindex(temp,1));
  }
  else if(!strcasecmp(lindex(temp,0),"setuserhost"))
  {
   userhost = 1;
  }
  else if(!strcasecmp(lindex(temp,0),"setservice"))
  {
   is_a_service = 1;
  }
  else if(!strcasecmp(lindex(temp,0),"exit"))
  {
   sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
   appendlog(temp4);
   shutdown(sockfd,2);
   close(sockfd);
   if(strcasecmp(cron,"")) system(cron);
   if(lindex(temp,1)!=NULL && atoi(lindex(temp,1))!=0) exit(atoi(lindex(temp,1)));
   else exit(0);
  }
  else if(!strcasecmp(lindex(temp,0),"goto"))
  {
   strcpy(subnumber,lindex(temp,1));
   if(fp!=NULL) fclose(fp);
   fp=fopen(filename,"r");
   while(fgets(temp,255,fp)!=NULL)
   { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
  }
  else if(!strcasecmp(lindex(temp,0),"for"))
  {
   min_for=atoi(lindex(temp,2));
   max_for=atoi(lindex(temp,4));
   current_for=min_for;
  }
  else if(!strcasecmp(lindex(temp,0),"endfor"))
  {
   if(current_for!=max_for)
   {
    current_for++;
    strcpy(temp4,lindex(temp,1));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    if(fp==NULL) printf("*** Can't open the script!\n");
    while(fgets(temp,255,fp)!=NULL)
    {
     if(!strcasecmp(lindex(temp,0),"for") && !strcasecmp(lindex(temp,1),temp4)) break;
    }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"nodelay"))
  {
   if(( i = fcntl(sockfd, F_GETFL, 0)) == -1);
   else if (fcntl(sockfd, F_SETFL, i | FNDELAY) == -1);
  }
  else if(!strcasecmp(lindex(temp,0),"snmp"))
  {
#ifdef USE_SNMP
   strncpy(in[atoi(lindex(temp,4))],(char *)snmp_query(lindex(temp,1), lindex2(temp,2), lindex(temp,3)),511);
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"http"))
  {
   if(!strcasecmp(lindex(temp,1),"html"))
   {
    parse_html(in[atoi(lindex(temp,2))]);
   }
   if(!strcasecmp(lindex(temp,1),"js"))
   {
    make_js();
   }
  }
  else if(!strcasecmp(lindex(temp,0),"getenv"))
  {
   if(getenv(lindex2(temp,1))==NULL) lasterror=104;
   else
   strncpy(in[atoi(lindex(temp,2))],getenv(lindex2(temp,1)),512);
  }
  else if(!strcasecmp(lindex(temp,0),"lasterror"))
  {
   sprintf(in[atoi(lindex(temp,1))],"%d",lasterror);
  }
  else if(!strcasecmp(lindex(temp,0),"clearlasterror"))
  {
   lasterror=0;
  }
  else if(!strcasecmp(lindex(temp,0),"background"))
  {
   if(fork()) exit(0);
  }
  else if(!strcasecmp(lindex(temp,0),"choicebox"))
  {
#ifdef GUI
   choicebox(argc, argv);
   strcpy(in[atoi(lindex(temp,1))],queryGlVar);
#else
   lasterror=105;
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"setowner"))
  {
   if(setuid(atoi(lindex(temp,1)))<0) lasterror=106;
  }
  else if(!strcasecmp(lindex(temp,0),"run"))
  {
   system(in[atoi(lindex(temp,1))]);
  }
  else if(!strcasecmp(lindex(temp,0),"append"))
  {
   fpa=fopen(lindex(temp,2),"a");
   if(fpa==NULL || fileno(fpa)<0) lasterror=103;
   else
   {
    fputs(in[atoi(lindex(temp,1))],fpa);
    fputs("\n",fpa);
    if(fpa!=NULL) fclose(fpa);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"remove"))
  {
   fpa=fopen(lindex(temp,2),"r");
   if(fpa==NULL || fileno(fpa)<0) lasterror=107;
   sprintf(temp2,"%s/.temp%ld.tmp",TMP_DIR,time(NULL));
   fpb=fopen(temp2,"w");
   if(fpb==NULL || fileno(fpb)<0) lasterror=103;
   else
   {
    while(fgets(temp4,255,fpa)!=NULL)
    if(strcasecmp(temp4,in[atoi(lindex(temp,1))])) fputs(temp4,fpb);
    if(fpb!=NULL) fclose(fpb);
    if(fpa!=NULL) fclose(fpa);
    sprintf(temp4,"mv %s %s\n",temp2,lindex(temp,2));
    system(temp4);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"rementry"))
  {
   fpa=fopen(lindex(temp,2),"r");
   if(fpa==NULL || fileno(fpa)<0) lasterror=107;
   sprintf(temp2,"%s/.temp%ld.tmp",TMP_DIR,time(NULL));
   fpb=fopen(temp2,"w");
   if(fpb==NULL || fileno(fpb)<0) lasterror=103;
   else
   {
    while(fgets(temp4,255,fpa)!=NULL)   
    if(strcasecmp(lindex(temp4,0),lindex2(in[atoi(lindex(temp,1))],0)))
     fputs(temp4,fpb);
    if(fpb!=NULL) fclose(fpb);
    if(fpa!=NULL) fclose(fpa);
    sprintf(temp4,"mv %s %s\n",temp2,lindex(temp,2));
    system(temp4);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"ask"))
  {
   gets(in[atoi(lindex(temp,1))]);
  }
  else if(!strcasecmp(lindex(temp,0),"set"))
  {
   bzero(buf,1024);
   strcpy(buf,"");
   for(i=2;lindex(temp,i)!=NULL;i++)
   {
    if(reversechop) strcat(buf," ");
    if(*lindex(temp,i)=='$')
    {
     if(*(lindex(temp,i)+1)=='w')
     {
      i++;
      if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
      strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
     if(*(lindex(temp,i)+1)=='1') { sleep(1); }
     if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
     if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
     if(*(lindex(temp,i)+1)=='/')
     {
      i++;
      if(*(lindex(temp,i))=='0') strcat(buf,"\000");
      if(*(lindex(temp,i))=='1') strcat(buf,"\001");
      if(*(lindex(temp,i))=='2') strcat(buf,"\002");
      if(*(lindex(temp,i))=='3') strcat(buf,"\003");
      if(*(lindex(temp,i))=='4') strcat(buf,"\004");
      if(*(lindex(temp,i))=='5') strcat(buf,"\005");
      if(*(lindex(temp,i))=='6') strcat(buf,"\006");
      if(*(lindex(temp,i))=='7') strcat(buf,"\007");
      if(*(lindex(temp,i))=='8') strcat(buf,"\008");
      if(*(lindex(temp,i))=='9') strcat(buf,"\009");
     }
     if(*(lindex(temp,i)+1)=='p')
     { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
     if(*(lindex(temp,i)+1)=='t')
     {
      lt=time(NULL);
      strcpy(temp4,ctime(&lt));
      temp4[strlen(temp4)-1]=' ';
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='r')
     {
      if(fp!=NULL) fclose(fp);
      fp=fopen(lindex(temp,1),"r");
     }
     if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
     if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
     if(*(lindex(temp,i)+1)=='%')
     {
      sprintf(temp4,"%d",current_for);
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='2') { sleep(2); }
     if(*(lindex(temp,i)+1)=='3') { sleep(3); }
     if(*(lindex(temp,i)+1)=='g')
     {
      strcpy(subnumber,lindex(temp,(i+1)));
      if(fp!=NULL) fclose(fp);
      fp=fopen(filename,"r");
      while(fgets(temp,255,fp)!=NULL)
       { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
      goto_on = 1;
      break;
     }
     if(*(lindex(temp,i)+1)=='4') { sleep(4); }
     if(*(lindex(temp,i)+1)=='5') { sleep(5); }
     if(*(lindex(temp,i)+1)=='6') { sleep(6); }
     if(*(lindex(temp,i)+1)=='7') { sleep(7); }
     if(*(lindex(temp,i)+1)=='8') { sleep(8); }
     if(*(lindex(temp,i)+1)=='9') { sleep(9); }
     if(*(lindex(temp,i)+1)=='n')
     {
      strcat(buf,nick);  
     } 
     if(*(lindex(temp,i)+1)=='u')
     {
      strcat(buf,user);
     }
     if(*(lindex(temp,i)+1)=='e')
     {
      sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
      appendlog(temp4);         
      shutdown(sockfd,2);
      close(sockfd);
      if(strcasecmp(cron,"")) system(cron);
      exit(0);
     }
     if(*(lindex(temp,i)+1)=='i')
     {
      i++;
      fpa=fopen(lindex(temp,i),"r");
      strcpy(temp2,"");
      for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
       fgets(temp2,255,fpa);
      strcat(buf,temp2);
      if(fpa!=NULL) fclose(fpa);
      i++;
     }
     if(*(lindex(temp,i)+1)=='b')
     {
      goto_on = 1;
      loop = 0;
     }
     if(*(lindex(temp,i)+1)=='s')
     {
      i++;
      strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
    }   
    else
    {
     strcat(buf,lindex(temp,i));
    }
    if(!reversechop) strcat(buf," ");
   }
   strncpy(in[atoi(lindex(temp,1))],buf,512);
  }
  else if(!strcasecmp(lindex(temp,0),"setstrictwrite"))
  {
   strictwrite=1;
  }
  else if(!strcasecmp(lindex(temp,0),"setmaster"))
  {
   strcpy(master,lindex(temp,1));
  }
  else if(!strcasecmp(lindex(temp,0),"file"))
  {
   if(!strcasecmp(lindex(temp,1),"access"))
   {
    if(fgets(in[atoi(lindex(temp,2))],255,fpaccess)==NULL) lasterror=121;
    else
    in[atoi(lindex(temp,2))][strlen(in[atoi(lindex(temp,2))])-1]=' ';
   }
   if(!strcasecmp(lindex(temp,1),"open"))
   {
    fpaccess=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpaccess==NULL || fileno(fpaccess)<0) lasterror=107;
   }
   if(!strcasecmp(lindex(temp,1),"close"))
   {
    if(fpaccess!=NULL) fclose(fpaccess);
   }
   if(!strcasecmp(lindex(temp,1),"exist"))
   {
    fpb=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpb==NULL) strcpy(in[atoi(lindex(temp,3))],"1 ;");
    else if(fileno(fpb)<0) strcpy(in[atoi(lindex(temp,3))],"1 ;");
    else strcpy(in[atoi(lindex(temp,3))],"0 ;");
    if(fpb!=NULL) fclose(fpb);
   }
   if(!strcasecmp(lindex(temp,1),"size"))
   {
    fpb=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpb==NULL || fileno(fpb)<0) lasterror=108;
    fstat(fileno(fpb), &stat_buf);
    sprintf(in[atoi(lindex(temp,3))],"%ld",stat_buf.st_size);
    if(fpb!=NULL) fclose(fpb);
   }
   if(!strcasecmp(lindex(temp,1),"mode"))
   {
    fpb=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpb==NULL || fileno(fpb)<0) lasterror=108;
    fstat(fileno(fpb), &stat_buf);
    if(S_ISDIR(stat_buf.st_mode)) 
    sprintf(in[atoi(lindex(temp,3))],"DIRECTORY");
    if(S_ISCHR(stat_buf.st_mode))
    sprintf(in[atoi(lindex(temp,3))],"CHAR DEVICE");
    if(S_ISBLK(stat_buf.st_mode))
    sprintf(in[atoi(lindex(temp,3))],"BLOCK DEVICE");
    if(S_ISREG(stat_buf.st_mode))
    sprintf(in[atoi(lindex(temp,3))],"FILE");
    if(S_ISFIFO(stat_buf.st_mode))
    sprintf(in[atoi(lindex(temp,3))],"FIFO");
    if(S_ISLNK(stat_buf.st_mode))
    sprintf(in[atoi(lindex(temp,3))],"LINK");
    if(S_ISSOCK(stat_buf.st_mode))
    sprintf(in[atoi(lindex(temp,3))],"UNIX SOCKET");
    if(fpb!=NULL) fclose(fpb);
   }
   if(!strcasecmp(lindex(temp,1),"owner"))
   {
    fpb=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpb==NULL || fileno(fpb)<0) lasterror=108;
    fstat(fileno(fpb), &stat_buf);
    sprintf(in[atoi(lindex(temp,3))],"%d",stat_buf.st_uid);
    if(fpb!=NULL) fclose(fpb);
   }
   if(!strcasecmp(lindex(temp,1),"group"))
   {
    fpb=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpb==NULL || fileno(fpb)<0) lasterror=108;
    fstat(fileno(fpb), &stat_buf);
    sprintf(in[atoi(lindex(temp,3))],"%d",stat_buf.st_gid);
    if(fpb!=NULL) fclose(fpb);
   }
   if(!strcasecmp(lindex(temp,1),"mtime"))
   {
    fpb=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpb==NULL || fileno(fpb)<0) lasterror=108;
    fstat(fileno(fpb), &stat_buf);
    sprintf(in[atoi(lindex(temp,3))],"%ld",stat_buf.st_mtime);
    if(fpb!=NULL) fclose(fpb);
   }
   if(!strcasecmp(lindex(temp,1),"ctime"))
   {
    fpb=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpb==NULL || fileno(fpb)<0) lasterror=108;
    fstat(fileno(fpb), &stat_buf);
    sprintf(in[atoi(lindex(temp,3))],"%ld",stat_buf.st_ctime);
    if(fpb!=NULL) fclose(fpb);
   }
   if(!strcasecmp(lindex(temp,1),"atime"))
   {
    fpb=fopen(lindex2(in[atoi(lindex(temp,2))],0),"r");
    if(fpb==NULL || fileno(fpb)<0) lasterror=108;
    fstat(fileno(fpb), &stat_buf);
    sprintf(in[atoi(lindex(temp,3))],"%ld",stat_buf.st_atime);
    if(fpb!=NULL) fclose(fpb);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"binary-send"))
  {
   sprintf(temp4,"uuencode %s %s > %s/.temp.uue 2>/dev/null",lindex2(in[atoi(lindex(temp,1))],0),lindex2(in[atoi(lindex(temp,1))],0),TMP_DIR);
   system(temp4);
   sprintf(temp2,"%s/.temp.uue",TMP_DIR);
   fpa=fopen(temp2,"r");
   if(fpa==NULL || fileno(fpa)<0) lasterror=107;
   else {
    while((cnt = read(fileno(fpa), temp4, 250))>0)
     write(sockfd, temp4, cnt);
    if(fpa!=NULL) fclose(fpa);
    sprintf(temp4,"rm -f %s/.temp.uue",TMP_DIR);
    system(temp4);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"binary-get"))
  {
   sprintf(temp2,"%s/.temp.uue",TMP_DIR);
   fpa=fopen(temp2,"w");
   if(fpa==NULL || fileno(fpa)<0) lasterror=103;
   else {
    while(strcasecmp(inall,"end\n"))
    {
     bzero(inall, 1024);
     for(i=0;read(sockfd,&inchar,1)!='\0';i++)
     { 
      inall[i]=inchar;
      if(inchar=='\n') break;
     }
     if (chop) inall[i-1]=' ';
     if(debug) printf("[%d] [%s]\n",atoi(lindex(temp,1)),inall);
     fputs(inall,fpa);
    }
    if(fpa!=NULL) fclose(fpa);
    sprintf(temp4,"uudecode %s/.temp.uue",TMP_DIR);
    system(temp4);
    sprintf(temp4,"rm -f %s/.temp.uue",TMP_DIR);
    system(temp4);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"cwd"))
  {
   getcwd(in[atoi(lindex(temp,1))],sizeof(in[atoi(lindex(temp,1))]));
  }
  else if(!strcasecmp(lindex(temp,0),"chdir"))
  {
   if(chdir(lindex2(in[atoi(lindex(temp,1))],0))<0) lasterror=120;
  }
  else if(!strcasecmp(lindex(temp,0),"setinputchop"))
  {
   inputchop=1;
  }
  else if(!strcasecmp(lindex(temp,0),"input"))
  {
   fpa=fopen(lindex2(in[atoi(lindex(temp,1))],0),"r");
   if(fpa==NULL || fileno(fpa)<0) lasterror=107;
   result=0;
   for(i=0;fgets(temp4,255,fpa)!=NULL;i++)
    if(i==atoi(in[atoi(lindex(temp,2))])) { result=1; break; }
   if(result==0) lasterror=121;
   strcpy(in[atoi(lindex(temp,3))],temp4);
   if(inputchop) in[atoi(lindex(temp,3))][strlen(in[atoi(lindex(temp,3))])-1]=' ';
   if(fpa!=NULL) fclose(fpa);
  }
  else if(!strcasecmp(lindex(temp,0),"dump"))
  {
   fpa=fopen(lindex2(in[atoi(lindex(temp,1))],0),"r");
   if(fpa==NULL || fileno(fpa)<0) lasterror=107;
   while((cnt = read(fileno(fpa), temp4, 250))>0)
    write(sockfd, temp4, cnt);
   if(fpa!=NULL) fclose(fpa);
  }
  else if(!strcasecmp(lindex(temp,0),"gui"))
  {
#ifdef GTK
   strcpy(queryGlVar,"(null)");
   custom_gui(in);
   if(strcasecmp(queryGlVar,"(null)")) sprintf(in[atoi(lindex(queryGlVar,1))],"%s %s",lindex2(queryGlVar,0),lrange(queryGlVar,2));
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"devstat"))
  {
   strcpy(in[atoi(lindex(temp,2))],if_setup(lindex(temp,1)));
  }
  else if(!strcasecmp(lindex(temp,0),"expr"))
  {
   if(!strcasecmp(lindex(temp,2),"+"))
   sprintf(in[atoi(lindex(temp,5))],"%ld",(atol(in[atoi(lindex2(temp,1))])+atol(in[atoi(lindex(temp,3))])));
   if(!strcasecmp(lindex(temp,2),"-"))
   sprintf(in[atoi(lindex(temp,5))],"%ld",(atol(in[atoi(lindex2(temp,1))])-atol(in[atoi(lindex(temp,3))])));
   if(!strcasecmp(lindex(temp,2),"*"))
   sprintf(in[atoi(lindex(temp,5))],"%ld",(atol(in[atoi(lindex2(temp,1))])*atol(in[atoi(lindex(temp,3))])));
   if(!strcasecmp(lindex(temp,2),"/"))
   sprintf(in[atoi(lindex(temp,5))],"%ld",(atol(in[atoi(lindex2(temp,1))])/atol(in[atoi(lindex(temp,3))])));
  }
  else if(!strcasecmp(lindex(temp,0),"firewall"))
  {
   firewall();
  }
  else if(!strcasecmp(lindex(temp,0),"wordlenght"))
  {
   for(i=0;lindex(in[atoi(lindex2(temp,1))],i)!=NULL;i++) { }
   sprintf(in[atoi(lindex(temp,2))],"%d",i);
  }
  else if(!strcasecmp(lindex(temp,0),"wordlength"))
  {
   for(i=0;lindex(in[atoi(lindex2(temp,1))],i)!=NULL;i++) { }
   sprintf(in[atoi(lindex(temp,2))],"%d",i);
  }
  else if(!strcasecmp(lindex(temp,0),"varlenght"))
  {
   if(lindex(in[atoi(lindex2(temp,1))],0)==NULL)
   strcpy(in[atoi(lindex(temp,2))],"0");
   else
   sprintf(in[atoi(lindex(temp,2))],"%d",strlen(lindex2(in[atoi(lindex(temp,1))],0)));
  }
  else if(!strcasecmp(lindex(temp,0),"procinfo"))
  {
   strncpy(in[atoi(lindex(temp,1))],procinfo(lindex2(temp,2)),512);
  }
  else if(!strcasecmp(lindex(temp,0),"sysinfo"))
  {
   strcpy(in[atoi(lindex(temp,1))],(char *)info(0));
  }
  else if(!strcasecmp(lindex(temp,0),"draw"))
  {
   draw(in);
  }
  else if(!strcasecmp(lindex(temp,0),"math"))
  {
   math_fct(in);
  }
  else if(!strcasecmp(lindex(temp,0),"password"))
  {
   password(in);
  }
  else if(!strcasecmp(lindex(temp,0),"constat"))
  {
   strcpy(in[atoi(lindex(temp,2))],(char *)constat(lindex(temp,1),sockfd));
  }
  else if(!strcasecmp(lindex(temp,0),"parse"))
  {
   if(!strcasecmp(lindex(temp,1),"<<"))
   {
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    {
     if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3)) break;
     in[atoi(lindex(temp,2))][i]=' ';
    }
   }
   if(!strcasecmp(lindex(temp,1),"<"))
   {
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    {
     if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3)) break;
     in[atoi(lindex(temp,2))][i]=' ';
    }
    in[atoi(lindex(temp,2))][i]=' ';
   }
   if(!strcasecmp(lindex(temp,1),">"))
   {
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    { if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3)) break; }
    for(i=i;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    { in[atoi(lindex(temp,2))][i]=' '; }
   }
   if(!strcasecmp(lindex(temp,1),">>"))
   {
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    { if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3)) break; }
    i++;
    for(i=i;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    { in[atoi(lindex(temp,2))][i]=' '; }
   } 
   if(!strcasecmp(lindex(temp,1),"!"))
   {
    strcpy(temp4,"");
    for(i=0;lindex(in[atoi(lindex2(temp,2))],i)!=NULL;i++)
    {
     strcat(temp4,lindex(in[atoi(lindex2(temp,2))],i));
    }
    strcpy(in[atoi(lindex2(temp,2))],temp4);
   }
   if(!strcasecmp(lindex(temp,1),"_>"))
   {
    j=0;
    bzero(inall, 1024);
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    {
     inall[j]=in[atoi(lindex(temp,2))][i];
     j++;
     if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3))
     {
      inall[j]=' ';
      j++;
     }
    }
    strncpy(in[atoi(lindex(temp,2))],inall,511);
   }
   if(!strcasecmp(lindex(temp,1),"<_"))
   {
    j=0;
    bzero(inall, 1024);
    for(i=0;(char)in[atoi(lindex(temp,2))][i]!=(char)NULL;i++)
    {
     if(in[atoi(lindex(temp,2))][i]==*lindex(temp,3))
     {
      inall[j]=' ';
      j++;
     }
     inall[j]=in[atoi(lindex(temp,2))][i];
     j++;
    }
    strncpy(in[atoi(lindex(temp,2))],inall,511);
   }
   if(!strcasecmp(lindex(temp,1),"%"))
   {
    bzero(buf, 1024);
    strcpy(buf,"");
    for(i=0;lindex(in[atoi(lindex2(temp,2))],i)!=NULL;i++)
    {
     if(match(lindex2(temp,3),lindex(in[atoi(lindex2(temp,2))],i)))
     { strcat(buf,lindex(in[atoi(lindex2(temp,2))],i)); strcat(buf," "); }
    }
    strncpy(in[atoi(lindex2(temp,2))],buf,512);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"cl"))
  {
  /* these are only examples. The CL function has been made for people
     to be able to quickly add Custom Libraries without messing with the
     code too much. See the docs. */
   if(!strcasecmp(lindex(temp,1),"gui-tk"))
   {
    gui_tk_cl(sockfd,in);
   }
   else if(!strcasecmp(lindex(temp,1),"utils"))
   {
    utils_cl(sockfd,in);
   }
   else if(!strcasecmp(lindex(temp,1),"ssdb"))
   {
    ssdb_cl(sockfd,in);
   }
   else if(!strcasecmp(lindex(temp,1),"ssdb2"))
   {
    ssdb2_cl(in);
   }
/* ---------------------------------------------------------------- */
/* *****        CUSTOM LIBRARIES SHOULD BE ADDED HERE        ****** */
/* ---------------------------------------------------------------- */
   else
   {
    for(i=0;lindex(include_files[i],0)!=NULL;i++)
    {
     if(!strcasecmp(lindex(include_files[i],0),lindex2(temp,1)))
     {
      sprintf(temp4,"%s %s",lindex(include_files[i],1),temp);
      system(temp4);
     }
    }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"ping"))
  {
   othersck=socket(AF_INET, SOCK_STREAM, 0);
   if(othersck<0) lasterror=109;
   other_addr.sin_family = AF_INET;
   other_addr.sin_addr.s_addr = inet_addr(lindex(temp,1));
   other_addr.sin_port = htons(7);
   if(connect(othersck, (struct sockaddr*) &other_addr,sizeof(other_addr))<0) lasterror=110;
   temp3=write(othersck,"ping\n",strlen("ping\n"));
   temp3=read(othersck,temp4,temp3);
   close(othersck);
  }
  else if(!strcasecmp(lindex(temp,0),"test"))
  {
   if((othersck=socket(AF_INET, SOCK_STREAM, 0))<0)
   {
    sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
    lasterror=109;
   }
   other_addr.sin_family = AF_INET;
   other_addr.sin_addr.s_addr = inet_addr(lindex2(in[atoi(lindex(temp,1))],0));
   other_addr.sin_port = htons(atoi(lindex2(in[atoi(lindex(temp,1))],1)));
   if(connect(othersck, (struct sockaddr*)&other_addr,sizeof(other_addr))==-1)
   {
    sprintf(in[atoi(lindex(temp,1))],"CONNECT FAILED: %s",strerror(errno));
    lasterror=110;
   }
   else strcpy(in[atoi(lindex(temp,1))],"0");
   close(othersck);
  }
  else if(!strcasecmp(lindex(temp,0),"rdisconnect"))
  {
   shutdown(rsck,2);
   close(rsck);
  }
  else if(!strcasecmp(lindex(temp,0),"rconnect"))
  {
   if((rsck=socket(AF_INET, SOCK_STREAM, 0))<0)
   {
    sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
    lasterror=109;
   }
   r_addr.sin_family = AF_INET;
   r_addr.sin_addr.s_addr = inet_addr(lindex2(in[atoi(lindex(temp,1))],0));
   r_addr.sin_port = htons(atoi(lindex2(in[atoi(lindex(temp,1))],1)));
   if(connect(rsck, (struct sockaddr*)&r_addr,sizeof(r_addr))==-1)
   {
    sprintf(in[atoi(lindex(temp,1))],"CONNECT FAILED: %s",strerror(errno));
    lasterror=110;
   }
   else strcpy(in[atoi(lindex(temp,1))],"0");
  }
  else if(!strcasecmp(lindex(temp,0),"rread"))
  {
   bzero(in[atoi(lindex(temp,1))], 512);
   for(i=0;(result=read(rsck,&inchar,1))!='\0';i++)
   {
    in[atoi(lindex(temp,1))][i]=inchar;
    if(inchar=='\n') break;
    if(i==510)
    { in[atoi(lindex(temp,1))][511]='\0'; lasterror=123; break; }
   }
   if(result==0) lasterror=122;   
   if (chop) in[atoi(lindex(temp,1))][i-1]=' ';
   in[atoi(lindex(temp,1))][i]=' ';
   if(lindex(in[atoi(lindex2(temp,1))],0)==NULL) strcpy(in[atoi(lindex2(temp,1))],"<NO-STRING>");
  }
  else if(!strcasecmp(lindex(temp,0),"rwrite"))
  {
   bzero(buf,1024);
   strcpy(buf,"");
   if(rsck<1) lasterror=111;
   for(i=0;lindex(in[atoi(lindex2(temp,1))],i)!=NULL;i++)
   {
    if(reversechop) strcat(buf," ");
    strcat(buf,lindex(in[atoi(lindex2(temp,1))],i));
    if(!reversechop) strcat(buf," ");
   }
   if(!strictwrite)
   {
    if(windows) strcat(buf,"\r\n");
    else strcat(buf,"\n");
   }  
   else buf[strlen(buf)-1]='\n';
   if(goto_on) goto_on=0; else
   write(rsck, buf, strlen(buf));
   if(debug) printf(">>> %s\n",buf);
  }
  else if(!strcasecmp(lindex(temp,0),"include"))
  {
   for(i=0;lindex(include_files[i],0)!=NULL;i++) { }
   sprintf(include_files[i],"%s %s ;",lindex(temp,1),lindex2(temp,2));
  }
  else if(!strcasecmp(lindex(temp,0),"require-gui"))
  {
#ifndef GUI
   if(lang==0)
   printf("This script needs SScript to be compiled as a graphical application (GUI).\n");
   else if(lang==1)
   printf("Ce script a besoin que SScript soit compile comme application graphique.\n");
   else if(lang==2)
   printf("Este Script necesita SScript paea ser compilado como aplicacion grafica (GUI).\n");
   exit(1);
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"require"))
  {
   if(atoi(lindex(temp,1)) > VERSION)
   {
#ifdef GUI
    if(lang==0)
    msgbox("error","This script requires a newer Socket Script version. You can find the latest SScript at http://devplanet.fastethernet.net/sscript.html",120); 
    else if(lang==1)
    msgbox("error","Ce script a besoin d'une version de Socket Script plus recente. Vous pouvez en trouver une a http://devplanet.fastethernet.net/sscript.html",120);
    else if(lang==2)
    msgbox("error","Este script necesita una version nueva de Socket Script. Puedes encontrar la mas nueva en http://devplanet.fastethernet.net/sscript.html",120);
#else
    if(lang==0)
    printf("This script requires a newer Socket Script version. You can find the latest SScript at http://devplanet.fastethernet.net/sscript.html\n");
    else if(lang==1)
    printf("Ce script a besoin d'une version de Socket Script plus recente. Vous pouvez en trouver une a http://devplanet.fastethernet.net/sscript.html\n");
    else if(lang==2)
    printf("Este script necesita una version nueva de Socket Script. Puedes encontrar la mas nueva en http://devplanet.fastethernet.net/sscript.html\n");
#endif
    exit(1);
   } 
  }
  else if(!strcasecmp(lindex(temp,0),"version"))
  {
   if(lang==0)
   printf("SScript v1.14 by Drow <drow@wildstar.net>\n");
   else if(lang==1)
   printf("SScript v1.14 par Drow <drow@wildstar.net>\n");
   else if(lang==2)
   printf("SScript v1.14 por Drow <drow@wildstar.net>\n");
  }
  else if(!strcasecmp(lindex(temp,0),"addlog"))
  {
   sprintf(temp4,"[%ld] %s\n",time(NULL),in[atoi(lindex(temp,1))]);
   appendlog(temp4);
  }
  else if(!strcasecmp(lindex(temp,0),"udpsend"))
  {
   udp_send(in);
  }
  else if(!strcasecmp(lindex(temp,0),"udplisten"))
  {
   udp_listen(in);
  }
  else if(!strcasecmp(lindex(temp,0),"icmplisten"))
  {
   icmp_detect(in);
  }
  else if(!strcasecmp(lindex(temp,0),"users"))
  {
   users(in);
  }
  else if(!strcasecmp(lindex(temp,0),"resolve"))
  {
   resolve(in);
  }
  else if(!strcasecmp(lindex(temp,0),"raw"))
  {
#ifdef RAWLINUX
   raw_linux(in,1);
#else
   lasterror=112;
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"rawp"))
  {
#ifdef RAWLINUX   
   raw_linux(in,0);
#else
   lasterror=112;
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"timeout"))
  {
   strncpy(in[atoi(lindex2(temp,2))], timeread(sockfd, atoi(lindex(temp,1))), 512);
  }
  else if(!strcasecmp(lindex(temp,0),"read"))
  {
   bzero(in[atoi(lindex(temp,1))], 512);
   for(i=0;(result=read(sockfd,&inchar,1))!='\0';i++)
   {
    in[atoi(lindex(temp,1))][i]=inchar;
    if(inchar=='\n') break;
    if(i==510)
    { in[atoi(lindex(temp,1))][511]='\0'; lasterror=123; break; }
   }
   if(result==0) lasterror=122;
   if(setremoteecho) write(sockfd,in[atoi(lindex(temp,1))],sizeof(in[atoi(lindex(temp,1))]));
   if (chop) in[atoi(lindex(temp,1))][i-1]=' ';
   in[atoi(lindex(temp,1))][i]=' ';
#ifdef HANDLE_EMPTY_STRINGS
   /* to prevent SIGSEVG on empty input */
   if(strlen(in[atoi(lindex(temp,1))])<3)
   {
    strcpy(in[atoi(lindex(temp,1))],"<NO-STRING>");
   }
   if(lindex2(in[atoi(lindex(temp,1))],0)==NULL)
   {
    strcpy(in[atoi(lindex(temp,1))],"<NO-STRING>");
   }
#endif
   if(strictcheck)
   {
    if(!strcasecmp(in[atoi(lindex(temp,1))],"") || !strcasecmp(in[atoi(lindex(temp,1))],"\n") || !strcasecmp(in[atoi(lindex(temp,1))],"\0"))
    {
     strcpy(in[atoi(lindex(temp,1))],"<NO-STRING>");
    }
   }
   if(!result && server_oriented)
   { 
    sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
    appendlog(temp4);         
    shutdown(sockfd,2);
    close(sockfd);
    if(strcasecmp(cron,"")) system(cron);
    exit(0);
   }
   if(debug) printf("[%d] [%s]\n",atoi(lindex(temp,1)),in[atoi(lindex(temp,1))]);
   if(userhost)
   {
    if(lindex(in[atoi(lindex(temp,1))],0)!=NULL) strcpy(temp4,lindex(in[atoi(lindex(temp,1))],0));
    bzero(nick,255);
    bzero(user,255);
    strcpy(nick,"");
    strcpy(user,"");
    if(is_a_service)
    {
     strcpy(nick,temp4);
     nick[0]=' ';
    }
    if(strchr(temp4,'!')!=NULL)
    {
     j=0;
     for(i=1;temp4[i]!='!';i++)
     {
      nick[j]=temp4[i];
      j++;
     }
     j=0;
     for(i=(i+1);(char)temp4[i]!=(char)NULL;i++)
     {
      user[j]=temp4[i];
      j++;
     }
    }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"saveall"))
  {
   fpa=fopen(lindex(temp,1),"a");
   if(fpa==NULL || fileno(fpa)<0) lasterror=103;
   while(strcasecmp(inall," "))
   {
    bzero(inall, 1024);
    for(i=0;read(sockfd,&inchar,1)!='\0';i++)
    {
     inall[i]=inchar;
     if(inchar=='\n') break;
    }
    if (chop) inall[i-1]=' ';
    inall[i]=' ';
    if(debug) printf("[%d] [%s]\n",atoi(lindex(temp,1)),inall);
    fputs(inall,fpa);
    fputs("\n",fpa);
   }
   if(fpa!=NULL) fclose(fpa);
  }
  else if(!strcasecmp(lindex(temp,0),"sleep"))
  {
   sleep(atoi(lindex(temp,1)));
  }
  else if(!strcasecmp(lindex(temp,0),"wait")) sleep(1);
  else if(!strcasecmp(lindex(temp,0),"ifmaster"))
  {
   if(!strcasecmp(lindex(temp,3),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,2)))))
   {
    fpa=fopen(master,"r");
    while(fgets(temp2,255,fpa)!=NULL)
    {
     if(!match(lindex2(temp2,0),lindex(in[atoi(lindex(temp,1))],0)))
     {
      bzero(buf,1024);
      strcpy(buf,"");
      for(i=4;lindex(temp,i)!=NULL;i++)
      {
       if(reversechop) strcat(buf," ");
       if(*lindex(temp,i)=='$')
       {
        if(*(lindex(temp,i)+1)=='w')
        {
         i++;
         if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
         strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
         i++;
        }
        if(*(lindex(temp,i)+1)=='1') { sleep(1); }
        if(*(lindex(temp,i)+1)=='2') { sleep(2); }
        if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
        if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
        if(*(lindex(temp,i)+1)=='/')
        {
         i++;
         if(*(lindex(temp,i))=='0') strcat(buf,"\000");
         if(*(lindex(temp,i))=='1') strcat(buf,"\001");
         if(*(lindex(temp,i))=='2') strcat(buf,"\002");
         if(*(lindex(temp,i))=='3') strcat(buf,"\003");
         if(*(lindex(temp,i))=='4') strcat(buf,"\004");
         if(*(lindex(temp,i))=='5') strcat(buf,"\005");
         if(*(lindex(temp,i))=='6') strcat(buf,"\006");
         if(*(lindex(temp,i))=='7') strcat(buf,"\007");
         if(*(lindex(temp,i))=='8') strcat(buf,"\008");
         if(*(lindex(temp,i))=='9') strcat(buf,"\009");
        }
        if(*(lindex(temp,i)+1)=='p') 
        { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
        if(*(lindex(temp,i)+1)=='t')
        {
         lt=time(NULL);
         strcpy(temp4,ctime(&lt));
         temp4[strlen(temp4)-1]=' ';
         strcat(buf,temp4);
        }
        if(*(lindex(temp,i)+1)=='r')
        {
         if(fp!=NULL) fclose(fp);
         fp=fopen(lindex(temp,1),"r");
        }
        if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
        if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
        if(*(lindex(temp,i)+1)=='3') { sleep(3); }
        if(*(lindex(temp,i)+1)=='%')              
        {
         sprintf(temp4,"%d",current_for);
         strcat(buf,temp4);
        }
        if(*(lindex(temp,i)+1)=='4') { sleep(4); }
        if(*(lindex(temp,i)+1)=='g')
        {
         strcpy(subnumber,lindex(temp,(i+1)));
         if(fp!=NULL) fclose(fp);
         fp=fopen(filename,"r");
         while(fgets(temp,255,fp)!=NULL)
         { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
         pain_in_the=1;
         goto_on = 1;
         break;
        }
        if(*(lindex(temp,i)+1)=='5') { sleep(5); }
        if(*(lindex(temp,i)+1)=='6') { sleep(6); }
        if(*(lindex(temp,i)+1)=='7') { sleep(7); }
        if(*(lindex(temp,i)+1)=='8') { sleep(8); }
        if(*(lindex(temp,i)+1)=='i')
        {    
         i++;
         fpa=fopen(lindex(temp,i),"r");
         strcpy(temp2,"");
         for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
          fgets(temp2,255,fpa);
         strcat(buf,temp2);
         if(fpa!=NULL) fclose(fpa); 
         i++;
        }
        if(*(lindex(temp,i)+1)=='9') { sleep(9); }
        if(*(lindex(temp,i)+1)=='n')
        {
         strcat(buf,nick);
        }
        if(*(lindex(temp,i)+1)=='u')
        {
         strcat(buf,user);
        }
        if(*(lindex(temp,i)+1)=='e')
        {
         sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
         appendlog(temp4);         
         shutdown(sockfd,2);
         close(sockfd);
         if(strcasecmp(cron,"")) system(cron);
         exit(0);
        }
        if(*(lindex(temp,i)+1)=='b')
        {
         goto_on = 1;
         loop = 0;
        }
        if(*(lindex(temp,i)+1)=='s')
        {
         i++;
         strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
         i++;
        }
       } 
       else
       {   
        strcat(buf,lindex(temp,i));
       }
       if(!reversechop) strcat(buf," ");
      }
      strcat(buf,"\n");
      if(goto_on) goto_on=0; else
      write(sockfd, buf, strlen(buf));
      if(debug) printf(">>> %s\n",buf);
     }
     if(pain_in_the) { pain_in_the=0; break; }
    }  
   if(fpa!=NULL) fclose(fpa);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"ifmaster2"))
  {
   if(!strcasecmp(lindex(temp,3),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,2)))))
   {   
    if(!strcasecmp(lindex(temp,5),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,4)))))
    {
     fpa=fopen(master,"r");
     while(fgets(temp2,255,fpa)!=NULL)
     {
      if(!match(lindex2(temp2,0),lindex(in[atoi(lindex(temp,1))],0)))
      {
       bzero(buf,1024);
       strcpy(buf,"");
       for(i=6;lindex(temp,i)!=NULL;i++)
       {
        if(reversechop) strcat(buf," ");
        if(*lindex(temp,i)=='$')
        {
         if(*(lindex(temp,i)+1)=='w')
         {
          i++;
          if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
          strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
          i++;
         }
         if(*(lindex(temp,i)+1)=='1') { sleep(1); }
         if(*(lindex(temp,i)+1)=='2') { sleep(2); }
         if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
         if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
         if(*(lindex(temp,i)+1)=='/')
         {
          i++;
          if(*(lindex(temp,i))=='0') strcat(buf,"\000");
          if(*(lindex(temp,i))=='1') strcat(buf,"\001");
          if(*(lindex(temp,i))=='2') strcat(buf,"\002");
          if(*(lindex(temp,i))=='3') strcat(buf,"\003");
          if(*(lindex(temp,i))=='4') strcat(buf,"\004");
          if(*(lindex(temp,i))=='5') strcat(buf,"\005");
          if(*(lindex(temp,i))=='6') strcat(buf,"\006");
          if(*(lindex(temp,i))=='7') strcat(buf,"\007");
          if(*(lindex(temp,i))=='8') strcat(buf,"\008");
          if(*(lindex(temp,i))=='9') strcat(buf,"\009");
         }
         if(*(lindex(temp,i)+1)=='p') 
         { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
         if(*(lindex(temp,i)+1)=='t')
         {
          lt=time(NULL);
          strcpy(temp4,ctime(&lt));
          temp4[strlen(temp4)-1]=' ';
          strcat(buf,temp4);
         }
         if(*(lindex(temp,i)+1)=='r')
         {
          if(fp!=NULL) fclose(fp);
          fp=fopen(lindex(temp,1),"r");
         }
         if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
         if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
         if(*(lindex(temp,i)+1)=='3') { sleep(3); }
         if(*(lindex(temp,i)+1)=='%')              
         {
          sprintf(temp4,"%d",current_for);
          strcat(buf,temp4);
         }
         if(*(lindex(temp,i)+1)=='4') { sleep(4); }
         if(*(lindex(temp,i)+1)=='5') { sleep(5); }
         if(*(lindex(temp,i)+1)=='g')
         {
          strcpy(subnumber,lindex(temp,(i+1)));
          if(fp!=NULL) fclose(fp);
          fp=fopen(filename,"r");
          while(fgets(temp,255,fp)!=NULL)
          { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
          pain_in_the=1;
          goto_on = 1;
          break;
         }
         if(*(lindex(temp,i)+1)=='6') { sleep(6); }
         if(*(lindex(temp,i)+1)=='i')
         {    
          i++;
          fpa=fopen(lindex(temp,i),"r");
          strcpy(temp2,"");
          for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
           fgets(temp2,255,fpa);
          strcat(buf,temp2);
          if(fpa!=NULL) fclose(fpa); 
          i++;
         }
         if(*(lindex(temp,i)+1)=='7') { sleep(7); }
         if(*(lindex(temp,i)+1)=='8') { sleep(8); }
         if(*(lindex(temp,i)+1)=='9') { sleep(9); }
         if(*(lindex(temp,i)+1)=='e')
         {
          sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
          appendlog(temp4);         
          shutdown(sockfd,2);
          close(sockfd);
          if(strcasecmp(cron,"")) system(cron);
          exit(0);
         }
         if(*(lindex(temp,i)+1)=='n')
         {
          strcat(buf,nick);
         }
         if(*(lindex(temp,i)+1)=='u')
         {
          strcat(buf,user);
         }
         if(*(lindex(temp,i)+1)=='b')
         {
          goto_on = 1;
          loop = 0;
         }
         if(*(lindex(temp,i)+1)=='s')
         {
          i++;
          strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
          i++;
         }
        } 
        else
        {   
         strcat(buf,lindex(temp,i));
        } 
        if(!reversechop) strcat(buf," ");
       }
       strcat(buf,"\n");
       if(goto_on) goto_on=0; else
       write(sockfd, buf, strlen(buf));
       if(debug) printf(">>> %s\n",buf);
      }
     if(pain_in_the) { pain_in_the=0; break; }
     }
    if(fpa!=NULL) fclose(fpa);
    }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"msgbox"))
  {
#ifdef GUI
   msgbox("info",in[atoi(lindex(temp,1))],strlen(in[atoi(lindex(temp,1))]));
#else
   lasterror=105;
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"textbox"))
  {
#ifdef GUI
   textview(lindex(temp,1),argc,argv);
#else
   lasterror=105;
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"viewfile"))
  {
#ifdef GUI
   if(lindex(temp,2)==NULL || strcasecmp(lindex(temp,2),"-query"))
    viewfile(lindex(temp,1),argc,argv);
   else
   {
    view_n_query(lindex(temp,1),in[atoi(lindex(temp,3))],argc,argv);  
    strcpy(in[atoi(lindex(temp,3))],queryGlVar);
   }
#else
   lasterror=105;
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"query"))
  {
#ifdef GUI
   query(in[atoi(lindex(temp,1))]);
   strcpy(in[atoi(lindex(temp,2))],queryGlVar);
#else
   lasterror=105;
#endif
  }
  else if(!strcasecmp(lindex(temp,0),"rawprint"))
  {
   printf("%s",lrange(temp,1));
   fflush(stdout);
  }
  else if(!strcasecmp(lindex(temp,0),"print"))
  {
   bzero(buf,1024);
   strcpy(buf,"");
   for(i=1;lindex(temp,i)!=NULL;i++)
   {
    if(reversechop) strcat(buf," ");
    if(*lindex(temp,i)=='$')
    {
     if(*(lindex(temp,i)+1)=='w')
     {
      i++;
      if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
      strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
     if(*(lindex(temp,i)+1)=='n')
     {
      strcat(buf,nick);
     }
     if(*(lindex(temp,i)+1)=='1') { sleep(1); }
     if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
     if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
     if(*(lindex(temp,i)+1)=='/')
     {
      i++;
      if(*(lindex(temp,i))=='0') strcat(buf,"\000");
      if(*(lindex(temp,i))=='1') strcat(buf,"\001");
      if(*(lindex(temp,i))=='2') strcat(buf,"\002");
      if(*(lindex(temp,i))=='3') strcat(buf,"\003");
      if(*(lindex(temp,i))=='4') strcat(buf,"\004");
      if(*(lindex(temp,i))=='5') strcat(buf,"\005");
      if(*(lindex(temp,i))=='6') strcat(buf,"\006");
      if(*(lindex(temp,i))=='7') strcat(buf,"\007");
      if(*(lindex(temp,i))=='8') strcat(buf,"\008");
      if(*(lindex(temp,i))=='9') strcat(buf,"\009");
     }
     if(*(lindex(temp,i)+1)=='p') 
     { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
     if(*(lindex(temp,i)+1)=='t')
     {
      lt=time(NULL);
      strcpy(temp4,ctime(&lt));
      temp4[strlen(temp4)-1]=' ';
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='r')
     {
      if(fp!=NULL) fclose(fp);
      fp=fopen(lindex(temp,1),"r");
     }
     if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
     if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
     if(*(lindex(temp,i)+1)=='%')              
     {
      sprintf(temp4,"%d",current_for);
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='2') { sleep(2); }
     if(*(lindex(temp,i)+1)=='3') { sleep(3); }
     if(*(lindex(temp,i)+1)=='4') { sleep(4); }
     if(*(lindex(temp,i)+1)=='g')
     {
      strcpy(subnumber,lindex(temp,(i+1)));
      if(fp!=NULL) fclose(fp);
      fp=fopen(filename,"r");
      while(fgets(temp,255,fp)!=NULL)
      { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
      goto_on = 1;
      break;
     }
     if(*(lindex(temp,i)+1)=='5') { sleep(5); }
     if(*(lindex(temp,i)+1)=='6') { sleep(6); }
     if(*(lindex(temp,i)+1)=='i')
     {
      i++;
      fpa=fopen(lindex(temp,i),"r");
      strcpy(temp2,"");
      for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
       fgets(temp2,255,fpa);
      strcat(buf,temp2);
      if(fpa!=NULL) fclose(fpa); 
      i++;
     }
     if(*(lindex(temp,i)+1)=='7') { sleep(7); }
     if(*(lindex(temp,i)+1)=='8') { sleep(8); }
     if(*(lindex(temp,i)+1)=='9') { sleep(9); }
     if(*(lindex(temp,i)+1)=='u')
     {
      strcat(buf,user);
     }
     if(*(lindex(temp,i)+1)=='e')
     {
      sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
      appendlog(temp4);         
      shutdown(sockfd,2);
      close(sockfd);
      if(strcasecmp(cron,"")) system(cron);
      exit(0);
     }
     if(*(lindex(temp,i)+1)=='b')
     {
      goto_on = 1;
      loop = 0;
     }
     if(*(lindex(temp,i)+1)=='s')
     {
      i++;
      strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
    }   
    else
    {
     strcat(buf,lindex(temp,i));
    }
    if(!reversechop) strcat(buf," ");
   }
   printf("%s\n",buf);
  }
  else if(!strcasecmp(lindex(temp,0),"setreversechop"))
  {
   reversechop = 1;
  }
  else if(!strcasecmp(lindex(temp,0),"write"))
  {
   bzero(buf,1024);
   strcpy(buf,""); 
   if(sockfd<1) lasterror=111;
   for(i=1;lindex(temp,i)!=NULL;i++)
   {
    if(reversechop) strcat(buf," ");
    if(*lindex(temp,i)=='$')
    {
     if(*(lindex(temp,i)+1)=='w')
     {
      i++;
      if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
      strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
     if(*(lindex(temp,i)+1)=='n')
     {
      strcat(buf,nick);
     }
     if(*(lindex(temp,i)+1)=='1') { sleep(1); }
     if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
     if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
     if(*(lindex(temp,i)+1)=='/')
     {
      i++;
      if(*(lindex(temp,i))=='0') strcat(buf,"\000");
      if(*(lindex(temp,i))=='1') strcat(buf,"\001");
      if(*(lindex(temp,i))=='2') strcat(buf,"\002");
      if(*(lindex(temp,i))=='3') strcat(buf,"\003");
      if(*(lindex(temp,i))=='4') strcat(buf,"\004");
      if(*(lindex(temp,i))=='5') strcat(buf,"\005");
      if(*(lindex(temp,i))=='6') strcat(buf,"\006");
      if(*(lindex(temp,i))=='7') strcat(buf,"\007");
      if(*(lindex(temp,i))=='8') strcat(buf,"\008");
      if(*(lindex(temp,i))=='9') strcat(buf,"\009");
     }
     if(*(lindex(temp,i)+1)=='p') 
     { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
     if(*(lindex(temp,i)+1)=='t')
     {
      lt=time(NULL);
      strcpy(temp4,ctime(&lt));
      temp4[strlen(temp4)-1]=' ';
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='r')
     {
      if(fp!=NULL) fclose(fp);
      fp=fopen(lindex(temp,1),"r");
     }
     if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
     if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
     if(*(lindex(temp,i)+1)=='%')              
     {
      sprintf(temp4,"%d",current_for);
      strcat(buf,temp4);
     }
     if(*(lindex(temp,i)+1)=='2') { sleep(2); }
     if(*(lindex(temp,i)+1)=='3') { sleep(3); }
     if(*(lindex(temp,i)+1)=='4') { sleep(4); }
     if(*(lindex(temp,i)+1)=='g')
     {
      strcpy(subnumber,lindex(temp,(i+1)));
      if(fp!=NULL) fclose(fp);
      fp=fopen(filename,"r");
      while(fgets(temp,255,fp)!=NULL)
      { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
      goto_on = 1;
      break;
     }
     if(*(lindex(temp,i)+1)=='5') { sleep(5); }
     if(*(lindex(temp,i)+1)=='6') { sleep(6); }
     if(*(lindex(temp,i)+1)=='i')
     {    
      i++;
      fpa=fopen(lindex(temp,i),"r");
      strcpy(temp2,"");
      for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
       fgets(temp2,255,fpa);
      strcat(buf,temp2);
      if(fpa!=NULL) fclose(fpa); 
      i++;
     }
     if(*(lindex(temp,i)+1)=='7') { sleep(7); }
     if(*(lindex(temp,i)+1)=='8') { sleep(8); }
     if(*(lindex(temp,i)+1)=='9') { sleep(9); }
     if(*(lindex(temp,i)+1)=='u')
     {
      strcat(buf,user);
     }
     if(*(lindex(temp,i)+1)=='e')
     {
      sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
      appendlog(temp4);         
      shutdown(sockfd,2);
      close(sockfd);
      if(strcasecmp(cron,"")) system(cron);
      exit(0);
     }
     if(*(lindex(temp,i)+1)=='b')
     {
      goto_on = 1;
      loop = 0;
     }
     if(*(lindex(temp,i)+1)=='s')
     {
      i++;
      strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
      i++;
     }
    }   
    else
    {
     strcat(buf,lindex(temp,i));
    }
    if(!reversechop) strcat(buf," ");
   }
   if(!strictwrite) 
   {
    if(windows) strcat(buf,"\r\n");
    else strcat(buf,"\n");
   }
   else buf[strlen(buf)-1]='\n';
   if(goto_on) goto_on=0; else
   write(sockfd, buf, strlen(buf));
   if(debug) printf(">>> [%s]\n",buf);
  }
  else if(!strcasecmp(lindex(temp,0),"remoteip"))
  {
   strcpy(in[atoi(lindex(temp,1))],remote_ip);
  }
  else if(!strcasecmp(lindex(temp,0),"?match"))
  {
   if(lindex(in[atoi(lindex(temp,1))],0)!=NULL && lindex2(in[atoi(lindex(temp,2))],0)!=NULL)
   if(!match(lindex(in[atoi(lindex(temp,1))],0),lindex2(in[atoi(lindex(temp,2))],0)))
   {
    strcpy(subnumber,lindex(temp,(3)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
     { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"!match"))
  { 
   if(lindex(in[atoi(lindex(temp,1))],0)!=NULL && lindex2(in[atoi(lindex(temp,2))],0)!=NULL)
   if(match(lindex(in[atoi(lindex(temp,1))],0),lindex2(in[atoi(lindex(temp,2))],0)))
   {
    strcpy(subnumber,lindex(temp,(3)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
     { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"?compare")) 
  {
   if(lindex(in[atoi(lindex(temp,1))],0)!=NULL && lindex2(in[atoi(lindex(temp,2))],0)!=NULL)
   if(!strcasecmp(lindex(in[atoi(lindex(temp,1))],0),lindex2(in[atoi(lindex(temp,2))],0)))
   {
    strcpy(subnumber,lindex(temp,(3)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
     { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"?compareword"))
  {
   i = atoi(lindex(temp,2));
   j = atoi(lindex(temp,4));
   if(!strcasecmp(lindex(in[atoi(lindex(temp,1))],i),lindex2(in[atoi(lindex(temp,3))],j)))
   {
    strcpy(subnumber,lindex(temp,5));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
     { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"!compareword"))
  {
   i = atoi(lindex(temp,2));
   j = atoi(lindex(temp,4));
   if(strcasecmp(lindex(in[atoi(lindex(temp,1))],i), lindex2(in[atoi(lindex(temp,3))],j)))
   {
    strcpy(subnumber,lindex(temp,5));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
     { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"!compare"))
  {
   if(lindex(in[atoi(lindex(temp,1))],0)!=NULL && lindex2(in[atoi(lindex(temp,2))],0)!=NULL)
   if(strcasecmp(lindex(in[atoi(lindex(temp,1))],0),lindex2(in[atoi(lindex(temp,2))],0)))
   {
    strcpy(subnumber,lindex(temp,(3)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
     { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"boolean"))
  {
   if(!strcasecmp(lindex(temp,1),"TRUE")) bool_val = 1;
   if(!strcasecmp(lindex(temp,1),"1")) bool_val = 1;
   if(!strcasecmp(lindex(temp,1),"FALSE")) bool_val = 0;
   if(!strcasecmp(lindex(temp,1),"0")) bool_val = 0;
  }
  else if(!strcasecmp(lindex(temp,0),"iftrue"))
  {
   if(bool_val==1)
   {
    strcpy(subnumber,lindex(temp,1));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"iffalse"))
  {
   if(bool_val==0)
   {
    strcpy(subnumber,lindex(temp,1));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"if"))
  {
   if(!strcasecmp(lindex(temp,2),"="))
   if(atoi(in[atoi(lindex(temp,1))])==atoi(in[atoi(lindex(temp,3))]))
   {
    strcpy(subnumber,lindex(temp,(4)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
   if(!strcasecmp(lindex(temp,2),"=="))
   if(atoi(in[atoi(lindex(temp,1))])==atoi(in[atoi(lindex(temp,3))]))
   {
    strcpy(subnumber,lindex(temp,(4)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
   if(!strcasecmp(lindex(temp,2),"!="))
   if(atoi(in[atoi(lindex(temp,1))])!=atoi(in[atoi(lindex(temp,3))]))
   {
    strcpy(subnumber,lindex(temp,(4)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
   if(!strcasecmp(lindex(temp,2),">"))
   if(atoi(in[atoi(lindex(temp,1))])>atoi(in[atoi(lindex(temp,3))]))
   {
    strcpy(subnumber,lindex(temp,(4)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
   if(!strcasecmp(lindex(temp,2),"<"))
   if(atoi(in[atoi(lindex(temp,1))])<atoi(in[atoi(lindex(temp,3))]))
   {
    strcpy(subnumber,lindex(temp,(4)));
    if(fp!=NULL) fclose(fp);
    fp=fopen(filename,"r");
    while(fgets(temp,255,fp)!=NULL)
    { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
   }
  }
  else if(!strcasecmp(lindex(temp,0),"ifmatch"))
  {
   bzero(matching,1024);
   strcpy(matching,"");
   for(i=0;lindex(in[atoi(lindex(temp,1))],i)!=NULL;i++)
   {
    strcat(matching,lindex(in[atoi(lindex(temp,1))],i));
   }
   if(!match(lindex(temp,2),matching))
   {
    bzero(buf,1024);
    strcpy(buf,"");
    for(i=3;lindex(temp,i)!=NULL;i++)
    {
     if(reversechop) strcat(buf," ");
     if(*lindex(temp,i)=='$')
     {
      if(*(lindex(temp,i)+1)=='w')
      {
       i++;
       if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
       strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
       i++;
      }
      if(*(lindex(temp,i)+1)=='n')
      {
       strcat(buf,nick);
      }
      if(*(lindex(temp,i)+1)=='1') { sleep(1); }
      if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
      if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
      if(*(lindex(temp,i)+1)=='/')
      {
       i++;
       if(*(lindex(temp,i))=='0') strcat(buf,"\000");
       if(*(lindex(temp,i))=='1') strcat(buf,"\001");
       if(*(lindex(temp,i))=='2') strcat(buf,"\002");
       if(*(lindex(temp,i))=='3') strcat(buf,"\003");
       if(*(lindex(temp,i))=='4') strcat(buf,"\004");
       if(*(lindex(temp,i))=='5') strcat(buf,"\005");
       if(*(lindex(temp,i))=='6') strcat(buf,"\006");
       if(*(lindex(temp,i))=='7') strcat(buf,"\007");
       if(*(lindex(temp,i))=='8') strcat(buf,"\008");
       if(*(lindex(temp,i))=='9') strcat(buf,"\009");
      }
      if(*(lindex(temp,i)+1)=='p') 
      { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
      if(*(lindex(temp,i)+1)=='t')
      {
       lt=time(NULL);
       strcpy(temp4,ctime(&lt));
       temp4[strlen(temp4)-1]=' ';
       strcat(buf,temp4);
      }
      if(*(lindex(temp,i)+1)=='r')
      {
       if(fp!=NULL) fclose(fp);
       fp=fopen(lindex(temp,1),"r");
      }
      if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
      if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
      if(*(lindex(temp,i)+1)=='%')              
      {
       sprintf(temp4,"%d",current_for);
       strcat(buf,temp4);
      }
      if(*(lindex(temp,i)+1)=='g')
      {
       strcpy(subnumber,lindex(temp,(i+1)));
       if(fp!=NULL) fclose(fp);
       fp=fopen(filename,"r");
       while(fgets(temp,255,fp)!=NULL)
       { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
       goto_on = 1;
       break;
      }
      if(*(lindex(temp,i)+1)=='2') { sleep(2); }
      if(*(lindex(temp,i)+1)=='i')
      {    
       i++;
       fpa=fopen(lindex(temp,i),"r");
       strcpy(temp2,"");
       for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
        fgets(temp2,255,fpa);
       strcat(buf,temp2);
       if(fpa!=NULL) fclose(fpa); 
       i++;
      }
      if(*(lindex(temp,i)+1)=='3') { sleep(3); }
      if(*(lindex(temp,i)+1)=='4') { sleep(4); }
      if(*(lindex(temp,i)+1)=='5') { sleep(5); }
      if(*(lindex(temp,i)+1)=='6') { sleep(6); }
      if(*(lindex(temp,i)+1)=='7') { sleep(7); }
      if(*(lindex(temp,i)+1)=='e')
      {
       sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
       appendlog(temp4);         
       shutdown(sockfd,2);
       close(sockfd);
       if(strcasecmp(cron,"")) system(cron);
       exit(0);
      }
      if(*(lindex(temp,i)+1)=='8') { sleep(8); }
      if(*(lindex(temp,i)+1)=='9') { sleep(9); }
      if(*(lindex(temp,i)+1)=='u')
      {
       strcat(buf,user);
      }
      if(*(lindex(temp,i)+1)=='b')
      {
       goto_on = 1;
       loop = 0;
      }
      if(*(lindex(temp,i)+1)=='s')
      {
       i++;
       strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
       i++;
      }
     } 
     else
     { 
      strcat(buf,lindex(temp,i));
     }
     if(!reversechop) strcat(buf," ");
    }
    if(windows) strcat(buf,"\r\n");
    else strcat(buf,"\n");
    if(goto_on) goto_on=0; else
    write(sockfd, buf, strlen(buf));
    if(debug) printf(">>> %s\n",buf);
   }  
  }
  else if(!strcasecmp(lindex(temp,0),"ifword")) 
  {
   if(!strcasecmp(lindex(temp,3),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,2)))))
   {
    bzero(buf,1024);
    strcpy(buf,"");
    for(i=4;lindex(temp,i)!=NULL;i++)
    {
     if(reversechop) strcat(buf," ");
     if(*lindex(temp,i)=='$')
     {
      if(*(lindex(temp,i)+1)=='w')
      {
       i++;
       if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
       strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
       i++;
      }
      if(*(lindex(temp,i)+1)=='n')
      {
       strcat(buf,nick);
      }
      if(*(lindex(temp,i)+1)=='1') { sleep(1); }
      if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
      if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
      if(*(lindex(temp,i)+1)=='/')
      {
       i++;
       if(*(lindex(temp,i))=='0') strcat(buf,"\000");
       if(*(lindex(temp,i))=='1') strcat(buf,"\001");
       if(*(lindex(temp,i))=='2') strcat(buf,"\002");
       if(*(lindex(temp,i))=='3') strcat(buf,"\003");
       if(*(lindex(temp,i))=='4') strcat(buf,"\004");
       if(*(lindex(temp,i))=='5') strcat(buf,"\005");
       if(*(lindex(temp,i))=='6') strcat(buf,"\006");
       if(*(lindex(temp,i))=='7') strcat(buf,"\007");
       if(*(lindex(temp,i))=='8') strcat(buf,"\008");
       if(*(lindex(temp,i))=='9') strcat(buf,"\009");
      }
      if(*(lindex(temp,i)+1)=='p') 
      { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
      if(*(lindex(temp,i)+1)=='t')
      {
       lt=time(NULL);
       strcpy(temp4,ctime(&lt));
       temp4[strlen(temp4)-1]=' ';
       strcat(buf,temp4);
      }
      if(*(lindex(temp,i)+1)=='r')
      {
       if(fp!=NULL) fclose(fp);
       fp=fopen(lindex(temp,1),"r");
      }
      if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
      if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
      if(*(lindex(temp,i)+1)=='%')              
      {
       sprintf(temp4,"%d",current_for);
       strcat(buf,temp4);
      }
      if(*(lindex(temp,i)+1)=='g')
      {
       strcpy(subnumber,lindex(temp,(i+1)));
       if(fp!=NULL) fclose(fp);
       fp=fopen(filename,"r");
       while(fgets(temp,255,fp)!=NULL)
       { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
       goto_on = 1;
       break;
      }
      if(*(lindex(temp,i)+1)=='i')
      {    
       i++;
       fpa=fopen(lindex(temp,i),"r");
       strcpy(temp2,"");
       for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
        fgets(temp2,255,fpa);
       strcat(buf,temp2);
       if(fpa!=NULL) fclose(fpa); 
       i++;
      }
      if(*(lindex(temp,i)+1)=='2') { sleep(2); }
      if(*(lindex(temp,i)+1)=='3') { sleep(3); }
      if(*(lindex(temp,i)+1)=='4') { sleep(4); }
      if(*(lindex(temp,i)+1)=='e')
      {
       sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
       appendlog(temp4);
       shutdown(sockfd,2);
       close(sockfd);
       if(strcasecmp(cron,"")) system(cron);
       exit(0);
      }
      if(*(lindex(temp,i)+1)=='5') { sleep(5); }
      if(*(lindex(temp,i)+1)=='6') { sleep(6); }
      if(*(lindex(temp,i)+1)=='7') { sleep(7); }
      if(*(lindex(temp,i)+1)=='8') { sleep(8); }
      if(*(lindex(temp,i)+1)=='9') { sleep(9); }
      if(*(lindex(temp,i)+1)=='u')
      {
       strcat(buf,user);
      }
      if(*(lindex(temp,i)+1)=='b')
      {
       goto_on = 1;
       loop = 0;
      }
      if(*(lindex(temp,i)+1)=='s')
      {
       i++;
       strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
       i++;
      }
     }
     else
     {
      strcat(buf,lindex(temp,i));
     }
     if(!reversechop) strcat(buf," ");
    }
    if(windows) strcat(buf,"\r\n");
    else strcat(buf,"\n");
    if(goto_on) goto_on=0; else
    write(sockfd, buf, strlen(buf));
    if(debug) printf(">>> %s\n",buf);
   }
  }
  else if(!strcasecmp(lindex(temp,0),"ifword2"))
  {
   if(!strcasecmp(lindex(temp,3),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,2)))))
   {
    if(!strcasecmp(lindex(temp,5),lindex2(in[atoi(lindex(temp,1))],atoi(lindex(temp,4)))))
    {
     bzero(buf,1024);
     strcpy(buf,"");
     for(i=6;lindex(temp,i)!=NULL;i++)
     {
      if(reversechop) strcat(buf," ");
      if(*lindex(temp,i)=='$')
      {
       if(*(lindex(temp,i)+1)=='w')
       {
        i++;
        if(lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1)))!=NULL)
        strcat(buf,lindex(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
        i++;
       }
       if(*(lindex(temp,i)+1)=='n')
       {
        strcat(buf,nick);
       }
       if(*(lindex(temp,i)+1)=='u')
       {
        strcat(buf,user);
       }
       if(*(lindex(temp,i)+1)=='1') { sleep(1); }
       if(*(lindex(temp,i)+1)=='$') { strcat(buf,"$"); }
       if(*(lindex(temp,i)+1)=='\\') { strcat(buf,"\002"); }
       if(*(lindex(temp,i)+1)=='/')
       {
        i++;
        if(*(lindex(temp,i))=='0') strcat(buf,"\000");
        if(*(lindex(temp,i))=='1') strcat(buf,"\001");
        if(*(lindex(temp,i))=='2') strcat(buf,"\002");
        if(*(lindex(temp,i))=='3') strcat(buf,"\003");
        if(*(lindex(temp,i))=='4') strcat(buf,"\004");
        if(*(lindex(temp,i))=='5') strcat(buf,"\005");
        if(*(lindex(temp,i))=='6') strcat(buf,"\006");
        if(*(lindex(temp,i))=='7') strcat(buf,"\007");
        if(*(lindex(temp,i))=='8') strcat(buf,"\008");
        if(*(lindex(temp,i))=='9') strcat(buf,"\009");
       }
       if(*(lindex(temp,i)+1)=='p') 
       { sprintf(temp4,"%d",pid); strcat(buf,temp4); }
       if(*(lindex(temp,i)+1)=='t')
       {
        lt=time(NULL);
        strcpy(temp4,ctime(&lt));
        temp4[strlen(temp4)-1]=' ';
        strcat(buf,temp4);
       }
       if(*(lindex(temp,i)+1)=='r')
       {
        if(fp!=NULL) fclose(fp);
        fp=fopen(lindex(temp,1),"r");
       }
       if(*(lindex(temp,i)+1)=='_') { strcat(buf," "); }
       if(*(lindex(temp,i)+1)=='l') { strcat(buf,"\n"); }
       if(*(lindex(temp,i)+1)=='%')              
       {
        sprintf(temp4,"%d",current_for);
        strcat(buf,temp4);
       }
       if(*(lindex(temp,i)+1)=='g')
       {
        strcpy(subnumber,lindex(temp,(i+1)));
        if(fp!=NULL) fclose(fp);
        fp=fopen(filename,"r");
        while(fgets(temp,255,fp)!=NULL)
        { if(!strcasecmp(lindex(temp,0),"sub") && !strcasecmp(lindex(temp,1),subnumber)) break; }
        goto_on = 1;
        break;
       }
       if(*(lindex(temp,i)+1)=='2') { sleep(2); }
       if(*(lindex(temp,i)+1)=='3') { sleep(3); }
       if(*(lindex(temp,i)+1)=='i')
       {    
        i++;
        fpa=fopen(lindex(temp,i),"r");
        strcpy(temp2,"");
        for(j=0;j!=atoi(lindex(temp,(i+1)));j++)
         fgets(temp2,255,fpa);
        strcat(buf,temp2);
        if(fpa!=NULL) fclose(fpa); 
        i++;
       }
       if(*(lindex(temp,i)+1)=='4') { sleep(4); }
       if(*(lindex(temp,i)+1)=='5') { sleep(5); }
       if(*(lindex(temp,i)+1)=='6') { sleep(6); }
       if(*(lindex(temp,i)+1)=='7') { sleep(7); }
       if(*(lindex(temp,i)+1)=='e')
       {
        sprintf(temp4,"[%ld] Normal exit [pid=%d]\n",time(NULL),pid);
        appendlog(temp4);         
        shutdown(sockfd,2);
        close(sockfd);
        if(strcasecmp(cron,"")) system(cron);
        exit(0);
       }
       if(*(lindex(temp,i)+1)=='8') { sleep(8); }
       if(*(lindex(temp,i)+1)=='9') { sleep(9); }
       if(*(lindex(temp,i)+1)=='b')
       {
        goto_on = 1;
        loop = 0;
       }
       if(*(lindex(temp,i)+1)=='s')
       {
        i++;
        strcat(buf,lrange(in[atoi(lindex2(temp,i))],atoi(lindex(temp,i+1))));
        i++;
       }
      }
      else
      {
       strcat(buf,lindex(temp,i)); 
      } 
      if(!reversechop) strcat(buf," ");
     }
     if(windows) strcat(buf,"\r\n");
     else strcat(buf,"\n");
     if(goto_on) goto_on=0; else
     write(sockfd, buf, strlen(buf));
     if(debug) printf(">>> %s\n",buf);
    }
   }   
  }
 }
 close(sockfd);
 if(strcasecmp(cron,"")) system(cron);
}

char *lindex2(char *input_string, int word_number)
{
 char *tokens[255];
 static char tmpstring[512];
 int i;
 strcpy(tmpstring,input_string);
 tokens[i=0] = (char *)strtok(tmpstring, " ");
 while ((tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 return (char *)tokens[word_number];
}

char *lrange(char *input_string, int starting_at)
{
 char *tokens[1024];
 static char tmpstring[1024]="";
 int i;
 char out_string[1024]="";
 strcpy(out_string,"");
 if(input_string==NULL) {
  strcpy(out_string," ");
  strcat(out_string,NULL);
  strcpy(global_var,out_string);
  return (char *)global_var; }
 strncpy(tmpstring,input_string,1024);
 tokens[i=0] = strtok(tmpstring, " ");
 while((tokens[++i] = strtok(NULL, " ")));
 tokens[i] = NULL;
 i++;
 if(i<starting_at)
 {
  lasterror=113;
  return (char *)"";
 }
 while(tokens[starting_at] != NULL)
 {
  strncat(out_string,tokens[starting_at],1024);
  strcat(out_string, " ");
  starting_at++;
 }
 strncpy(global_var,out_string,511);
 return (char *)global_var;
}

int match(char *check,char *orig)
{ 
 while(*check == '*' || tolower(*check)==tolower(*orig) || *check == '?') 
  if(*check == '*')
  if(*++check)
  {
   while(*orig)
    if(!match(check,orig++)) return 0;
   return 1;
  }
  else return 0;
  else if (!*check) return 0;
  else if (!*orig) return 1;
  else 
  {
   ++check;
   ++orig;
  }
 return 1;
}

int appendlog(char *what)
{
 FILE *fdlog;
 if(strcasecmp(lindex(logfilename,0),"syslog"))
 {
  fdlog=fopen(lindex(logfilename,0),"a");
  if(fdlog==NULL || fileno(fdlog)<0)
  {
   lasterror=114;
   printf("*** Warning: Can't open the log file\n");
   return;
  }
  fputs(what,fdlog);
  if(fdlog!=NULL) fclose(fdlog);
 }
 else
 {
  openlog("SScript",LOG_PID,LOG_USER);
  syslog(LOG_INFO|LOG_USER,"%s",what);
  closelog();
 }
}

udp_send(char in[1024][512])
{
 int udpsock,i;
 struct sockaddr_in udpaddr;
 char msg[255];
 strncpy(msg,lrange(in[atoi(lindex(temp,1))],2),254);
 udpsock = socket(AF_INET, SOCK_DGRAM, 0);
 if(udpsock<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
  lasterror=109;
  return -1;
 }
 udpaddr.sin_family = AF_INET;
 udpaddr.sin_port = htons(atoi(lindex(in[atoi(lindex2(temp,1))],1)));
 udpaddr.sin_addr.s_addr = inet_addr(lindex(in[atoi(lindex2(temp,1))],0));
 if(sendto(udpsock,msg,sizeof(msg),0,(struct sockaddr *)&udpaddr,sizeof(udpaddr))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SEND FAILED: %s",strerror(errno));
  lasterror=110;
  return -1;
 }
}

udp_listen(char in[1024][512])
{
 int udpsock,len;
 struct sockaddr_in udpaddr, from;
 char msg[255];
 udpsock = socket(AF_INET, SOCK_DGRAM, 0);
 if(udpsock<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
  lasterror=109;
  return -1;
 }
 udpaddr.sin_family = AF_INET;
 udpaddr.sin_addr.s_addr = INADDR_ANY;
 udpaddr.sin_port = htons(atoi(lindex(temp,2)));
 if(bind(udpsock,(struct sockaddr *)&udpaddr,sizeof(udpaddr))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"BIND FAILED: %s",strerror(errno));
  lasterror=115;
  return -1;
 }
 len = sizeof(from);
 if(recvfrom(udpsock,msg,sizeof(msg),0,(struct sockaddr *)&from,&len)<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"RECEIVE FAILED: %s",strerror(errno));
  lasterror=116;
  return -1;
 }
 strcpy(in[atoi(lindex(temp,1))],msg);
 close(udpsock);
}

addtrace(int type)
{
 FILE *fptrace;
 char my[16];
 fptrace=fopen("trace.log","a");
 if(fptrace==NULL || fileno(fptrace)<0) { lasterror=103; return; }
 if(type==-1) fputs(temp,fptrace);
 else
 {
  sprintf(my,"lasterror: %d",lasterror);
  fputs(my,fptrace);
 }
 fputs("\n",fptrace);
 if(fptrace!=NULL) fclose(fptrace);
}

icmp_detect(char in[1024][512])
{
 /* Should be a better function than this, but this'll have to do for
    now since icmpinfo seg faults if I try to add it. */
 char readbuf[4096];
 int icmpsock,from,result,type,len;
 struct sockaddr_in icmpaddr;
 strcpy(in[atoi(lindex(temp,1))],"");
 if((icmpsock=socket(AF_INET, SOCK_RAW, IPPROTO_ICMP))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
  lasterror=109;
  return -1;
 }
 icmpaddr.sin_family = AF_INET;
 icmpaddr.sin_addr.s_addr = INADDR_ANY;
 icmpaddr.sin_port = 0;
 if(bind(icmpsock,(struct sockaddr *)&icmpaddr,sizeof(icmpaddr))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"BIND FAILED: %s",strerror(errno));
  lasterror=115;
  return -1;
 }
 len=sizeof(icmpaddr);
 if(getsockname(icmpsock,(struct sockaddr *)&icmpaddr,&len)<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SOCKET ADDRESS: %s",strerror(errno));
  lasterror=117;
  return -1;
 }
 if((result=read(icmpsock,readbuf,sizeof(readbuf)))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"READING FAILED: %s",strerror(errno));
  lasterror=118;
  return -1;
 }
 type=readbuf[20] & 0xff;
 sprintf(in[atoi(lindex(temp,1))],"%ld %d %d.%d.%d.%d ;",time(NULL),type,readbuf[12]&0xff,readbuf[13]&0xff,readbuf[14]&0xff,readbuf[15]&0xff);
}

resolve(char in[1024][512])
{
 int blah;
 struct hostent *hp;
 struct sockaddr_in from;
 unsigned long dest;
 if(!strcasecmp(lindex(temp,1),"host"))
 {
  memset(&from, 0, sizeof(struct sockaddr_in));
  from.sin_family = AF_INET;
  hp=gethostbyname(lindex(in[atoi(lindex2(temp,2))],0));
  if(hp==NULL) strcpy(in[atoi(lindex(temp,3))],"unknown");
  else
  {
   memcpy(&from.sin_addr,hp->h_addr,hp->h_length);
   strcpy(in[atoi(lindex(temp,3))],inet_ntoa(from.sin_addr));
  }
 }
 else if(!strcasecmp(lindex(temp,1),"ip"))
 {
  from.sin_family = AF_INET;
  from.sin_addr.s_addr = inet_addr(lindex(in[atoi(lindex2(temp,2))],0));
  hp=gethostbyaddr((char *)&from.sin_addr, sizeof(struct in_addr),from.sin_family);
  if(hp==NULL) strcpy(in[atoi(lindex(temp,3))],"unknown");
  else strcpy(in[atoi(lindex(temp,3))],(char *)hp->h_name);
 }
 else
 {
  strcpy(in[atoi(lindex(temp,3))],"Unknown request type.");
 }
}

int help(int type, int argc, char *argv[], char *string)
{
 char help_string[4048];
 char ask[40]="(null)";
 if(type!=3)
 {
  if(argv[2]!=NULL)
  strcpy(ask, argv[2]);
 }
 if(type==3)
 {
  if(string!=NULL)
  strcpy(ask, string);
 }
 strcpy(help_string,"");
#ifndef GTK
 if(lang==0)
 strcpy(help_string,"This is the online help screen for Socket Script.\n");
 else if(lang==1)
 strcpy(help_string,"Ceci est l'aide en ligne de Socket Script. Une traduction n'est pas disponible pour l'instant.\n");
 else if(lang==2)
 strcpy(help_string,"Este es la ayuda en line para Socket Script. Una traduccion para el sistema de ayuda todavia no es disponible.\n");
#endif /* gtk */
 if(ask==NULL || !strcasecmp(ask,"(null)"))
 {
  strcat(help_string,"Socket Script v1.14\n");
  strcat(help_string,"Syntax:\n");
  strcat(help_string,"        sscript [-d] [-c] [-r <remote ip> <port>] [script or project file [-l line]] [-help [command]] [-display <screen>]\n");
  strcat(help_string,"\nsscript  loads the startup screen and starts sscript.file\n");
  strcat(help_string,"sscript <script file or project file>  loads the specified script or project\n");
  strcat(help_string,"sscript <script file> -l <line>  will load the script <script file> and start running it at line number <line>\n");
  strcat(help_string,"sscript -help [command]  gets you online help on the specified command. Use sscript -help index  for a list of all commands.\n");
  strcat(help_string,"sscript -d <script>  will launch the debugger to check the specified script for possible errors.\n");
  strcat(help_string,"sscript -c <script>  will launch the composer which allows you to make your scripts.\n");
  strcat(help_string,"sscript -r <server ip> <server port> <script>  will fetch <script> from a remote server running the ERSS script (examples/sscript.script-serving)  \n\n");
  strcat(help_string,"The full documentation is also available in docs/sscript.doc (or sscript -help docs) along with technical notes on how to make your scripts.\n");
  strcat(help_string,"You can also look at the examples in the examples dir that came with this package.\n\n");
  strcat(help_string,"Socket Script is free software.\n(C) 1998 Patrick Lambert <drow@fastethernet.net>\nLatest version available at http://devplanet.fastethernet.net/sscript.html\nor ftp://sunsite.unc.edu/pub/Linux/devel/");
 }
 else if(!strcasecmp(ask,"index"))
 {
  strcat(help_string,"Index of available commands as of now:\n");
  strcat(help_string,"server, port, chop, debug, virtual, require, read, write, print, save, append, rementry, remove,\n");
  strcat(help_string,"version, ping, test, parse, dump, set, setmaster, setuserhost, setservice, setreversechop,\n");
  strcat(help_string,"setstrictcheck, setstrictwrite, setlogfile, settrace, setwindows, setsignalsoff, rconnect,\n");
  strcat(help_string,"rread, rwrite, rdisconnect, for, endfor, ask, exit, ifword, ifword2, ifmaster, msgbox, users,\n");
  strcat(help_string,"ifmaster2, ifmatch, ?compare, ?match, loop, saveall, addlog, run, goto, sub, wait, if,\n");
  strcat(help_string,"cron, remoteip, random, command, resolve, cl, udpsend, udplisten, icmplisten, raw, rawp,\n");
  strcat(help_string,"query, viewfile, devstat, setowner, background, require-gui, getenv, file, include, choicebox,\n");
  strcat(help_string,"setremoteecho, nodelay, constat, lasterror, expr, binary-send, binary-get, chdir, input,\n");
  strcat(help_string,"!match, !compare, clearlasterror, setinputchop, uname, firewall, textbox, sysinfo, varlenght,\n");
  strcat(help_string,"encryptfile, decryptfile, timer, math, password, draw, utime, wordlength, varchop, clear,\n");
  strcat(help_string,"servicename, ascii, cwd, redir, listen, multilisten, http, modem, snmp, zipstring, unzipstring,\n");
  strcat(help_string,"zipfile, unzipfile, ?compareword, !compareword, gui, pgp, say, db, printparams, rawprint,\n");
  strcat(help_string,"boolean, iftrue, iffalse, procinfo, sleep, timeout\n");
 }
 else if(!strcasecmp(ask,"timeout"))
 {
  strcat(help_string,"timeout <time> <variable number> ;\n");
  strcat(help_string,"This command works like read and waits for data from the main connection\n");
  strcat(help_string,"for <time> seconds. It returns the data in <variable number>, or\n");
  strcat(help_string,"\"timeout\" if no data was read in the specified time.\n");
 }
 else if(!strcasecmp(ask,"sleep"))
 {
  strcat(help_string,"sleep <time> ;\n");
  strcat(help_string,"Will halt the program for <time> seconds.\n");
 }
 else if(!strcasecmp(ask,"procinfo"))
 {
  strcat(help_string,"procinfo <variable number> <query> ;\n");
  strcat(help_string,"This command looks in the Linux proc directory to get system info, and\n");
  strcat(help_string,"puts it in <variable number>. <query> can be cpu, model, vendor, fpu,\n");
  strcat(help_string,"totalmem, freemem, totalswap or freeswap. This only works on systems\n");
  strcat(help_string,"supporting the proc file-system.\n");
 }
 else if(!strcasecmp(ask,"boolean"))
 {
  strcat(help_string,"boolean [TRUE|FALSE] ;\n");
  strcat(help_string,"Set a boolean value true or false.\n");
 }
 else if(!strcasecmp(ask,"iftrue"))
 {
  strcat(help_string,"iftrue <sub name> ;\n");
  strcat(help_string,"If boolean is true, goto <sub name>.\n");
 }
 else if(!strcasecmp(ask,"iffalse"))
 {
  strcat(help_string,"iffalse <sub name> ;\n");
  strcat(help_string,"If boolean is false, goto <sub name>.\n");
 }
 else if(!strcasecmp(ask,"rawprint"))
 {
  strcat(help_string,"rawprint <string> ;\n");
  strcat(help_string,"Prints <string> with no end-of-line char.\n");
 }
 else if(!strcasecmp(ask,"printparams"))
 {
  strcat(help_string,"printparams ;\n");
  strcat(help_string,"Print the current settings on the screen.\n");
 }
 else if(!strcasecmp(ask,"db")) 
 {
  strcat(help_string,"db <args...>\n");
  strcat(help_string,"This command is used to access GDBM databases. SScript must be compiled\n");
  strcat(help_string,"to support it for this command to work. Here are how to use it:\n");
  strcat(help_string,"db open-write <file name> ;\n");
  strcat(help_string,"Open a database file for writing.\n");
  strcat(help_string,"db open-read <file name> ;\n");
  strcat(help_string,"Open a database file for reading.\n");
  strcat(help_string,"db close ;\n");
  strcat(help_string,"Close the opened database.\n");
  strcat(help_string,"db insert <key> <data> ;\n");
  strcat(help_string,"Insert <key> with corresponding <data> in a database opened for writing.\n");
  strcat(help_string,"db get <key> <variable number> ;\n");
  strcat(help_string,"Get the data corresponding to <key> and put it in <variable number>.\n");
  strcat(help_string,"db delete <key> ;\n");
  strcat(help_string,"Delete <key> from the database.\n");
  strcat(help_string,"See sscript.dbm for an example.\n");
 }
 else if(!strcasecmp(ask,"say"))
 {
  strcat(help_string,"say <variable number> ;\n");
  strcat(help_string,"Say the string in <variable number> on the speakers. This assumes that\n");
  strcat(help_string,"you have access to /dev/dsp and that you said yes in the configure choice.\n");
 }
 else if(!strcasecmp(ask,"pgp"))
 {
  strcat(help_string,"pgp <args...>\n");
  strcat(help_string,"This command is used to call the PGP binaries to encrypt and decrypt\n");
  strcat(help_string,"files to allow secure sending over the Internet. See section 4.7 on how\n");
  strcat(help_string,"to setup PGP. Here is how to use the PGP command:\n");
  strcat(help_string,"pgp generate <output file> ;\n");
  strcat(help_string,"This is used to make your private and public keys so someone can send you\n");
  strcat(help_string,"encrypted messages. Your public key will be put in <output file> so you\n");
  strcat(help_string,"can publish it.\n");
  strcat(help_string,"pgp add-key <location> ;\n");
  strcat(help_string,"This is used to add someone else's public key to encrypt files so that\n");
  strcat(help_string,"person can decrypt them. <location> is a file containing the key, or an\n");
  strcat(help_string,"URL.\n");
  strcat(help_string,"pgp encrypt <user id> <file> ;\n");
  strcat(help_string,"This is used to encrypt <file> using <user id>'s public key (that you\n");
  strcat(help_string,"added with add-key previously, of course). The resulting encrypted file\n");
  strcat(help_string,"is saved under <file>.asc in text-only format.\n");
  strcat(help_string,"pgp decrypt <in file> <out file> ;\n");
  strcat(help_string,"This will decrypt <in file> and save the result in <out file>.\n");
 }
 else if(!strcasecmp(ask,"gui"))
 {
  strcat(help_string,"gui <args...>\n");
  strcat(help_string,"With the GUI command, you can make your own graphical window with\n");
  strcat(help_string,"buttons, an entry box, a text box, separators, and labels. You must begin\n");
  strcat(help_string,"with gui main and end with gui show. Before using an horizontal control,\n");
  strcat(help_string,"gui hbox must be used. Here are the available arguments for the gui\n");
  strcat(help_string,"command:\n");
  strcat(help_string,"gui main <title>\n");
  strcat(help_string,"This is used to begin the GUI building process.\n");
  strcat(help_string,"gui position <horizontal> <vertical> ;\n");
  strcat(help_string,"This sets the window's position on the screen.\n");
  strcat(help_string,"gui toolbar ;\n");
  strcat(help_string,"This is used to make a toolbar of buttons, and should be considered as\n");
  strcat(help_string,"horizontal.\n");
  strcat(help_string,"gui size <horizontal size> <vertical size> ;\n");
  strcat(help_string,"This command sets the window size.\n");
  strcat(help_string,"gui label [horizontal|vertical] <label>\n");
  strcat(help_string,"This command shows <label>, lined up horizontaly or verticaly.\n");
  strcat(help_string,"gui textbox [horizontal|vertical] ;\n");
  strcat(help_string,"This shows a textbox.\n");
  strcat(help_string,"gui insert <variable number> ;\n");
  strcat(help_string,"This command inserts what's in <varable number> in the text box. Or\n");
  strcat(help_string,"an end-of-line if <variable number> is EOL.\n");
  strcat(help_string,"gui text-editable ;\n");
  strcat(help_string,"Set the textbox editable by the user.\n");
  strcat(help_string,"gui hbox ;\n");
  strcat(help_string,"Sets the [horizontal] feature possible.\n");
  strcat(help_string,"gui entry [horizontal|vertical] ; \n");
  strcat(help_string,"This shows an entry box for user input.\n");
  strcat(help_string,"gui button [horizontal|vertical] <button number> <label>\n");
  strcat(help_string,"This will show a button, and when pressed, <button number> is returned.\n");
  strcat(help_string,"gui icon [horizontal|vertical] <button number> <xpm file name> ;\n");
  strcat(help_string,"This will show a button with the image in <xpm file name>.\n");
  strcat(help_string,"gui show <variable number> <file name> ;\n");
  strcat(help_string,"This will show the whole window and wait for user input. When a button is\n");
  strcat(help_string,"pressed, <variable number> will return the button number, and the content\n");
  strcat(help_string,"of the entry box, if one was used. The content of the textbox, if\n");
  strcat(help_string,"used, is put in <file name>.\n");
  strcat(help_string,"For an example, see sscript.gui in the examples directory.\n");
 }
 else if(!strcasecmp(ask,"?compareword"))
 {
  strcat(help_string,"?compareword <variable 1> <word 1> <variable 2> <word 2> <sub name> ;\n");
  strcat(help_string,"If <word 1> from <variable 1> is the same as <word 2> in <variable 2>,\n");
  strcat(help_string,"then goto <sub name>.\n");
 }
 else if(!strcasecmp(ask,"!compareword"))
 {
  strcat(help_string,"!compareword <variable 1> <word 1> <variable 2> <word 2> <sub name> ;\n");
  strcat(help_string,"If <word 1> from <variable 1> is not the same as <word 2> in <variable\n");
  strcat(help_string,"2>, then goto <sub name>.\n");
 }
 else if(!strcasecmp(ask,"zipfile"))
 {
  strcat(help_string,"zipfile <in file> <out file> ;\n");
  strcat(help_string,"This will compress the <in file> text file into <out file> using the gzip\n");
  strcat(help_string,"compression format. Maximum file size is 1 meg.\n");
 }
 else if(!strcasecmp(ask,"unzipfile"))
 {
  strcat(help_string,"unzipfile <in file> <out file> ;\n");
  strcat(help_string,"This will uncompress the <in file> gzip text file into <out file>.\n");
  strcat(help_string,"Maximum file size is 1 meg.\n");
 }
 else if(!strcasecmp(ask,"zipstring"))
 {
  strcat(help_string,"zipstring <variable number> <file name> ;\n");
  strcat(help_string,"Takes the content of a variable and compress it into file <file name>.\n");
  strcat(help_string,"Requires SScript to be compiled with LIBZ.\n");
 }
 else if(!strcasecmp(ask,"unzipstring"))
 {
  strcat(help_string,"unzipstring <variable number> <file name> ;\n");
  strcat(help_string,"Uncompress <file name> and puts the line of text in <variable number>.\n");
  strcat(help_string,"Requires SScript to be compiled with LIBZ.\n");
 }
 else if(!strcasecmp(ask,"snmp"))
 {
  strcat(help_string,"snmp <hostname> <community name> <query object> <variable number> ;\n");
  strcat(help_string,"Queries the <hostname> SNMP deamon, using <community name> for <query\n");
  strcat(help_string,"object> and returns it in <variable number>.\n");
 }
 else if(!strcasecmp(ask,"modem"))
 {
  strcat(help_string,"modem [dial|write|read|hangup] <variable number> ;\n");
  strcat(help_string,"You can dial to the phone number in <variable number>, write the string\n");
  strcat(help_string,"in <variable number>, read and put the input in <variable number>, or\n"); 
  strcat(help_string,"hangup the modem. Needs libmodem and a proper /etc/modems.\n");
 }
 else if(!strcasecmp(ask,"http"))
 {
  strcat(help_string,"http <command> <variable number> ;\n");
  strcat(help_string,"Executes an HTTP related command. Available commands for now are 'html'\n");
  strcat(help_string,"and 'js <script>'. The html command takes the line in <variable number>\n");
  strcat(help_string,"and prints it in text-only mode, interpreting HTML tags. See sscript.web\n");
  strcat(help_string,"for examples. The js command is used to make a very simple sample\n");
  strcat(help_string,"html page with JavaScript in it. Supported scripts are 'scrolling' and 'entry'.\n");
 }
 else if(!strcasecmp(ask,"multilisten"))
 {
  strcat(help_string,"multilisten <mode> <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"This command is used to wait for input on 2 connections. If <mode> is 1,\n");
  strcat(help_string,"it will wait for input from the keyboard and from the main connection. If\n");
  strcat(help_string,"<mode> is 2, it will wait for input from the keyboard and from the second\n");
  strcat(help_string,"connection (rconnect). If <mode> is 3, it will wait for the main and\n");
  strcat(help_string,"second connection. When it reads something on either connection, it will\n");
  strcat(help_string,"return which one in <variable number 1>, 1 being the first choice and 2\n");
  strcat(help_string,"the second, and the actual read data in <variable number 2>.\n");
 }
 else if(!strcasecmp(ask,"redir"))
 {
  strcat(help_string,"redir ;\n");
  strcat(help_string,"This command makes a redirect between the main connection and the remote\n");
  strcat(help_string,"connection (rconnect). Both connections must be open. See sscript.redir\n");
  strcat(help_string,"for an example.\n");
 }
 else if(!strcasecmp(ask,"listen"))
 {
  strcat(help_string,"listen <variable number> ;\n");
  strcat(help_string,"This commands returns which of the connections, the main one or the\n");
  strcat(help_string,"remote one (rconnect), is ready for reading. Note that you should prefer\n");
  strcat(help_string,"the 'redir' command rather than this to make a redirect program. Both\n");
  strcat(help_string,"connections must be opened. Returns 1 in <variable number> if the main\n"); 
  strcat(help_string,"connection is ready for reading (read), returns 2 if the remote\n");
  strcat(help_string,"connection is ready for reading (rread), or returns 0 if an error\n");
  strcat(help_string,"occured, or no connection is ready. Can block if not ready.\n");
 }
 else if(!strcasecmp(ask,"cwd"))
 {
  strcat(help_string,"cwd <variable number> ;\n");
  strcat(help_string,"This command returns the current working directory.\n");
 }
 else if(!strcasecmp(ask,"ascii"))
 {
  strcat(help_string,"ascii [TOUPPER|TOLOWER|ISNUMBER] <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Converts the input string into all upper-case chars (toupper) or all\n");
  strcat(help_string,"lower-case chars (tolower), or return 1 if <variable number 1> begins\n");
  strcat(help_string,"with a digit, or 0 if not. Input is <variable number 1> and the result is\n");
  strcat(help_string,"<variable number 2>.\n");
 }
 else if(!strcasecmp(ask,"servicename"))
 {
  strcat(help_string,"servicename <name> <variable number> ;\n");
  strcat(help_string,"Request the port number for service <name>.\n");
 }
 else if(!strcasecmp(ask,"clear"))
 {
  strcat(help_string,"clear ;\n");
  strcat(help_string,"Clears the screen using the shell command 'tput clear'.\n");
 }
 else if(!strcasecmp(ask,"varchop"))
 {
  strcat(help_string,"varchop <variable number> ;\n");
  strcat(help_string,"Removes the last char from <variable number>.\n");
 }
 else if(!strcasecmp(ask,"wordlenght"))
 {
  strcat(help_string,"wordlenght <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Returns the number of words (where word is anything with separed with a  \n");
  strcat(help_string,"space) in <variable number 1> and puts the result in <variable number 2>.\n");
  strcat(help_string,"Returns 0 if no word is there.\n");
 }
 else if(!strcasecmp(ask,"wordlength"))
 { 
  strcat(help_string,"wordlenght <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Returns the number of words (where word is anything with separed with a  \n");
  strcat(help_string,"space) in <variable number 1> and puts the result in <variable number 2>.\n");
  strcat(help_string,"Returns 0 if no word is there.\n");
 }
 else if(!strcasecmp(ask,"utime"))
 {
  strcat(help_string,"utime <variable number> ;\n");
  strcat(help_string,"Copies the current time in UNIX-time format in <variable number>.\n");
 }
 else if(!strcasecmp(ask,"composer"))
 {
  strcat(help_string,"Socket Script Composer\n\n");
  strcat(help_string,"With this composer, you can make your own scripts.\n");
  strcat(help_string,"The menus only have the most commonly used commands.\n");
  strcat(help_string,"You can get a complete description on any command with the\nCommand description choice in the Help menu.\n");
  strcat(help_string,"In there, enter 'index' without the quotes to have the\ncomplete list of Socket Script commands.\n");
  strcat(help_string,"Here are the keyboard shortcuts you can use:\n");
  strcat(help_string,"ctrl+a               go to begining of line\n");
  strcat(help_string,"ctrl+e               go to end of the line\n");
  strcat(help_string,"ctrl+c               copy\n");
  strcat(help_string,"ctrl+v               paste\n");
  strcat(help_string,"ctrl+d (or DEL)      delete a char\n");
  strcat(help_string,"ctrl+k               remove a line\n");
  strcat(help_string,"ctrl+w               delete the selected text\n");
 }
 else if(!strcasecmp(ask,"libraries"))
 {
  strcat(help_string,"Socket Script Composer\n\n");
  strcat(help_string,"Most Socket Script commands are native of Socket Script.\n");
  strcat(help_string,"This means that whatever the choices you make when compiling the interpreter,\n");
  strcat(help_string,"they will work. However, some needs libraries to work. For example,\n");
  strcat(help_string,"the draw command needs the ncurses library to work. This is due to the\n");
  strcat(help_string,"fact that all the functions to access the hardware interface for this\n");
  strcat(help_string,"command are not in the standard C library, they are in a library\n");
  strcat(help_string,"that someone made to make it easy for others touse these functions.\n");
  strcat(help_string,"That said, you must have the library installed and decided to include it\n");
  strcat(help_string,"when you compiled Socket Script. Note that the binaries already\n");
  strcat(help_string,"compiled on the web site do not include these libraries.\n");
 }
 else if(!strcasecmp(ask,"draw"))
 {
  strcat(help_string,"draw [INIT|SET|UNSET|PRINT|REFRESH|ASK|CLEAR|COLOR|BOX|BREFRESH|PRINTBOX|END] <args...>\n");
  strcat(help_string,"The draw command enables you to use formatted text in console, text-only\n");
  strcat(help_string,"mode. You need to INIT it at first, and END it at the end. You can SET\n");  
  strcat(help_string,"and UNSET BOLD, UNDERLINE, BLINK or DIM. You can print in it with PRINT\n");
  strcat(help_string,"<x location> <y location> <variable number>. No change you make is\n");
  strcat(help_string,"actualy made on the screen until you REFRESH the screen. You can also use\n");
  strcat(help_string,"the COLOR GREEN, RED, WHITE or CYAN. ASK <variable number> will wait for\n");
  strcat(help_string,"user input. You can also make a window with BOX <number of cols> <number\n");
  strcat(help_string,"of lines> <x location> <y location>, print in it with PRINTBOX <x\n");
  strcat(help_string,"location> <y location> <variable number>, and refresh the window with\n");
  strcat(help_string,"BREFRESH. Everything is based on curses or ncurses, so you need that\n");
  strcat(help_string,"library on the system to use this command. You also need to include\n");
  strcat(help_string,"the curses or ncurses library in SScript for this to work. See the\n");
  strcat(help_string,"example sscript.draw\n");
 }
 else if(!strcasecmp(ask,"password"))
 {
  strcat(help_string,"password <variable number> ;\n");
  strcat(help_string,"Asks for a 8 chars password on the screen, without returning the echo, and puts\n");
  strcat(help_string,"it in <variable number>.\n");
 }
 else if(!strcasecmp(ask,"math"))
 {
  strcat(help_string,"math <variable number> [LOG|LN|E|SQRT|EXPR] <number> ;\n");
  strcat(help_string,"This will calculate the log, natural log, e raised to the power of, and\n");
  strcat(help_string,"square root of <number>, and put the result in <variable number>. EXPR\n");
  strcat(help_string,"works the same way as the expr command, with <variable number 1>\n");
  strcat(help_string,"[+,-,*,/] <variable number 2>.\n");
 }
 else if(!strcasecmp(ask,"timer"))
 {
  strcat(help_string,"timer <time> <variable number> ;\n");
  strcat(help_string,"This command changes the variable <variable number> from 0 to 1 when\n");
  strcat(help_string,"<time> seconds have passed.\n");
 }
 else if(!strcasecmp(ask,"encryptfile"))
 {
  strcat(help_string,"encryptfile <variable number> ;\n");
  strcat(help_string,"This function uses the DES encryption utility to encrypt a file.\n");
  strcat(help_string,"<variable number> must contain: \"<file name> <key> ;\" without the quotes,\n");
  strcat(help_string,"where <file name> is the file to encrypt and <key> is a 8 letters or less\n");
  strcat(help_string,"key to encrypt it. The encrypted file name will be added a .des\n");
  strcat(help_string,"extention. The file can then be sent somewhere with binary-send. See\n");
  strcat(help_string,"section 4.5 for more about SScript's encryption and where to get the DES\n");
  strcat(help_string,"binary.\n");
 }
 else if(!strcasecmp(ask,"decryptfile"))
 {
  strcat(help_string,"decryptfile <variable number> ;\n");
  strcat(help_string,"This decrypts a file that was encrypted with encryptfile. The syntax of\n");
  strcat(help_string,"<variable number> is the same. Do not put .des in the <file name>, this\n");
  strcat(help_string,"function will add it automaticly. See section 4.5 for more about\n");
  strcat(help_string,"SScript's encryption and where to get the DES binary.\n");
 }
 else if(!strcasecmp(ask,"users"))
 {
  strcat(help_string,"users <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"This command returns information from the system password file about a\n");   
  strcat(help_string,"user and should be used carefully. <variable number 1> must contain\n");
  strcat(help_string,"\"<NAME|UID> <string>\" where string is either a login name, or a user id.\n");
  strcat(help_string,"This returns the \"<login name> <user id> <group id> <password> <user\n");
  strcat(help_string,"path>\" in <variable number 2>, without the quotes of course.\n");
 }
 else if(!strcasecmp(ask,"varlenght"))
 {
  strcat(help_string,"varlenght <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Calculates the number of chars in the first word of <variable number 1>,\n");
  strcat(help_string,"and puts the result in <variable number 2>.\n");
 }
 else if(!strcasecmp(ask,"sysinfo"))
 {
  strcat(help_string,"sysinfo <variable number> ;\n");
  strcat(help_string,"This returns information on the system. It returns the uptime, 1min load\n");
  strcat(help_string,"average, 5mins load average, 15mins load average, total RAM size, free\n");
  strcat(help_string,"RAM size, shared RAM size, memory in buffers, total swap size, free swap\n");
  strcat(help_string,"size, number of processes running in <variable number>. This command\n");
  strcat(help_string,"only runs on Linux systems.\n");
 }
 else if(!strcasecmp(ask,"textbox"))
 {
  strcat(help_string,"textbox <file name> ;\n");
  strcat(help_string,"This command allows people to type in a graphical text box, and the text\n");
  strcat(help_string,"is saved in <file name>. SScript needs to be compiled in GUI mode for\n");
  strcat(help_string,"this to work.\n");
 }
 else if(!strcasecmp(ask,"firewall"))
 {
  strcat(help_string,"firewall [add|rem] [allow|deny] <source ip> <destination ip> <port> <protocol>\n");
  strcat(help_string,"This command is a simple frontend for the system's ipfwadm(8) command.\n");
  strcat(help_string,"It will add or remove a firewalling rule allowing or denying <source ip>\n");
  strcat(help_string,"to send packets to <destination ip> to <port>, using <protocol>. The\n");
  strcat(help_string,"last 4 parameters can be the keyword 'ALL' meaning all IPs, ports or\n");
  strcat(help_string,"protocols. Protocols available are TCP, UDP and ICMP. Usualy,\n");
  strcat(help_string,"<destination ip> is your own IP, or ALL. You must be root to use this\n");
  strcat(help_string,"command, and you must have the binary ipfwadm on the system, at the path\n");
  strcat(help_string,"defined by IPFW in config.h\n");
 }
 else if(!strcasecmp(ask,"uname"))
 {
  strcat(help_string,"uname <variable number> ;\n");
  strcat(help_string,"This will provide the same information as the Unix shell command\n");
  strcat(help_string,"'uname'. It will put in <variable number> the system's OS, name,\n"); 
  strcat(help_string,"release, version, machine and domain.\n");
 }
 else if(!strcasecmp(ask,"setinputchop"))
 {
  strcat(help_string,"setinputchop ;\n");
  strcat(help_string,"The input command chops the ending '\\n' char.\n");
 }
 else if(!strcasecmp(ask,"clearlasterror"))
 {
  strcat(help_string,"clearlasterror ;\n");
  strcat(help_string,"Clear the lasterror variable so an error that already occured isn't\n");
  strcat(help_string,"catched by your script later on.\n");
 }
 else if(!strcasecmp(ask,"!compare"))
 {
  strcat(help_string,"!compare <variable number 1> <variable number 2> <sub name> ;\n");
  strcat(help_string,"If the first word of <variable number 1> is NOT the same as <variable\n");
  strcat(help_string,"number 2> then go to <sub name>.\n");
 }
 else if(!strcasecmp(ask,"!match"))
 {
  strcat(help_string,"!match <variable number 1> <variable number 2> <sub name> ;\n");
  strcat(help_string,"If the masked word in <variable number 1> does NOT match the one in\n");
  strcat(help_string,"<variable number 2> then go to <sub name>.\n");
 }
 else if(!strcasecmp(ask,"input"))
 {
  strcat(help_string,"input <variable number 1> <variable number 2> <variable number 3> ;\n");
  strcat(help_string,"This reads a line number <variable number 2> from the file in <variable\n");
  strcat(help_string,"number 1>, and put it in <variable number 3>.\n");
 }
 else if(!strcasecmp(ask,"chdir"))
 {
  strcat(help_string,"chdir <variable number> ;\n");
  strcat(help_string,"Change the current directory to the path in <variable number>.\n");
  strcat(help_string,"Note that you must start the script with an absolute path if you use the\n");
  strcat(help_string,"chdir command.\n");
 }
 else if(!strcasecmp(ask,"binary-send"))
 {
  strcat(help_string,"binary-send <variable number> ;\n");
  strcat(help_string,"Sends the binary file in <variable number>. Note that you need uuencode\n");
  strcat(help_string,"for this to work.\n");
 }
 else if(!strcasecmp(ask,"binary-get"))
 {
  strcat(help_string,"binary-get ;\n");
  strcat(help_string,"Waits for a binary file sent by the binary-send command, and save it\n");
  strcat(help_string,"under its original filename and path. Note that you need uudecode for\n");
  strcat(help_string,"this to work.\n");
 }
 else if(!strcasecmp(ask,"lasterror"))
 {
  strcat(help_string,"lasterror <variable number> ;\n");
  strcat(help_string,"This returns the last error reported.\n");
 }
 else if(!strcasecmp(ask,"expr"))
 {
  strcat(help_string,"expr <variable number 1> <+,-,*,/> <variable number 2> > <variable number 3> ;\n");
  strcat(help_string,"This will add (+), substract (-), multiply (*) or divide (/) <variable  \n");
  strcat(help_string,"number 1> to <variable number 2>, and put the result in <variable number 3>. the numbers must be integers.\n");
 }
 else if(!strcasecmp(ask,"constat"))
 {
  strcat(help_string,"constat <type> <variable number> ;\n");
  strcat(help_string,"This gives connection stats about the opened socket on the <type>\n");
  strcat(help_string,"requested. <type> must be type, error, recvbuf or sendbuf. The result is\n");
  strcat(help_string,"a number returned in <variable number>.\n");
 }
 else if(!strcasecmp(ask,"nodelay"))
 {
  strcat(help_string,"nodelay ; \n");
  strcat(help_string,"Sets the connection in non-blocking mode.\n");
 }
 else if(!strcasecmp(ask,"setremoteecho"))
 {
  strcat(help_string,"setremoteecho ;\n");
  strcat(help_string,"Make a server-oriented script return everything it reads from to the\n");
  strcat(help_string,"remote host.\n");
 }
 else if(!strcasecmp(ask,"choicebox"))
 {
  strcat(help_string,"choicebox <variable number> <button 1> <button 2> ... | <label>\n");
  strcat(help_string,"The choicebox command will popup a window to the user and ask him the   \n");
  strcat(help_string,"question <label>, with buttons for him to choose an answer. There can be\n");
  strcat(help_string,"up to 10 buttons, where <button 1>, <button 2>, etc are the button's    \n");
  strcat(help_string,"labels. The command will return the button chosen (1, 2, 3... 10) in\n");
  strcat(help_string,"<variable number>.\n");
 }
 else if(!strcasecmp(ask,"server"))
 {
  strcat(help_string,"server <ip> ;\n");
  strcat(help_string,"Tells the program what IP to connect to. Enter 0 there if you want to\n");
  strcat(help_string,"use SScript as a server, or \"no-connection\" (without the quotes) for\n");
  strcat(help_string,"a connection-less script. See sscript.server for more.\n");
 }
 else if(!strcasecmp(ask,"include"))
 {
  strcat(help_string,"include <name> <cl binary> ;\n");
  strcat(help_string,"This launch <cl binary> whenever SScript sees 'cl <name> ...' in the    \n");
  strcat(help_string,"script. See plugins.txt for details.\n");
 }
 else if(!strcasecmp(ask,"require-gui"))
 {
  strcat(help_string,"require-gui ;\n");
  strcat(help_string,"This means that SScript must be compiled as a GUI app for this script to work.\n");
 }
 else if(!strcasecmp(ask,"port"))
 {
  strcat(help_string,"port <port> ;\n");
  strcat(help_string,"Tells the program what port to connect to.\n");
 }
 else if(!strcasecmp(ask,"debug"))
 {
  strcat(help_string,"debug <mode> ;\n");
  strcat(help_string,"If mode is 1, the program will output everything it reads to the\n");
  strcat(help_string,"screen. Default use should be mode 0.\n");
 }
 else if(!strcasecmp(ask,"chop"))
 {
  strcat(help_string,"chop <mode> ;\n");
  strcat(help_string,"Tells the program to chop the last char of a\n");
  strcat(help_string,"string. You choose this\n");
  strcat(help_string,"option depending on what kind of server you need to connect to. Use\n");
  strcat(help_string,"mode 1 for IRC servers, and mode 0 for WEB server and most others.  \n");
 }
 else if(!strcasecmp(ask,"virtual"))
 {
  strcat(help_string,"virtual <ip> ;\n");
  strcat(help_string,"Binds to a virtual IP if available. If not, simply put 0.\n");
 }
 else if(!strcasecmp(ask,"getenv"))
 {
  strcat(help_string,"getenv <word> <variable number> ;\n");
  strcat(help_string,"Put the environment value corresponding to <word> in <variable number>.\n");
 }
 else if(!strcasecmp(ask,"require"))
 {
  strcat(help_string,"require <version> ;\n");
  strcat(help_string,"Requires a Socket Script interpreter <version> or more. Version is a 2\n");
  strcat(help_string,"number word, ie. 16 for version 1.6.\n");
 }
 else if(!strcasecmp(ask,"read"))
 {
  strcat(help_string,"read <variable number> ;\n");
  strcat(help_string,"Reads a line of text. Variable number is the variable to save the   \n");
  strcat(help_string,"line to. You have from 1 to 1000. You can always use the same, or use\n");
  strcat(help_string,"different ones if you need to save something for later use. \n");
 }
 else if(!strcasecmp(ask,"write"))
 {
  strcat(help_string,"write <string>\n");
  strcat(help_string,"Sends <string> to the remote server. \n");
 }
 else if(!strcasecmp(ask,"print"))
 {
  strcat(help_string,"print <string>\n");
  strcat(help_string,"Prints <string> on the screen. \n");
 }
 else if(!strcasecmp(ask,"save"))
 {
  strcat(help_string,"save <variable number> <file> ;  \n");
  strcat(help_string,"Saves the line of text in <variable number> to <file>. It overwrites\n");
  strcat(help_string,"what's in the file.\n");
 }
 else if(!strcasecmp(ask,"append"))
 {
  strcat(help_string,"append <variable number> <file> ;\n");
  strcat(help_string,"Saves the line of text in <variable number> to <file>. It does not\n");
  strcat(help_string,"overwrites the file. \n");
 }
 else if(!strcasecmp(ask,"rementry"))
 {
  strcat(help_string,"rementry <variable number> <file> ;\n");
  strcat(help_string,"Remove the lines matching the 1st word in <variable number> from\n");
  strcat(help_string,"<file>. \n");
 }
 else if(!strcasecmp(ask,"remove"))
 {
  strcat(help_string,"remove <vairable number> <file> ;\n");
  strcat(help_string,"Remove the lines matching the string in <variable number> from\n");
  strcat(help_string,"<file>. \n");
 }
 else if(!strcasecmp(ask,"version"))
 {
  strcat(help_string,"version ;\n");
  strcat(help_string,"Prints the version information. \n");
 }
 else if(!strcasecmp(ask,"ping"))
 {
  strcat(help_string,"ping <remote ip> ;\n");
  strcat(help_string,"Used to check if the remote IP is alive. Will not return if it's\n");
  strcat(help_string,"not (of if port 7 is filtered).  \n");
 }
 else if(!strcasecmp(ask,"test"))
 {
  strcat(help_string,"test <variable number> ;\n");
  strcat(help_string,"Tests to see if a remote port is listening. <variable number> must\n");
  strcat(help_string,"contain \"<remote ip> <remote port> ;\" (without the quotes). This\n");
  strcat(help_string,"returns 0 if the port is listening, or an error if not, in that variable number.  \n");
 }
 else if(!strcasecmp(ask,"parse"))
 {
  strcat(help_string,"parse [<,<<,>>,>,!,_>,<_,%] <variable number> <char> ;\n");
  strcat(help_string,"This will remove everything in the first word of <variable\n");
  strcat(help_string,"number> before (<<), before and including (<), after (>>), or\n");
  strcat(help_string,"after and including (>) the <char> if it exist. (!) is use to remove\n");
  strcat(help_string,"every space in the string. So \"this is a string\" will become\n");
  strcat(help_string,"\"thisisastring\". Can be useful for matching commands. The <_ command \n");
  strcat(help_string,"puts a space *before* every <char> in the string, and the _> command\n");
  strcat(help_string,"puts a space *after* every <char>. Use the % command to remove every word\n");
  strcat(help_string,"in the string that match the <char>, which can be a masked word,\n");
  strcat(help_string,"containing * and ? chars.\n");
 }
 else if(!strcasecmp(ask,"dump"))
 {
  strcat(help_string,"dump <variable number> ;\n");
  strcat(help_string,"Writes everything from the file in <variable number>.  \n");
 }
 else if(!strcasecmp(ask,"set"))
 {
  strcat(help_string,"set <variable number> <string>\n");
  strcat(help_string,"Enter <string> in <variable number> for future retreval.  \n");
 }
 else if(!strcasecmp(ask,"setmaster"))
 {
  strcat(help_string,"setmaster <file containing: <masked nick!user@host> ;> ;  \n");
  strcat(help_string,"Used mainly for IRC bots. Defines who will have access to the\n");
  strcat(help_string,"ifmaster and ifmaster2 functions.  \n");
 }
 else if(!strcasecmp(ask,"setuserhost"))
 {
  strcat(help_string,"setuserhost ;\n");
  strcat(help_string,"From that point the program will try to get a nick!user@host from\n");
  strcat(help_string,"what it gets from the server. Useful for IRC bots.  \n");
 }
 else if(!strcasecmp(ask,"setservice"))
 {
  strcat(help_string,"setservice ;\n");
  strcat(help_string,"Sets the sscript to be a service server for IRC.\n");
 }
 else if(!strcasecmp(ask,"setreversechop"))
 {
  strcat(help_string,"setreversechop ;\n");
  strcat(help_string,"Puts a ' ' before a word rather than after a word\n");
  strcat(help_string,"when parsing a command line.  \n");
 }
 else if(!strcasecmp(ask,"setstrictcheck"))
 {
  strcat(help_string,"setstrictcheck ;\n");
  strcat(help_string,"Strict check for empty strings which might get the script to SEG FAULT.  \n");
 }
 else if(!strcasecmp(ask,"setstrictwrite"))
 {
  strcat(help_string,"setstrictwrite ;\n");
  strcat(help_string,"Don't append a space at the end of a 'write' command. Useful for web\n");
  strcat(help_string,"servers mainly.  \n");
 }
 else if(!strcasecmp(ask,"setlogfile"))
 {
  strcat(help_string,"setlogfile <filename> ;\n");
  strcat(help_string,"Changes the LOGFILE name. Set it to 'syslog' to make SScript log with the\n");
  strcat(help_string,"syslogd facility.\n");
 }
 else if(!strcasecmp(ask,"settrace"))
 {
  strcat(help_string,"settrace ;\n");
  strcat(help_string,"Traces every command in trace.log for debugging purposes. Can get pretty large.  \n");
 }
 else if(!strcasecmp(ask,"setwindows"))
 {
  strcat(help_string,"setwindows ;\n");
  strcat(help_string,"Set Windows compatibility. Unfortunatly Windows's telnet doesn't follow\n");
  strcat(help_string,"normal rules and needs SScript to tell it there's a return sign AND a\n");
  strcat(help_string,"new line for it to parse text properly. Turn this on if you want to make\n");
  strcat(help_string,"Windows-compatible server-oriented scripts. This is not compatible with\n");
  strcat(help_string,"setstrictwrite.  \n");
 }
 else if(!strcasecmp(ask,"setsignalsoff"))
 {
  strcat(help_string,"setsignalsoff ;\n");
  strcat(help_string,"This function sets the signal handeling off, so SScript won't say\n");
  strcat(help_string,"anything if dies from errors like Seg fault or Broken pipe. Useful for \n");
  strcat(help_string,"server-oriented scripts.  \n");
 }
 else if(!strcasecmp(ask,"rconnect"))
 {
  strcat(help_string,"rconnect <variable number> ;\n");
  strcat(help_string,"Makes an other connection. <variable number> must contain\n");
  strcat(help_string,"\"<remote ip> <remote port> <protocol number> <type> ;\" (without the  \n");
  strcat(help_string,"quotes). You can then read and write with rread and rwrite. Returns an  \n");
  strcat(help_string,"error in <variable number> if the connect failed. <protocol number> is 0\n");
  strcat(help_string,"for IP and <type> is 1 for TCP.  \n");
 }
 else if(!strcasecmp(ask,"rread"))
 {
  strcat(help_string,"rread <variable number> ;\n");
  strcat(help_string,"Reads from the second connection and puts the result in\n");
  strcat(help_string,"<variable number>.  \n");
 }
 else if(!strcasecmp(ask,"rwrite"))
 {
  strcat(help_string,"rwrite <variable number> ;\n");
  strcat(help_string,"Writes what's in <variable number> to the second connection.  \n");
 }
 else if(!strcasecmp(ask,"rdisconnect"))
 {
  strcat(help_string,"rdisconnect ;\n");
  strcat(help_string,"Disconnects the other remote connection.  \n");
 }
 else if(!strcasecmp(ask,"for"))
 {
  strcat(help_string,"for <for number> <start number> to <end number> ;\n");
  strcat(help_string,"This is a loop which begins at <start number> and ends at <end\n");
  strcat(help_string,"number>. The current number where the loop is currently in can be\n");
  strcat(help_string,"accessed with $%. You can set <end number> to -1 to get an infinite\n");
  strcat(help_string,"loop.  \n");
 }
 else if(!strcasecmp(ask,"endfor"))
 {
  strcat(help_string,"endfor <for number> ;\n");
  strcat(help_string,"Goes back to the 'for' corresponding to <for number> untill <end\n");
  strcat(help_string,"number> is reached.  \n");
 }
 else if(!strcasecmp(ask,"ask"))
 {
  strcat(help_string,"ask <variable number> ;\n");
  strcat(help_string,"Waits for input from the user.  \n");
 }
 else if(!strcasecmp(ask,"exit"))
 {
  strcat(help_string,"exit [exit code] ;\n");
  strcat(help_string,"Makes the program quit. The exit code is optional and only for error reporting. \n");
 }
 else if(!strcasecmp(ask,"ifword"))
 {
  strcat(help_string,"ifword <variable number> <word number> <word> <string>\n");
  strcat(help_string,"This function compares 2 words. It matches <word> with the word in\n");
  strcat(help_string,"<variable number> at position <word number> and if it does match, it\n");
  strcat(help_string,"sends <string> to the server.  \n");
 }
 else if(!strcasecmp(ask,"ifword2"))
 {
  strcat(help_string,"ifword2 <variable number> <word number> <word> <word number 2> <word 2> <string>\n");
  strcat(help_string,"This is like ifword, but tries to match 2 different sets of words.  \n");
 }
 else if(!strcasecmp(ask,"ifmaster"))
 {
  strcat(help_string,"ifmaster <variable number> <word number> <word> <string>\n");
  strcat(help_string,"This is like ifword, but the sender must also be the nick!user@host\n");
  strcat(help_string,"sets by setmaster. Used in IRC bots.  \n");
 }
 else if(!strcasecmp(ask,"ifmaster2"))
 {
  strcat(help_string,"ifmaster2 <variable number> <word number> <word> <word number 2> <word 2> <sting>\n");
  strcat(help_string,"This is like ifword2, but the sender must also be the nick!user@host\n");
  strcat(help_string,"sets by setmaster. Used in IRC bots.  \n");
 }
 else if(!strcasecmp(ask,"ifmatch"))
 {
  strcat(help_string,"ifmatch <variable number> <masked word> <string>\n");
  strcat(help_string,"If there is a match for <masked word> in <variable number>, then\n");
  strcat(help_string,"writes <string>.  \n");
 }
 else if(!strcasecmp(ask,"?compare"))
 {
  strcat(help_string,"?compare <variable number 1> <variable number 2> <sub name> ;\n");
  strcat(help_string,"If the first word of <variable number 1> is the same as <variable number\n");
  strcat(help_string,"2> then go to <sub name>.  \n");
 }
 else if(!strcasecmp(ask,"?match"))
 {
  strcat(help_string,"?match <variable number 1> <variable number 2> <sub name> ;\n");
  strcat(help_string,"If the masked word in <variable number 1> match the one in <variable\n");
  strcat(help_string,"number 2> then go to <sub name>.  \n");
 }
 else if(!strcasecmp(ask,"loop"))
 {
  strcat(help_string,"loop start <loop number> ;\n");
  strcat(help_string,"This is used to start a loop.\n\n");
  strcat(help_string,"loop end <loop number> ;\n");
  strcat(help_string,"This is the end of the loop. When the program reaches this line, it\n");
  strcat(help_string,"goes back to the right loop start ; line and loops indefinitly.\n");
 }
 else if(!strcasecmp(ask,"saveall"))
 {
  strcat(help_string,"saveall <file> ;\n");
  strcat(help_string,"Reads all there is to read from the server and saves it in <file>.  \n");
 }
 else if(!strcasecmp(ask,"addlog"))
 {
  strcat(help_string,"addlog <variable number> ;\n");
  strcat(help_string,"Add to SScript's log file what's in <variable number>.  \n");
 }
 else if(!strcasecmp(ask,"run"))
 {
  strcat(help_string,"run <variable number>\n");
  strcat(help_string,"Executes a shell command contained in <variable number>.  \n");
 }
 else if(!strcasecmp(ask,"goto"))
 {
  strcat(help_string,"goto <function name> ;\n");
  strcat(help_string,"Go to a function. You need to define a function with the sub command.  \n");
 }
 else if(!strcasecmp(ask,"sub"))
 {
  strcat(help_string,"sub <function name> ;\n");
  strcat(help_string,"Declares a function to be called with goto to $goto. \n");
 }
 else if(!strcasecmp(ask,"wait"))
 {
  strcat(help_string,"wait ;\n");
  strcat(help_string,"Makes the bot wait 1 sec. Useful for debugging purposes or if you\n");
  strcat(help_string,"want to see what the program is reading. \n");
 }
 else if(!strcasecmp(ask,"if"))
 {
  strcat(help_string,"if <variable number 1> [<,>,=,!=] <variable number 2> <sub name> ;\n");
  strcat(help_string,"Check if the number in <variable number 1> is '>', '<', '=' or '!=' the\n");
  strcat(help_string,"one in <variable number 2>. If it is, goto <sub name>. \n");
 }
 else if(!strcasecmp(ask,"cron"))
 {
  strcat(help_string,"cron <command line>\n");
  strcat(help_string,"SScript will run that command line every time just before it exits. Can\n");
  strcat(help_string,"be useful to restart itself when it gets a segfault or some other\n");
  strcat(help_string,"error. Note that this can be a dangerous command if not used wisely. If\n");
  strcat(help_string,"you run into a loop it can hang resources down. Be very carefull when\n");
  strcat(help_string,"using it. Also the <command line> should end with a '&' if you want\n");
  strcat(help_string,"sscript to sucessfully quit. \n");
 }
 else if(!strcasecmp(ask,"file"))
 {
  strcat(help_string,"file <type> <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Get stats about a file. <type> must be exist, size, owner, group, mode,\n");
  strcat(help_string,"mtime, atime, ctime, open, close or access. The file name must be in <variable number 1>, and\n");
  strcat(help_string,"it returns the expected result in <variable number 2>. Check\n");
  strcat(help_string,"sscript.files for an example.\n");
 }
 else if(!strcasecmp(ask,"remoteip"))
 {
  strcat(help_string,"remoteip <variable number> ;\n");
  strcat(help_string,"For server-oriented scripts, set the remote IP number in <variable\n");
  strcat(help_string,"number>. \n");
 }
 else if(!strcasecmp(ask,"random"))
 {
  strcat(help_string,"random <variable number> <max number> ;\n");
  strcat(help_string,"This will output a random number from 0 to <max number> in <variable \n");
  strcat(help_string,"number>. \n");
 }
 else if(!strcasecmp(ask,"command"))
 {
  strcat(help_string,"command <variable number> ;\n");
  strcat(help_string,"This will make SScript execute a command line in <variable number> just\n");
  strcat(help_string,"like if it was a line in the current script. \n");
 }
 else if(!strcasecmp(ask,"resolve"))
 {
  strcat(help_string,"resolve [ip,host] <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Resolve an IP from <variable number 1> to an host and put it in \n");
  strcat(help_string,"<variable number 2>, or resolve an host from <variable number 1> to an\n");
  strcat(help_string,"IP and put it in <variable number 2>. \n");
 }
 else if(!strcasecmp(ask,"cl"))
 {
  strcat(help_string,"cl <library> <args>\n");
  strcat(help_string,"This loads a custom library. SScript comes currently with 1\n");
  strcat(help_string,"library: the gui-tk library that provides a graphical interface\n");
  strcat(help_string,"to SScript. See section 4 of this document for more. \n");
 }
 else if(!strcasecmp(ask,"udpsend"))
 {
  strcat(help_string,"udpsend <variable number> ;\n");
  strcat(help_string,"Send an UDP message to a remote host. <variable number> must contain\n");
  strcat(help_string,"'<ip> <port> <message>' Returns an error message in <variable number> if\n");
  strcat(help_string,"the function fails. \n");
 }
 else if(!strcasecmp(ask,"udplisten"))
 {
  strcat(help_string,"udplisten <variable number> <port number> ;\n");
  strcat(help_string,"Listens for UDP calls at the specified port and returns what it got. \n");
 }
 else if(!strcasecmp(ask,"icmplisten"))
 {
  strcat(help_string,"icmplisten <variable number> ;\n");
  strcat(help_string,"This will return the next ICMP packet it caught in <variable number> in\n");
  strcat(help_string,"the form: '<time> <type> <ip of sender> ;' See ICMP.types for\n");
  strcat(help_string,"descriptions of ICMP types. Must be run as root.\n");
 }
 else if(!strcasecmp(ask,"raw"))
 {
  strcat(help_string,"raw <variable number 1> <number of loops> <variable number 2> ;\n");
  strcat(help_string,"This command scans an ethernet device for TCP packets. It waits for a \n");
  strcat(help_string,"packet from the device in <variable number 1> (for example eth0), and\n");
  strcat(help_string,"returns it in <variable number 2> in the following format: \"<source ip>\n");
  strcat(help_string,"<source port> -> <dest ip> <dest port> ;\" It does this <number of loops>\n");
  strcat(help_string,"times. If the number of loops is more than 1, <variable number 2> is\n");
  strcat(help_string,"overwrited at every new packet. Returns an error message in <variable\n");
  strcat(help_string,"number 1> if the function fails. This can be useful to monitor packets\n");
  strcat(help_string,"and check for remote addresses that access the system. Note that sscript\n");
  strcat(help_string,"must be run as root and it only works on Linux for now. \n");
 }
 else if(!strcasecmp(ask,"rawp"))
 {
  strcat(help_string,"rawp <variable number> <number of loops> ;\n");
  strcat(help_string,"This does the same as raw, but prints the result directly to the screen. \n");
 }
 else if(!strcasecmp(ask,"msgbox"))
 {
  strcat(help_string,"msgbox <variable number> ;\n");
  strcat(help_string,"Show an info box with the string in <variable box>. You must have\n");
  strcat(help_string,"specified the graphical mode in the config. \n");
 }
 else if(!strcasecmp(ask,"query"))
 {
  strcat(help_string,"query <variable number 1> <variable number 2> ;\n");
  strcat(help_string,"Asks the user a question, showing the string in <variable number 1> as \n");
  strcat(help_string,"the question, and storing the user's input in <variable number 2>. You  \n");
  strcat(help_string,"must have specified the graphical mode in the config.\n");
 }
 else if(!strcasecmp(ask,"viewfile"))
 {
  strcat(help_string,"viewfile <file name> [-query <variable number>] ;\n");
  strcat(help_string,"Open a text box to view the whole content of the file <file name>. You  \n");
  strcat(help_string,"must have specified the graphical mode in the config. If you add the \n");
  strcat(help_string,"-query option, SScript will also ask the question in <variable number>  \n");
  strcat(help_string,"to the user, and put his answer in <vairable number>.\n");
 }
 else if(!strcasecmp(ask,"devstat"))
 {
  strcat(help_string,"devstat <device> <variable number> ;\n");
  strcat(help_string,"This reports stats about a network device like eth0 or lo and reports it\n");
  strcat(help_string,"in <variable number> in the following format: <device> <promisc> <up>   \n");
  strcat(help_string,"<pointopoint> <broadcast> <multicast> <allmulti> <no arp>. All stats are\n");
  strcat(help_string,"0 for OFF or 1 for ON. See sscript.devstat for an example. \n");
 }
 else if(!strcasecmp(ask,"setowner"))
 {
  strcat(help_string,"setowner <userid> ;\n");
  strcat(help_string,"Sets the owner to <userid>. This can be useful for a server-side script\n");
  strcat(help_string,"running as root to set its children as user 'nobody' (userid: 65534).\n");
  strcat(help_string,"Must be run as root. Use carefully.\n");
 }
 else if(!strcasecmp(ask,"background"))
 {
  strcat(help_string,"background ;  \n");
  strcat(help_string,"Send the script in the background. This shouldn't be use with   \n");
  strcat(help_string,"server-oriented scripts if you set FORK_START to ON in config.h\n");
 }
 else
 {
  strcat(help_string,"Unknown function.\n");
 }
#ifdef GTK
 if(type==3 && strcasecmp(ask,"(null)")) GTK_composer_cmd_return(help_string);
#endif
#ifdef GUI
 if(type!=3 || !strcasecmp(ask,"(null)")) gui_help(help_string, argc, argv);
#else
 if(type!=3) text_help(help_string);
#endif
}

int text_help(char *help_string[])
{
 printf("%s\n",help_string);
 return 0;
}

char *if_setup(char *device)
{
#ifdef DEV_STAT
 /* based on Trevor F. Linton's code, with written consent */
 int sockfd, device_flags=0, found=0;
 char lbuf[255], *blen, *blenmax;
 struct ifreq ifreq, *ifr;
 struct ifconf ifc;
 if((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
 {
  sprintf(global_var, "SOCKET FAILED: %s", strerror(errno));
  lasterror=109;
  return (char *)global_var;
 }
 ifc.ifc_len = sizeof(lbuf);
 ifc.ifc_buf = lbuf;
 if(ioctl(sockfd, SIOCGIFCONF, (char *)&ifc) < 0)
 {
  sprintf(global_var, "IOCTL FAILED: %s", strerror(errno));
  lasterror=119;
  return (char *)global_var;
 }
 ifr = ifc.ifc_req;
 blenmax = lbuf + ifc.ifc_len;
 for(blen = lbuf; blen < blenmax; blen = blen + sizeof(ifr->ifr_name) + sizeof(ifr->ifr_addr))
 {
  ifr = (struct ifreq *)blen;
  if(strcmp(ifr->ifr_name, device)) continue;
  found = 1;
  ifreq = *ifr;
  if(ioctl(sockfd, SIOCGIFFLAGS, (char *)&ifreq) < 0)
  {
   sprintf(global_var, "IOCTL FAILED: %s", strerror(errno));
   lasterror=119;
   return (char *)global_var;
  }
  device_flags = ifreq.ifr_flags;
  sprintf(global_var, "%s ", ifreq.ifr_name);
  if((device_flags & IFF_PROMISC) != 0) strcat(global_var, "1 ");
  else strcat(global_var, "0 ");
  if((device_flags & IFF_UP) != 0) strcat(global_var, "1 ");
  else strcat(global_var, "0 ");
  if((device_flags & IFF_POINTOPOINT) != 0) strcat(global_var, "1 ");
  else strcat(global_var, "0 ");
  if((device_flags & IFF_BROADCAST) != 0) strcat(global_var, "1 ");
  else strcat(global_var, "0 ");
  if((device_flags & IFF_MULTICAST) != 0) strcat(global_var, "1 ");
  else strcat(global_var, "0 ");
  if((device_flags & IFF_ALLMULTI) != 0) strcat(global_var, "1 ");
  else strcat(global_var, "0 ");
  if((device_flags & IFF_NOARP) != 0) strcat(global_var, "1");
  else strcat(global_var, "0");
 }
 if(found==0) sprintf(global_var, "%s: Unknown device.", device);
 return (char *)global_var;
#endif
}

int debugger(char *file)
{
 FILE *fp;
 char tmp[255];
 int line,i;
 printf("Checking %s...\n",file);
 fp=fopen(file,"r");
 if(fileno(fp)<0)
 {
  printf("Error: Script not found.\n");
  exit(1);
 }
 if(fgets(tmp,255,fp)==NULL) printf("Error: Server line not found.\n");
 if(strcasecmp(lindex(tmp,0),"server")) printf("Error: Server line not found.\n");
 if(fgets(tmp,255,fp)==NULL) printf("Error: Port line not found.\n");
 if(strcasecmp(lindex(tmp,0),"port")) printf("Error: Port line not found.\n");
 if(fgets(tmp,255,fp)==NULL) printf("Error: Debug line not found.\n");
 if(strcasecmp(lindex(tmp,0),"debug")) printf("Error: Debug line not found.\n");
 if(fgets(tmp,255,fp)==NULL) printf("Error: Chop line not found.\n");
 if(strcasecmp(lindex(tmp,0),"chop")) printf("Error: Chop line not found.\n");
 if(fgets(tmp,255,fp)==NULL) printf("Error: Virtual line not found.\n");
 if(strcasecmp(lindex(tmp,0),"virtual")) printf("Error: Virtual line not found.\n");
 line=5;
 while(fgets(tmp,255,fp)!=NULL)
 {
  line++;
  for(i=0;lindex(tmp,i)!=NULL;i++) { }
  if(strcasecmp(lindex(tmp,0),"#") && 
     strcasecmp(lindex(tmp,0),"print") &&
     strcasecmp(lindex(tmp,0),"set") && 
     strcasecmp(lindex(tmp,0),"write") &&
     strcasecmp(lindex(tmp,0),"ifmatch") &&
     strcasecmp(lindex(tmp,0),"ifmatch2") &&
     strcasecmp(lindex(tmp,0),"ifword") && 
     strcasecmp(lindex(tmp,0),"ifword2") && 
     strcasecmp(lindex(tmp,0),"ifmaster") &&
     strcasecmp(lindex(tmp,0),"ifmaster2"))
  if(*lindex(tmp,i-1)!=';') printf("Warning: Line does not end with ';' [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"ifword") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"ifword2") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"ifmaster") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"ifmaster2") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"ifmatch") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"ifmatch2") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"require") && atoi(lindex(tmp,1))<1)
   printf("Error: Version number < 0 [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"save") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);  
  if(!strcasecmp(lindex(tmp,0),"append") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"rementry") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"remove") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"parse") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"for") && lindex(tmp,5)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"endfor") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"?compare") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"?match") && lindex(tmp,3)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"loop") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"sub") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"goto") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"if") && lindex(tmp,4)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"random") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"udplisten") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
  if(!strcasecmp(lindex(tmp,0),"raw") && lindex(tmp,2)==NULL)
   printf("Error: Not enough parameters [line %d]\n",line);
 }
 printf("End of file.\n");
}

int remote(char *host, int port, char *script, char *filename)
{
 int rsock, len, i, result;
 FILE *fr;
 char data[1024]="";
 char inchar;
 struct sockaddr_in address;
 rsock=socket(AF_INET, SOCK_STREAM, 0);
 if(rsock<0)
 {
#ifdef GUI
   if(lang==0)   
   msgbox("error","Internal error: Socket failed.",25);
   else if(lang==1)
   msgbox("error","Erreur interne: Socket erreur.",25);
   else if(lang==2)
   msgbox("error","Error Interno: Fallo el Socket.",25);
#else
   if(lang==0)
   fprintf(stderr,"*** Internal error: Socket failed [%d].\n",errno);
   else if(lang==1)
   fprintf(stderr,"*** Erreur interne: Socket erreur. [%d].\n",errno);
   else if(lang==2)
   fprintf(stderr,"*** Error Interno: Fallo el Socket. [%d].\n",errno);
#endif
   exit(1);
 }
 address.sin_family = AF_INET;
 address.sin_addr.s_addr = inet_addr(host);
 address.sin_port = htons(port);
 len = sizeof(address);
 result = connect(rsock, (struct sockaddr *)&address, len);
 if(result==-1)
 {
#ifdef GUI
  if(lang==0)
  msgbox("error","Script error: Can't connect to remote host.",30);
  else if(lang==1)
  msgbox("error","Erreur script: Incapable de me connecter.",30);
  else if(lang==2)
  msgbox("error","Error en Script: No se puede conectar a host remoto.",30);
#else
  if(lang==0)
  fprintf(stderr,"*** Script error: Can't connect to %s\n",host);
  else if(lang==1)
  fprintf(stderr,"*** Erreur script: Incapable de me connecter sur %s\n",host);
  else if(lang==2)
  fprintf(stderr,"*** Error en Script: No se puede conectar a host remoto %s\n",host);
#endif
  exit(1);
 }
 sprintf(data,"%s ;\n",script);
 write(rsock,data,sizeof(data));
 fr=fopen(filename,"w");
 while(strcasecmp(lindex(data,0),"--DATA--"))
 {
  bzero(data, 1024);
  for(i=0;(result=read(rsock,&inchar,1))!='\0';i++)
  {
   data[i]=inchar;
   if(inchar=='\n') break;
  }
  fputs(data,fr);
 }
 if(fr!=NULL) fclose(fr);
}

char *constat(char *option, int sockfd)
{
 char data[255];
 int optlen=sizeof(int),optval=1;
 if(!strcasecmp(option,"sendbuf")) getsockopt(sockfd, SOL_SOCKET, SO_SNDBUF, (char *)&optval, &optlen);
 else if(!strcasecmp(option,"recvbuf")) getsockopt(sockfd, SOL_SOCKET, SO_RCVBUF, (char *)&optval, &optlen);
 else if(!strcasecmp(option,"error")) getsockopt(sockfd, SOL_SOCKET, SO_ERROR, (char *)&optval, &optlen);
 else if(!strcasecmp(option,"type")) getsockopt(sockfd, SOL_SOCKET, SO_TYPE, (char *)&optval, &optlen);
 else optval=-1;
 sprintf(global_var,"%d",optval);
 return (char *)global_var;
}

int firewall()
{
 /* maybe this should be changed to use ipfw(4) instead...*/
 char src[25], dst[25], protocol[5], what[5], rule[5], result[100];
 int port;
 if(lindex(temp,1)==NULL || lindex(temp,2)==NULL || lindex(temp,3)==NULL || lindex(temp,4)==NULL || lindex(temp,5)==NULL || lindex(temp,6)==NULL)
 {
  lasterror=200;
  return -1;
 }
 if(strcasecmp(lindex(temp,1),"add") && strcasecmp(lindex(temp,1),"rem"))
 {
  lasterror=201;
  return -1;
 }
 if(strcasecmp(lindex(temp,2),"allow") && strcasecmp(lindex(temp,2),"deny"))
 {
  lasterror=201;
  return -1;
 }
 if(strcasecmp(lindex(temp,6),"icmp") && strcasecmp(lindex(temp,6),"tcp") && strcasecmp(lindex(temp,6),"udp") && strcasecmp(lindex(temp,6),"ALL"))
 {
  lasterror=201;
  return -1;
 }
 strcpy(src,lindex(temp,3));
 strcpy(dst,lindex(temp,4));
 strcpy(protocol,lindex(temp,6));
 if(!strcasecmp(lindex(temp,1),"add")) strcpy(what,"-i");
 if(!strcasecmp(lindex(temp,1),"rem")) strcpy(what,"-d");
 if(!strcasecmp(lindex(temp,2),"allow")) strcpy(rule,"accept");
 if(!strcasecmp(lindex(temp,2),"deny")) strcpy(rule,"deny");
 port = atoi(lindex(temp,5));
 if(!strcasecmp(src,"ALL")) strcpy(src,"0.0.0.0/0");
 else sprintf(src,"%s/28",lindex(temp,3));
 if(!strcasecmp(dst,"ALL")) strcpy(dst,"0.0.0.0/0");
 else sprintf(dst,"%s/28",lindex(temp,4));
 if(!strcasecmp(protocol,"ALL"))
 {
  if(port==0)
  {
   sprintf(result,"%s -I %s %s -P tcp -S %s -D %s\n",IPFW,what,rule,src,dst);
   sprintf(result,"%s -I %s %s -P udp -S %s -D %s\n",IPFW,what,rule,src,dst);
   sprintf(result,"%s -I %s %s -P icmp -S %s -D %s\n",IPFW,what,rule,src,dst);
  }
  else
  {
   sprintf(result,"%s -I %s %s -P tcp -S %s -D %s %d\n",IPFW,what,rule,src,dst,port); 
   sprintf(result,"%s -I %s %s -P udp -S %s -D %s %d\n",IPFW,what,rule,src,dst,port);
   sprintf(result,"%s -I %s %s -P icmp -S %s -D %s %d\n",IPFW,what,rule,src,dst,port);
  }
 }
 else
 {
  if(port==0) sprintf(result,"%s -I %s %s -P %s -S %s -D %s\n",IPFW,what,rule,protocol,src,dst);
  else sprintf(result,"%s -I %s %s -P %s -S %s -D %s %d\n",IPFW,what,rule,protocol,src,dst,port);
 }
 system(result);
}

int users(char in[1024][512])
{
#ifdef POSIX
 struct passwd *pw;
 if(!strcasecmp(lindex(in[atoi(lindex2(temp,1))],0),"UID"))
 {
  pw = getpwuid(atol(lindex(in[atoi(lindex2(temp,1))],1)));
  if(pw!=NULL)
  sprintf(in[atoi(lindex(temp,2))],"%s %ld %ld %s %s ;",pw->pw_name,pw->pw_uid,pw->pw_gid,pw->pw_passwd,pw->pw_dir);
  else
  sprintf(in[atoi(lindex(temp,2))],"unknown -1 -1 unknown unknown ;");
 }
 if(!strcasecmp(lindex(in[atoi(lindex2(temp,1))],0),"NAME"))
 {
  pw = getpwnam(lindex(in[atoi(lindex2(temp,1))],1));
  if(pw!=NULL)
  sprintf(in[atoi(lindex(temp,2))],"%s %ld %ld %s %s ;",pw->pw_name,pw->pw_uid,pw->pw_gid,pw->pw_passwd,pw->pw_dir);
  else
  sprintf(in[atoi(lindex(temp,2))],"unknown -1 -1 unknown unknown ;");
 }
#endif
}

int des_file(int type, char in[1024][512])
{
 char data[255];
 if(type==1)
 {
  if(lindex(in[atoi(lindex2(temp,1))],0)!=NULL && lindex(in[atoi(lindex2(temp,1))],1)!=NULL)
  {
   sprintf(data,"des -E %s %s.des -k %s",lindex(in[atoi(lindex2(temp,1))],0),lindex(in[atoi(lindex2(temp,1))],0),lindex(in[atoi(lindex2(temp,1))],1));
   system(data);
  }
 }
 else
 {
  if(lindex(in[atoi(lindex2(temp,1))],0)!=NULL && lindex(in[atoi(lindex2(temp,1))],1)!=NULL)
  {
   sprintf(data,"des -D %s.des %s -k %s",lindex(in[atoi(lindex2(temp,1))],0),lindex(in[atoi(lindex2(temp,1))],0),lindex(in[atoi(lindex2(temp,1))],1));
   system(data);
  }
 }
}

int math_fct(char in[1024][512])
{
 float a;
 if(lindex(temp,1)==NULL || lindex(temp,2)==NULL || lindex(temp,3)==NULL) return;
 if(!strcasecmp(lindex(temp,2),"LOG"))
 sprintf(in[atoi(lindex(temp,1))],"%f",log10(atof(lindex(temp,3))));
 else if(!strcasecmp(lindex(temp,2),"LN"))
 sprintf(in[atoi(lindex(temp,1))],"%f",log(atof(lindex(temp,3))));
 else if(!strcasecmp(lindex(temp,2),"E"))
 sprintf(in[atoi(lindex(temp,1))],"%f",exp(atof(lindex(temp,3))));
 else if(!strcasecmp(lindex(temp,2),"SQRT"))
 sprintf(in[atoi(lindex(temp,1))],"%f",sqrt(atof(lindex(temp,3))));
 else if(!strcasecmp(lindex(temp,2),"EXPR"))
 {
  if(!strcasecmp(lindex(temp,4),"+"))
  sprintf(in[atoi(lindex(temp,1))],"%f",(atof(in[atoi(lindex2(temp,3))])+atof(in[atoi(lindex(temp,5))])));
  if(!strcasecmp(lindex(temp,4),"-"))
  sprintf(in[atoi(lindex(temp,1))],"%f",(atof(in[atoi(lindex2(temp,3))])-atof(in[atoi(lindex(temp,5))])));
  if(!strcasecmp(lindex(temp,4),"*"))
  sprintf(in[atoi(lindex(temp,1))],"%f",(atof(in[atoi(lindex2(temp,3))])*atof(in[atoi(lindex(temp,5))])));
  if(!strcasecmp(lindex(temp,4),"/"))
  sprintf(in[atoi(lindex(temp,1))],"%f",(atof(in[atoi(lindex2(temp,3))])/atof(in[atoi(lindex(temp,5))])));
 }
 else
 sprintf(in[atoi(lindex(temp,1))],"-1");
}

int password(char in[1024][512])
{
#ifdef PASSWORD
 struct termios first, new;
 tcgetattr(fileno(stdin), &first);
 new = first;
 new.c_lflag &= ~ECHO;
 if(tcsetattr(fileno(stdin), TCSAFLUSH, &new)!=0)
  fprintf(stderr,"termios error\n");
 else
 {
  printf("Password: ");
/*  fgets(in[atoi(lindex(temp,1))], PASS_LENGHT, stdin);*/
  gets(in[atoi(lindex(temp,1))]);
  tcsetattr(fileno(stdin), TCSANOW, &first);
/* in[atoi(lindex(temp,1))][strlen(in[atoi(lindex(temp,1))])-1]=' ';*/
  printf("\n");
 }
#endif
}

int get_service(char *name)
{
 struct servent *s;
 s = getservbyname(name, "tcp");
 if(s!=NULL) return ntohs(s->s_port);
 else return -1;
}

int listen_select(int sockfd, int rsck)
{
 int max_fd;
 fd_set readfs, newfs;
 FD_ZERO(&readfs);
 FD_SET(sockfd, &readfs);
 FD_SET(rsck, &readfs);
 if(sockfd>rsck) max_fd = sockfd;
 else max_fd = rsck;
 memcpy(&newfs, &readfs, sizeof(readfs));
 select(max_fd+1, &newfs, NULL, NULL, NULL);
 if(FD_ISSET (sockfd, &newfs)) return 1;
 else if(FD_ISSET (rsck, &newfs)) return 2;
 else return 0;
}

char *timeread(int sockfd, int time_sec)
{
 struct timeval timeout;
 int max_fd;
 fd_set readfs, newfs;
 timeout.tv_sec=time_sec;
 timeout.tv_usec=0;
 FD_ZERO(&readfs);
 FD_SET(sockfd, &readfs);
 max_fd = sockfd;
 memcpy(&newfs, &readfs, sizeof(readfs));
 select(max_fd+1, &newfs, NULL, NULL, &timeout);
 if(FD_ISSET (sockfd, &newfs))
 {
  read(sockfd, global_var, sizeof(global_var));
  return(global_var);
 }
 return("timeout");
}

int redir(int sockfd, int rsck)
{
 char buf[4096];
 fd_set readfs, newfs;
 int max_fd, len;
 FD_ZERO(&readfs);
 FD_SET(sockfd, &readfs);
 FD_SET(rsck, &readfs);
 if(sockfd>rsck) max_fd = sockfd;
 else max_fd = rsck;
 while(1) {
  memcpy(&newfs, &readfs, sizeof(readfs));
  select(max_fd+1, &newfs, NULL, NULL, NULL);
  if(FD_ISSET(sockfd, &newfs))
  {
   if((len=read(sockfd, buf, sizeof(buf)))<1) break;
   if(write(rsck, buf, len)!=len) break;
  }
  if(FD_ISSET(rsck, &newfs))
  {
   if((len=read(rsck, buf, sizeof(buf)))<1) break;
   if(write(sockfd, buf, len)!=len) break;
  }
 }
}

int multilisten(char in[1024][512], int s1, int s2)
{
 /* multilisten [mode] <v1> <v2> */
 char buf[512];
 fd_set readfs, newfs;
 int max_fd, len;
 bzero(buf, 512);
 FD_ZERO(&readfs);
 FD_SET(s1, &readfs);
 FD_SET(s2, &readfs);
 if(s1>s2) max_fd = s1;
 else max_fd = s2;
 while(1) {
  memcpy(&newfs, &readfs, sizeof(readfs));
  select(max_fd+1, &newfs, NULL, NULL, NULL);
  if(FD_ISSET(s1, &newfs))
  {
   len=read(s1, buf, sizeof(buf));
   if(len==0) lasterror=122;
   sprintf(in[atoi(lindex(temp,2))],"%d",1);
   strcpy(in[atoi(lindex(temp,3))],buf);
   return;
  }
  if(FD_ISSET(s2, &newfs))
  {
   len=read(s2, buf, sizeof(buf));
   if(len==0) lasterror=122;
   sprintf(in[atoi(lindex(temp,2))],"%d",2);
   strcpy(in[atoi(lindex(temp,3))],buf);
   return; 
  }
 }
}

char *procinfo(char *what)
{
 FILE *fd;
 char data[255];
 struct proc_cpuinfo cpuinfo;
 struct proc_meminfo meminfo;
 fd = fopen("/proc/cpuinfo", "r");
 if(fd==NULL) return("unknown");
 while(fgets(data,255,fd)!=NULL)
 {
  data[strlen(data)-1] = ' ';
  if(!match("cpu\t*",lindex(data,0)))
   cpuinfo.cpu = atoi(lindex(data,1));
  else if(!match("model\t*",lindex(data,0)))
   strncpy(cpuinfo.model, lindex(data,1), 20);
  else if(!match("vendor_id\t*",lindex(data,0)))
   strncpy(cpuinfo.vendor, lindex(data,1), 20);
  else if(!match("fpu\t*",lindex(data,0)))
  {
   if(!strcasecmp(lindex(data,1),"yes"))
   cpuinfo.fpu = 1;
   else
   cpuinfo.fpu = 0;
  }
 }
 fclose(fd);
 if(!strcasecmp(what,"cpu"))
 {
  sprintf(global_var, "%d", cpuinfo.cpu);
  return(global_var);
 }
 if(!strcasecmp(what,"fpu"))
 {
  sprintf(global_var, "%d", cpuinfo.fpu);
  return(global_var);
 }
 if(!strcasecmp(what,"model"))
 {
  sprintf(global_var, "%s", cpuinfo.model);
  return(global_var);
 }
 if(!strcasecmp(what,"vendor"))
 {
  sprintf(global_var, "%s", cpuinfo.vendor);
  return(global_var);
 }
 fd = fopen("/proc/meminfo", "r");
 if(fd==NULL) return("unknown");
 while(fgets(data,255,fd)!=NULL)
 {
  data[strlen(data)-1] = ' ';
  if(!strcasecmp(lindex(data,0),"MemTotal:"))
  meminfo.total_mem = atol(lindex(data,1));
  else if(!strcasecmp(lindex(data,0),"MemFree:"))
  meminfo.free_mem = atol(lindex(data,1));
  else if(!strcasecmp(lindex(data,0),"SwapTotal:"))
  meminfo.total_swap = atol(lindex(data,1));
  else if(!strcasecmp(lindex(data,0),"SwapFree:"))
  meminfo.free_swap = atol(lindex(data,1));
 }
 if(!strcasecmp(what,"freemem"))
 {
  sprintf(global_var, "%ld", meminfo.free_mem);
  return(global_var);
 }
 if(!strcasecmp(what,"totalmem"))
 {
  sprintf(global_var, "%ld", meminfo.total_mem);
  return(global_var);
 }
 if(!strcasecmp(what,"totalswap"))
 {
  sprintf(global_var, "%ld", meminfo.total_swap);
  return(global_var);
 }
 if(!strcasecmp(what,"freeswap"))
 {
  sprintf(global_var, "%ld", meminfo.free_swap);
  return(global_var);
 }
 fclose(fd);
 return("unknown");
}
