/*
(C) 1998 Patrick Lambert <drow@fastethernet.net>

This program is free software. You can use, distribute and modify it if
you let this legal note in all future versions, and if the program made
stays under free software. (see sscript.doc)

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

Latest version of Socket Script is always available from
http://devplanet.fastethernet.net/sscript.html
*/

/* This program uses CMU SNMP lib by Juergen Schoenwaelder and Erik
   Schoenfelder available from sunsite.unc.edu 

 Part of this file is from snmpwalk, Copyright 1988, 1989, 1991, 1992 by
 Carnegie Mellon University
*/

#include "sscript.h"
#ifdef USE_SNMP
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <stdio.h>
#include <netdb.h>
#ifdef RAWLINUX
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#endif
#include <snmp/snmp.h>
#include <snmp/mib.h>  
#include <snmp/asn1.h>
#include <snmp/snmp_impl.h>
#include <snmp/snmp_api.h>
#include <snmp/snmp_client.h>
#include <snmp/party.h>
#include <snmp/context.h>
#include <snmp/view.h> 
#include <snmp/acl.h>
oid objid_mib[] = {1, 3, 6, 1, 2, 1};
int snmp_dump_packet = 0;

char *snmp_query(char *hostname, char *community, char *object)
{
 struct snmp_session session, *ss;
 struct snmp_pdu *pdu, *response;
 struct variable_list *vars;
 char buf[2048];
 int gotroot = 0;
 oid name[MAX_NAME_LEN];
 int name_length;
 oid root[MAX_NAME_LEN];  
 int rootlen, count;
 int running;
 int status;
 struct partyEntry *pp;

 init_mib();
 rootlen = MAX_NAME_LEN;
 if(read_objid(object, root, &rootlen))
 {
  gotroot = 1;
 }
 else 
 {
  lasterror = 125;
  return("Invalid object");
 }
 if(gotroot == 0)
 {
  bcopy((char *)objid_mib, (char *)root, sizeof(objid_mib));
  rootlen = sizeof(objid_mib) / sizeof(oid);
  gotroot = 1;
 }
 bzero((char *)&session, sizeof(struct snmp_session));
 session.peername = hostname;
 session.version = SNMP_VERSION_1; 
 session.community = (u_char *)community;
 session.community_len = strlen((char *)community);
 session.retries = SNMP_DEFAULT_RETRIES;
 session.timeout = 2000000L;
 session.authenticator = NULL;
 snmp_synch_setup(&session);
 ss = snmp_open(&session);  
 if (ss == NULL)
 {
  lasterror = 125;
  return("Can't open SNMP");
 }
 bcopy((char *)root, (char *)name, rootlen * sizeof(oid));
 name_length = rootlen;
 running = 1;
 while(running)
 {
  running = 0;
  pdu = snmp_pdu_create(GETNEXT_REQ_MSG);
  snmp_add_null_var(pdu, name, name_length);
  status = snmp_synch_response(ss, pdu, &response);
  if(status == STAT_SUCCESS)
  {
   if(response->errstat == SNMP_ERR_NOERROR)
   {
    for(vars = response->variables; vars; vars = vars->next_variable)
    {
     if(vars->name_length < rootlen || bcmp(root, vars->name, rootlen * sizeof(oid)))
     continue;
     sprint_variable(buf, vars->name, vars->name_length, vars);
     strcpy(global_var,buf);
     return(global_var);
     if(vars->type != SNMP_ENDOFMIBVIEW
     && vars->type != SNMP_NOSUCHOBJECT
     && vars->type != SNMP_NOSUCHINSTANCE)
     {
      bcopy((char *)vars->name, (char *)name, vars->name_length * sizeof(oid));
      name_length = vars->name_length;
      running = 0;
     }
    }
   }
   else
   {
    lasterror = 125;
    return("Error retrieving SNMP");
   }
  }
  else if (status == STAT_TIMEOUT)
  {
   lasterror = 125;
   return("No Response from remote host");
  }
  else
  {
   lasterror = 125;
   return("An error occurred");
  }
  if (response) snmp_free_pdu(response);
 }
 snmp_close(ss);
 return 0;
}

#endif
