/*
rndpwr2.c - random number generator
	generates random number with normal distribution
	from 0 to (2^n) - 1
	where 1 <= n <= 32
Version 1.5.0
Copyright (C) 1999-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Usage:
    	unsigned int i;
    	i = rndpwr(int bits, unsigned char *sd);
*/

/*
Subroutine calls:
	void rnd(unsigned char *sd);
*/

/* offset to high order byte of seed */
#define HIBYTE 15

unsigned int rndpwr(bits,sd)
int bits;
unsigned char *sd;
	{
	int i;
	unsigned int rslt;
	unsigned char *p;
	void rnd();
	if (bits > 32 || bits < 1)
	   return(0);
	rslt = 0;
	p = sd + HIBYTE;
	for (i=0;i<bits;i++)
	   {
	   rnd(sd);
	   rslt <<= 1;
	   rslt |= (*p >> 7) & 1;
	   }
	return(rslt);
	} /* rndpwr */
