/*
smpl.c Version 1.5.0 - Coin Flip Test
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 8, The Normal Probability Distribution */
/* Section 4, Sampling Distribution of the Mean */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* Sample test: */

/* smpl 10000 17 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size "
      "x_length\n", pgm);
   fprintf(stderr,"Where size is 1000 to 1000000000\n");
   fprintf(stderr,"      x_length is 2 to 30\n");
   fprintf(stderr,"Example: %s "
      "10000 17\n", pgm);
   fprintf(stderr,"Size is more than 100 "
      "times larger than x_length ^ 2\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j;
   int size;
   int xlength;
   int ofst;
   int successes;
   int netsuccess;
   int smplsize;
   int min;
   int max;
   int *smplptr;
   int *smplend;
   int *smpl;
   double dblpbase;
   double *p,*q;
   double *prob;
   double *probptr;
   double *probend;
   double totprob;
   double popmu;
   double popvar;
   double popstdev;
   double zscore;
   double dblz;
   double mu,musq;
   double est_xsq;
   double expect;
   double variance,stdev;
   double diff;
   double sumchi;
   double dblsize;
   double sumx,sumxsqd;
   double negtblv,postblv;
   void chirange(int degf, double *lorange,
      double *hirange);
   if (argc != 3) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 1000 || size > 1000000000)
      {
      fprintf(stderr,"Invalid size.\n");
      putstx(*argv);
      } /* bad size */
   dblsize = (double) size;
   xlength = (int) atoi(*(argv+2));
   if (xlength < 2)
      {
      fprintf(stderr,"x_length "
	 "is too small.\n");
      putstx(*argv);
      } /* xlength too small */
   if (xlength > 30)
      {
      fprintf(stderr,"x_length "
	 "is too large.\n");
      putstx(*argv);
      } /* xlength too large */
   if (size < xlength * xlength * 100)
      {
      fprintf(stderr,"Size is too small.\n");
      putstx(*argv);
      } /* if size too small */
   dblpbase = (double) xlength * (double) xlength;
   smplsize = (int) dblpbase;
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"smpl: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */
   /* Allocate array for sample totals */
   smpl = (int *) malloc((smplsize + 1) * sizeof(int) + 32);
   if (smpl == NULL)
      {
      fprintf(stderr,"smpl: out of memory "
	 "allocating array of samples.\n");
      exit(1);
      } /* out of memory */
   prob = (double *) malloc((smplsize + 1) * sizeof(double) + 32);
   if (prob == NULL)
      {
      fprintf(stderr,"smpl: out of memory "
	 "allocating probability array.\n");
      exit(1);
      } /* out of memory */
   p = (double *) prob;
   q = (double *) p + smplsize + 1;
   while (p < q) *p++ = 0.0;
   i = 2;
   while (i <= (xlength + xlength))
      {
      j = 2;
      while (j <= (xlength + xlength))
	 {
	 ofst = (i + j) >> 1;
	 p = (double *) prob + ofst;
	 *p += 1.0;
	 j += 2;
	 } /* for each second value of X */
      i += 2;
      } /* for each first value of X */
   p = (double *) prob + 2;
   q = (double *) p + smplsize;
   while (p < q)
      {
      if (*p < 1.0) break;
      *p++ /= dblpbase;
      } /* for each # of heads */
   mu = 0.0;
   p = (double *) prob + 2;
   q = (double *) p + smplsize + 1;
   i = 2;
   while (p < q)
      {
      if (*p == 0.0) break;
      mu += ((double) i * *p++);
      i++;
      } /* for each # of observations */
   musq = mu * mu;
   est_xsq = 0.0;
   p = (double *) prob + 2;
   q = (double *) p + smplsize + 1;
   i = 2;
   while (p < q)
      {
      if (*p == 0.0) break;
      est_xsq += ((double) (i * i) * *p++);
      i++;
      } /* for each # of observations */
   variance = est_xsq -  musq;
   stdev    = sqrt(variance);
   printf("Sample Mean Probability Distribution\n");
   printf("x = random variable\n");
   printf(" x    P(x) "
      "                  "
      "Total P(x)             z\n");
   totprob = 0.0;
   p = (double *) prob + 2;
   q = (double *) p + smplsize;
   i = 2;
   while (p < q)
      {
      if (i > 2 && *p == 0.0) break;
      totprob += *p;
      dblz = ((double) i - mu) / stdev;
      printf("%2d %22.17f %22.17f %9.4f\n",
	 i, *p, totprob, dblz);
      i++;
      p++;
      } /* for each # of heads */
   printf("\n");
   printf("             Mean       Variance "
      "  Stdev      Z Score      Min     Max\n");
   printf("Population %10.6f %10.6f %10.6f\n",
      mu, variance, stdev);
   popmu    = mu;
   popvar   = variance;
   popstdev = stdev;
   smplptr = (int *) smpl;
   smplend = (int *) smplptr + smplsize + 1;
   while (smplptr < smplend) *smplptr++ = 0;
   sumx = sumxsqd = 0.0;
   min =  999999999;
   max = -999999999;
   i = size;
   while (i--)
      {
      successes = j = 0;
      while (j < 2)
	 {
	 successes += (((int) rndnum(xlength,sd) + 1) << 1);
	 j++;
	 } /* for each simple random event */
      netsuccess = successes >> 1;
      smplptr   = (int *) smpl + netsuccess;
      (*smplptr)++;
      sumx     += ((double) netsuccess);
      sumxsqd  += ((double) (netsuccess * netsuccess));
      if (netsuccess < min) min = netsuccess;
      if (netsuccess > max) max = netsuccess;
      } /* generate histogram */
   variance = (sumxsqd - (sumx * sumx / dblsize))
      / (dblsize - 1.0);
   stdev = sqrt(variance);
   mu = sumx / dblsize;
   sumchi = 0.0;
   i = 2;
   smplptr = (int *) smpl + 2;
   smplend = (int *) smplptr + smplsize + 1;
   probptr = (double *) prob + 2;
   probend = (double *) probptr + smplsize + 1;
   while (smplptr < smplend)
      {
      if (*probptr == 0.0) break;
      expect = *probptr * dblsize;
      diff = (double) (*smplptr) - expect;
      sumchi += (diff * diff / expect);
      i++;
      probptr++;
      smplptr++;
      } /* sum chi-sq */
   zscore = (mu - popmu) / (popstdev / sqrt(dblsize));
   printf("Observed   %10.6f %10.6f %10.6f %10.6f %7d %7d\n",
      sumx / dblsize, variance, sqrt(variance),
      zscore, min, max);
   printf("\n");
   printf("Chi-square %f\n", sumchi);
   chirange(xlength+xlength-2,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
