# rndnum.s - random number generator based on 16 byte seed
#	generates a random number with normal distribution
#   	from 0 to limit
#   	where limit < 2^32
# Version 1.5.0
# Copyright (C) 1999-2010   dondalah721@yahoo.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

#	Free Software Foundation, Inc.
#	59 Temple Place - Suite 330
#	Boston, MA  02111-1307, USA.

# Usage:
# 	unsigned int rndnum(unsigned int limit,
#		unsigned char *sd);

# subroutine calls: 
#   	unsigned int rndpwr(int bits,
#		unsigned char *sd);

# initialize the seed with:
#   	unsigned char *sd;
#   	sd = (unsigned char *) rndinit();

	.file	"rndnum.s"
	.version	"1.5.0"
gcc2_compiled.:
.text
	.align 4
.globl rndnum
	.type	 rndnum,@function
rndnum:
	pushl %ebp
	movl %esp,%ebp
	pushl %ebx
	pushl %edx
	movl 12(%ebp),%eax	/* pass sd parm to rndpwr */
	pushl %eax
	movl $32,%eax		/* 1st parm = (int) 32 */
	pushl %eax
	/* create a random 32 bit number in accumulator */
	call rndpwr		/* accum = rndpwr(32,sd); */
	addl $8,%esp		/* restore stack */
	movl 8(%ebp),%ebx	/* multiplier = upper limit */
	mull %ebx		/* multiply by limit */
	movl %edx,%eax		/* truncate fraction */

	jmp .L1
	.align 4
.L1:
	popl %edx
	popl %ebx
	popl %ebp
	ret
.Lfe1:
	.size	 rndnum,.Lfe1-rndnum
	.ident	"GCC: (GNU) 2.7.2"
