#!/usr/bin/make

# pwrball.mak Version 1.5.0 - Compile pwrball.c
# Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

OBJ=pwrball.o \
	getpb.o \
	combo.o \
	rndinit.o \
	rnd.o \
	rndnum.o \
	rndpwr.o \
	getmd5.o \
	md5c.o

CC=gcc

CFLAGS=-c -Wall -O6

LDFLAGS=-lm

pwrball:	$(OBJ)
	$(CC) -Wall -O6 $(OBJ) -o pwrball $(LDFLAGS)

pwrball.o:	pwrball.c
	$(CC) $(CFLAGS) pwrball.c

getpb.o:	getpb.c
	$(CC) $(CFLAGS) getpb.c

combo.o:	combo.c
	$(CC) $(CFLAGS) combo.c

rndinit.o:	rndinit.c
	$(CC) $(CFLAGS) rndinit.c

rnd.o:		rnd.s
	$(CC) $(CFLAGS) rnd.s

rndnum.o:	rndnum.s
	$(CC) $(CFLAGS) rndnum.s

rndpwr.o:	rndpwr.s
	$(CC) $(CFLAGS) rndpwr.s

getmd5.o:	getmd5.c
	gcc $(CFLAGS) getmd5.c

md5c.o:		md5c.c
	gcc $(CFLAGS) md5c.c

clean:
	rm -f combo.o getpb.o pwrball.o
	rm -f rndinit.o rnd.o rndnum.o rndpwr.o
	rm -f getmd5.o md5c.o
	rm -f pwrball
