/*
indep.c Version 1.5.0 - Independence Chi Square Test
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This chi-square test is based on */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Chapter 12, Chi-square Tests */
/* Section  4, Testing for Independence */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, California, when he wrote this book. */

/* sample test: */

/* indep 10000 6 6 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

#define CONF 95.0
#define ZLMT 1.96

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size columns rows\n",
      pgm);
   fprintf(stderr,"Where size is 1000 to 1000000000\n");
   fprintf(stderr,"Where columns is 2 to 10\n");
   fprintf(stderr,"      rows    is 2 to 10\n");
   fprintf(stderr,"Size is more than 10 times larger "
      "than columns x rows\n");
   fprintf(stderr,"Example: %s 10000 6 6\n",
      pgm);
   fprintf(stderr,"Degrees of freedom is 25 in "
      "this example\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,size,cols,rows;
   int mtxsize;
   int degf;
   int tstrow;
   int tstcol;
   int *mtx;
   int *p,*q;
   double expect;
   double diff;
   double diffsq;
   double dblsz;
   double dblobs;
   double dblmtxsz;
   double popmean;
   double popprob;
   double popqfail;
   double popvar;
   double popstdev;
   double popstderr;
   double zscore;
   double mtxsumx;
   double mtxsumxsqd;
   double mtxmean;
   double mtxvar;
   double mtxstdev;
   double mtxstderr;
   double chivar;
   double t;
   double negtblv,postblv;
   if (argc != 4) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 1000 || size > 1000000000)
      {
      fprintf(stderr,"Invalid size %s.\n",
	 *(argv+1));
      putstx(*argv);
      } /* bad size */
   dblsz = (double) size;
   cols = atoi(*(argv+2));
   if (cols < 2)
      {
      fprintf(stderr,"Columns is too small.\n");
      putstx(*argv);
      } /* not enough cols */
   if (cols > 10)
      {
      fprintf(stderr,"Columns is too large.\n");
      putstx(*argv);
      } /* if cols too large */
   rows = atoi(*(argv+3));
   if (rows < 2)
      {
      fprintf(stderr,"Rows is too small.\n");
      putstx(*argv);
      } /* not enough rows */
   if (rows > 10)
      {
      fprintf(stderr,"Rows is too large.\n");
      putstx(*argv);
      } /* if rows too large */
   if (size < cols * rows * 10)
      {
      fprintf(stderr,"Size is too small.\n");
      putstx(*argv);
      } /* if size too small */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"indep: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */
   mtxsize = cols * rows;
   dblmtxsz = (double) mtxsize;
   mtx = (int *) malloc((mtxsize * sizeof(int)) + 128);
   if (mtx == NULL)
      {
      fprintf(stderr,"indep: out of memory "
	 "allocating joint probability matrix.\n");
      exit(1);
      } /* out of memory */
   p = mtx;
   q = p + mtxsize;
   while (p < q) *p++ = 0;
   i = size;
   while (i--)
      {
      tstrow = rndnum(rows,sd);
      tstcol = rndnum(cols,sd);
      p = mtx + (tstrow * cols) + tstcol;
      (*p)++;
      } /* generate joint probability matrix */
   expect    = floor(dblsz / dblmtxsz);
   popmean   = dblsz / dblmtxsz;
   popprob   = 1.0 / dblmtxsz;
   popqfail  = 1.0 - popprob;
   popvar    = dblsz * popprob * popqfail;
   popstdev  = sqrt(popvar);
   popstderr = popstdev / sqrt(dblsz);
   mtxstderr = popstdev * ZLMT;
   printf("   Observations "
      "      Confidence Level\n");
   printf("%11d %19.1f\n\n", size, CONF);
   printf("  Row   Col "
      "    Observations "
      "      Z Score\n");
   t = 0.0;
   mtxsumx = mtxsumxsqd = 0.0;
   i = 0;
   p = mtx;
   q = mtx + mtxsize;
   while (p < q)
      {
      dblobs = (double) *p;
      diff   = expect - dblobs;
      diffsq = diff * diff;
      t     += (diffsq / expect);
      zscore = (dblobs - popmean) / popstdev;
      if (dblobs + mtxstderr < popmean
	 || dblobs - mtxstderr > popmean)
	 {
	 tstrow = i / cols;
	 tstcol = i % cols;
         printf("%5d %5d %11.0f %19.6f\n",
	    tstrow, tstcol, dblobs, zscore);
	 } /* zscore exceeded 95% */
      mtxsumx    += dblobs;
      mtxsumxsqd += (dblobs * dblobs);
      p++;
      i++;
      } /* calc chi sq */
   printf("\n");
   mtxmean = mtxsumx / dblmtxsz;
   mtxvar = (mtxsumxsqd - (mtxsumx * mtxsumx / dblmtxsz))
      / (dblmtxsz - 1.0);
   mtxstdev = sqrt(mtxvar);
   printf("                 Mean "
      "          Stdev \n");
   printf("Population %14.6f %14.6f\n",
      popmean, popstdev);
   printf("Observed   %14.6f %14.6f\n\n",
      mtxmean, mtxstdev);
   chivar = (dblmtxsz - 1.0) * mtxvar / popvar;
   printf("Chi-square %f (Variance)\n", chivar);
   printf("Chi-square %f (Goodness of Fit)\n", t);
   degf = (cols-1) * (rows-1);
   chirange(degf,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   free(sd);
   free(mtx);
   return(0);
   } /* main */
