/*
getsz.c  Version 1.5.0 Calculate Sample Size
Based on population mean and variance.
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Subroutine call:
    	double confidence;
    	double esterr;
    	double variance;
    	int size;
    	size = getsz(confidence,esterr,variance);

        Where:
	confidence is 90.0, 95.0, 98.0, 99.0
	esterr   is >= 0.001
	variance is >= 0.001

*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int getsz(double confidence, double esterr,
   double variance)
   {
   int size;
   double esqd;
   double zval;
   double zsqd;
   double varsqd;
   if (confidence == 90.0)
      {
      zval = 1.645;
      } /* if 90% confidence */
   else if (confidence == 95.0)
      {
      zval = 1.96;
      } /* if 95% confidence */
   else if (confidence == 98.0)
      {
      zval = 2.326;
      } /* if 98% confidence */
   else if (confidence == 99.0)
      {
      zval = 2.575;
      } /* if 99% confidence */
   else
      {
      fprintf(stderr,"getsz: confidence %f is "
	 "not correct\n", confidence);
      fprintf(stderr,"Correct values are "
	 "90.0, 95.0, 98.0, 99.0\n");
      exit(1);
      } /* if invalid confidence */
   if (esterr < 0.001)
      {
      fprintf(stderr,"getsz: error of estimation "
	 "%f is invalid\n", esterr);
      fprintf(stderr,"Error of estimation is "
	 ">= 0.001\n");
      exit(1);
      } /* if invalid error of estimation */
   if (variance <= 0.001)
      {
      fprintf(stderr,"getsz: variance "
	 "%f invalid\n", variance);
      fprintf(stderr,"Variance is "
	 ">= 0.001\n");
      exit(1);
      } /* if invalid variance */
   zsqd = zval * zval;
   varsqd = variance * variance;
   esqd = esterr * esterr;
   size = (int) floor((varsqd * zsqd / esqd) + 0.999999);
   if (size < 30)
      {
      fprintf(stderr,"getsz: size %d "
	 "is too small\n", size);
      fprintf(stderr,"Size should be "
	 "from 30 to 2000000\n");
      fprintf(stderr,"Adjust confidence level "
	 "or error rate\n");
      exit(1);
      } /* if size too small */
   if (size > 2000000)
      {
      fprintf(stderr,"getsz: size %d "
	 "is too large\n", size);
      fprintf(stderr,"Size should be "
	 "from 30 to 2000000\n");
      fprintf(stderr,"Adjust confidence level "
	 "or error rate\n");
      exit(1);
      } /* if size too large */
   return(size);
   } /* getsz */
