/*
getpb.c  Version 1.5.0 Powerball Odds
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/*
Usage:
    	int select;
    	int pwrball;
    	double odds;
    	double getpb(int select, int pwrball);
    	odds = getpb(select,pwrball);
*/

#include <stdio.h>
#include <stdlib.h>

#define FOURTYFIVE 45

double getpb(select,pwrball)
int select;
int pwrball;
   {
   double odds;
   double max45;
   double topwin,toplose;
   double top;
   double bottom;
   double dbl45,dbl40,dbl44;
   double combo(int n, int r);

   if (select < 0 || select > 5)
      {
      fprintf(stderr,"getpb: invalid select %d\n",
         select);
      exit(1);
      } /* invalid select */
   if (pwrball < 0 || pwrball > 1)
      {
      fprintf(stderr,"getpb: invalid powerball %d\n",
         pwrball);
      exit(1);
      } /* invalid pwrball */
   if (select >= 0 && select <= 2)
      {
      if (pwrball != 1)
         {
         fprintf(stderr,"getpb: invalid powerball %d "
            "when select is %d\n",
            pwrball, select);
         exit(1);
         } /* invalid pwrball */
      } /* select = 2,1,0 */

   max45 = FOURTYFIVE;
   dbl45 = (double) max45;
   dbl40 = dbl45 - 5.0;
   dbl44 = dbl45 - 1.0;

   if (select == 5 && pwrball == 1)
      {
      top = combo(5,select);
      bottom = combo(max45,5) * dbl45;
      odds = bottom / top;
      return(odds);
      } /* 5 1 */

   else if (select == 5 && pwrball == 0)
      {
      topwin  = combo(5,select);
      toplose = dbl44;
      top = topwin * toplose;
      bottom = combo(max45,5) * dbl45;
      odds = bottom / top;
      return(odds);
      } /* 5 0 */

   else if (select == 4 && pwrball == 1)
      {
      topwin  = combo(5,select);
      toplose = combo(40,5 - select);
      top = topwin * toplose;
      bottom = combo(max45,5) * dbl45;
      odds = bottom / top;
      return(odds);
      } /* 4 1 */

   else if (select == 4 && pwrball == 0)
      {
      topwin  = combo(5,select);
      toplose = combo(40,5 - select) * dbl44;
      top = topwin * toplose;
      bottom = combo(max45,5) * dbl45;
      odds = bottom / top;
      return(odds);
      } /* 4 0 */

   else if (select == 3 && pwrball == 1)
      {
      topwin  = combo(5,select);
      toplose = combo(40,5 - select);
      top = topwin * toplose;
      bottom = combo(max45,5) * dbl45;
      odds = bottom / top;
      return(odds);
      } /* 3 1 */

   else if (select == 3 && pwrball == 0)
      {
      topwin  = combo(5,select);
      toplose = combo(40,5 - select) * dbl44;
      top = topwin * toplose;
      bottom = combo(max45,5) * dbl45;
      odds = bottom / top;
      return(odds);
      } /* 3 0 */

   else if (select == 2 && pwrball == 1)
      {
      topwin  = combo(5,select);
      toplose = combo(40,5 - select);
      top = topwin * toplose;
      bottom = combo(max45,5) * dbl45;
      odds = bottom / top;
      return(odds);
      } /* 2 1 */

   else if (select == 1 && pwrball == 1)
      {
      topwin  = combo(5,select);
      toplose = combo(40,5 - select);
      top = topwin * toplose;
      bottom = combo(max45,5) * dbl45;
      odds = bottom / top;
      return(odds);
      } /* 1 1 */

   else if (select == 0 && pwrball == 1)
      {
      topwin  = combo(5,select);
      toplose = combo(40,5 - select);
      top = topwin * toplose;
      bottom = combo(max45,5) * dbl45;
      odds = bottom / top;
      return(odds);
      } /* 0 1 */
   fprintf(stderr,"getpb: edit failed for "
      "powerball %d when select is %d\n",
      pwrball, select);
   exit(1);
   } /* getpb */
