/*
gap.c Version 1.5.0 - Gap Test
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

#define SIZE 10000
#define CATS 25

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s lowrange hirange "
      "gaps size\n", pgm);
   fprintf(stderr,"Where lowrange and hirange are 0.0 - 1.0\n");
   fprintf(stderr,"      gaps is 1 - 1000\n");
   fprintf(stderr,"      size is 10 - 1000000\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j,s,r,maxgap,lmt;
   double low,hi;
   double v,itm,rslt;
   double prob,postblv,negtblv;
   double tmp,gap,inverse,pwr;
   unsigned int *kount;
   double *problst;
   unsigned int *p,*q;
   if (argc != 5) putstx(*argv);
   low = atof(*(argv+1));
   if (low < 0.0 || low > 1.0)
      {
      fprintf(stderr,"Invalid lowrange\n");
      putstx(*argv);
      } /* invalid low */
   hi = atof(*(argv+2));
   if (hi < 0.0 || hi > 1.0)
      {
      fprintf(stderr,"Invalid hirange\n");
      putstx(*argv);
      } /* invalid hi */
   if (low >= hi)
      {
      fprintf(stderr,"Lowrange is not less than hirange\n");
      putstx(*argv);
      } /* low >= hi */
   maxgap = atoi(*(argv+3));
   if (maxgap < 1 || maxgap > 1000)
      {
      fprintf(stderr,"Invalid gaps\n");
      putstx(*argv);
      } /* invalid maxgap */
   lmt = atoi(*(argv+4));
   if (lmt < 10 || lmt > 1000000)
      {
      fprintf(stderr,"Invalid size\n");
      putstx(*argv);
      } /* invalid size */
   if (maxgap * 10 > lmt)
      {
      fprintf(stderr,"Size too small compared to gaps\n");
      putstx(*argv);
      } /* invalid size compared to gaps */
   kount = (unsigned int *)
      malloc(maxgap * sizeof(unsigned int) + 16);
   if (kount == NULL)
      {
      fprintf(stderr,"Out of memory allocating kount\n");
      exit(1);
      } /* out of memory */
   problst = (double *)
      malloc(maxgap * sizeof(double) + 16);
   if (problst == NULL)
      {
      fprintf(stderr,"gap: out of memory "
	 "allocating problst\n");
      exit(1);
      } /* out of memory */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"gap: out of memory "
	 "allocating sd\n");
      exit(1);
      } /* out of memory */
   j = -1;
   s = 0;
   p = kount;
   q = kount + maxgap;
   while (p <= q) *(p++) = 0.0;
   while (s < lmt)
      {
      r = 0;
      while (1)
         {
         j++;
	 tmp = rndfrac(sd);
         if (tmp >= low && tmp < hi) break;
         r++;
         } /* if outside range */
      if (r >= maxgap)
         kount[maxgap]++;
      else
         kount[r]++;
      s++;
      } /* while s < lmt */
   i = 0;
   gap = hi - low;
   inverse = 1.0 - gap;
   while (i < maxgap)
      {
      pwr = (double) i;
      problst[i++] = gap * pow(inverse,pwr);
      } /* initialize problst */
   pwr = (double) maxgap;
   problst[maxgap] = pow(inverse,pwr);
   chirange(maxgap,&negtblv,&postblv);
   i = 0;
   v = 0.0;
   while (i <= maxgap)
      {
      itm = kount[i];
      prob = problst[i++];
      v += (double) (itm * itm / prob);
      } /* calc chi sq */
   rslt = (double) v / lmt - lmt;
   printf("%f\n"
      "Range at 95 percent: %f  to  %f\n",
      rslt, negtblv, postblv);
   return(0);
   } /* main */
