/*
flipsz.c Version 1.5.0 - Coin Flip Sample Size
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 6, Expected Value and Population Parameters */
/* Section 2, Population Mean and Variance */
/* Chapter 9, Statistical Estimation */
/* Section 4, Determination of Sample Size */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* Sample test: */

/* flipsz 95.0 0.01 12 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s confidence "
      "est_errors flips\n",
      pgm);
   fprintf(stderr,"Where confidence is "
      "90.0, 95.0, 98.0, 99.0\n");
   fprintf(stderr,"      est_errors is 0.001 to 10\n");
   fprintf(stderr,"      flips is 2 to 48\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i;
   int size,flips;
   double confidence;
   double esterr;
   double *p,*q;
   double *prob;
   double totprob;
   double bottom,top;
   double mu,musq;
   double est_xsq;
   double variance,stdev;
   int getsz(double confidence, double esterr,
      double variance);
   double combo(int n, int r);
   if (argc != 4) putstx(*argv);
   confidence = atof(*(argv+1));
   if (confidence == 90.0 || confidence == 95.0
      || confidence == 98.0 || confidence == 99.0);
   else
      {
      fprintf(stderr,"Invalid confidence level.\n");
      putstx(*argv);
      } /* bad confidence */
   esterr = atof(*(argv+2));
   if (esterr < 0.001 || esterr > 10.0)
      {
      fprintf(stderr,"Invalid error of estimation.\n");
      putstx(*argv);
      } /* bad error of estimation */
   flips = atoi(*(argv+3));
   if (flips < 2)
      {
      fprintf(stderr,"Flips is too small.\n");
      putstx(*argv);
      } /* not enough flips */
   if (flips > 48)
      {
      fprintf(stderr,"Flips is too large.\n");
      putstx(*argv);
      } /* if flips too large */
   prob = (double *) malloc((flips + 1) * sizeof(double) + 32);
   if (prob == NULL)
      {
      fprintf(stderr,"flipsz: out of memory "
	 "allocating probability array.\n");
      exit(1);
      } /* out of memory */
   bottom = pow(2.0,(double) flips);
   totprob = 0.0;
   p = prob;
   q = p + flips + 1;
   i = 0;
   while (p < q)
      {
      top = combo(flips,i);
      *p = top / bottom;
      totprob += *p;
      i++;
      p++;
      } /* for each # of heads */
   mu = 0.0;
   p = prob;
   q = p + flips + 1;
   i = 0;
   while (p < q)
      {
      mu += ((double) i * *p++);
      i++;
      } /* for each # of heads */
   musq = mu * mu;
   est_xsq = 0.0;
   p = prob;
   q = p + flips + 1;
   i = 0;
   while (p < q)
      {
      est_xsq += ((double) (i * i) * *p++);
      i++;
      } /* for each # of heads */
   variance = est_xsq -  musq;
   stdev    = sqrt(variance);
   size = getsz(confidence,esterr,variance);
   printf("Sample size is %d\n", size);
   return(0);
   } /* main */
